/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.IDEClassPathBlock;
import org.eclipse.birt.report.designer.ui.IReportClasspathResolver;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class IDEReportClasspathResolver
implements IReportClasspathResolver {
    public String[] resolveClasspath(Object adaptable) {
        IProject project = this.adaptProject(adaptable);
        String value = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ReportPlugin.getDefault(), project).getString("org.eclipse.birt.report.designer.ui.preferences.classpath");
        List<IClasspathEntry> list = IDEClassPathBlock.getEntries(value);
        List<String> strs = this.getAllClassPathFromEntries(list);
        try {
            if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature")) {
                return strs.toArray(new String[strs.size()]);
            }
        }
        catch (CoreException e) {
            return strs.toArray(new String[strs.size()]);
        }
        List<String> temp = this.getProjectClasspath(project, true, true);
        int i = 0;
        while (i < temp.size()) {
            this.addToList(strs, temp.get(i));
            ++i;
        }
        return strs.toArray(new String[strs.size()]);
    }

    private List<String> getAllClassPathFromEntries(List<IClasspathEntry> list) {
        ArrayList<String> retValue = new ArrayList<String>();
        IWorkspace space = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = space.getRoot();
        int i = 0;
        while (i < list.size()) {
            IClasspathEntry curr = list.get(i);
            boolean inWorkSpace = true;
            if (space == null || space.getRoot() == null) {
                inWorkSpace = false;
            }
            IPath path = curr.getPath();
            path = curr.getEntryKind() == 4 ? JavaCore.getClasspathVariable((String)path.segment(0)) : JavaCore.getResolvedClasspathEntry((IClasspathEntry)curr).getPath();
            if (curr.getEntryKind() == 2) {
                if (root.findMember(path) instanceof IProject) {
                    List<String> strs = this.getProjectClasspath((IProject)root.findMember(path), false, true);
                    int j = 0;
                    while (j < strs.size()) {
                        this.addToList(retValue, strs.get(j));
                        ++j;
                    }
                }
            } else {
                if (root.findMember(path) == null) {
                    inWorkSpace = false;
                }
                if (inWorkSpace) {
                    String absPath = this.getFullPath(path, root.findMember(path).getProject());
                    this.addToList(retValue, absPath);
                } else {
                    this.addToList(retValue, path.toFile().getAbsolutePath());
                }
            }
            ++i;
        }
        return retValue;
    }

    private void addToList(List<String> list, String str) {
        if (!list.contains(str)) {
            list.add(str);
        }
    }

    private IProject adaptProject(Object adaptable) {
        IFile[] files;
        if (adaptable instanceof IProject) {
            return (IProject)adaptable;
        }
        if (adaptable instanceof IResource) {
            return ((IResource)adaptable).getProject();
        }
        if (adaptable instanceof URI) {
            IFile[] files2 = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI((URI)adaptable);
            if (files2 != null && files2.length > 0) {
                return files2[0].getProject();
            }
        } else if (adaptable instanceof IPath) {
            IFile[] files3 = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)adaptable);
            if (files3 != null && files3.length > 0) {
                return files3[0].getProject();
            }
        } else if (adaptable instanceof String && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(Path.fromOSString((String)((String)adaptable)))) != null && files.length > 0) {
            return files[0].getProject();
        }
        return null;
    }

    private List<String> getProjectClasspath(IProject project, boolean needExported, boolean needDepend) {
        String url;
        ArrayList<String> retValue = new ArrayList<String>();
        if (project == null) {
            return Collections.emptyList();
        }
        if (needDepend) {
            List<String> paths = this.getProjectDependentClasspath(project, needExported);
            int j = 0;
            while (j < paths.size()) {
                this.addToList(retValue, paths.get(j));
                ++j;
            }
        }
        if ((url = this.getProjectOutputClassPath(project)) != null) {
            this.addToList(retValue, url);
        }
        return retValue;
    }

    private String getProjectOutputClassPath(IProject project) {
        boolean projectExists;
        if (!this.hasJavaNature(project)) {
            return null;
        }
        IJavaProject fCurrJProject = JavaCore.create((IProject)project);
        IPath path = null;
        boolean bl = projectExists = project.exists() && project.getFile(".classpath").exists();
        if (projectExists && path == null) {
            path = fCurrJProject.readOutputLocation();
            if (path == null) {
                return null;
            }
            String absPath = this.getFullPath(path, project);
            return absPath;
        }
        return null;
    }

    private List<String> getProjectDependentClasspath(IProject project, boolean needExported) {
        boolean projectExists;
        if (!this.hasJavaNature(project)) {
            return Collections.emptyList();
        }
        List<String> retValue = new ArrayList<String>();
        IJavaProject fCurrJProject = JavaCore.create((IProject)project);
        IClasspathEntry[] classpathEntries = null;
        boolean bl = projectExists = project.exists() && project.getFile(".classpath").exists();
        if (projectExists && classpathEntries == null) {
            classpathEntries = fCurrJProject.readRawClasspath();
        }
        if (classpathEntries != null) {
            retValue = this.resolveClasspathEntries(classpathEntries, needExported, fCurrJProject);
        }
        return retValue;
    }

    private List<String> resolveClasspathEntries(IClasspathEntry[] classpathEntries, boolean needExported, IJavaProject project) {
        ArrayList<String> newClassPath = new ArrayList<String>();
        IWorkspace space = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = space.getRoot();
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry curr = classpathEntries[i];
            if (needExported || curr.isExported() || curr.getEntryKind() == 4) {
                IPath path = curr.getPath();
                path = JavaCore.getResolvedClasspathEntry((IClasspathEntry)curr).getPath();
                if (project != null && curr.getEntryKind() == 5) {
                    try {
                        IClasspathContainer contianer = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)project);
                        if (contianer != null && contianer.getKind() == 1) {
                            IClasspathEntry[] entrys = contianer.getClasspathEntries();
                            List<String> list = this.resolveClasspathEntries(entrys, needExported, project);
                            int j = 0;
                            while (j < list.size()) {
                                this.addToList(newClassPath, list.get(j));
                                ++j;
                            }
                        }
                    }
                    catch (JavaModelException contianer) {}
                } else {
                    if (curr.getEntryKind() == 3) {
                        path = curr.getOutputLocation();
                    }
                    if (path != null) {
                        if (curr.getEntryKind() == 2) {
                            if (root.findMember(path) instanceof IProject) {
                                List<String> strs = this.getProjectClasspath((IProject)root.findMember(path), false, false);
                                int j = 0;
                                while (j < strs.size()) {
                                    this.addToList(newClassPath, strs.get(j));
                                    ++j;
                                }
                            }
                        } else if (curr.getEntryKind() == 1 || curr.getEntryKind() == 4 || curr.getEntryKind() == 3) {
                            boolean inWorkSpace = true;
                            if (space == null || space.getRoot() == null) {
                                inWorkSpace = false;
                            }
                            if (root.findMember(path) == null) {
                                inWorkSpace = false;
                            }
                            if (inWorkSpace) {
                                String absPath = this.getFullPath(path, root.findMember(path).getProject());
                                newClassPath.add(absPath);
                            } else {
                                newClassPath.add(path.toFile().getAbsolutePath());
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return newClassPath;
    }

    private String getFullPath(IPath path, IProject project) {
        String directPath;
        try {
            directPath = project.getDescription().getLocationURI().toURL().getPath();
        }
        catch (Exception e) {
            directPath = project.getLocation().toOSString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root.findMember(path) == project) {
            return directPath;
        }
        String curPath = path.toOSString();
        int index = curPath.substring(1).indexOf(File.separator);
        String absPath = directPath + curPath.substring(index + 1);
        return absPath;
    }

    private boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

