/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.series;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskPopupSheet;
import org.eclipse.birt.chart.ui.swt.type.BubbleChart;
import org.eclipse.birt.chart.ui.swt.type.PieChart;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesPaletteSheet;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TreeItem;

public class SeriesSheetImpl
extends SubtaskSheetImpl
implements SelectionListener {
    private static Hashtable<String, Series> htSeriesNames = null;
    protected Collection<IChartType> cTypes = null;
    protected ChartCombo cmbColorBy;
    private ITaskPopupSheet popup = null;
    protected int columnDetailNumber = 7;
    protected static final int HORIZONTAL_SPACING = 5;
    protected Composite cmpList = null;

    @Override
    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartSeries_ID");
        int COLUMN_CONTENT = 4;
        this.cTypes = ChartUIExtensionsImpl.instance().getUIChartTypeExtensions(((ChartWizardContext)this.getContext()).getIdentifier());
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(4, false);
        glContent.horizontalSpacing = 5;
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        new Label(this.cmpContent, 0).setText(Messages.getString("ChartSheetImpl.Label.ColorBy"));
        this.cmbColorBy = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCombo(this.cmpContent, 12, (EObject)((Chart)this.getChart()).getLegend(), "itemType", ChartDefaultValueUtil.getDefaultLegend((Chart)((Chart)this.getChart())).getItemType().getName());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.cmbColorBy.setLayoutData((Object)gridData);
        NameSet ns = LiteralHelper.legendItemTypeSet;
        this.cmbColorBy.setItems(ns.getDisplayNames());
        this.cmbColorBy.setItemData(ns.getNames());
        this.cmbColorBy.setSelection(((Chart)this.getChart()).getLegend().getItemType().getName());
        this.cmbColorBy.addSelectionListener((SelectionListener)this);
        ScrolledComposite cmpScroll = new ScrolledComposite(this.cmpContent, 768);
        gd = new GridData(1808);
        gd.horizontalSpan = 4;
        cmpScroll.setLayoutData((Object)gd);
        cmpScroll.setExpandVertical(true);
        cmpScroll.setExpandHorizontal(true);
        this.createSeriesOptions(cmpScroll);
        this.createButtonGroup(this.cmpContent);
    }

    protected int getColorByComboDefaultIndex() {
        return ((Chart)this.getChart()).getLegend().isSetItemType() ? LiteralHelper.legendItemTypeSet.getSafeNameIndex(((Chart)this.getChart()).getLegend().getItemType().getName()) + 1 : 0;
    }

    protected void createSeriesOptions(ScrolledComposite cmpScroll) {
        if (this.cmpList == null || this.cmpList.isDisposed()) {
            this.cmpList = new Composite((Composite)cmpScroll, 0);
            GridLayout glContent = new GridLayout(this.columnDetailNumber, false);
            glContent.horizontalSpacing = 5;
            this.cmpList.setLayout((Layout)glContent);
            this.cmpList.setLayoutData((Object)new GridData(1808));
            cmpScroll.setContent((Control)this.cmpList);
        } else {
            Control[] children = this.cmpList.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        this.createSeriesOptionsLabels();
        int treeIndex = 0;
        if (this.needCategorySeries()) {
            EList seriesDefns = ChartUIUtil.getBaseSeriesDefinitions((Chart)((Chart)this.getChart()));
            int i = 0;
            while (i < seriesDefns.size()) {
                this.createSeriesOptionChoser((SeriesDefinition)seriesDefns.get(i), Messages.getString("SeriesSheetImpl.Label.CategoryBaseSeries"), i, treeIndex++, false).placeComponents(this.cmpList);
                ++i;
            }
        }
        List allSeriesDefns = ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)((Chart)this.getChart()));
        String text = this.getChart() instanceof ChartWithAxes ? Messages.getString("SeriesSheetImpl.Label.ValueYSeries") : Messages.getString("SeriesSheetImpl.Label.ValueOrthogonalSeries");
        int seriesIndex = 0;
        int i = 0;
        while (i < ChartUIUtil.getOrthogonalAxisNumber((Chart)((Chart)this.getChart()))) {
            boolean canStack = true;
            EList seriesDefns = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)((Chart)this.getChart()), (int)i);
            int j = 0;
            while (j < seriesDefns.size()) {
                if (!((SeriesDefinition)seriesDefns.get(j)).getDesignTimeSeries().canBeStacked()) {
                    canStack = false;
                    break;
                }
                ++j;
            }
            j = 0;
            while (j < seriesDefns.size()) {
                this.createSeriesOptionChoser((SeriesDefinition)seriesDefns.get(j), (String)(allSeriesDefns.size() == 1 ? text : text + " - " + (seriesIndex + 1)), seriesIndex++, treeIndex++, canStack, i).placeComponents(this.cmpList);
                ++j;
            }
            ++i;
        }
    }

    protected void createSeriesOptionsLabels() {
        Label lblSeries = new Label(this.cmpList, 64);
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        lblSeries.setLayoutData((Object)gd);
        lblSeries.setFont(JFaceResources.getBannerFont());
        lblSeries.setText(Messages.getString("SeriesSheetImpl.Label.Series"));
        Label lblTitle = new Label(this.cmpList, 64);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 0x1000000;
        lblTitle.setLayoutData((Object)gd2);
        lblTitle.setFont(JFaceResources.getBannerFont());
        lblTitle.setText(Messages.getString("SeriesSheetImpl.Label.Title"));
        Label lblType = new Label(this.cmpList, 64);
        GridData gd3 = new GridData();
        gd3.horizontalAlignment = 0x1000000;
        lblType.setLayoutData((Object)gd3);
        lblType.setFont(JFaceResources.getBannerFont());
        lblType.setText(Messages.getString("SeriesSheetImpl.Label.Type"));
        Label lblZOrder = new Label(this.cmpList, 64);
        GridData gd4 = new GridData();
        gd4.horizontalAlignment = 0x1000000;
        lblZOrder.setLayoutData((Object)gd4);
        lblZOrder.setFont(JFaceResources.getBannerFont());
        lblZOrder.setText(Messages.getString("SeriesSheetImpl.Label.ZOrder"));
        Label lblVisible = new Label(this.cmpList, 64);
        GridData gd5 = new GridData();
        gd5.horizontalAlignment = 0x1000000;
        lblVisible.setLayoutData((Object)gd5);
        lblVisible.setFont(JFaceResources.getBannerFont());
        lblVisible.setText(Messages.getString("SeriesSheetImpl.Label.Visible"));
        Label lblStack = new Label(this.cmpList, 64);
        GridData gd6 = new GridData();
        gd6.horizontalAlignment = 0x1000000;
        lblStack.setLayoutData((Object)gd6);
        lblStack.setFont(JFaceResources.getBannerFont());
        lblStack.setText(Messages.getString("SeriesSheetImpl.Label.Stacked"));
        Label lblTranslucent = new Label(this.cmpList, 64);
        GridData gd7 = new GridData();
        gd7.horizontalAlignment = 0x1000000;
        lblTranslucent.setLayoutData((Object)gd7);
        lblTranslucent.setFont(JFaceResources.getBannerFont());
        lblTranslucent.setText(Messages.getString("SeriesSheetImpl.Label.Translucent"));
    }

    protected SeriesOptionChoser createSeriesOptionChoser(SeriesDefinition seriesDefn, String seriesName, int iSeriesDefinitionIndex, int treeIndex, boolean canStack, int axisIndex) {
        return new SeriesOptionChoser(seriesDefn, seriesName, iSeriesDefinitionIndex, treeIndex, canStack, axisIndex);
    }

    protected SeriesOptionChoser createSeriesOptionChoser(SeriesDefinition seriesDefn, String seriesName, int iSeriesDefinitionIndex, int treeIndex, boolean canStack) {
        return new SeriesOptionChoser(seriesDefn, seriesName, iSeriesDefinitionIndex, treeIndex, canStack);
    }

    protected int getSeriesFillStyles() {
        return 59;
    }

    protected void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        this.popup = new SeriesPaletteSheet(Messages.getString("SeriesSheetImpl.Label.SeriesPalette"), (ChartWizardContext)this.getContext(), this.getCategorySeriesDefinition(), this.getValueSeriesDefinitions(), this.isGroupedSeries(), this.getSeriesFillStyles());
        Button btnSeriesPals = this.createToggleButton(cmp, ".Palette", Messages.getString("SeriesSheetImpl.Label.SeriesPalette&"), this.popup);
        btnSeriesPals.addSelectionListener((SelectionListener)this);
    }

    private SeriesDefinition getCategorySeriesDefinition() {
        return ChartUtil.getCategorySeriesDefinition((Chart)((Chart)this.getChart()));
    }

    private SeriesDefinition[] getValueSeriesDefinitions() {
        return ChartUtil.getValueSeriesDefinitions((Chart)((Chart)this.getChart()));
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.detachPopup(e.widget)) {
            if (this.isRegistered(e.widget)) {
                this.attachPopup(((Button)e.widget).getData().toString());
            } else if (e.widget.equals(this.cmbColorBy)) {
                String selectedItemType = this.cmbColorBy.getSelectedItemData();
                if (selectedItemType != null) {
                    ((Chart)this.getChart()).getLegend().setItemType(LegendItemType.getByName((String)selectedItemType));
                    if (((Chart)this.getChart()).getLegend().getItemType().getValue() == 1 && this.isGroupedSeries() && !ChartDefaultValueUtil.isAutoSeriesPalette((Chart)((Chart)this.getChart()))) {
                        ChartAdapter.beginIgnoreNotifications();
                        SeriesDefinition[] osds = this.getValueSeriesDefinitions();
                        SeriesDefinition bsd = this.getCategorySeriesDefinition();
                        bsd.getSeriesPalette().shift(0);
                        int i = 0;
                        while (i < osds.length) {
                            bsd.getSeriesPalette().getEntries().set(i, (Object)((Fill)osds[i].getSeriesPalette().getEntries().get(0)).copyInstance());
                            ++i;
                        }
                        ((SeriesPaletteSheet)this.popup).setCategorySeries(bsd);
                        ChartAdapter.endIgnoreNotifications();
                    }
                }
                ((SeriesPaletteSheet)this.popup).setGroupedPalette(this.isGroupedSeries());
                this.refreshPopupSheet();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private boolean isGroupedSeries() {
        return !this.getValueSeriesDefinitions()[0].getQuery().getDefinition().trim().equals("");
    }

    protected IChartType getCurrentChartType() {
        for (IChartType ct : this.cTypes) {
            if (!ct.getName().equals(((Chart)this.getChart()).getType())) continue;
            return ct;
        }
        return null;
    }

    protected boolean needCategorySeries() {
        return ((ChartWizardContext)this.getContext()).getChartType() instanceof PieChart;
    }

    public class SeriesOptionChoser
    implements SelectionListener,
    Listener {
        protected SeriesDefinition seriesDefn;
        private String seriesName;
        private Link linkSeries;
        private ExternalizedTextEditorComposite txtTitle;
        private Combo cmbTypes;
        private Spinner spnZOrder;
        private ChartCheckbox btnVisible;
        private ChartCheckbox btnStack;
        private ChartCheckbox btnTranslucent;
        private boolean canStack;
        private int iSeriesDefinitionIndex = 0;
        private int axisIndex = 0;
        private int treeIndex = 0;
        private boolean bStackedPercent;
        protected Series defSeries;

        public SeriesOptionChoser(SeriesDefinition seriesDefn, String seriesName, int iSeriesDefinitionIndex, int treeIndex, boolean canStack) {
            this.seriesDefn = seriesDefn;
            this.seriesName = seriesName;
            this.iSeriesDefinitionIndex = iSeriesDefinitionIndex;
            this.treeIndex = treeIndex;
            this.canStack = canStack;
            this.bStackedPercent = this.isStackedPercent(seriesDefn);
        }

        public SeriesOptionChoser(SeriesDefinition seriesDefn, String seriesName, int iSeriesDefinitionIndex, int treeIndex, boolean canStack, int axisIndex) {
            this.seriesDefn = seriesDefn;
            this.seriesName = seriesName;
            this.iSeriesDefinitionIndex = iSeriesDefinitionIndex;
            this.treeIndex = treeIndex;
            this.canStack = canStack;
            this.axisIndex = axisIndex;
            this.bStackedPercent = this.isStackedPercent(seriesDefn);
        }

        private boolean isStackedPercent(SeriesDefinition seriesDefn) {
            if (seriesDefn.eContainer() instanceof Axis) {
                return ((Axis)seriesDefn.eContainer()).isPercent();
            }
            return false;
        }

        public void placeComponents(Composite parent) {
            Series series = this.seriesDefn.getDesignTimeSeries();
            this.defSeries = ChartDefaultValueUtil.getDefaultSeries((Series)series);
            this.linkSeries = new Link(parent, 0);
            GridData gd = new GridData(768);
            this.linkSeries.setLayoutData((Object)gd);
            this.linkSeries.setText("<a>" + this.seriesName + "</a>");
            this.linkSeries.addSelectionListener((SelectionListener)this);
            List keys = null;
            if (((ChartWizardContext)SeriesSheetImpl.this.getContext()).getUIServiceProvider() != null) {
                keys = ((ChartWizardContext)SeriesSheetImpl.this.getContext()).getUIServiceProvider().getRegisteredKeys();
            }
            this.txtTitle = new ExternalizedTextEditorComposite(parent, 2052, -1, -1, keys, ((ChartWizardContext)SeriesSheetImpl.this.getContext()).getUIServiceProvider(), this.getSeriesIdentifierText(series));
            GridData gd2 = new GridData(768);
            this.txtTitle.setLayoutData(gd2);
            this.txtTitle.addListener(this);
            this.txtTitle.addScreenReaderAccessbility(Messages.getString("SeriesSheetImpl.Label.Title"));
            this.cmbTypes = new Combo(parent, 12);
            gd2 = new GridData(768);
            this.cmbTypes.setLayoutData((Object)gd2);
            this.cmbTypes.addSelectionListener((SelectionListener)this);
            if (this.iSeriesDefinitionIndex == 0) {
                this.cmbTypes.setEnabled(false);
            }
            ChartUIUtil.addScreenReaderAccessbility((Control)this.cmbTypes, (String)Messages.getString("SeriesSheetImpl.Label.Type"));
            if (!series.getClass().isAssignableFrom(SeriesImpl.class)) {
                this.initZOrderUI(parent);
                this.initVisibleUI(parent, series);
                this.initStackUI(parent, series);
                this.initTranslucentUI(parent, series);
                this.setTypeComboState();
                this.setStackedBoxState();
            } else {
                Label dummy = new Label(parent, 32);
                GridData gd3 = new GridData();
                gd3.horizontalSpan = 4;
                dummy.setLayoutData((Object)gd3);
            }
            this.populateLists(this.seriesDefn.getDesignTimeSeries());
        }

        protected String getSeriesIdentifierText(Series series) {
            if (series.getSeriesIdentifier() == null) {
                return "";
            }
            return series.getSeriesIdentifier().toString();
        }

        protected void initTranslucentUI(Composite parent, Series series) {
            this.btnTranslucent = ((ChartWizardContext)SeriesSheetImpl.this.getContext()).getUIFactory().createChartCheckbox(parent, 0, this.defSeries.isTranslucent());
            GridData gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            this.btnTranslucent.setLayoutData((Object)gd);
            this.btnTranslucent.setSelectionState(series.isSetTranslucent() ? (series.isTranslucent() ? 1 : 2) : 0);
            this.btnTranslucent.addSelectionListener((SelectionListener)this);
            this.btnTranslucent.addScreenReaderAccessiblity(Messages.getString("SeriesSheetImpl.Label.Translucent"));
        }

        protected void initVisibleUI(Composite parent, Series series) {
            this.btnVisible = ((ChartWizardContext)SeriesSheetImpl.this.getContext()).getUIFactory().createChartCheckbox(parent, 0, this.defSeries.isVisible());
            GridData gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            this.btnVisible.setLayoutData((Object)gd);
            this.btnVisible.setSelectionState(series.isSetVisible() ? (series.isVisible() ? 1 : 2) : 0);
            this.btnVisible.addSelectionListener((SelectionListener)this);
            this.btnVisible.addScreenReaderAccessiblity(Messages.getString("SeriesSheetImpl.Label.Visible"));
        }

        protected void initStackUI(Composite parent, Series series) {
            boolean defSelected = false;
            defSelected = this.defSeries.isSetStacked() && this.defSeries.isStacked() && !this.canStack ? false : this.defSeries.isStacked();
            this.btnStack = ((ChartWizardContext)SeriesSheetImpl.this.getContext()).getUIFactory().createChartCheckbox(parent, 0, defSelected);
            GridData gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            this.btnStack.setLayoutData((Object)gd);
            this.btnStack.setEnabled(this.canStack && series.canBeStacked() && ((Chart)SeriesSheetImpl.this.getChart()).getDimension().getValue() != 2 && !this.bStackedPercent);
            int state = 0;
            if (series.isSetStacked() && series.isStacked() && !this.canStack) {
                state = 2;
                series.setStacked(false);
            } else {
                state = series.isSetStacked() ? (series.isStacked() ? 1 : 2) : 0;
            }
            this.btnStack.setSelectionState(state);
            this.btnStack.addSelectionListener((SelectionListener)this);
            this.btnStack.addScreenReaderAccessiblity(Messages.getString("SeriesSheetImpl.Label.Stacked"));
        }

        protected void initZOrderUI(Composite parent) {
            this.spnZOrder = new Spinner(parent, 2048);
            GridData gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            this.spnZOrder.setLayoutData((Object)gd);
            this.spnZOrder.setMinimum(0);
            this.spnZOrder.setMaximum(10);
            if (SeriesSheetImpl.this.getChart() instanceof ChartWithAxes && !(((ChartWizardContext)SeriesSheetImpl.this.getContext()).getChartType() instanceof BubbleChart) && ((Chart)SeriesSheetImpl.this.getChart()).getDimension() == ChartDimension.TWO_DIMENSIONAL_LITERAL) {
                this.spnZOrder.setSelection(this.seriesDefn.getZOrder());
                this.spnZOrder.addSelectionListener((SelectionListener)this);
            } else {
                this.spnZOrder.setEnabled(false);
            }
            ChartUIUtil.addSpinnerScreenReaderAccessbility((Spinner)this.spnZOrder, (String)Messages.getString("SeriesSheetImpl.Label.ZOrder"));
        }

        public void widgetSelected(SelectionEvent e) {
            Series series = this.seriesDefn.getDesignTimeSeries();
            if (e.getSource().equals(this.cmbTypes)) {
                if (SeriesSheetImpl.this.getCurrentChartType().canCombine()) {
                    String typeName = this.cmbTypes.getText();
                    this.convertSeriesType(series, typeName);
                }
            } else if (e.widget == this.btnVisible) {
                if (this.btnVisible.getSelectionState() == 0) {
                    series.unsetVisible();
                } else {
                    series.setVisible(this.btnVisible.getSelectionState() == 1);
                }
            } else if (e.widget == this.btnStack) {
                if (this.btnStack.getSelectionState() == 0) {
                    series.unsetStacked();
                } else {
                    series.setStacked(this.btnStack.getSelectionState() == 1);
                }
                if (series instanceof BarSeries && series.isSetStacked() && series.isStacked()) {
                    series.setLabelPosition(Position.INSIDE_LITERAL);
                }
                this.setTypeComboState();
            } else if (e.widget == this.btnTranslucent) {
                if (this.btnTranslucent.getSelectionState() == 0) {
                    series.unsetTranslucent();
                } else {
                    series.setTranslucent(this.btnTranslucent.getSelectionState() == 1);
                }
            } else if (e.getSource().equals(this.linkSeries)) {
                this.switchTo(this.treeIndex);
            } else if (e.getSource().equals(this.spnZOrder)) {
                this.seriesDefn.setZOrder(this.spnZOrder.getSelection());
            }
        }

        private void convertSeriesType(Series series, String typeName) {
            Series newSeries = this.getNewSeries(typeName, series);
            ChartAdapter.beginIgnoreNotifications();
            SeriesDefinition[] seriesDefns = (SeriesDefinition[])ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)((Chart)SeriesSheetImpl.this.getChart()), (int)this.axisIndex).toArray((Object[])new SeriesDefinition[0]);
            if (!newSeries.canBeStacked()) {
                int i = 0;
                while (i < seriesDefns.length) {
                    if (seriesDefns[i].getDesignTimeSeries().isStacked()) {
                        seriesDefns[i].getDesignTimeSeries().setStacked(false);
                    }
                    ++i;
                }
            }
            ChartAdapter.endIgnoreNotifications();
            newSeries.eAdapters().addAll((Collection)this.seriesDefn.eAdapters());
            this.seriesDefn.getSeries().set(0, (Object)newSeries);
            SeriesSheetImpl.this.createSeriesOptions((ScrolledComposite)SeriesSheetImpl.this.cmpList.getParent());
            SeriesSheetImpl.this.cmpList.layout();
        }

        private Series getNewSeries(String sSeriesName, Series oldSeries) {
            try {
                ChartCacheManager.getInstance().cacheSeries(this.iSeriesDefinitionIndex, oldSeries);
                Series series = ChartCacheManager.getInstance().findSeries(htSeriesNames.get(sSeriesName).getDisplayName(), this.iSeriesDefinitionIndex);
                if (series == null) {
                    series = htSeriesNames.get(sSeriesName);
                    ChartAdapter.beginIgnoreNotifications();
                    ChartUIUtil.copyGeneralSeriesAttributes((Series)oldSeries, (Series)series);
                    ChartAdapter.endIgnoreNotifications();
                }
                ChartWizard.removeException((String)"SeriesSheetImpl.getNewSeries");
                return series;
            }
            catch (Exception e) {
                ChartWizard.showException((String)"SeriesSheetImpl.getNewSeries", (String)e.getLocalizedMessage());
                return null;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void handleEvent(Event event) {
            if (event.widget.equals((Object)this.txtTitle)) {
                String text = this.txtTitle.getText();
                if (text == null || text.trim().length() == 0) {
                    this.seriesDefn.getDesignTimeSeries().setSeriesIdentifier(null);
                } else {
                    this.seriesDefn.getDesignTimeSeries().setSeriesIdentifier((Object)this.txtTitle.getText());
                }
            }
        }

        private void populateLists(Series series) {
            if (htSeriesNames == null) {
                htSeriesNames = new Hashtable(20);
            }
            ChartUIExtensionUtil.populateSeriesTypesList(htSeriesNames, this.cmbTypes, (ChartWizardContext)SeriesSheetImpl.this.getContext(), SeriesSheetImpl.this.cTypes, series);
        }

        private void switchTo(int index) {
            TreeItem currentItem = SeriesSheetImpl.this.getParentTask().getNavigatorTree().getSelection()[0];
            TreeItem[] children = currentItem.getItems();
            if (index < children.length) {
                SeriesSheetImpl.this.getParentTask().switchToTreeItem(children[index]);
            }
        }

        public void setTypeComboState() {
            if (this.btnStack == null) {
                return;
            }
            ChartDimension cd = ((Chart)SeriesSheetImpl.this.getChart()).getDimension();
            if (cd == ChartDimension.TWO_DIMENSIONAL_LITERAL || cd == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
                if (this.btnStack.getSelectionState() == 1) {
                    this.cmbTypes.setEnabled(false);
                } else {
                    EList seriesDefns = ((ChartWizardContext)SeriesSheetImpl.this.getContext()).isMoreAxesSupported() || ChartUIUtil.getOrthogonalAxisNumber((Chart)((Chart)SeriesSheetImpl.this.getChart())) > 2 ? ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)((Chart)SeriesSheetImpl.this.getChart()), (int)0) : ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)((Chart)SeriesSheetImpl.this.getChart()), (int)this.axisIndex);
                    Series s = ((SeriesDefinition)seriesDefns.get(0)).getDesignTimeSeries();
                    if (s != this.seriesDefn.getDesignTimeSeries()) {
                        this.cmbTypes.setEnabled(true);
                    } else {
                        this.cmbTypes.setEnabled(false);
                    }
                }
            }
        }

        private void setStackedBoxState() {
            if (this.btnStack == null) {
                return;
            }
            ChartDimension cd = ((Chart)SeriesSheetImpl.this.getChart()).getDimension();
            if (cd == ChartDimension.TWO_DIMENSIONAL_LITERAL || cd == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
                EList seriesDefns = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)((Chart)SeriesSheetImpl.this.getChart()), (int)this.axisIndex);
                Series s = ((SeriesDefinition)seriesDefns.get(0)).getDesignTimeSeries();
                if (s.getDisplayName().equals(this.seriesDefn.getDesignTimeSeries().getDisplayName())) {
                    if (this.canStack && this.seriesDefn.getDesignTimeSeries().canBeStacked() && !this.bStackedPercent) {
                        this.btnStack.setEnabled(true);
                    }
                } else {
                    this.btnStack.setEnabled(false);
                    this.cmbTypes.setEnabled(true);
                }
            }
        }
    }
}

