/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.connectivity;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.db.generic.JDBCConnection;
import org.eclipse.datatools.enablement.ingres.internal.connectivity.VersionHelper;

public class IngresJDBCConnection
extends JDBCConnection {
    private String mServerName;
    private Version mServerVersion;
    private Version mTechVersion;

    public IngresJDBCConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    public String getProviderName() {
        return this.mServerName;
    }

    public Version getProviderVersion() {
        return this.mServerVersion;
    }

    public Version getTechnologyVersion() {
        return this.mTechVersion;
    }

    protected void initVersions() {
        try {
            DatabaseMetaData dbmd = ((Connection)this.getRawConnection()).getMetaData();
            try {
                this.mServerName = dbmd.getDatabaseProductName();
            }
            catch (Throwable throwable) {}
            try {
                String versionString = dbmd.getDatabaseProductVersion();
                this.mServerVersion = VersionHelper.valueOf(versionString);
            }
            catch (Throwable throwable) {}
            try {
                this.mTechVersion = new Version(dbmd.getJDBCMajorVersion(), dbmd.getJDBCMinorVersion(), 0, "");
            }
            catch (Throwable throwable) {}
        }
        catch (SQLException sQLException) {}
    }
}

