/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.report.exception.ViewerValidationException;
import org.eclipse.birt.report.model.api.metadata.ValidationValueException;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ParameterDataTypeConverter;
import org.eclipse.birt.report.utility.BirtUtility;

public class DataUtil {
    public static String getString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static String trimString(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    public static String trimSep(String path) {
        return DataUtil.trimSepFirst(DataUtil.trimSepEnd(path));
    }

    public static String trimSepEnd(String path) {
        if ((path = DataUtil.trimString(path)).endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String trimSepFirst(String path) {
        if ((path = DataUtil.trimString(path)).startsWith(File.separator)) {
            path = path.substring(1);
        }
        return path;
    }

    private static String getDefaultDateFormat(String dataType) {
        String defFormat = null;
        if ("dateTime".equalsIgnoreCase(dataType)) {
            defFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        } else if ("date".equalsIgnoreCase(dataType)) {
            defFormat = "yyyy-MM-dd";
        } else if ("time".equalsIgnoreCase(dataType)) {
            defFormat = "HH:mm:ss";
        }
        return defFormat;
    }

    public static Object validate(String paramName, String dataType, String format, String value, Locale locale, TimeZone timeZone, boolean isLocale) throws ViewerValidationException {
        if (paramName == null || value == null || "$${{((null))}}$$".equals(value)) {
            return null;
        }
        if (!"string".equalsIgnoreCase(dataType) && value.trim().length() <= 0) {
            throw new ViewerValidationException(BirtResources.getMessage("birt.viewer.error.parameternotallowblank", new String[]{paramName}));
        }
        try {
            return DataUtil.validate(dataType, format, value, locale, timeZone, isLocale);
        }
        catch (ValidationValueException e) {
            throw new ViewerValidationException(BirtResources.getMessage("birt.viewer.error.parameter.invalid", new String[]{paramName}) + " " + e.getLocalizedMessage(), e);
        }
    }

    public static Object validateWithPattern(String paramName, String dataType, String format, String value, Locale locale, TimeZone timeZone, boolean isLocale) throws ViewerValidationException {
        if (paramName == null || "$${{((null))}}$$".equals(value)) {
            return null;
        }
        try {
            return DataUtil.validateWithPattern(dataType, format, value, locale, timeZone, isLocale);
        }
        catch (ValidationValueException e) {
            throw new ViewerValidationException(BirtResources.getMessage("birt.viewer.error.parameter.invalid", new String[]{paramName}) + " " + e.getLocalizedMessage(), e);
        }
    }

    public static Object validate(String dataType, String format, String value, Locale locale, TimeZone timeZone, boolean isLocale) throws ValidationValueException {
        Object obj = null;
        if (value == null || "$${{((null))}}$$".equals(value)) {
            return null;
        }
        obj = isLocale ? DataUtil.validateWithLocale(dataType, format, value, locale, timeZone) : ParameterValidationUtil.validate((String)dataType, (String)DataUtil.getDefaultDateFormat(dataType), (String)value, (com.ibm.icu.util.TimeZone)BirtUtility.toICUTimeZone(timeZone));
        return obj;
    }

    public static Object validateWithPattern(String dataType, String format, String value, Locale locale, TimeZone timeZone, boolean isLocale) throws ValidationValueException {
        Object obj = null;
        if (value == null || "$${{((null))}}$$".equals(value)) {
            return null;
        }
        if (isLocale) {
            obj = DataUtil.validateWithLocale(dataType, format, value, locale, timeZone);
        } else {
            if (format == null) {
                format = DataUtil.getDefaultDateFormat(dataType);
            }
            obj = ParameterValidationUtil.validate((String)dataType, (String)format, (String)value, (com.ibm.icu.util.TimeZone)BirtUtility.toICUTimeZone(timeZone));
        }
        return obj;
    }

    public static Object validateWithLocale(String dataType, String format, String value, Locale locale, TimeZone timeZone) throws ValidationValueException {
        Object obj = null;
        if (value == null || "$${{((null))}}$$".equals(value)) {
            return null;
        }
        try {
            if (format == null) {
                if ("date".equalsIgnoreCase(dataType)) {
                    format = "Medium Date";
                } else if ("time".equalsIgnoreCase(dataType)) {
                    format = "Medium Time";
                } else if ("dateTime".equalsIgnoreCase(dataType)) {
                    format = "Unformatted";
                }
            }
            obj = ParameterValidationUtil.validate((String)dataType, (String)format, (String)value, (Locale)locale, (com.ibm.icu.util.TimeZone)BirtUtility.toICUTimeZone(timeZone));
        }
        catch (Exception e) {
            if ("dateTime".equalsIgnoreCase(dataType)) {
                try {
                    obj = timeZone != null ? DataTypeUtil.toDate((String)value, (com.ibm.icu.util.TimeZone)BirtUtility.toICUTimeZone(timeZone)) : DataTypeUtil.toDate((Object)value);
                }
                catch (BirtException el) {
                    throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "dateTime");
                }
            }
            if ("boolean".equalsIgnoreCase(dataType)) {
                try {
                    obj = ParameterValidationUtil.validate((String)dataType, (String)format, (String)String.valueOf(DataUtil.convert(value, ParameterDataTypeConverter.convertDataType(dataType))), (Locale)locale, (com.ibm.icu.util.TimeZone)BirtUtility.toICUTimeZone(timeZone));
                }
                catch (Exception e2) {
                    throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "boolean");
                }
            }
            obj = ParameterValidationUtil.validate((String)dataType, (String)DataUtil.getDefaultDateFormat(dataType), (String)value, (com.ibm.icu.util.TimeZone)BirtUtility.toICUTimeZone(timeZone));
        }
        return obj;
    }

    public static String getDisplayValue(String dataType, String format, Object value, Locale locale, TimeZone timeZone) {
        return ParameterValidationUtil.getDisplayValue((String)dataType, (String)format, (Object)value, (ULocale)ULocale.forLocale((Locale)locale), (com.ibm.icu.util.TimeZone)BirtUtility.toICUTimeZone(timeZone));
    }

    public static String getDisplayValue(Object value) {
        return DataUtil.getDisplayValue(value, null);
    }

    public static String getDisplayValue(Object value, TimeZone timeZone) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float || value instanceof Double) {
            return value.toString();
        }
        if (value instanceof BigDecimal || value instanceof com.ibm.icu.math.BigDecimal) {
            return value.toString().replaceFirst("E\\+", "E");
        }
        return ParameterValidationUtil.getDisplayValue((Object)value, (com.ibm.icu.util.TimeZone)BirtUtility.toICUTimeZone(timeZone));
    }

    public static String getCSVDisplayValue(Object value) throws BirtException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof com.ibm.icu.math.BigDecimal) {
            return value.toString();
        }
        return DataTypeUtil.toLocaleNeutralString((Object)value);
    }

    public static Object convert(Object source, int toType) throws BirtException {
        if (source == null) {
            return null;
        }
        if (toType == 0) {
            return source;
        }
        switch (toType) {
            case 6: {
                return DataTypeUtil.toInteger((Object)source);
            }
            case 3: {
                return DataTypeUtil.toBigDecimal((Object)source);
            }
            case 5: {
                return DataTypeUtil.toBoolean((Object)source);
            }
            case 4: {
                return DataTypeUtil.toDate((Object)source);
            }
            case 2: {
                return DataTypeUtil.toDouble((Object)source);
            }
            case 1: {
                return DataTypeUtil.toString((Object)source);
            }
            case 7: {
                return DataTypeUtil.toSqlDate((Object)source);
            }
            case 8: {
                return DataTypeUtil.toSqlTime((Object)source);
            }
        }
        throw new CoreException("Invalid type.");
    }

    public static String toUTF8(byte[] bytes) {
        assert (bytes != null);
        String str = null;
        try {
            str = new String(bytes, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String getOdaTypeName(int odaTypeCode) {
        switch (odaTypeCode) {
            case 4: {
                return "INT";
            }
            case 6: 
            case 8: {
                return "DOUBLE";
            }
            case 12: {
                return "STRING";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2: 
            case 3: {
                return "BIGDECIMAL";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
        }
        return "STRING";
    }

    public static boolean contain(List values, String value, boolean ifDelete) {
        if (values == null) {
            return false;
        }
        for (Object obj : values) {
            if (obj == null) {
                if (value != null) continue;
                if (ifDelete) {
                    values.remove(obj);
                }
                return true;
            }
            if (!(obj instanceof String) || !((String)obj).equals(value)) continue;
            if (ifDelete) {
                values.remove(obj);
            }
            return true;
        }
        return false;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 != null) {
            return s1.equals(s2);
        }
        if (s2 != null) {
            return s2.equals(s1);
        }
        return true;
    }
}

