/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.AbstractGroupedDataRowExpressionEvaluator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.emf.common.util.EList;

public class BaseGroupedQueryResultSetEvaluator
extends AbstractGroupedDataRowExpressionEvaluator {
    protected static final ILogger sLogger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    protected IResultIterator fResultIterator;
    protected List<IGroupDefinition> fGroupDefinitions;
    protected boolean fIsGrouped = false;
    protected int fGroupCount;
    protected boolean[] faEnabledGroups;
    protected List<Integer>[] faGroupBreaks;
    protected int fCountOfAvaiableRows = 0;
    protected boolean fHasSummaryAggregation = false;
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
    protected ExtendedItemHandle itemHandle = null;

    public BaseGroupedQueryResultSetEvaluator(IResultIterator resultIterator, boolean hasSummaryAggregation, Chart cm, ExtendedItemHandle handle) throws ChartException {
        this.fHasSummaryAggregation = hasSummaryAggregation;
        this.itemHandle = handle;
        this.fResultIterator = resultIterator;
        this.fGroupDefinitions = this.fResultIterator.getQueryResults().getPreparedQuery().getReportQueryDefn().getGroups();
        if (this.fGroupDefinitions != null && this.fGroupDefinitions.size() > 0) {
            this.fIsGrouped = true;
            this.fGroupCount = this.fGroupDefinitions.size();
            this.faGroupBreaks = new List[this.fGroupDefinitions.size()];
            int i = 0;
            while (i < this.faGroupBreaks.length) {
                this.faGroupBreaks[i] = new ArrayList<Integer>();
                ++i;
            }
            this.updateEnabledGroupIndexes(cm, this.fGroupDefinitions);
        }
    }

    public BaseGroupedQueryResultSetEvaluator(IResultIterator resultIterator, boolean hasAggregation, boolean isSubQuery, Chart cm, ExtendedItemHandle handle) throws ChartException {
        this.fHasSummaryAggregation = hasAggregation;
        this.itemHandle = handle;
        this.fResultIterator = resultIterator;
        if (isSubQuery) {
            List groups;
            ArrayList subQuerys = new ArrayList();
            Collection c = this.fResultIterator.getQueryResults().getPreparedQuery().getReportQueryDefn().getSubqueries();
            if (c != null && !c.isEmpty()) {
                subQuerys.addAll(c);
            }
            if ((groups = this.fResultIterator.getQueryResults().getPreparedQuery().getReportQueryDefn().getGroups()) != null) {
                Iterator iter = groups.iterator();
                while (iter.hasNext()) {
                    c = ((IGroupDefinition)iter.next()).getSubqueries();
                    if (c == null || c.isEmpty()) continue;
                    subQuerys.addAll(c);
                }
            }
            int i = 0;
            while (i < subQuerys.size()) {
                if (("chart_subquery" + handle.getElement().getID()).equals(((ISubqueryDefinition)subQuerys.get(i)).getName())) {
                    this.fGroupDefinitions = ((ISubqueryDefinition)subQuerys.get(i)).getGroups();
                    break;
                }
                ++i;
            }
            if (this.fGroupDefinitions == null) {
                this.fGroupDefinitions = this.fResultIterator.getQueryResults().getPreparedQuery().getReportQueryDefn().getGroups();
            }
        } else {
            this.fGroupDefinitions = this.fResultIterator.getQueryResults().getPreparedQuery().getReportQueryDefn().getGroups();
        }
        if (this.fGroupDefinitions != null && this.fGroupDefinitions.size() > 0) {
            this.fIsGrouped = true;
            this.fGroupCount = this.fGroupDefinitions.size();
            this.faGroupBreaks = new List[this.fGroupDefinitions.size()];
            int i = 0;
            while (i < this.faGroupBreaks.length) {
                this.faGroupBreaks[i] = new ArrayList<Integer>();
                ++i;
            }
            this.updateEnabledGroupIndexes(cm, this.fGroupDefinitions);
        }
    }

    protected List<Integer> getGroupBreaksList(int groupLevel) {
        if (this.faGroupBreaks == null || groupLevel < 0 || groupLevel > this.faGroupBreaks.length - 1) {
            return new ArrayList<Integer>();
        }
        return this.faGroupBreaks[groupLevel];
    }

    public int[] getGroupBreaks(int groupLevel) {
        Object[] breaksArray = this.getGroupBreaksList(groupLevel).toArray();
        int[] breaks = new int[breaksArray.length];
        int i = 0;
        while (i < breaksArray.length) {
            breaks[i] = (Integer)breaksArray[i];
            ++i;
        }
        return breaks;
    }

    public void close() {
        try {
            this.fResultIterator.close();
        }
        catch (BirtException e) {
            sLogger.log((Exception)((Object)e));
        }
    }

    public Object evaluate(String expression) {
        try {
            this.exprCodec.decode(expression);
            if (this.exprCodec.isConstant()) {
                return this.exprCodec.getExpression();
            }
            return this.fResultIterator.getValue(this.exprCodec.getExpression());
        }
        catch (BirtException e) {
            sLogger.log((Exception)((Object)e));
            return e;
        }
    }

    public Object evaluateGlobal(String expression) {
        return this.evaluate(expression);
    }

    public boolean first() {
        block5: {
            this.fCountOfAvaiableRows = 0;
            if (this.fIsGrouped) break block5;
            if (this.fResultIterator.next()) {
                return true;
            }
        }
        try {
            if (this.findFirst()) {
                return true;
            }
        }
        catch (BirtException e) {
            sLogger.log((Exception)((Object)e));
        }
        return false;
    }

    protected boolean findFirst() throws BirtException {
        if (!this.fResultIterator.next()) {
            return false;
        }
        int groupLevel = this.fResultIterator.getStartingGroupLevel();
        if (groupLevel == 0) {
            return true;
        }
        return this.findFirst();
    }

    private boolean usedByChart(int startIndex, int endIndex) {
        int i = startIndex;
        while (i <= endIndex) {
            if (this.faEnabledGroups[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean findNext() throws BirtException {
        while (this.fResultIterator.next()) {
            int startIndex = this.fResultIterator.getStartingGroupLevel();
            if (startIndex > 0 && startIndex <= this.fGroupCount && this.usedByChart(startIndex - 1, this.fGroupCount - 1)) {
                ++this.fCountOfAvaiableRows;
                this.getGroupBreaksList(startIndex - 1).add(this.fCountOfAvaiableRows);
                int i = startIndex;
                while (i < this.fGroupCount) {
                    this.getGroupBreaksList(i).add(this.fCountOfAvaiableRows);
                    ++i;
                }
                return true;
            }
            if (this.fHasSummaryAggregation) continue;
            ++this.fCountOfAvaiableRows;
            return true;
        }
        return false;
    }

    public boolean next() {
        block4: {
            if (this.fIsGrouped) break block4;
            if (this.fResultIterator.next()) {
                ++this.fCountOfAvaiableRows;
                return true;
            }
        }
        try {
            return this.findNext();
        }
        catch (BirtException e) {
            sLogger.log((Exception)((Object)e));
        }
        return false;
    }

    protected void updateEnabledGroupIndexes(Chart cm, List<IGroupDefinition> groupDefinitions) throws ChartException {
        this.faEnabledGroups = new boolean[this.fGroupCount];
        boolean isSharing = this.isSharing();
        EList baseSDs = ChartUtil.getBaseSeriesDefinitions((Chart)cm);
        for (SeriesDefinition sd : baseSDs) {
            Query q;
            String expr;
            int index;
            if (sd.getDesignTimeSeries().getDataDefinition().isEmpty() || sd.getGrouping() == null || !sd.getGrouping().isEnabled() || (index = this.getGroupIndex(expr = (q = (Query)sd.getDesignTimeSeries().getDataDefinition().get(0)).getDefinition(), groupDefinitions, true)) < 0) continue;
            this.faEnabledGroups[index] = true;
            if (!isSharing || sd.getGrouping() == null) continue;
            IGroupDefinition gd = groupDefinitions.get(index);
            this.setGroupingInterval(sd.getGrouping(), gd);
        }
        List orthoSDs = ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm);
        for (SeriesDefinition sd : orthoSDs) {
            String expr;
            int index;
            Query q = sd.getQuery();
            if (q == null || q.getDefinition() == null || "".equals(q.getDefinition().trim()) || (index = this.getGroupIndex(expr = q.getDefinition(), groupDefinitions, false)) < 0) continue;
            this.faEnabledGroups[index] = true;
            if (!isSharing || sd.getQuery() == null) continue;
            IGroupDefinition gd = groupDefinitions.get(index);
            this.setGroupingInterval(sd.getQuery().getGrouping(), gd);
        }
    }

    private void setGroupingInterval(SeriesGrouping sg, IGroupDefinition gd) {
        GroupingUnitType gut = GroupingUnitType.get((int)ChartItemUtil.convertToChartGroupUnit(gd.getInterval()));
        if (gut != null && sg != null) {
            sg.setGroupingUnit(gut);
            sg.setGroupingInterval(gd.getIntervalRange());
        }
    }

    private int getGroupIndex(String expr, List<IGroupDefinition> groupDefinitions, boolean isCategory) throws ChartException {
        if (expr == null) {
            return -1;
        }
        this.exprCodec.decode(expr);
        Set bindingNameSet = this.exprCodec.getRowBindingNameSet();
        boolean isJavaScript = "javascript".equals(this.exprCodec.getType());
        if (isCategory) {
            int i = groupDefinitions.size() - 1;
            while (i >= 0) {
                IGroupDefinition gd = groupDefinitions.get(i);
                String exprGroupKey = gd.getKeyExpression();
                if (isJavaScript && expr.indexOf(exprGroupKey) >= 0) {
                    return i;
                }
                if (!bindingNameSet.isEmpty()) {
                    Set grpBindings = this.exprCodec.getRowBindingNameSet(exprGroupKey);
                    for (String grpBinding : grpBindings) {
                        if (!bindingNameSet.contains(grpBinding)) continue;
                        return i;
                    }
                }
                --i;
            }
        } else {
            int i = 0;
            while (i < groupDefinitions.size()) {
                IGroupDefinition gd = groupDefinitions.get(i);
                String exprGroupKey = gd.getKeyExpression();
                if (isJavaScript && expr.indexOf(exprGroupKey) >= 0) {
                    return i;
                }
                if (!bindingNameSet.isEmpty()) {
                    Set grpBindings = this.exprCodec.getRowBindingNameSet(exprGroupKey);
                    for (String grpBinding : grpBindings) {
                        if (!bindingNameSet.contains(grpBinding)) continue;
                        return i;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    private boolean isSharing() {
        if (this.itemHandle == null) {
            return false;
        }
        return ChartItemUtil.isChartInheritGroups((ReportItemHandle)this.itemHandle) || ChartItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle) != null;
    }

    public boolean[] getGroupStatus() {
        return this.faEnabledGroups;
    }
}

