/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCCatalogLoader;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogPreDefinedType;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogRole;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECache;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECatalogType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASERole;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEDatabaseImpl;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogDatabase
extends SybaseASEDatabaseImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 3257562914901669687L;
    private Connection connection;
    private Boolean webServicesLoaded = Boolean.FALSE;
    private Boolean dataTypesLoaded = Boolean.FALSE;
    private Boolean catalogsLoaded = Boolean.FALSE;
    private Boolean rolesLoaded = Boolean.FALSE;
    private Boolean cachesLoaded = Boolean.FALSE;
    private Boolean encryptionKeyApplicableLoaded = Boolean.FALSE;
    private Boolean webserviceApplicableLoaded = Boolean.FALSE;
    private Boolean sdsServerLoaded = Boolean.FALSE;
    private Boolean tempDBNameLoaded = Boolean.FALSE;
    private SoftReference catalogLoaderRef;
    private String dbName = null;

    public SybaseASECatalogDatabase(Connection connection) {
        if (connection == null) {
            System.err.println("null connection");
            throw new RuntimeException();
        }
        this.connection = connection;
        try {
            this.name = this.dbName = this.connection.getCatalog();
        }
        catch (SQLException e) {
            JDBCASEPlugin.getDefault().log(e);
        }
    }

    public SybaseASECatalogDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        Boolean bl = this.catalogsLoaded;
        synchronized (bl) {
            if (this.catalogsLoaded.booleanValue()) {
                this.catalogsLoaded = Boolean.FALSE;
            }
        }
        bl = this.webServicesLoaded;
        synchronized (bl) {
            if (this.webServicesLoaded.booleanValue()) {
                this.webServicesLoaded = Boolean.FALSE;
            }
        }
        bl = this.dataTypesLoaded;
        synchronized (bl) {
            if (this.dataTypesLoaded.booleanValue()) {
                this.dataTypesLoaded = Boolean.FALSE;
            }
        }
        bl = this.rolesLoaded;
        synchronized (bl) {
            if (this.rolesLoaded.booleanValue()) {
                this.rolesLoaded = Boolean.FALSE;
            }
        }
        bl = this.sdsServerLoaded;
        synchronized (bl) {
            if (this.sdsServerLoaded.booleanValue()) {
                this.sdsServerLoaded = Boolean.FALSE;
            }
        }
        bl = this.cachesLoaded;
        synchronized (bl) {
            if (this.cachesLoaded.booleanValue()) {
                this.cachesLoaded = Boolean.FALSE;
            }
        }
        bl = this.encryptionKeyApplicableLoaded;
        synchronized (bl) {
            if (this.encryptionKeyApplicableLoaded.booleanValue()) {
                this.encryptionKeyApplicableLoaded = Boolean.FALSE;
            }
        }
        bl = this.webserviceApplicableLoaded;
        synchronized (bl) {
            if (this.webserviceApplicableLoaded.booleanValue()) {
                this.webserviceApplicableLoaded = Boolean.FALSE;
            }
        }
        bl = this.tempDBNameLoaded;
        synchronized (bl) {
            if (this.tempDBNameLoaded.booleanValue()) {
                this.tempDBNameLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getWebServices() {
        Boolean bl = this.webServicesLoaded;
        synchronized (bl) {
            if (!this.webServicesLoaded.booleanValue()) {
                this.loadWebServices();
            }
        }
        return super.getWebServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getDataTypes() {
        Boolean bl = this.dataTypesLoaded;
        synchronized (bl) {
            if (!this.dataTypesLoaded.booleanValue()) {
                this.loadDataTypes();
            }
        }
        return super.getDataTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getCatalogs() {
        Boolean bl = this.catalogsLoaded;
        synchronized (bl) {
            if (!this.catalogsLoaded.booleanValue()) {
                this.loadCatalogs();
            }
        }
        return super.getCatalogs();
    }

    protected JDBCCatalogLoader createLoader() {
        return new ASECatalogLoader(this);
    }

    protected final JDBCCatalogLoader getLoader() {
        if (this.catalogLoaderRef == null || this.catalogLoaderRef.get() == null) {
            this.catalogLoaderRef = new SoftReference<JDBCCatalogLoader>(this.createLoader());
        }
        return (JDBCCatalogLoader)this.catalogLoaderRef.get();
    }

    private void loadCatalogs() {
        try {
            boolean deliver = this.eDeliver();
            this.eSetDeliver(false);
            EList catalogList = super.getCatalogs();
            ArrayList existingCatalogs = new ArrayList(catalogList.size());
            existingCatalogs.addAll(catalogList);
            this.getLoader().clearCatalogs((Collection)catalogList);
            this.getLoader().loadCatalogs((List)catalogList, existingCatalogs);
            this.catalogsLoaded = Boolean.TRUE;
            this.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASEPlugin.getDefault().log(e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getCatalogDatabase() {
        return this;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 18: {
                this.getWebServices();
                break;
            }
            case 12: {
                this.getCatalogs();
                break;
            }
            case 14: {
                this.getDataTypes();
                break;
            }
            case 16: {
                this.getRoles();
                break;
            }
            case 17: {
                this.getCaches();
                break;
            }
            case 15: {
                this.isEncryptionKeyApplicable();
                break;
            }
            case 19: {
                this.isWebserviceApplicable();
            }
        }
        return super.eIsSet(eFeature);
    }

    private void loadDataTypes() {
        EList datatypesList = super.getDataTypes();
        datatypesList.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            List list = SybaseASECatalogUtils.getDBDatatypes(this.dbName, this.connection);
            int i = 0;
            while (i < list.size()) {
                String typename = (String)list.get(i);
                SybaseASECatalogPreDefinedType datatype = new SybaseASECatalogPreDefinedType();
                datatype.setName(typename);
                datatypesList.add((Object)datatype);
                ++i;
            }
            this.dataTypesLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            JDBCASEPlugin.getDefault().log(e);
        }
        this.eSetDeliver(deliver);
    }

    private void loadWebServices() {
    }

    private synchronized ResultSet getWSs() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getRoles() {
        Boolean bl = this.rolesLoaded;
        synchronized (bl) {
            if (!this.rolesLoaded.booleanValue()) {
                this.loadRoles();
            }
        }
        return super.getRoles();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void loadRoles() {
        block19: {
            block18: {
                if (this.rolesLoaded.booleanValue()) {
                    return;
                }
                deliver = this.eDeliver();
                this.eSetDeliver(false);
                roleList = super.getRoles();
                existingRoles = new ArrayList<E>();
                existingRoles.addAll(roleList);
                roleList.clear();
                stmt = null;
                rs = null;
                conn = this.getConnection();
                oldCatalog = null;
                accessSysSvr = true;
                roleSet = new HashSet<String>();
                try {
                    try {
                        oldCatalog = conn.getCatalog();
                        stmt = conn.prepareStatement("SELECT name FROM master.dbo.syssrvroles where name like ? order by 1");
                        stmt.setString(1, "%");
                        try {
                            rs = stmt.executeQuery();
                        }
                        catch (SQLException v0) {
                            accessSysSvr = false;
                        }
                        if (accessSysSvr) {
                            while (rs.next()) {
                                roleSet.add(rs.getString(1));
                            }
                            break block18;
                        }
                        catalogs = this.getCatalogs();
                        dbName = new String[catalogs.size()];
                        i = 0;
                        while (i < catalogs.size()) {
                            if (catalogs.get(i) instanceof Catalog) {
                                dbName[i] = ((Catalog)catalogs.get(i)).getName();
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < dbName.length) {
                            stmt = conn.prepareStatement(new MessageFormat("select S.name from {0}.dbo.sysroles R, {0}.dbo.sysusers S where R.lrid=S.uid").format(new Object[]{dbName[i]}));
                            try {
                                rs = stmt.executeQuery();
                                ** GOTO lbl55
                            }
                            catch (SQLException sqle) {
                                block20: {
                                    if (sqle.getErrorCode() != 10351) break block20;
                                    JDBCASEPlugin.getDefault().log(sqle.getMessage());
                                    if (true) ** GOTO lbl55
                                }
                                throw sqle;
                            }
                            do {
                                roleSet.add(rs.getString(1));
lbl55:
                                // 3 sources

                            } while (rs.next());
                            ++i;
                        }
                    }
                    catch (SQLException e) {
                        JDBCASEPlugin.getDefault().log(e);
                        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                        break block19;
                    }
                }
                catch (Throwable var14_18) {
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    throw var14_18;
                }
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        rolesArray = new String[roleSet.size()];
        roleSet.toArray(rolesArray);
        Arrays.sort(rolesArray);
        i = 0;
        while (i < rolesArray.length) {
            roleName = rolesArray[i];
            role /* !! */  = (SybaseASERole)ASEUtil.getSQLObject(existingRoles, (String)roleName);
            if (role /* !! */  != null) {
                roleList.add((Object)role /* !! */ );
                ((ICatalogObject)role /* !! */ ).refresh();
            } else {
                role /* !! */  = new SybaseASECatalogRole(this);
                role /* !! */ .setName((String)roleName);
                role /* !! */ .setSqlContainer((SQLObject)this);
                roleList.add((Object)role /* !! */ );
            }
            ++i;
        }
        this.rolesLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEncryptionKeyApplicable() {
        Boolean bl = this.encryptionKeyApplicableLoaded;
        synchronized (bl) {
            if (!this.encryptionKeyApplicableLoaded.booleanValue()) {
                this.loadEncryptionKeyApplicable();
            }
        }
        return super.isEncryptionKeyApplicable();
    }

    private void loadEncryptionKeyApplicable() {
        int resultVal;
        if (this.encryptionKeyApplicableLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        boolean result = false;
        if (this.getVersion().compareTo("12.5.3") >= 0 && (resultVal = SybaseASECatalogUtils.getConfigureOption("enable encrypted columns", this.connection)) == 1) {
            result = true;
        }
        super.setEncryptionKeyApplicable(result);
        this.encryptionKeyApplicableLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWebserviceApplicable() {
        Boolean bl = this.webserviceApplicableLoaded;
        synchronized (bl) {
            if (!this.webserviceApplicableLoaded.booleanValue()) {
                this.loadWebServiceApplicable();
            }
        }
        return super.isWebserviceApplicable();
    }

    private void loadWebServiceApplicable() {
        if (this.webserviceApplicableLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        boolean result = false;
        int resultVal = SybaseASECatalogUtils.getConfigureOption("enable webservices", this.connection);
        if (resultVal == 1) {
            result = true;
        }
        super.setWebserviceApplicable(result);
        this.webserviceApplicableLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getCaches() {
        Boolean bl = this.cachesLoaded;
        synchronized (bl) {
            if (!this.cachesLoaded.booleanValue()) {
                this.loadCaches();
            }
        }
        return super.getCaches();
    }

    private void loadCaches() {
        boolean deliver;
        block8: {
            if (this.cachesLoaded.booleanValue()) {
                return;
            }
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            EList cacheList = super.getCaches();
            ArrayList existingCaches = new ArrayList();
            existingCaches.addAll(cacheList);
            cacheList.clear();
            DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition((Database)this);
            DataModelElementFactory factory = dbDef.getDataModelElementFactory();
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog("master");
                    stmt = conn.prepareStatement("SELECT a.name, a.status, a.value FROM master.dbo.sysconfigures a WHERE parent = 19 AND config = parent and a.name like ? ORDER BY 1");
                    stmt.setString(1, "%");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String name = rs.getString(1);
                        SybaseASECache cache = (SybaseASECache)ASEUtil.getSQLObject(existingCaches, name);
                        if (cache == null) {
                            cache = (SybaseASECache)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getSybaseASECache());
                        }
                        cache.setName(name);
                        cacheList.add((Object)cache);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.cachesLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTempDBName() {
        Boolean bl = this.tempDBNameLoaded;
        synchronized (bl) {
            if (!this.tempDBNameLoaded.booleanValue()) {
                this.loadTempDBName();
            }
        }
        return super.getTempDBName();
    }

    private void loadTempDBName() {
        boolean deliver;
        block7: {
            if (this.tempDBNameLoaded.booleanValue()) {
                return;
            }
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog("master");
                    stmt = conn.prepareStatement("SELECT db_name(@@tempdbid)");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String name = rs.getString(1);
                        this.setTempDBName(name);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.tempDBNameLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    private void loadSDSServers() {
        boolean deliver;
        block7: {
            if (this.sdsServerLoaded.booleanValue()) {
                return;
            }
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            EList sdsServer = super.getSdsServer();
            sdsServer.clear();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Connection conn = this.getConnection();
            try {
                try {
                    stmt = conn.prepareStatement("SELECT srvname FROM master.dbo.sysservers WHERE srvclass = 6");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String sds = rs.getString(1);
                        sdsServer.add((Object)sds);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, null, conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, null, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, null, conn);
        }
        this.sdsServerLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getSdsServer() {
        Boolean bl = this.sdsServerLoaded;
        synchronized (bl) {
            if (!this.sdsServerLoaded.booleanValue()) {
                this.loadSDSServers();
            }
        }
        return super.getSdsServer();
    }

    private static class ASECatalogLoader
    extends JDBCCatalogLoader {
        public ASECatalogLoader(ICatalogObject catalogObject) {
            super(catalogObject, null);
        }

        protected Catalog createCatalog() {
            return new SybaseASECatalog();
        }

        protected ResultSet createResultSet() throws SQLException {
            IConnectionProfile profile;
            Properties props;
            String databaseName;
            String query = null;
            query = "SELECT name as TABLE_CAT, def_remote_loc, status3 FROM master.dbo.sysdatabases WHERE (status & 32) != 32 ORDER BY 1";
            if (DatabaseConnectionRegistry.getConnectionForDatabase((Database)this.getDatabase()) != null && (databaseName = (props = (profile = DatabaseConnectionRegistry.getConnectionForDatabase((Database)this.getDatabase()).getConnectionProfile()).getBaseProperties()).getProperty("org.eclipse.datatools.connectivity.db.databaseName")) != null && databaseName.trim().length() > 0) {
                query = MessageFormat.format("SELECT name as TABLE_CAT, def_remote_loc, status3 FROM master.dbo.sysdatabases WHERE (status & 32) != 32 AND name = ''{0}'' ORDER BY 1", databaseName);
            }
            Connection conn = this.getCatalogObject().getConnection();
            ResultSet rs = null;
            PreparedStatement stmt = conn.prepareStatement(query);
            try {
                rs = stmt.executeQuery();
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
                throw e;
            }
            return rs;
        }

        protected void initialize(Catalog catalog, ResultSet rs) throws SQLException {
            String name = rs.getString("TABLE_CAT");
            String defLocation = rs.getString(2);
            int status3 = rs.getInt(3);
            boolean istemp = (status3 & 0x100) == 256 || name.equals("tempdb");
            catalog.setName(name);
            ((SybaseASECatalog)catalog).setDefaultLocation(defLocation);
            SybaseASECatalogType ct = SybaseASECatalogType.USERCATALOG_LITERAL;
            if (defLocation != null && !defLocation.equals("")) {
                ct = SybaseASECatalogType.PROXYCATALOG_LITERAL;
            } else if (istemp) {
                ct = SybaseASECatalogType.TEMPCATALOG_LITERAL;
            }
            ((SybaseASECatalog)catalog).setCatalogType(ct);
        }
    }
}

