/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.impl.util;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.excel.ResultSetMetaDataHelper;
import org.eclipse.birt.report.data.oda.excel.impl.i18n.Messages;
import org.eclipse.birt.report.data.oda.excel.impl.util.ExcelFileReader;
import org.eclipse.birt.report.data.oda.excel.impl.util.ResourceLocatorUtil;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ExcelFileSource {
    private String fileExtension;
    private boolean isReaderInitialised;
    private IResultSetMetaData rsmd;
    private ResultSetMetaDataHelper rsmdHelper;
    private int statementMaxRows;
    private String currentTableName;
    private String uriPath;
    private URI uri;
    private boolean hasColumnNames;
    private boolean hasTypeLine;
    private List<String> sheetNameList = new ArrayList<String>();
    private ExcelFileReader excelFileReader;
    private int resultSetMaxRows = 0;
    private int maxRowsToRead = 0;
    private int fetchCounter = 0;
    public static final int MAX_ROWS_PER_FETCH = 65535;
    private int[] selectColumIndexes;
    private String[] originalColumnNames;
    private boolean isFirstTimeToReadSourceData = true;
    private List<String> nextDataLine;
    private Object resourceIdentifiers;

    public ExcelFileSource(Properties connProperties, String currentTableName, String workSheetNames, int statementMaxRows, IResultSetMetaData rsmd, ResultSetMetaDataHelper rsmdHelper, Map appContext) throws OdaException {
        this.rsmd = rsmd;
        this.rsmdHelper = rsmdHelper;
        this.statementMaxRows = statementMaxRows;
        this.currentTableName = currentTableName;
        this.resourceIdentifiers = appContext != null ? appContext.get("org.eclipse.datatools.connectivity.oda.util_consumerResourceIds") : null;
        this.fileExtension = ExcelFileReader.getExtensionName(this.resourceIdentifiers, connProperties.getProperty("URI"));
        Properties properties = this.getCopyOfConnectionProperties(connProperties);
        this.populateHomeDir(properties);
        this.populateHasColumnNames(properties);
        this.populateHasTypeLine(properties);
        this.populateWorksheetNames(workSheetNames);
    }

    public IResultSetMetaData getRsmd() {
        return this.rsmd;
    }

    public void setRsmd(IResultSetMetaData rsmd) {
        this.rsmd = rsmd;
    }

    public ResultSetMetaDataHelper getRsmdHelper() {
        return this.rsmdHelper;
    }

    public void setRsmdHelper(ResultSetMetaDataHelper rsmdHelper) {
        this.rsmdHelper = rsmdHelper;
    }

    public int getStatementMaxRows() {
        return this.statementMaxRows;
    }

    public void setStatementMaxRows(int statementMaxRows) {
        this.statementMaxRows = statementMaxRows;
    }

    public String getCurrentTableName() {
        return this.currentTableName;
    }

    public void setCurrentTableName(String currentTableName) {
        this.currentTableName = currentTableName;
    }

    private Properties getCopyOfConnectionProperties(Properties connProperties) {
        Properties copyConnProperites = new Properties();
        if (connProperties.getProperty("URI") != null) {
            copyConnProperites.setProperty("URI", connProperties.getProperty("URI"));
        }
        copyConnProperites.setProperty("INCLCOLUMNNAME", connProperties.getProperty("INCLCOLUMNNAME"));
        copyConnProperites.setProperty("INCLTYPELINE", connProperties.getProperty("INCLTYPELINE"));
        return copyConnProperites;
    }

    private void populateHomeDir(Properties connProperties) throws OdaException {
        this.uriPath = connProperties.getProperty("URI");
        this.uri = ResourceLocatorUtil.resolvePath(this.resourceIdentifiers, this.uriPath);
        if (this.uri == null) {
            throw new OdaException(Messages.getFormattedString("fileSource_excelFileNotFound", new Object[]{this.uriPath}));
        }
        try {
            ResourceLocatorUtil.validateFileURI(this.uri);
        }
        catch (Exception e) {
            throw new OdaException(Messages.getFormattedString("fileSource_excelFileNotFound", new Object[]{this.uriPath}));
        }
    }

    private void populateHasColumnNames(Properties connProperties) {
        this.hasColumnNames = !connProperties.getProperty("INCLCOLUMNNAME").equalsIgnoreCase("NO");
    }

    private void populateHasTypeLine(Properties connProperties) {
        this.hasTypeLine = !connProperties.getProperty("INCLTYPELINE").equalsIgnoreCase("NO");
    }

    private void populateWorksheetNames(String workSheetNames) throws OdaException {
        if (workSheetNames == null) {
            throw new OdaException(Messages.getString("query_WORKSHEET_CANNOT_BE_NULL"));
        }
        String[] workSheetNamesArray = workSheetNames.split(";");
        int index = 0;
        while (index < workSheetNamesArray.length) {
            this.sheetNameList.add(workSheetNamesArray[index]);
            ++index;
        }
    }

    public int getColumnCount() throws OdaException {
        int count;
        try {
            List<String> columnLine;
            this.initialiseReader();
            while (this.isEmptyRow(columnLine = this.excelFileReader.readLine())) {
            }
            count = columnLine.size();
        }
        catch (IOException e) {
            throw new OdaException(Messages.getString("query_IO_EXCEPTION") + this.findDataFileAbsolutePath());
        }
        return count;
    }

    public String findDataFileAbsolutePath() throws OdaException {
        if (this.uri == null) {
            throw new OdaException(Messages.getFormattedString("fileSource_excelFileNotFound", new Object[]{this.uriPath}));
        }
        try {
            ResourceLocatorUtil.validateFileURI(this.uri);
        }
        catch (Exception e) {
            throw new OdaException(Messages.getString("query_invalidTableName") + this.uriPath);
        }
        return this.uri.toString();
    }

    public String[][] getSourceData() throws OdaException {
        try {
            this.initialiseReader();
            List<String[]> v = this.fetchQueriedDataFromFileToList();
            String[][] stringArray = this.copyDataFromListToTwoDimensionArray(v);
            return stringArray;
        }
        catch (IOException e) {
            throw new OdaException((Throwable)e);
        }
        finally {
            try {
                this.excelFileReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private List<String[]> fetchQueriedDataFromFileToList() throws OdaException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        try {
            if (this.isFirstTimeToReadSourceData) {
                this.excelFileReader.setCurrentRowIndex(0);
                if (this.hasColumnNames) {
                    List<String> columeNameLine;
                    while (this.isEmptyRow(columeNameLine = this.excelFileReader.readLine())) {
                    }
                    this.originalColumnNames = this.getColumnNameArray(columeNameLine);
                    this.initNameIndexMap();
                }
                if (this.hasTypeLine) {
                    while (this.isEmptyRow(this.excelFileReader.readLine())) {
                    }
                }
                if (!this.hasColumnNames) {
                    while (this.isEmptyRow(this.nextDataLine = this.excelFileReader.readLine())) {
                    }
                    this.originalColumnNames = this.createTempColumnNames(this.nextDataLine);
                    this.initNameIndexMap();
                } else {
                    this.nextDataLine = this.excelFileReader.readLine();
                }
                this.excelFileReader.setMaxColumnIndex(this.originalColumnNames.length);
                this.isFirstTimeToReadSourceData = false;
            }
            int counterLimitPerFetch = this.fetchCounter + 65535;
            while ((this.maxRowsToRead <= 0 || this.fetchCounter < this.maxRowsToRead) && this.fetchCounter < counterLimitPerFetch && this.nextDataLine != null) {
                if (!this.isEmptyRow(this.nextDataLine)) {
                    ++this.fetchCounter;
                    result.add(this.fetchQueriedDataFromRow(this.nextDataLine));
                }
                this.nextDataLine = this.excelFileReader.readLine();
            }
            return result;
        }
        catch (IOException e) {
            throw new OdaException(e.getMessage());
        }
    }

    private String[][] copyDataFromListToTwoDimensionArray(List<String[]> v) throws OdaException {
        String[][] rowSet = new String[v.size()][this.rsmd.getColumnCount()];
        int i = 0;
        while (i < v.size()) {
            String[] temp = v.get(i);
            int j = 0;
            while (j < temp.length) {
                if (temp[j] == null) {
                    throw new OdaException(Messages.getString("data_read_error"));
                }
                rowSet[i][j] = temp[j].trim();
                ++j;
            }
            ++i;
        }
        return rowSet;
    }

    private void initNameIndexMap() throws OdaException {
        assert (this.originalColumnNames != null);
        HashMap<String, Integer> originalColumnNameIndexMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < this.originalColumnNames.length) {
            originalColumnNameIndexMap.put(this.originalColumnNames[i].trim().toUpperCase(), i);
            ++i;
        }
        this.selectColumIndexes = new int[this.rsmd.getColumnCount()];
        i = 0;
        while (i < this.rsmd.getColumnCount()) {
            this.selectColumIndexes[i] = this.findIndex(this.rsmdHelper.getOriginalColumnName(this.rsmd.getColumnName(i + 1)), originalColumnNameIndexMap);
            ++i;
        }
    }

    private String[] createTempColumnNames(List<String> aRow) throws OdaException {
        String[] tempColumnNames = new String[aRow.size()];
        int i = 0;
        while (i < aRow.size()) {
            tempColumnNames[i] = ExcelFileSource.formatTempColumnName(i + 1);
            ++i;
        }
        return tempColumnNames;
    }

    private static String formatTempColumnName(int columnPosition) {
        return "COLUMN_" + columnPosition;
    }

    private String[] fetchQueriedDataFromRow(List<String> aRow) throws OdaException {
        String[] sArray = new String[this.rsmd.getColumnCount()];
        int i = 0;
        while (i < sArray.length) {
            int location = this.selectColumIndexes[i];
            if (location != -1) {
                if (location >= aRow.size()) {
                    throw new OdaException(Messages.getString("query_INVALID_EXCEL_FILE"));
                }
                sArray[i] = aRow.get(location).toString();
            }
            ++i;
        }
        return sArray;
    }

    private int findIndex(String value, HashMap<String, Integer> originalColumnNameIndexMap) {
        Integer index = originalColumnNameIndexMap.get(value.trim().toUpperCase());
        if (index == null) {
            return -1;
        }
        return index;
    }

    public List<String> readLine() throws OdaException, IOException {
        if (!this.isReaderInitialised) {
            this.initialiseReader();
            this.isReaderInitialised = true;
        }
        return this.excelFileReader.readLine();
    }

    public void resetRowCounter() {
        if (this.excelFileReader != null) {
            this.excelFileReader.setCurrentRowIndex(0);
        }
    }

    private void initialiseReader() throws OdaException, IOException {
        if (this.isReaderInitialised) {
            return;
        }
        this.fileExtension = ExcelFileReader.getExtensionName(this.uri);
        this.excelFileReader = new ExcelFileReader(ResourceLocatorUtil.getURIStream(this.uri), this.fileExtension, this.sheetNameList, this.statementMaxRows);
        this.isReaderInitialised = true;
    }

    public String[] getColumnNameArray(List<?> line) throws OdaException {
        if (line == null) {
            throw new OdaException(Messages.getString("common_CANNOT_FIND_COLUMN"));
        }
        return ExcelFileSource.getStringArrayFromList(line);
    }

    public static String[] getStringArrayFromList(List<?> list) {
        String[] array = null;
        if (list != null) {
            array = new String[list.size()];
            int i = 0;
            while (i < list.size()) {
                String columnName = (String)list.get(i);
                if (columnName == null || columnName.isEmpty()) {
                    columnName = ExcelFileSource.formatTempColumnName(i + 1);
                }
                array[i] = columnName;
                ++i;
            }
        }
        return array;
    }

    public boolean isEmptyRow(List<String> line) throws OdaException {
        if (line == null) {
            throw new OdaException(Messages.getString("query_INVALID_EXCEL_FILE"));
        }
        return line.isEmpty() || line.size() == 1 && line.get(0).equals("");
    }

    public void close() throws OdaException {
        try {
            if (this.isReaderInitialised) {
                this.excelFileReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getMaxRows() throws OdaException {
        try {
            if (!this.isReaderInitialised) {
                this.initialiseReader();
            }
            return this.excelFileReader.getMaxRows();
        }
        catch (IOException e) {
            this.close();
            throw new OdaException((Throwable)e);
        }
    }

    public int getMaxRowsToRead(int resultSetMaxRows) {
        this.resultSetMaxRows = resultSetMaxRows;
        this.maxRowsToRead = this.statementMaxRows != 0 && this.statementMaxRows < this.resultSetMaxRows || this.resultSetMaxRows == 0 ? this.statementMaxRows : this.resultSetMaxRows;
        return this.maxRowsToRead;
    }

    public void closeFileSource() {
        try {
            if (this.excelFileReader != null) {
                this.excelFileReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.excelFileReader = null;
    }

    public void finalize() {
        this.closeFileSource();
    }
}

