/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.swt.custom;

import java.util.Vector;
import org.eclipse.birt.core.ui.swt.custom.ICustomChoice;
import org.eclipse.birt.core.ui.utils.UIHelper;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class CustomChooserComposite
extends Composite {
    public static final int SELECTION_EVENT = 1;
    public static final int DROPDOWN_EVENT = 2;
    private Composite cmpDropDown = null;
    protected ICustomChoice cnvSelection = null;
    private Button btnDown = null;
    private Object iCurrentValue = null;
    private Vector<Listener> vSelectionListeners = new Vector();
    private Vector<Listener> vDropDownListeners = new Vector();
    private boolean bEnabled = true;
    private boolean bJustFocusLost = false;
    private ICustomChoice popupSelection;
    private ICustomChoice[] popupCanvases;
    private Object[] items;
    private Listener canvasListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget == CustomChooserComposite.this.cnvSelection) {
                CustomChooserComposite.this.handleEventCanvasSelection(event);
            } else {
                CustomChooserComposite.this.handleEventCanvasPopup(event);
            }
        }
    };
    private AccessibleListener accessibleListener = new AccessibleAdapter(){

        public void getHelp(AccessibleEvent e) {
            e.result = CustomChooserComposite.this.getToolTipText();
        }
    };
    private AccessibleControlListener accessibleControlListener = new AccessibleControlAdapter(){

        public void getChildAtPoint(AccessibleControlEvent e) {
            Point testPoint = CustomChooserComposite.this.toControl(new Point(e.x, e.y));
            if (CustomChooserComposite.this.getBounds().contains(testPoint)) {
                e.childID = -1;
            }
        }

        public void getLocation(AccessibleControlEvent e) {
            Rectangle location = CustomChooserComposite.this.getBounds();
            Point pt = CustomChooserComposite.this.toDisplay(new Point(location.x, location.y));
            e.x = pt.x;
            e.y = pt.y;
            e.width = location.width;
            e.height = location.height;
        }

        public void getChildCount(AccessibleControlEvent e) {
            e.detail = 0;
        }

        public void getRole(AccessibleControlEvent e) {
            e.detail = 46;
        }

        public void getState(AccessibleControlEvent e) {
            e.detail = 0;
        }
    };
    private ScrolledComposite container;

    public CustomChooserComposite(Composite parent, int style) {
        super(parent, style | 0x800);
    }

    protected CustomChooserComposite(Composite parent, int style, Object choiceValue) {
        this(parent, style);
        this.iCurrentValue = choiceValue;
    }

    private void initControls() {
        this.setLayout(new InternalLayout());
        this.cnvSelection = this.createChoice(this, null);
        this.cnvSelection.setValue(this.iCurrentValue);
        this.cnvSelection.addListener(1, this.canvasListener);
        this.cnvSelection.addListener(31, this.canvasListener);
        this.cnvSelection.addListener(15, this.canvasListener);
        this.cnvSelection.addListener(16, this.canvasListener);
        this.cnvSelection.addListener(3, this.canvasListener);
        this.btnDown = new Button((Composite)this, 1028);
        this.btnDown.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CustomChooserComposite.this.toggleDropDown();
            }
        });
        this.layout();
        this.initAccessible();
    }

    protected abstract ICustomChoice createChoice(Composite var1, Object var2);

    public void setItems(Object[] items) {
        Object[] objectArray = this.items = items == null ? new Object[]{} : items;
        if (this.cnvSelection == null) {
            this.initControls();
        }
        if (this.findChoiceIndex(this.iCurrentValue) == -1) {
            this.setChoiceValue(null);
        }
    }

    public Object[] getItems() {
        return this.items;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public Object getItem(int index) {
        if (index >= 0 && index < this.items.length) {
            return this.items[index];
        }
        return null;
    }

    public void setEnabled(boolean bState) {
        this.btnDown.setEnabled(bState);
        this.cnvSelection.setEnabled(bState);
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    private void createDropDownComponent(int iXLoc, int iYLoc) {
        if (!this.bEnabled) {
            return;
        }
        int shellWidth = this.getSize().x;
        Shell shell = new Shell(this.getShell(), 0);
        shell.setLayout((Layout)new FillLayout(4));
        if ((this.getStyle() & 0x4000000) != 0) {
            iXLoc -= shellWidth;
        }
        shell.setLocation(iXLoc, iYLoc);
        this.container = new ScrolledComposite((Composite)shell, 512);
        this.container.setAlwaysShowScrollBars(false);
        this.container.setExpandHorizontal(true);
        this.cmpDropDown = new Composite((Composite)this.container, 0);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.cmpDropDown.setLayout((Layout)gl);
        Listener listenerCmpDropDown = new Listener(){

            public void handleEvent(Event event) {
                CustomChooserComposite.this.handleEventCmpDropDown(event);
            }
        };
        this.cmpDropDown.addListener(1, listenerCmpDropDown);
        this.cmpDropDown.addListener(16, listenerCmpDropDown);
        this.popupCanvases = new ICustomChoice[this.items.length];
        int iC = 0;
        while (iC < this.items.length) {
            ICustomChoice cnv = this.createChoice(this.cmpDropDown, this.items[iC]);
            GridData gd = new GridData(768);
            cnv.setLayoutData(gd);
            cnv.addListener(3, this.canvasListener);
            cnv.addListener(6, this.canvasListener);
            cnv.addListener(1, this.canvasListener);
            this.popupCanvases[iC] = cnv;
            if (this.cnvSelection.getValue().equals(cnv.getValue())) {
                cnv.notifyListeners(15, new Event());
                this.popupSelection = cnv;
            }
            ++iC;
        }
        int height = 0;
        int maxWidth = 0;
        Control[] children = this.container.getChildren();
        int i = 0;
        while (i < children.length) {
            Point point = children[i].computeSize(-1, -1);
            maxWidth = point.x > maxWidth ? point.x : maxWidth;
            height += point.y;
            ++i;
        }
        int width = this.getSize().x > maxWidth ? this.getSize().x : maxWidth;
        height = 18 > height ? 18 : height;
        this.cmpDropDown.setBounds(0, 0, width, height);
        this.container.setContent((Control)this.cmpDropDown);
        if (height >= 298) {
            int containerWidth = maxWidth + this.container.getVerticalBar().getSize().x;
            width = width > containerWidth ? this.getSize().x : containerWidth;
        }
        shell.setSize(width, height < 298 ? height + 2 : 300);
        shell.layout();
        shell.open();
    }

    void handleEventCmpDropDown(Event event) {
        switch (event.type) {
            case 1: {
                this.keyPressed(new KeyEvent(event));
                break;
            }
            case 16: {
                Control cTmp = Display.getCurrent().getCursorControl();
                if (cTmp != null && (cTmp.equals(this.cnvSelection) || cTmp.equals(this.btnDown))) {
                    this.bJustFocusLost = true;
                }
                if (this.isPopupControl(cTmp)) break;
                this.cmpDropDown.getShell().close();
            }
        }
    }

    public void select(int index) {
        this.setChoiceValue(this.items[index]);
    }

    public int getChoiceIndex() {
        return this.findChoiceIndex(this.iCurrentValue);
    }

    public Object getChoiceValue() {
        return this.iCurrentValue;
    }

    public void setChoiceValue(Object iValue) {
        this.iCurrentValue = iValue;
        this.cnvSelection.setValue(this.iCurrentValue);
        this.cnvSelection.redraw();
    }

    public void addListener(int eventType, Listener listener) {
        switch (eventType) {
            case 1: {
                this.vSelectionListeners.add(listener);
                break;
            }
            case 2: {
                this.vDropDownListeners.add(listener);
            }
        }
    }

    public void removeListener(int eventType, Listener listener) {
        switch (eventType) {
            case 1: {
                this.vSelectionListeners.remove(listener);
                break;
            }
            case 2: {
                this.vDropDownListeners.remove(listener);
            }
        }
    }

    private void toggleDropDown() {
        if (this.bJustFocusLost) {
            this.bJustFocusLost = false;
            return;
        }
        if (this.cmpDropDown == null || this.cmpDropDown.isDisposed() || !this.cmpDropDown.isVisible()) {
            this.fireDropDownEvent();
            Point pLoc = UIHelper.getScreenLocation(this);
            if ("macosx".equals(Platform.getOS())) {
                this.createDropDownComponent(pLoc.x, pLoc.y);
            } else {
                this.createDropDownComponent(pLoc.x, pLoc.y + this.getSize().y);
            }
        } else {
            this.cmpDropDown.getShell().close();
        }
    }

    private void fireSelectionEvent() {
        Event e = new Event();
        e.widget = this;
        e.data = this.iCurrentValue;
        e.type = 1;
        int i = 0;
        while (i < this.vSelectionListeners.size()) {
            this.vSelectionListeners.get(i).handleEvent(e);
            ++i;
        }
    }

    private void fireDropDownEvent() {
        Event e = new Event();
        e.widget = this;
        e.type = 2;
        int i = 0;
        while (i < this.vDropDownListeners.size()) {
            this.vDropDownListeners.get(i).handleEvent(e);
            ++i;
        }
    }

    void keyPressed(KeyEvent event) {
        if (this.cmpDropDown != null && !this.cmpDropDown.getShell().isDisposed()) {
            ICustomChoice currentControl;
            int styleIndex;
            if (event.keyCode == 27) {
                this.cmpDropDown.getShell().close();
            } else if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                ICustomChoice currentControl2 = this.popupSelection == null ? this.popupCanvases[this.findChoiceIndex(this.cnvSelection.getValue())] : this.popupSelection;
                this.setChoiceValue(currentControl2.getValue());
                this.fireSelectionEvent();
                this.cmpDropDown.getShell().close();
            } else if ((event.keyCode == 0x1000001 || event.keyCode == 0x1000002) && (styleIndex = this.findChoiceIndex((currentControl = this.popupSelection == null ? this.popupCanvases[this.findChoiceIndex(this.cnvSelection.getValue())] : this.popupSelection).getValue())) >= 0) {
                currentControl.notifyListeners(16, new Event());
                currentControl.redraw();
                if (event.keyCode == 0x1000001) {
                    if (styleIndex > 0) {
                        --styleIndex;
                    }
                } else if (event.keyCode == 0x1000002 && styleIndex < this.items.length - 1) {
                    ++styleIndex;
                }
                this.popupSelection = this.popupCanvases[styleIndex];
                this.popupSelection.notifyListeners(15, new Event());
                this.popupSelection.redraw();
                if (this.popupSelection instanceof Control) {
                    this.container.showControl((Control)this.popupSelection);
                }
            }
        }
    }

    private boolean isPopupControl(Object control) {
        return control instanceof Control && ((Control)control).getShell() == this.cmpDropDown.getShell();
    }

    void handleEventCanvasSelection(Event event) {
        switch (event.type) {
            case 15: {
                this.cnvSelection.redraw();
                break;
            }
            case 16: {
                this.cnvSelection.redraw();
                break;
            }
            case 1: {
                if (this.isDisposed() || event.keyCode != 0x1000001 && event.keyCode != 0x1000002) break;
                this.toggleDropDown();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: {
                        this.getShell().close();
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = true;
                        this.cnvSelection.redraw();
                    }
                }
                break;
            }
            case 3: {
                this.toggleDropDown();
            }
        }
    }

    void handleEventCanvasPopup(Event event) {
        switch (event.type) {
            case 3: {
                this.setChoiceValue(((ICustomChoice)event.widget).getValue());
                this.cmpDropDown.getShell().close();
                this.fireSelectionEvent();
                break;
            }
            case 6: {
                if (this.popupSelection != null) {
                    this.popupSelection.notifyListeners(16, new Event());
                    this.popupSelection.redraw();
                }
                this.popupSelection = (ICustomChoice)event.widget;
                this.popupSelection.notifyListeners(15, event);
                this.popupSelection.redraw();
            }
        }
    }

    private int findChoiceIndex(Object value) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i].equals(value)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void initAccessible() {
        try {
            this.getAccessible().removeAccessibleListener(this.accessibleListener);
            this.getAccessible().addAccessibleListener(this.accessibleListener);
            this.getAccessible().removeAccessibleControlListener(this.accessibleControlListener);
            this.getAccessible().addAccessibleControlListener(this.accessibleControlListener);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private class InternalLayout
    extends Layout {
        private InternalLayout() {
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point buttonSize = CustomChooserComposite.this.btnDown.computeSize(-1, -1, force);
            Point selectionSize = ((Control)CustomChooserComposite.this.cnvSelection).computeSize(-1, -1, force);
            return new Point(selectionSize.x + buttonSize.x, buttonSize.y);
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point buttonSize = CustomChooserComposite.this.btnDown.computeSize(-1, -1, force);
            ((Control)CustomChooserComposite.this.cnvSelection).setBounds(0, 0, bounds.width - buttonSize.x, buttonSize.y - 1);
            CustomChooserComposite.this.btnDown.setBounds(bounds.width - buttonSize.x, 0, buttonSize.x, buttonSize.y);
        }
    }
}

