/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SimpleGroupElementHandle;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StringPropertyType;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_117648
extends BaseTestCase {
    public void test_regression_117648() throws UserPropertyException {
        DesignEngine engine = new DesignEngine(new DesignConfig());
        SessionHandle session = engine.newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle designHandle = session.createDesign();
        ElementFactory factory = designHandle.getElementFactory();
        LabelHandle label = factory.newLabel("label");
        UserPropertyDefn userProp = new UserPropertyDefn();
        userProp.setName("prop1");
        userProp.setType((PropertyType)new StringPropertyType());
        userProp.setDefault((Object)"default value");
        label.addUserPropertyDefn(userProp);
        ArrayList<LabelHandle> elements = new ArrayList<LabelHandle>();
        elements.add(label);
        SimpleGroupElementHandle groupHandle = new SimpleGroupElementHandle((ModuleHandle)designHandle, elements);
        Iterator propIter = groupHandle.visiblePropertyIterator();
        GroupPropertyHandle userPropHandle = null;
        while (propIter.hasNext()) {
            GroupPropertyHandle handle = (GroupPropertyHandle)propIter.next();
            if ("prop1".equals(handle.getPropertyDefn().getName())) {
                // empty if block
            }
            userPropHandle = handle;
        }
        Regression_117648.assertNotNull(userPropHandle);
        Regression_117648.assertEquals((int)0, (int)userPropHandle.getPropertyDefn().getTypeCode());
        Regression_117648.assertEquals((Object)"default value", (Object)userPropHandle.getPropertyDefn().getDefault());
    }
}

