/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class HTMLServerImageHandlerTest
extends EngineCase {
    static final String INPUT = "EmbedImage.txt";

    public HTMLServerImageHandlerTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource();
    }

    public static Test suite() {
        return new TestSuite(HTMLServerImageHandlerTest.class);
    }

    public void testOnDesignImage() {
        try {
            String fp;
            String path = this.getFullQualifiedClassName() + "/input/EmbedImage.txt";
            byte[] imageBytes = this.readImageFile(path);
            HTMLServerImageHandlerTest.assertNotNull((Object)imageBytes);
            HTMLRenderContext context = new HTMLRenderContext();
            context.setBaseImageURL(".");
            context.setImageDirectory(".");
            HTMLServerImageHandler imageHandler = new HTMLServerImageHandler();
            Image image = new Image(imageBytes, "image1");
            RenderOptionBase option = new RenderOptionBase();
            image.setRenderOption((IRenderOption)option);
            File f = null;
            int count = 0;
            String fPath = System.getProperty("user.dir");
            while ((f = new File(fp = fPath + FileSystems.getDefault().getSeparator() + "design" + String.valueOf(++count))).exists()) {
                f.delete();
            }
            String str = imageHandler.onDesignImage((IImage)image, (Object)context);
            String strGet = "./design1";
            HTMLServerImageHandlerTest.assertEquals((String)"", (String)str, (String)strGet);
            this.removeFile(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testOnURLImage() {
        String url = "http://image";
        Image image = new Image(url);
        RenderOptionBase option = new RenderOptionBase();
        image.setRenderOption((IRenderOption)option);
        HTMLRenderContext context = new HTMLRenderContext();
        HTMLServerImageHandler handler = new HTMLServerImageHandler();
        String urlGet = handler.onURLImage((IImage)image, (Object)context);
        HTMLServerImageHandlerTest.assertEquals((String)"OnURLImage() fail", (String)url, (String)urlGet);
    }

    public void testOnCustomImage() {
        try {
            String fp;
            String path = this.getClassFolder() + FileSystems.getDefault().getSeparator() + "input" + FileSystems.getDefault().getSeparator() + INPUT;
            byte[] imageBytes = this.readImageFile(path);
            HTMLRenderContext context = new HTMLRenderContext();
            context.setBaseImageURL(".");
            context.setImageDirectory(".");
            HTMLServerImageHandler imageHandler = new HTMLServerImageHandler();
            Image image = new Image(imageBytes, "image1");
            RenderOptionBase option = new RenderOptionBase();
            image.setRenderOption((IRenderOption)option);
            File f = null;
            int count = 1;
            String fPath = System.getProperty("user.dir");
            while ((f = new File(fp = fPath + FileSystems.getDefault().getSeparator() + "custom" + String.valueOf(++count))).exists()) {
                f.delete();
            }
            String str = imageHandler.onCustomImage((IImage)image, (Object)context);
            byte[] actualBytes = this.readImageFile(str);
            int length = imageBytes.length;
            HTMLServerImageHandlerTest.assertEquals((int)length, (int)actualBytes.length);
            int index = 0;
            while (index < length) {
                HTMLServerImageHandlerTest.assertEquals((byte)imageBytes[index], (byte)actualBytes[index]);
                ++index;
            }
            this.removeFile(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] readImageFile(String path) throws FileNotFoundException, IOException {
        File imageFile = new File(path);
        long size = imageFile.length();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(imageFile));
        byte[] imageBytes = new byte[(int)size];
        ((InputStream)is).read(imageBytes);
        return imageBytes;
    }

    public void testOnDocImage() {
        String url = "http://image";
        Image image = new Image(url);
        RenderOptionBase option = new RenderOptionBase();
        image.setRenderOption((IRenderOption)option);
        HTMLRenderContext context = new HTMLRenderContext();
        HTMLServerImageHandler handler = new HTMLServerImageHandler();
        String urlGet = handler.onDocImage((IImage)image, (Object)context);
        HTMLServerImageHandlerTest.assertNull((String)"OnDocImage() fail", (Object)urlGet);
    }
}

