/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.toc.TOCTestCase;

public class TOCStyleTest
extends TOCTestCase {
    static final String TOC_DESIGN = "org/eclipse/birt/report/engine/toc/tocStyle.xml";
    static final String TOC_STYLE_GOLDEN = "<toc nodeId=\"/\">    <toc nodeId=\"__TOC_0\" displayText=\"2.4512E02\"/>    <toc nodeId=\"__TOC_1\" displayText=\"LOWER CASE TOC\"/>    <toc nodeId=\"__TOC_2\" displayText=\"bold font\"/></toc>";

    public void testStyle() {
        try {
            this.copyResource(TOC_DESIGN, "utest/toc.rptdesign");
            this.createReportDocument("utest/toc.rptdesign", "utest/toc.rptdocument");
            try (IReportDocument document = this.engine.openReportDocument("utest/toc.rptdocument");){
                ITOCTree tree = document.getTOCTree("html", ULocale.ENGLISH);
                String out = this.toString(tree.getRoot());
                TOCStyleTest.assertEquals((String)TOC_STYLE_GOLDEN.replaceAll("\\s", ""), (String)out.replaceAll("\\s", ""));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TOCStyleTest.fail();
        }
    }
}

