/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportBlob;
import org.apache.derby.impl.load.ImportClob;
import org.apache.derby.impl.load.ImportReadData;
import org.apache.derby.impl.load.ImportResultSetMetaData;
import org.apache.derby.impl.load.LoadError;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.vti.VTITemplate;

abstract class ImportAbstract
extends VTITemplate {
    ControlInfo controlFileReader;
    ImportReadData importReadData;
    String[] columnNames;
    int numberOfColumns;
    int[] columnWidths;
    int lineNumber = 0;
    String[] nextRow;
    ImportResultSetMetaData importResultSetMetaData;
    int noOfColumnsExpected;
    protected boolean lobsInExtFile = false;
    String tableColumnTypesStr;
    int[] tableColumnTypes;
    String columnTypeNamesString;
    String[] columnTypeNames;
    String udtClassNamesString;
    HashMap udtClasses;
    private boolean wasNull;
    static final String COLUMNNAMEPREFIX = "COLUMN";

    ImportAbstract() {
    }

    abstract ImportReadData getImportReadData() throws Exception;

    void doAllTheWork() throws Exception {
        this.importReadData = this.getImportReadData();
        this.numberOfColumns = this.importReadData.getNumberOfColumns();
        if (this.numberOfColumns == 0) {
            this.numberOfColumns = this.noOfColumnsExpected;
        }
        this.columnWidths = this.controlFileReader.getColumnWidths();
        this.columnNames = new String[this.numberOfColumns];
        this.loadColumnNames();
        this.nextRow = new String[this.numberOfColumns];
        this.tableColumnTypes = ColumnInfo.getExpectedVtiColumnTypes(this.tableColumnTypesStr, this.numberOfColumns);
        this.columnTypeNames = ColumnInfo.getExpectedColumnTypeNames(this.columnTypeNamesString, this.numberOfColumns);
        this.udtClasses = ColumnInfo.getExpectedUDTClasses(this.udtClassNamesString);
        this.importResultSetMetaData = new ImportResultSetMetaData(this.numberOfColumns, this.columnNames, this.columnWidths, this.tableColumnTypes, this.columnTypeNames, this.udtClasses);
    }

    void loadColumnNames() {
        for (int i = 1; i <= this.numberOfColumns; ++i) {
            this.columnNames[i - 1] = COLUMNNAMEPREFIX + i;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.importResultSetMetaData;
    }

    @Override
    public int getRow() throws SQLException {
        return this.importReadData.getCurrentRowNumber();
    }

    public int getCurrentLineNumber() {
        return this.lineNumber;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            ++this.lineNumber;
            return this.importReadData.readNextRow(this.nextRow);
        }
        catch (Exception ex) {
            throw this.importError(ex);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.importReadData != null) {
                this.importReadData.closeStream();
            }
        }
        catch (Exception ex) {
            throw LoadError.unexpectedError(ex);
        }
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (columnIndex <= this.numberOfColumns) {
            String val = this.nextRow[columnIndex - 1];
            if (this.isColumnInExtFile(columnIndex)) {
                val = this.importReadData.getClobColumnFromExtFileAsString(val, columnIndex);
            }
            this.wasNull = val == null;
            return val;
        }
        throw LoadError.invalidColumnNumber(this.numberOfColumns);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        Clob clob = null;
        if (this.lobsInExtFile) {
            clob = this.importReadData.getClobColumnFromExtFile(this.nextRow[columnIndex - 1], columnIndex);
        } else {
            String data = this.nextRow[columnIndex - 1];
            if (data != null) {
                clob = new ImportClob(data);
            }
        }
        this.wasNull = clob == null;
        return clob;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        Blob blob = null;
        if (this.lobsInExtFile) {
            blob = this.importReadData.getBlobColumnFromExtFile(this.nextRow[columnIndex - 1], columnIndex);
        } else {
            String hexData = this.nextRow[columnIndex - 1];
            byte[] data = null;
            if (hexData != null) {
                data = StringUtil.fromHexString(hexData, 0, hexData.length());
                if (data == null) {
                    throw PublicAPI.wrapStandardException(StandardException.newException("XIE0N.S", hexData));
                }
                blob = new ImportBlob(data);
            }
        }
        this.wasNull = blob == null;
        return blob;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        byte[] bytes = this.getBytes(columnIndex);
        try {
            Class udtClass = this.importResultSetMetaData.getUDTClass(columnIndex);
            Object obj = ImportAbstract.readObject(bytes);
            if (obj != null && !udtClass.isInstance(obj)) {
                throw new ClassCastException(obj.getClass().getName() + " -> " + udtClass.getName());
            }
            return obj;
        }
        catch (Exception e) {
            throw this.importError(e);
        }
    }

    public static Object readObject(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    public static Object destringifyObject(String raw) throws Exception {
        byte[] bytes = StringUtil.fromHexString(raw, 0, raw.length());
        return ImportAbstract.readObject(bytes);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String hexData = this.nextRow[columnIndex - 1];
        this.wasNull = hexData == null;
        byte[] data = null;
        if (hexData != null && (data = StringUtil.fromHexString(hexData, 0, hexData.length())) == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0N.S", hexData));
        }
        return data;
    }

    private boolean isColumnInExtFile(int colIndex) {
        return this.lobsInExtFile && (this.tableColumnTypes[colIndex - 1] == 2004 || this.tableColumnTypes[colIndex - 1] == 2005);
    }

    public SQLException importError(Exception ex) {
        Exception closeException = null;
        if (this.importReadData != null) {
            try {
                this.importReadData.closeStream();
            }
            catch (Exception e) {
                closeException = e;
            }
        }
        SQLException le = LoadError.unexpectedError(ex);
        if (closeException != null) {
            le.setNextException(LoadError.unexpectedError(closeException));
        }
        return le;
    }
}

