/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.birt.data.engine.odaconsumer.OdaconsumerTestCase;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.JavaRuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;
import org.eclipse.datatools.connectivity.oda.util.manifest.RuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.TraceLogging;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Ignore tests that require manual setup")
public class ManifestExplorerTest
extends OdaconsumerTestCase {
    private final String m_jdbcId = "org.eclipse.birt.report.data.oda.jdbc";
    private final String m_expectedJdbcDataSetId = "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet";
    private final String m_testDriverId = "org.eclipse.birt.data.engine.odaconsumer.testdriver";
    private static Object[][] sm_mappings = new Object[][]{{new Integer(-7), "BIT", "Integer"}, {new Integer(-6), "TINYINT", "Integer"}, {new Integer(5), "SMALLINT", "Integer"}, {new Integer(4), "INTEGER", "Integer"}, {new Integer(-5), "BIGINT", "Decimal"}, {new Integer(6), "FLOAT", "Double"}, {new Integer(7), "REAL", "Double"}, {new Integer(8), "DOUBLE", "Double"}, {new Integer(2), "NUMERIC", "Decimal"}, {new Integer(3), "DECIMAL", "Decimal"}, {new Integer(1), "CHAR", "String"}, {new Integer(12), "VARCHAR", "String"}, {new Integer(-1), "LONGVARCHAR", "String"}, {new Integer(91), "DATE", "Date"}, {new Integer(92), "TIME", "Time"}, {new Integer(93), "TIMESTAMP", "Timestamp"}, {new Integer(-2), "BINARY", "Blob"}, {new Integer(-3), "VARBINARY", "Blob"}, {new Integer(-4), "LONGVARBINARY", "Blob"}, {new Integer(16), "BOOLEAN", "Boolean"}};

    @Test
    public void testGetDataSourceNames() throws Exception {
        Properties names = ManifestExplorer.getInstance().getDataSourceIdentifiers();
        Assert.assertNotNull((Object)names.getProperty("org.eclipse.birt.data.engine.odaconsumer.testdriver"));
    }

    @Test
    public void testGetExtensionConfigs() throws Exception {
        ExtensionManifest[] configs = ManifestExplorer.getInstance().getExtensionManifests();
        Assert.assertTrue((configs.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetExtensionConfig() throws Exception {
        ExtensionManifest config = ManifestExplorer.getInstance().getExtensionManifest("org.eclipse.birt.report.data.oda.jdbc");
        this.verifyExtensionConfig(config);
    }

    @Test
    public void testGetExtensionConfigCompatibility() throws Exception {
        ExtensionManifest config = ManifestExplorer.getInstance().getExtensionManifest("org.eclipse.birt.report.data.oda.jdbc");
        this.verifyExtensionConfig(config);
    }

    void verifyExtensionConfig(ExtensionManifest config) throws Exception {
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"org.eclipse.birt.report.data.oda.jdbc", (Object)config.getDataSourceElementID());
        Assert.assertEquals((Object)"JDBC Data Source", (Object)config.getDataSourceDisplayName());
        Assert.assertEquals((Object)"3.1", (Object)config.getOdaVersion());
        RuntimeInterface runtime = config.getRuntimeInterface();
        Assert.assertTrue((boolean)(runtime instanceof JavaRuntimeInterface));
        JavaRuntimeInterface javaRuntime = (JavaRuntimeInterface)runtime;
        Assert.assertEquals((Object)"org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver", (Object)javaRuntime.getDriverClass());
        Assert.assertFalse((boolean)javaRuntime.needSetThreadContextClassLoader());
        Assert.assertEquals((long)1L, (long)javaRuntime.getInterfaceType());
        Assert.assertTrue((javaRuntime.getLibraryLocation().toString().indexOf("org.eclipse.birt.report.data.oda.jdbc") > 0 ? 1 : 0) != 0);
        TraceLogging traceLogging = config.getTraceLogging();
        Assert.assertNull((Object)traceLogging);
        this.myTestGetExtensionProperties(config);
        String[] dataSetTypeIds = config.getDataSetTypeIDs();
        Assert.assertTrue((dataSetTypeIds.length == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet", (Object)dataSetTypeIds[0]);
        this.myTestGetDataSetTypes(config);
    }

    void myTestGetExtensionProperties(ExtensionManifest config) {
        Property[] dataSourceProps = config.getProperties();
        Assert.assertTrue((dataSourceProps.length >= 5 ? 1 : 0) != 0);
        Hashtable<String, Property> propsList = new Hashtable<String, Property>(dataSourceProps.length);
        int i = 0;
        while (i < dataSourceProps.length) {
            Property prop = dataSourceProps[i];
            propsList.put(prop.getName(), prop);
            ++i;
        }
        String expectedGroupName = "connectionProperties";
        String expectedGroupDisplayName = "Connection Properties";
        Property aProp = (Property)propsList.get("odaDriverClass");
        this.myTestPropertyAttributes(aProp, "JDBC Driver &Class", expectedGroupName, expectedGroupDisplayName, "string", true, null, false);
        aProp = (Property)propsList.get("odaURL");
        this.myTestPropertyAttributes(aProp, "JDBC Driver U&RL", expectedGroupName, expectedGroupDisplayName, "string", true, null, false);
        aProp = (Property)propsList.get("odaDataSource");
        this.myTestPropertyAttributes(aProp, "Data Source", expectedGroupName, expectedGroupDisplayName, "string", true, null, false);
        aProp = (Property)propsList.get("odaUser");
        this.myTestPropertyAttributes(aProp, "User &Name", expectedGroupName, expectedGroupDisplayName, "string", true, null, false);
        aProp = (Property)propsList.get("odaPassword");
        this.myTestPropertyAttributes(aProp, "Pass&word", expectedGroupName, expectedGroupDisplayName, "string", true, null, true);
    }

    void myTestPropertyAttributes(Property aProp, String expectedDisplayName, String expectedGroupName, String expectedGroupDisplayName, String expectedType, boolean expectedInheritability, String expectedDefaultValue, boolean expectedIsEncryptable) {
        Assert.assertNotNull((Object)aProp);
        Assert.assertEquals((Object)expectedDisplayName, (Object)aProp.getDisplayName());
        Assert.assertEquals((Object)expectedGroupName, (Object)aProp.getGroupName());
        Assert.assertEquals((Object)expectedGroupDisplayName, (Object)aProp.getGroupDisplayName());
        Assert.assertEquals((Object)expectedType, (Object)aProp.getType());
        Assert.assertEquals((Object)expectedInheritability, (Object)aProp.canInherit());
        Assert.assertEquals((Object)expectedDefaultValue, (Object)aProp.getDefaultValue());
        Assert.assertEquals((Object)expectedIsEncryptable, (Object)aProp.isEncryptable());
    }

    void myTestGetDataSetTypes(ExtensionManifest config) throws Exception {
        DataSetType[] dataSetTypes = config.getDataSetTypes();
        Assert.assertTrue((dataSetTypes.length == 2 ? 1 : 0) != 0);
        DataSetType dataSetType = config.getDataSetType("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertEquals((Object)"org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet", (Object)dataSetType.getID());
        Assert.assertEquals((Object)"SQL Select Query", (Object)dataSetType.getDisplayName());
        int i = 0;
        int n = sm_mappings.length;
        while (i < n) {
            Integer s = (Integer)sm_mappings[i][0];
            DataTypeMapping mapping = dataSetType.getDataTypeMapping((int)s.shortValue());
            Assert.assertNotNull((Object)mapping);
            Assert.assertEquals((long)s.intValue(), (long)mapping.getNativeTypeCode());
            Assert.assertEquals((Object)sm_mappings[i][1], (Object)mapping.getNativeType());
            Assert.assertEquals((Object)sm_mappings[i][2], (Object)mapping.getOdaScalarDataType());
            Assert.assertTrue((mapping.getAlternativeOdaDataTypes().length == 0 ? 1 : 0) != 0);
            ++i;
        }
        Property[] dataSetProps = dataSetType.getProperties();
        Assert.assertEquals((long)1L, (long)dataSetProps.length);
        String expectedGroupName = "queryProperties";
        String expectedGroupDisplayName = "Query Properties";
        Property aProp = dataSetProps[0];
        Assert.assertEquals((Object)"queryTimeOut", (Object)aProp.getName());
        this.myTestPropertyAttributes(aProp, "&Query Time Out (in seconds)", expectedGroupName, expectedGroupDisplayName, "string", true, null, false);
    }
}

