/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import testutil.ConfigText;

public class IncreCacheDataSetTest
extends APITestCase {
    private Map appContextMap = new HashMap();
    private File tempDataFile;
    private static final String LINE_SEP = System.lineSeparator();

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Impl.TestIncreCacheData.TableName"), ConfigText.getString("Impl.TestIncreCacheData.TableSQL"), ConfigText.getString("Impl.TestIncreCacheData.TestDataFileName"));
    }

    @Before
    public void increCacheDataSetSetUp() throws Exception {
        this.defineDataSourceAndDataSet();
        String configName = "testIncreCacheConfig.txt";
        URL url = this.getClass().getResource("input/" + configName);
        this.appContextMap.put(DataEngine.INCREMENTAL_CACHE_CONFIG, url);
    }

    @After
    public void increCacheDataSetTearDown() throws Exception {
        this.dataEngine.shutdown();
        this.getDataSetCacheManager(this.dataEngine).clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        this.getDataSetCacheManager((DataEngine)((DataEngineImpl)this.dataEngine)).resetForTest();
    }

    private void defineDataSourceAndDataSet() throws BirtException {
        OdaDataSetDesign odaDesign = new OdaDataSetDesign("Test Data Set");
        odaDesign.setExtensionID(((OdaDataSetDesign)this.dataSet).getExtensionID());
        odaDesign.setQueryText(((OdaDataSetDesign)this.dataSet).getQueryText());
        this.dataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
    }

    private DataSetCacheManager getDataSetCacheManager(DataEngine dataEngine) {
        DataEngineImpl engine = (DataEngineImpl)dataEngine;
        return engine.getSession().getDataSetCacheManager();
    }

    @Override
    protected InputStream getInputFolder(String dataFileName) {
        InputStream in = super.getInputFolder(dataFileName);
        String tempDir = System.getProperty("java.io.tmpdir");
        this.tempDataFile = new File(tempDir, dataFileName);
        try {
            if (!this.tempDataFile.exists()) {
                this.copy(in, this.tempDataFile);
            }
            this.tempDataFile.deleteOnExit();
            return new FileInputStream(this.tempDataFile);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    private void copy(InputStream in, File tempFile) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(in);
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(tempFile));
        byte[] buffer = new byte[8192];
        int len = bin.read(buffer);
        while (len > 0) {
            bout.write(buffer, 0, len);
            len = bin.read(buffer);
        }
        bout.flush();
        bout.close();
        bin.close();
    }

    private void appendNewData(int count) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.tempDataFile, "rw");
        raf.seek(raf.length());
        SimpleDateFormat fm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int i = 0;
        while (i < count) {
            Date curDate = new Date();
            String latestTime = fm.format(curDate);
            String rowData = LINE_SEP + "'CHINA','Shangahi','" + latestTime + "',800,1,null";
            raf.writeBytes(rowData);
            ++i;
        }
        raf.close();
    }

    @Test
    public void testBasicIncreCache() {
        try {
            Assert.assertEquals((long)8L, (long)this.getQueryResultCount());
            Assert.assertTrue((boolean)this.getDataSetCacheManager(this.dataEngine).doesSaveToCache());
            Assert.assertTrue((boolean)this.getDataSetCacheManager(this.dataEngine).doesLoadFromCache());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUpdateIncreCache() {
        try {
            Assert.assertEquals((long)8L, (long)this.getQueryResultCount());
            this.getDataSetCacheManager((DataEngine)((DataEngineImpl)this.dataEngine)).resetForTest();
            Random random = new Random();
            int count = random.nextInt(100) + 1;
            this.appendNewData(count);
            this.prepareDataSet(this.getDataSourceInfo());
            Assert.assertEquals((long)(count + 8), (long)this.getQueryResultCount());
            Assert.assertTrue((boolean)this.getDataSetCacheManager(this.dataEngine).doesSaveToCache());
            Assert.assertTrue((boolean)this.getDataSetCacheManager(this.dataEngine).doesLoadFromCache());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private int getQueryResultCount() throws BirtException {
        QueryDefinition qd = this.newReportQuery();
        IQueryResults qr = this.dataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        IResultIterator resultIterator = qr.getResultIterator();
        int count = 0;
        while (resultIterator.next()) {
            ++count;
        }
        qr.close();
        return count;
    }
}

