/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.extensions;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.testutil.BaseTestCase;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExtensionPointManagerTest
extends BaseTestCase {
    public void testGetExtendedElementPoints() {
        List list = ExtensionPointManager.getInstance().getExtendedElementPoints();
        ExtensionPointManagerTest.assertFalse((boolean)list.isEmpty());
        ExtensionPointManagerTest.assertTrue((boolean)list.contains(ExtensionPointManager.getInstance().getExtendedElementPoint("TestingBall")));
    }

    public void testGetExtendedElementPoint() {
        ExtendedElementUIPoint point = ExtensionPointManager.getInstance().getExtendedElementPoint("TestingBall");
        ExtensionPointManagerTest.assertNotNull((Object)point);
        ExtensionPointManagerTest.assertEquals((Object)point, (Object)ExtensionPointManager.getInstance().getExtendedElementPoint("TestingBall"));
        ExtensionPointManagerTest.assertEquals((String)"TestingBall", (String)point.getExtensionName());
        ExtensionPointManagerTest.assertEquals((Object)Boolean.TRUE, (Object)point.getAttribute("showInDesigner"));
        ExtensionPointManagerTest.assertEquals((Object)Boolean.TRUE, (Object)point.getAttribute("showInMasterPage"));
        ExtensionPointManagerTest.assertEquals((Object)Boolean.FALSE, (Object)point.getAttribute("canResize"));
        String paletteIconSymbol = ReportPlatformUIImages.getIconSymbolName((String)"TestingBall", (String)"paletteIcon");
        ExtensionPointManagerTest.assertEquals((Object)"TestCategory", (Object)point.getAttribute("category"));
        ExtensionPointManagerTest.assertNull((Object)point.getAttribute("categoryDisplayName"));
        ExtensionPointManagerTest.assertNull((Object)point.getAttribute("paletteIcon"));
        ExtensionPointManagerTest.assertNull((Object)ReportPlatformUIImages.getImageDescriptor((String)paletteIconSymbol));
        ExtensionPointManagerTest.assertNull((Object)ReportPlatformUIImages.getImage((String)paletteIconSymbol));
        String outlineIconSymbol = ReportPlatformUIImages.getIconSymbolName((String)"TestingBall", (String)"outlineIcon");
        ImageDescriptor descriptor = ReportPlatformUIImages.getImageDescriptor((String)outlineIconSymbol);
        ExtensionPointManagerTest.assertNotNull((Object)point.getAttribute("outlineIcon"));
        ExtensionPointManagerTest.assertNotNull((Object)descriptor);
        ExtensionPointManagerTest.assertEquals((Object)descriptor, (Object)point.getAttribute("outlineIcon"));
        ExtensionPointManagerTest.assertNotNull((Object)ReportPlatformUIImages.getImage((String)outlineIconSymbol));
    }
}

