/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.ReportEngine;

public abstract class EngineCase
extends TestCase {
    protected static final String REPORT_DESIGN = "design.rptdesign";
    protected static final String REPORT_DOCUMENT = "reportdocument";
    protected IReportEngine engine;

    protected void setUp() throws Exception {
        this.engine = new ReportEngine(new EngineConfig());
    }

    public void copyResource(String src, String tgt) {
        InputStream in;
        File parent = new File(tgt).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        EngineCase.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(src)) != null ? 1 : 0) != 0);
        try {
            int size = in.available();
            byte[] buffer = new byte[size];
            in.read(buffer);
            FileOutputStream out = new FileOutputStream(tgt);
            ((OutputStream)out).write(buffer);
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EngineCase.fail();
        }
    }

    public byte[] loadResource(String src) {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(src);
        EngineCase.assertTrue((in != null ? 1 : 0) != 0);
        try {
            int size = in.available();
            byte[] buffer = new byte[size];
            in.read(buffer);
            in.close();
            return buffer;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EngineCase.fail();
            return null;
        }
    }

    public void removeFile(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.removeFile(children[i]);
                ++i;
            }
        }
        if (file.exists() && !file.delete()) {
            System.out.println(file.toString() + " can't be removed");
        }
    }

    public void removeFile(String file) {
        this.removeFile(new File(file));
    }

    public void unzip(String src, String folder) {
    }

    public IReportEngine createReportEngine() {
        return this.createReportEngine(null);
    }

    public IReportEngine createReportEngine(EngineConfig config) {
        Object factory;
        if (config == null) {
            config = new EngineConfig();
        }
        if ((factory = Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory")) instanceof IReportEngineFactory) {
            return ((IReportEngineFactory)factory).createReportEngine(config);
        }
        return null;
    }

    public void render(String design, IRenderOption options) throws EngineException {
        IReportDocument document = this.createReportDocument(design);
        IRenderTask render = this.engine.createRenderTask(document);
        render.setRenderOption(options);
        render.render();
        render.close();
    }

    protected IReportDocument createReportDocument(String designFileName) throws EngineException {
        this.useDesignFile(designFileName);
        this.createReportDocument();
        return this.engine.openReportDocument(REPORT_DOCUMENT);
    }

    protected void useDesignFile(String fileName) {
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
        this.copyResource(fileName, REPORT_DESIGN);
    }

    protected void createReportDocument() throws EngineException {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask task = this.engine.createRunTask(report);
        task.run(REPORT_DOCUMENT);
        task.close();
    }

    protected String runAndRender(String designFile) throws EngineException, IOException {
        IRunAndRenderTask runAndRenderTask = this.createRunAndRenderTask(designFile);
        HTMLRenderOption options = new HTMLRenderOption();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        options.setOutputStream((OutputStream)out);
        options.setOutputFormat("html");
        options.setHtmlPagination(true);
        runAndRenderTask.setRenderOption((IRenderOption)options);
        runAndRenderTask.run();
        runAndRenderTask.close();
        String result = new String(out.toByteArray());
        out.close();
        return result;
    }

    protected IRunAndRenderTask createRunAndRenderTask(String designFile) throws EngineException {
        this.useDesignFile(designFile);
        IReportRunnable reportDesign = this.engine.openReportDesign(REPORT_DESIGN);
        IRunAndRenderTask runAndRenderTask = this.engine.createRunAndRenderTask(reportDesign);
        return runAndRenderTask;
    }

    protected String render(String designFile) throws EngineException, IOException {
        HTMLRenderOption options = new HTMLRenderOption();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        options.setOutputStream((OutputStream)out);
        options.setOutputFormat("html");
        this.render(designFile, (IRenderOption)options);
        String result = new String(out.toByteArray());
        out.close();
        return result;
    }

    protected int getCount(String source, String match) {
        int count = 0;
        int index = 0;
        while ((index = source.indexOf(match, index)) >= 0) {
            ++count;
            if (++index < source.length()) continue;
        }
        return count;
    }
}

