/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.List;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.CopyUtil;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CopyUtilTest
extends BaseTestCase {
    public void testCopyPasteInSameDesign() throws Exception {
        this.openDesign("CopyUtilTest_1.xml");
        LabelHandle label = (LabelHandle)this.designHandle.findElement("Body Label");
        IElementCopy copy = CopyUtil.copy((DesignElementHandle)label);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)6);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)6);
        this.save();
        CopyUtilTest.assertTrue((boolean)this.compareFile("CopyUtilTest_1_golden.xml"));
        this.openDesign("CopyUtilTest_3.xml");
        label = (LabelHandle)this.designHandle.findElement("Body Label");
        copy = CopyUtil.copy((DesignElementHandle)label);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)6);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)6);
        TableHandle table = (TableHandle)this.designHandle.findElement("table");
        copy = CopyUtil.copy((DesignElementHandle)table);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)6);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)6);
        CubeHandle cube = this.designHandle.findCube("cube1");
        copy = CopyUtil.copy((DesignElementHandle)cube);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)9);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)9);
        ExtendedItemHandle testingTable = (ExtendedItemHandle)this.designHandle.findElement("testingTable1");
        copy = CopyUtil.copy((DesignElementHandle)testingTable);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)6);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)6);
        this.save();
        CopyUtilTest.assertTrue((boolean)this.compareFile("CopyUtilTest_golden.xml"));
    }

    public void testCutPasteInSameDesign() throws Exception {
        this.openDesign("CopyUtilTest.xml");
        LabelHandle label = (LabelHandle)this.designHandle.findElement("Body Label");
        IElementCopy copy = CopyUtil.copy((DesignElementHandle)label);
        label.drop();
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)6);
        this.save();
        CopyUtilTest.assertTrue((boolean)this.compareFile("CopyUtilTest_cut_golden.xml"));
    }

    public void testCopyPasteCrossDesign() throws Exception {
        this.openDesign("CopyUtilTest_1.xml");
        ReportDesignHandle design1 = this.designHandle;
        this.openDesign("CopyUtilTest.xml");
        ReportDesignHandle design = this.designHandle;
        LabelHandle label = (LabelHandle)design.findElement("Body Label");
        IElementCopy copy = CopyUtil.copy((DesignElementHandle)label);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)design1, (int)6);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)design1, (int)6);
        DesignElementHandle elementHandle = copy.getHandle((ModuleHandle)design);
        CopyUtilTest.assertNotNull((Object)elementHandle.getElement().getExtendsName());
        TableHandle table = (TableHandle)design.findElement("table");
        copy = CopyUtil.copy((DesignElementHandle)table);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)design1, (int)6);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)design1, (int)6);
        this.designHandle = design1;
        this.save();
        CopyUtilTest.assertTrue((boolean)this.compareFile("CopyUtilTest_cross_golden.xml"));
    }

    public void testCutPasteCrossDesign() throws Exception {
        this.openDesign("CopyUtilTest.xml");
        ReportDesignHandle design = this.designHandle;
        this.openDesign("CopyUtilTest_1.xml");
        ReportDesignHandle design1 = this.designHandle;
        LabelHandle label = (LabelHandle)design.findElement("Body Label");
        IElementCopy copy = CopyUtil.copy((DesignElementHandle)label);
        label.drop();
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)design1, (int)6);
        this.save();
        CopyUtilTest.assertTrue((boolean)this.compareFile("CopyUtilTest_cut_cross_golden_1.xml"));
        this.openDesign("CopyUtilTest_2.xml");
        design = this.designHandle;
        String fileName = "input/CopyUtilTest.xml";
        design1 = this.sessionHandle.openDesign(this.getResource(fileName).toString());
        label = (LabelHandle)design1.findElement("Body Label");
        copy = CopyUtil.copy((DesignElementHandle)label);
        label.drop();
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)design, (int)6);
        this.save();
        CopyUtilTest.assertTrue((boolean)this.compareFile("CopyUtilTest_cut_cross_golden_2.xml"));
    }

    public void testInvalidPaste() throws Exception {
        this.openDesign("CopyUtilTest.xml");
        try {
            CopyUtil.paste(null, (DesignElementHandle)this.designHandle, (int)6);
            CopyUtilTest.fail();
        }
        catch (SemanticException e) {
            CopyUtilTest.assertEquals((String)"Error.ContentException.CONTENT_NOT_ALLOWED_PASTED", (String)e.getErrorCode());
        }
    }

    public void testCopyExtendedItemWithUnknowExtensionName() throws Exception {
        this.openDesign("CopyExtendedItemWithUnknowExtensionNameTest.xml");
        DesignElementHandle handle = this.designHandle.getElementByID(7L);
        IElementCopy copy = CopyUtil.copy((DesignElementHandle)handle);
    }

    public void testCopyExtendedItem() throws Exception {
        this.openDesign("CopyExtendedItemTest.xml");
        DesignElementHandle handle = this.designHandle.findElement("box");
        IElementCopy copy = CopyUtil.copy((DesignElementHandle)handle);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)6);
        handle = this.designHandle.findElement("box1");
        List list = handle.getListProperty("filter");
        CopyUtilTest.assertEquals((int)1, (int)list.size());
        PropertyHandle propHandle = handle.getPropertyHandle("filter");
        propHandle.removeItem(0);
        list = handle.getListProperty("filter");
        CopyUtilTest.assertNull((Object)list);
    }

    public void testCopyWithBinding() throws Exception {
        this.openDesign("CopyUtilTest_4.xml");
        DataSourceHandle dataSource = this.designHandle.findDataSource("Data Source");
        CopyUtilTest.assertNotNull((Object)dataSource);
        IElementCopy copy = CopyUtil.copy((DesignElementHandle)dataSource);
        CopyUtil.paste((IElementCopy)copy, (DesignElementHandle)this.designHandle, (int)2);
        dataSource = this.designHandle.findDataSource("Data Source1");
        CopyUtilTest.assertNotNull((Object)dataSource);
        Expression expr = dataSource.getPropertyBindingExpression("odaUser");
        CopyUtilTest.assertNotNull((Object)expr);
        CopyUtilTest.assertEquals((String)"constant", (String)expr.getType());
        CopyUtilTest.assertEquals((String)"administrator", (String)expr.getStringExpression());
        this.save();
        CopyUtilTest.assertTrue((boolean)this.compareFile("CopyUtilTest_4_golden.xml"));
    }
}

