/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ScalarParameterParseTest
extends BaseTestCase {
    public void testWrite() throws Exception {
        this.openDesign("ScalarParameterParseTest.xml");
        SlotHandle params = this.designHandle.getParameters();
        ScalarParameterHandle handle1 = (ScalarParameterHandle)params.get(0);
        ScalarParameterParseTest.assertTrue((boolean)handle1.isHidden());
        handle1.setHidden(true);
        ScalarParameterParseTest.assertTrue((boolean)handle1.isHidden());
        handle1.setValidate("new validation test");
        handle1.setDataType("dateTime");
        ScalarParameterParseTest.assertEquals((String)"dateTime", (String)handle1.getDataType());
        handle1.setParamType("simple");
        ScalarParameterParseTest.assertEquals((String)"simple", (String)handle1.getParamType());
        handle1.setConcealValue(true);
        ScalarParameterParseTest.assertTrue((boolean)handle1.isConcealValue());
        handle1.setDefaultValue("new default value.\r\nthis the next line of the value.");
        ScalarParameterParseTest.assertEquals((String)"new default value.\r\nthis the next line of the value.", (String)handle1.getDefaultValue());
        handle1.setIsRequired(false);
        ScalarParameterParseTest.assertFalse((boolean)handle1.isRequired());
        handle1.setDistinct(false);
        ScalarParameterParseTest.assertFalse((boolean)handle1.distinct());
        handle1.setSortDirection("asc");
        ScalarParameterParseTest.assertEquals((String)"asc", (String)handle1.getSortDirection());
        handle1.setSortBy("label");
        ScalarParameterParseTest.assertEquals((String)"label", (String)handle1.getSortBy());
        handle1.setSortByColumn("city");
        ScalarParameterParseTest.assertEquals((String)"city", (String)handle1.getSortByColumn());
        handle1.setCategory("Custom");
        ScalarParameterParseTest.assertEquals((String)"Custom", (String)handle1.getCategory());
        handle1.setPattern("aaaaa");
        ScalarParameterParseTest.assertEquals((String)"aaaaa", (String)handle1.getPattern());
        handle1.setPattern("$***,***.**");
        ScalarParameterParseTest.assertEquals((String)"$***,***.**", (String)handle1.getPattern());
        PropertyHandle propHandle = handle1.getPropertyHandle("format");
        FormatValue formatValueToSet = (FormatValue)handle1.getProperty("format");
        FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
        formatHandle.setLocale(ULocale.CANADA);
        handle1.setControlType("radio-button");
        ScalarParameterParseTest.assertEquals((String)"radio-button", (String)handle1.getControlType());
        handle1.setAlignment("right");
        ScalarParameterParseTest.assertEquals((String)"right", (String)handle1.getAlignment());
        handle1.setDataSetName("ds1");
        handle1.setValueExpr("new value column");
        handle1.setLabelExpr("new label column");
        handle1.setMustMatch(false);
        ScalarParameterParseTest.assertFalse((boolean)handle1.isMustMatch());
        handle1.setFixedOrder(false);
        handle1.setHelpText("new help text");
        handle1.setHelpTextKey("new resource key of the help text");
        handle1.setAutoSuggestThreshold(600);
        handle1.setDefaultValueListMethod("new getDefaultValueList");
        handle1.setSelectionValueListMethod("new getSelectionValueList");
        ScalarParameterHandle handle2 = (ScalarParameterHandle)params.get(1);
        ScalarParameterParseTest.assertEquals((String)"dynamic", (String)handle2.getValueType());
        ScalarParameterParseTest.assertEquals((String)"ds1", (String)handle2.getDataSetName());
        ScalarParameterParseTest.assertEquals((String)"row[\"test\"]", (String)handle2.getValueExpr());
        handle2.setValueType("static");
        handle2.setDataSetName(null);
        handle2.setValueExpr(null);
        handle2.setPromptText("new Text");
        handle2.setListlimit(300);
        ScalarParameterHandle handle3 = (ScalarParameterHandle)params.get(2);
        ArrayList<Expression> valueList = new ArrayList<Expression>();
        valueList.add(new Expression((Object)"default_value_1", "constant"));
        valueList.add(null);
        valueList.add(new Expression((Object)"default_value_2", "constant"));
        valueList.add(new Expression((Object)"", "constant"));
        handle3.setDefaultValueList(valueList);
        this.save();
        ScalarParameterParseTest.assertTrue((boolean)this.compareFile("ScalarParameterParseTest_golden.xml"));
    }

    public void testProperties() throws Exception {
        this.openDesign("ScalarParameterParseTest.xml");
        SlotHandle params = this.designHandle.getSlot(1);
        ScalarParameterParseTest.assertEquals((int)4, (int)params.getCount());
        ScalarParameterHandle handle = (ScalarParameterHandle)params.get(0);
        ScalarParameterParseTest.assertEquals((String)"scalar para help", (String)handle.getHelpText());
        ScalarParameterParseTest.assertEquals((String)"help", (String)handle.getHelpTextKey());
        ScalarParameterParseTest.assertTrue((boolean)handle.isHidden());
        ScalarParameterParseTest.assertEquals((String)"decimal", (String)handle.getDataType());
        ScalarParameterParseTest.assertEquals((String)"multi-value", (String)handle.getParamType());
        ScalarParameterParseTest.assertEquals((String)"the validation test", (String)handle.getValidate());
        ScalarParameterParseTest.assertFalse((boolean)handle.isConcealValue());
        List valueList = handle.getDefaultValueList();
        ScalarParameterParseTest.assertEquals((Object)((Expression)valueList.get(0)).getExpression(), (Object)handle.getDefaultValue());
        ScalarParameterParseTest.assertEquals((Object)"", (Object)((Expression)valueList.get(1)).getExpression());
        ScalarParameterParseTest.assertEquals((Object)"", (Object)((Expression)valueList.get(2)).getExpression());
        ScalarParameterParseTest.assertNull((Object)((Expression)valueList.get(3)).getExpression());
        ScalarParameterParseTest.assertNull((Object)((Expression)valueList.get(4)).getExpression());
        ScalarParameterParseTest.assertNull(valueList.get(5));
        ScalarParameterParseTest.assertEquals((Object)" ", (Object)((Expression)valueList.get(6)).getExpression());
        ScalarParameterParseTest.assertTrue((boolean)handle.isRequired());
        ScalarParameterParseTest.assertFalse((boolean)handle.distinct());
        ScalarParameterParseTest.assertEquals((String)"##,###.##", (String)handle.getPattern());
        ScalarParameterParseTest.assertEquals((Object)ULocale.ENGLISH, (Object)this.getLocale(handle, "format"));
        ScalarParameterParseTest.assertEquals((String)"check-box", (String)handle.getControlType());
        ScalarParameterParseTest.assertEquals((String)"auto", (String)handle.getAlignment());
        ScalarParameterParseTest.assertEquals((String)"desc", (String)handle.getSortDirection());
        ScalarParameterParseTest.assertEquals((String)"value", (String)handle.getSortBy());
        ScalarParameterParseTest.assertTrue((boolean)handle.isMustMatch());
        ScalarParameterParseTest.assertTrue((boolean)handle.isFixedOrder());
        ScalarParameterParseTest.assertEquals((int)500, (int)handle.getAutoSuggestThreshold());
        StructureHandle[] choices = new StructureHandle[3];
        int count = 0;
        Iterator iter = null;
        iter = handle.choiceIterator();
        while (iter.hasNext()) {
            choices[count] = (StructureHandle)iter.next();
            ++count;
        }
        ScalarParameterParseTest.assertEquals((int)3, (int)count);
        ScalarParameterParseTest.assertEquals((Object)"option 1", (Object)choices[0].getMember("value").getValue());
        ScalarParameterParseTest.assertEquals((Object)"option 1 label", (Object)choices[0].getMember("label").getValue());
        ScalarParameterParseTest.assertEquals((Object)"key 1 for label 1", (Object)choices[0].getMember("labelID").getValue());
        ScalarParameterParseTest.assertEquals((Object)"option 3", (Object)choices[2].getMember("value").getValue());
        ScalarParameterParseTest.assertNull((Object)choices[2].getMember("label").getValue());
        ScalarParameterParseTest.assertNull((Object)choices[2].getMember("labelID").getValue());
        handle = (ScalarParameterHandle)params.get(1);
        ScalarParameterParseTest.assertEquals((String)"City", (String)handle.getPromptText());
        handle.setPromptText("new Text");
        ScalarParameterParseTest.assertEquals((String)"new Text", (String)handle.getPromptText());
        ScalarParameterParseTest.assertEquals((int)100, (int)handle.getListlimit());
        handle.setListlimit(200);
        ScalarParameterParseTest.assertEquals((int)200, (int)handle.getListlimit());
        ScalarParameterParseTest.assertEquals((Object)ULocale.CHINESE, (Object)this.getLocale(handle, "format"));
        handle = (ScalarParameterHandle)params.get(2);
        ScalarParameterParseTest.assertNull((Object)this.getLocale(handle, "format"));
        handle = (ScalarParameterHandle)params.get(3);
        ScalarParameterParseTest.assertEquals((String)"test", (String)this.getLocale(handle, "format").toString());
        valueList = handle.getDefaultValueList();
        ScalarParameterParseTest.assertEquals((Object)"value1", (Object)((Expression)valueList.get(0)).getExpression());
        ScalarParameterParseTest.assertEquals((String)"constant", (String)((Expression)valueList.get(0)).getType());
        ScalarParameterParseTest.assertEquals((Object)"value2", (Object)((Expression)valueList.get(1)).getExpression());
        ScalarParameterParseTest.assertEquals((String)"javascript", (String)((Expression)valueList.get(1)).getType());
    }

    private ULocale getLocale(ScalarParameterHandle handle, String propName) {
        PropertyHandle propHandle = handle.getPropertyHandle(propName);
        FormatValue formatValueToSet = (FormatValue)handle.getProperty(propName);
        FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
        return formatHandle.getLocale();
    }

    public void testBackwardCompatibility() throws Exception {
        this.openDesign("ScalarParameterParseTest_1.xml");
        SlotHandle params = this.designHandle.getParameters();
        ScalarParameterHandle param = (ScalarParameterHandle)params.get(0);
        ScalarParameterParseTest.assertEquals((String)"default value", (String)param.getDefaultValue());
    }
}

