/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CascadingParameterGroupParserTest
extends BaseTestCase {
    private static final String INPUT = "CascadingParameterGroupParserTest.xml";
    private static final String INPUT_SEMANTIC_ERRORS = "CascadingParameterGroupParserTest_1.xml";
    private static final String GOLDEN = "CascadingParameterGroupParserTest_golden.xml";

    public void testGetPropertiesAndContents() throws DesignFileException, SemanticException {
        this.openDesign(INPUT);
        CascadingParameterGroupHandle groupHandle = this.getGroupHandle("Country-State-City");
        CascadingParameterGroupParserTest.assertEquals((String)"Group for Country-State-City", (String)groupHandle.getDisplayName());
        CascadingParameterGroupParserTest.assertEquals((String)"actuate", (String)groupHandle.getPromptText());
        groupHandle.setPromptText("actuate shanghai");
        CascadingParameterGroupParserTest.assertEquals((String)"actuate shanghai", (String)groupHandle.getPromptText());
        CascadingParameterGroupParserTest.assertEquals((String)"ResourceKey.Parameter.PromptText", (String)groupHandle.getPromptTextKey());
        groupHandle.setPromptTextKey("ResourceKey.Parameter.PromptTextValue");
        CascadingParameterGroupParserTest.assertEquals((String)"ResourceKey.Parameter.PromptTextValue", (String)groupHandle.getPromptTextKey());
        CascadingParameterGroupParserTest.assertEquals((String)"multiple", (String)groupHandle.getDataSetMode());
        SlotHandle parameters = groupHandle.getParameters();
        CascadingParameterGroupParserTest.assertEquals((int)3, (int)parameters.getCount());
        ScalarParameterHandle p1 = (ScalarParameterHandle)parameters.get(0);
        CascadingParameterGroupParserTest.assertEquals((String)"dynamic", (String)p1.getValueType());
        CascadingParameterGroupParserTest.assertEquals((String)"Country", (String)p1.getName());
        CascadingParameterGroupParserTest.assertEquals((String)"ds1", (String)p1.getDataSetName());
        CascadingParameterGroupParserTest.assertEquals((String)"country", (String)p1.getValueExpr());
        CascadingParameterGroupParserTest.assertEquals((String)"Enter country:", (String)p1.getLabelExpr());
    }

    public void testWriter() throws Exception {
        this.openDesign(INPUT);
        CascadingParameterGroupHandle groupHandle = this.getGroupHandle("Country-State-City");
        groupHandle.setDisplayName("new name");
        groupHandle.setPromptText("new prompt text");
        groupHandle.setPromptTextKey("new prompt text id");
        groupHandle.setDataSetMode("single");
        groupHandle.setDataSet(this.designHandle.findDataSet("ds1"));
        this.save();
        CascadingParameterGroupParserTest.assertTrue((boolean)this.compareFile(GOLDEN));
    }

    private CascadingParameterGroupHandle getGroupHandle(String name) {
        SlotHandle parameters = this.designHandle.getParameters();
        int i = 0;
        while (i < parameters.getCount()) {
            DesignElementHandle elementHandle = parameters.get(i);
            if (elementHandle.getName().equals(name)) {
                return (CascadingParameterGroupHandle)elementHandle;
            }
            ++i;
        }
        return null;
    }

    public void testSemanticErrors() throws Exception {
        this.openDesign(INPUT_SEMANTIC_ERRORS);
        List errors = this.designHandle.getErrorList();
        CascadingParameterGroupParserTest.assertEquals((int)2, (int)errors.size());
        ErrorDetail error1 = (ErrorDetail)errors.get(0);
        CascadingParameterGroupParserTest.assertEquals((String)"Error.SemanticError.INVALID_ELEMENT_REF", (String)error1.getErrorCode());
        ErrorDetail error2 = (ErrorDetail)errors.get(1);
        CascadingParameterGroupParserTest.assertEquals((String)"Error.SemanticError.INVALID_SCALAR_PARAMETER_TYPE", (String)error2.getErrorCode());
    }
}

