/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import java.util.List;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.RowOperationParameters;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibraryWithTableTest
extends BaseTestCase {
    private String fileCanUpdate = "TableItemRowUpdateTest.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testRowAndColumnUpdateAction() throws Exception {
        this.openDesign(this.fileCanUpdate);
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("NewTable");
        ColumnBandData data = tableHandle.copyColumn(1);
        LibraryWithTableTest.assertFalse((boolean)tableHandle.canPasteColumn(data, 2, true));
        try {
            tableHandle.pasteColumn(data, 2, true);
            LibraryWithTableTest.fail((String)"forbidden do action on column ");
        }
        catch (SemanticException e) {
            LibraryWithTableTest.assertEquals((String)"Error.SemanticError.COLUMN_PASTE_FORBIDDEN", (String)e.getErrorCode());
        }
        LibraryWithTableTest.assertFalse((boolean)tableHandle.canInsertAndPasteColumn(data, 1));
        try {
            tableHandle.insertAndPasteColumn(data, 1);
            LibraryWithTableTest.fail((String)"forbidden do action on column ");
        }
        catch (SemanticException e) {
            LibraryWithTableTest.assertEquals((String)"Error.SemanticError.COLUMN_PASTE_FORBIDDEN", (String)e.getErrorCode());
        }
        LibraryWithTableTest.assertFalse((boolean)tableHandle.canShiftColumn(1, 2));
        try {
            tableHandle.shiftColumn(1, 2, false);
            LibraryWithTableTest.fail((String)"forbidden do action on column ");
        }
        catch (SemanticException e) {
            LibraryWithTableTest.assertEquals((String)"Error.SemanticError.COLUMN_PASTE_FORBIDDEN", (String)e.getErrorCode());
        }
        SlotHandle slotHandle = tableHandle.getSlot(0);
        RowHandle rowHandle = (RowHandle)slotHandle.get(0);
        IDesignElement row = rowHandle.copy();
        RowOperationParameters parameters = new RowOperationParameters(0, -1, 0);
        LibraryWithTableTest.assertFalse((boolean)tableHandle.canPasteRow(row, parameters));
        try {
            tableHandle.pasteRow(row, parameters);
            LibraryWithTableTest.fail((String)"forbidden do action on row ");
        }
        catch (SemanticException e) {
            LibraryWithTableTest.assertEquals((String)"Error.SemanticError.ROW_PASTE_FORBIDDEN", (String)e.getErrorCode());
        }
        LibraryWithTableTest.assertFalse((boolean)tableHandle.canInsertRow(parameters));
        try {
            tableHandle.insertRow(parameters);
            LibraryWithTableTest.fail((String)"forbidden do action on row ");
        }
        catch (SemanticException e) {
            LibraryWithTableTest.assertEquals((String)"Error.SemanticError.ROW_INSERT_FORBIDDEN", (String)e.getErrorCode());
        }
        LibraryWithTableTest.assertFalse((boolean)tableHandle.canInsertAndPasteRow(row, parameters));
        try {
            tableHandle.insertAndPasteRow(row, parameters);
            LibraryWithTableTest.fail((String)"forbidden do action on row ");
        }
        catch (SemanticException e) {
            LibraryWithTableTest.assertEquals((String)"Error.SemanticError.ROW_INSERTANDPASTE_FORBIDDEN", (String)e.getErrorCode());
        }
        parameters.setDestIndex(2);
        parameters.setSourceIndex(0);
        LibraryWithTableTest.assertFalse((boolean)tableHandle.canShiftRow(parameters));
        try {
            tableHandle.shiftRow(parameters);
            LibraryWithTableTest.fail((String)"forbidden do action on row ");
        }
        catch (SemanticException e) {
            LibraryWithTableTest.assertEquals((String)"Error.SemanticError.ROW_SHIFT_FORBIDDEN", (String)e.getErrorCode());
        }
    }

    public void testGridContainTableInLib() throws Exception {
        this.openDesign("LibraryWithTableTest_GridContainTable.xml");
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("NewTable");
        LibraryWithTableTest.assertNotNull((Object)tableHandle);
    }

    public void testMultiViewsExtends() throws Exception {
        this.openDesign("DesignIncludeTableMultiView.xml");
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("MyTable1");
        MultiViewsHandle multiView = (MultiViewsHandle)tableHandle.getProperty("multiViews");
        LibraryWithTableTest.assertEquals((int)-1, (int)multiView.getIntProperty("index"));
        List views = multiView.getListProperty("views");
        LibraryWithTableTest.assertEquals((int)2, (int)views.size());
        ExtendedItemHandle box1 = (ExtendedItemHandle)views.get(0);
        LibraryWithTableTest.assertEquals((String)"box1", (String)box1.getName());
        LibraryWithTableTest.assertEquals((String)"5in", (String)box1.getWidth().getStringValue());
        tableHandle.setCurrentView((DesignElementHandle)((ExtendedItemHandle)views.get(1)));
        box1.setWidth(3.0);
        this.save();
        LibraryWithTableTest.assertTrue((boolean)this.compareFile("DesignIncludeTableMultiView_golden.xml"));
    }
}

