/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsEvent;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.CoreTestUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StyleElementTest
extends BaseTestCase {
    StyledElement label1;
    StyledElement label2;
    StyleElement style;
    TableHandle table = null;
    LabelHandle label = null;
    ListHandle list1 = null;
    ListHandle list2 = null;
    MyActionListener clientListenerTable = null;
    MyActionListener clientListenerLabel = null;
    MyActionListener clientListenerList1 = null;
    MyActionListener clientListenerList2 = null;
    StyleHandle tableSelector = null;
    StyleHandle listSelector = null;
    SessionHandle sessionHandle = null;
    private StyleHandle reportSelector = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        SessionHandle sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(null);
        this.designHandle = sessionHandle.createDesign();
        LabelHandle handle = this.designHandle.getElementFactory().newLabel("label1");
        this.designHandle.getBody().add((DesignElementHandle)handle);
        this.label1 = (Label)handle.getElement();
        handle = this.designHandle.getElementFactory().newLabel("label2");
        this.designHandle.getBody().add((DesignElementHandle)handle);
        this.label2 = (Label)handle.getElement();
        handle = this.designHandle.getElementFactory().newStyle("style");
        this.designHandle.getStyles().add((DesignElementHandle)handle);
        this.style = (StyleElement)handle.getElement();
    }

    public void testAddAndDropClient() {
        this.label1.setStyle(this.style);
        this.label2.setStyle(this.style);
        StyleElementTest.assertEquals((int)2, (int)this.style.getClientList().size());
        StyleElementTest.assertEquals((Object)this.label1, (Object)((BackRef)this.style.getClientList().get(0)).getElement());
        StyleElementTest.assertEquals((Object)this.label2, (Object)((BackRef)this.style.getClientList().get(1)).getElement());
        this.style.dropClient((DesignElement)this.label1);
        StyleElementTest.assertEquals((int)1, (int)this.style.getClientList().size());
        StyleElementTest.assertFalse((boolean)this.style.getClientList().contains(this.label1));
        StyleElementTest.assertEquals((Object)this.style, (Object)this.label1.getStyle());
        this.style.addClient((DesignElement)this.label1, null);
        StyleElementTest.assertEquals((Object)this.label1, (Object)((BackRef)this.style.getClientList().get(1)).getElement());
    }

    public void testBroadcast() {
        MyActionListener styleListener = new MyActionListener();
        MyActionListener clientListener1 = new MyActionListener();
        MyActionListener clientListener2 = new MyActionListener();
        this.style.addListener((Listener)styleListener);
        this.label1.addListener((Listener)clientListener1);
        this.label2.addListener((Listener)clientListener2);
        StyleElementTest.assertTrue((boolean)CoreTestUtil.getListeners((DesignElement)this.label1).contains(clientListener1));
        StyleElementTest.assertTrue((boolean)CoreTestUtil.getListeners((DesignElement)this.label2).contains(clientListener2));
        this.label1.setStyle(this.style);
        this.label2.setStyle(this.style);
        ExtendsEvent ev = new ExtendsEvent((DesignElement)this.style);
        this.style.broadcast((NotificationEvent)ev);
        StyleElementTest.assertTrue((boolean)styleListener.done);
        StyleElementTest.assertEquals((int)0, (int)styleListener.path);
        StyleElementTest.assertTrue((boolean)clientListener1.done);
        StyleElementTest.assertEquals((int)2, (int)clientListener1.path);
        StyleElementTest.assertTrue((boolean)clientListener2.done);
        StyleElementTest.assertEquals((int)2, (int)clientListener2.path);
    }

    public void testBroadcastAfterDropStyle() throws SemanticException {
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table");
        SharedStyleHandle myStyle = this.designHandle.getElementFactory().newStyle("myStyle");
        this.designHandle.getBody().add((DesignElementHandle)table);
        this.designHandle.getStyles().add((DesignElementHandle)myStyle);
        table.setStyle(myStyle);
        MyActionListener styleListener = new MyActionListener();
        table.addListener((Listener)styleListener);
        StyleElementTest.assertFalse((boolean)styleListener.done);
        this.designHandle.getStyles().dropAndClear((DesignElementHandle)myStyle);
        StyleElementTest.assertTrue((boolean)styleListener.done);
    }

    public void testBroadcastFromSimpleSelectorStyle() throws Exception {
        this.style.setName("label");
        MyActionListener clientListener1 = new MyActionListener();
        this.label1.addListener((Listener)clientListener1);
        this.style.getHandle((Module)this.design).setProperty("backgroundColor", (Object)"red");
        StyleElementTest.assertTrue((boolean)clientListener1.done);
        StyleElementTest.assertEquals((int)2, (int)clientListener1.path);
    }

    public void testBroadcastFromContainerSlotSelectorStyle() throws Exception {
        this.designHandle.getStyles().dropAndClear(this.style.getHandle(this.designHandle.getModule()));
        this.designHandle.getBody().dropAndClear(this.label1.getHandle(this.designHandle.getModule()));
        this.style.setName("list-header");
        ListHandle listHandle = this.designHandle.getElementFactory().newList("list1");
        this.designHandle.getBody().add((DesignElementHandle)listHandle);
        this.designHandle.getStyles().add(this.style.getHandle((Module)this.design));
        listHandle.getHeader().add(this.label1.getHandle((Module)this.design));
        MyActionListener clientListener1 = new MyActionListener();
        this.label1.addListener((Listener)clientListener1);
        this.style.getHandle((Module)this.design).setProperty("color", (Object)"red");
        StyleElementTest.assertTrue((boolean)clientListener1.done);
        StyleElementTest.assertEquals((int)2, (int)clientListener1.path);
    }

    private void prepareForSelectorBroadCastTest() throws ContentException, NameException {
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(null);
        this.designHandle = this.sessionHandle.createDesign();
        this.tableSelector = this.designHandle.getElementFactory().newStyle("table");
        this.listSelector = this.designHandle.getElementFactory().newStyle("list");
        this.reportSelector = this.designHandle.getElementFactory().newStyle("report");
        this.designHandle.getStyles().add((DesignElementHandle)this.reportSelector);
        this.designHandle.getStyles().add((DesignElementHandle)this.tableSelector);
        this.designHandle.getStyles().add((DesignElementHandle)this.listSelector);
        this.table = this.designHandle.getElementFactory().newTableItem("my Tabel");
        this.label = this.designHandle.getElementFactory().newLabel("My Label");
        RowHandle row = this.designHandle.getElementFactory().newTableRow();
        CellHandle cell = this.designHandle.getElementFactory().newCell();
        this.designHandle.getBody().add((DesignElementHandle)this.table);
        this.table.getDetail().add((DesignElementHandle)row);
        row.getCells().add((DesignElementHandle)cell);
        cell.getContent().add((DesignElementHandle)this.label);
        this.list1 = this.designHandle.getElementFactory().newList("list1");
        this.list2 = this.designHandle.getElementFactory().newList("list2");
        cell.getContent().add((DesignElementHandle)this.list1);
        this.list1.getDetail().add((DesignElementHandle)this.list2);
        this.clientListenerTable = new MyActionListener();
        this.table.addListener((Listener)this.clientListenerTable);
        this.clientListenerLabel = new MyActionListener();
        this.label.addListener((Listener)this.clientListenerLabel);
        this.clientListenerList1 = new MyActionListener();
        this.list1.addListener((Listener)this.clientListenerList1);
        this.clientListenerList2 = new MyActionListener();
        this.list2.addListener((Listener)this.clientListenerList2);
    }

    public void testBroadcastAfterAddSelector() throws SemanticException {
        this.prepareForSelectorBroadCastTest();
        this.designHandle.getStyles().dropAndClear((DesignElementHandle)this.tableSelector);
        this.designHandle.getStyles().dropAndClear((DesignElementHandle)this.listSelector);
        this.table.removeListener((Listener)this.clientListenerTable);
        this.label.removeListener((Listener)this.clientListenerLabel);
        this.list1.removeListener((Listener)this.clientListenerList1);
        this.list2.removeListener((Listener)this.clientListenerList2);
        this.clientListenerTable = new MyActionListener();
        this.clientListenerLabel = new MyActionListener();
        this.clientListenerList1 = new MyActionListener();
        this.clientListenerList2 = new MyActionListener();
        this.table.addListener((Listener)this.clientListenerTable);
        this.label.addListener((Listener)this.clientListenerLabel);
        this.list1.addListener((Listener)this.clientListenerList1);
        this.list2.addListener((Listener)this.clientListenerList2);
        this.designHandle.getStyles().add((DesignElementHandle)this.tableSelector);
        StyleElementTest.assertTrue((boolean)this.clientListenerTable.done);
        StyleElementTest.assertEquals((int)2, (int)this.clientListenerTable.path);
        StyleElementTest.assertFalse((boolean)this.clientListenerLabel.done);
        this.designHandle.getStyles().add((DesignElementHandle)this.listSelector);
        StyleElementTest.assertTrue((boolean)this.clientListenerList1.done);
        StyleElementTest.assertEquals((int)2, (int)this.clientListenerList1.path);
        StyleElementTest.assertFalse((boolean)this.clientListenerList2.done);
    }

    public void testBroadcastAfterDropSelector() throws SemanticException {
        this.prepareForSelectorBroadCastTest();
        StyleElementTest.assertFalse((boolean)this.clientListenerTable.done);
        this.designHandle.getStyles().dropAndClear((DesignElementHandle)this.tableSelector);
        StyleElementTest.assertTrue((boolean)this.clientListenerTable.done);
        StyleElementTest.assertEquals((int)2, (int)this.clientListenerTable.path);
        StyleElementTest.assertFalse((boolean)this.clientListenerLabel.done);
        StyleElementTest.assertFalse((boolean)this.clientListenerList1.done);
        this.designHandle.getStyles().dropAndClear((DesignElementHandle)this.listSelector);
        StyleElementTest.assertTrue((boolean)this.clientListenerList1.done);
        StyleElementTest.assertEquals((int)2, (int)this.clientListenerList1.path);
        StyleElementTest.assertFalse((boolean)this.clientListenerList2.done);
    }

    public void testBroadcastAfterRenameSelector() throws ContentException, NameException {
        this.prepareForSelectorBroadCastTest();
        StyleElementTest.assertFalse((boolean)this.clientListenerTable.done);
        this.tableSelector.setName("table-style");
        StyleElementTest.assertTrue((boolean)this.clientListenerTable.done);
        StyleElementTest.assertEquals((int)2, (int)this.clientListenerTable.path);
        StyleElementTest.assertFalse((boolean)this.clientListenerLabel.done);
        this.listSelector.setName("list-style");
        StyleElementTest.assertTrue((boolean)this.clientListenerList1.done);
        StyleElementTest.assertEquals((int)2, (int)this.clientListenerList1.path);
        StyleElementTest.assertFalse((boolean)this.clientListenerList2.done);
    }

    public void testBroadcastAfterSelectorPropertyChanged() throws SemanticException {
        this.prepareForSelectorBroadCastTest();
        StyleElementTest.assertFalse((boolean)this.clientListenerTable.done);
        this.tableSelector.getBackgroundColor().setStringValue("yellow");
        StyleElementTest.assertTrue((boolean)this.clientListenerTable.done);
        StyleElementTest.assertEquals((int)2, (int)this.clientListenerTable.path);
        StyleElementTest.assertFalse((boolean)this.clientListenerLabel.done);
        StyleElementTest.assertFalse((boolean)this.clientListenerList1.done);
        this.listSelector.getBackgroundColor().setStringValue("red");
        StyleElementTest.assertTrue((boolean)this.clientListenerList1.done);
        StyleElementTest.assertEquals((int)2, (int)this.clientListenerList1.path);
        StyleElementTest.assertFalse((boolean)this.clientListenerList2.done);
    }

    public void testBroadcastForReportSelector() throws SemanticException {
        this.prepareForSelectorBroadCastTest();
        MyActionListener designListener = new MyActionListener();
        this.designHandle.addListener((Listener)designListener);
        StyleElementTest.assertFalse((boolean)designListener.done);
        this.reportSelector.getColor().setStringValue("yellow");
        StyleElementTest.assertTrue((boolean)designListener.done);
    }

    public void testBroadcastWhenRenameSelector() throws ContentException, NameException {
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table");
        ListHandle list = this.designHandle.getElementFactory().newList("list");
        this.designHandle.getBody().add((DesignElementHandle)table);
        this.designHandle.getBody().add((DesignElementHandle)list);
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("table");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        MyActionListener clientListener1 = new MyActionListener();
        MyActionListener clientListener2 = new MyActionListener();
        table.addListener((Listener)clientListener1);
        list.addListener((Listener)clientListener2);
        StyleElementTest.assertFalse((boolean)clientListener1.done);
        StyleElementTest.assertFalse((boolean)clientListener2.done);
        style.setName("list");
        StyleElementTest.assertTrue((boolean)clientListener1.done);
        StyleElementTest.assertTrue((boolean)clientListener2.done);
    }

    public void testBroadcastPredefinedStyle() throws Exception {
        this.openDesign("BroadcastPredefinedStyleTest.xml");
        SharedStyleHandle style = this.designHandle.findStyle("table-header-cell");
        DesignElementHandle cellInHeader = this.designHandle.getElementByID(10L);
        DesignElementHandle cellInGroupHeader = this.designHandle.getElementByID(125L);
        MyActionListener styleListener = new MyActionListener();
        MyActionListener clientListener1 = new MyActionListener();
        MyActionListener clientListener2 = new MyActionListener();
        style.addListener((Listener)styleListener);
        cellInHeader.addListener((Listener)clientListener1);
        cellInGroupHeader.addListener((Listener)clientListener2);
        style.setProperty("fontStyle", (Object)"italic");
        StyleElementTest.assertTrue((boolean)styleListener.done);
        StyleElementTest.assertEquals((int)0, (int)styleListener.path);
        StyleElementTest.assertTrue((boolean)clientListener1.done);
        StyleElementTest.assertEquals((int)2, (int)clientListener1.path);
        StyleElementTest.assertFalse((boolean)clientListener2.done);
        style = this.designHandle.findStyle("table-group-header-cell");
        style.setProperty("fontStyle", (Object)"italic");
        StyleElementTest.assertTrue((boolean)styleListener.done);
        StyleElementTest.assertEquals((int)0, (int)styleListener.path);
        StyleElementTest.assertTrue((boolean)clientListener2.done);
        StyleElementTest.assertEquals((int)2, (int)clientListener2.path);
    }

    class MyActionListener
    implements Listener {
        boolean done = false;
        int path = -1;

        MyActionListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.done = true;
            this.path = ev.getDeliveryPath();
        }
    }
}

