/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.i18n.ThreadResources;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleRuleHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;
import org.eclipse.birt.report.model.util.VersionInfo;
import org.eclipse.birt.report.model.util.XMLParserException;

public class ModuleUtilTest
extends BaseTestCase {
    public void testDeserialize() throws XMLParserException, IOException, DesignFileException {
        InputStream is = ModuleUtilTest.class.getResourceAsStream("input/ActionDeserializeTest.xml");
        ActionHandle action = ModuleUtil.deserializeAction((InputStream)is);
        ModuleUtilTest.assertEquals((String)"drill-through", (String)action.getLinkType());
        ModuleUtilTest.assertEquals((String)"Window3", (String)action.getTargetWindow());
        MemberHandle paramBindings = action.getParamBindings();
        ModuleUtilTest.assertEquals((int)2, (int)paramBindings.getListValue().size());
        ParamBindingHandle paramBinding1 = (ParamBindingHandle)paramBindings.getAt(0);
        ModuleUtilTest.assertEquals((String)"param1", (String)paramBinding1.getParamName());
        ModuleUtilTest.assertEquals((String)"1+1=3", (String)paramBinding1.getExpression());
        MemberHandle searchKeys = action.getSearch();
        ModuleUtilTest.assertEquals((int)2, (int)searchKeys.getListValue().size());
        SearchKeyHandle key1 = (SearchKeyHandle)searchKeys.getAt(0);
        ModuleUtilTest.assertEquals((String)"\"E001\".equals(row[\"studentId\"])", (String)key1.getExpression());
        is = ModuleUtilTest.class.getResourceAsStream("input/ActionDeserializeTest_1.xml");
        action = ModuleUtil.deserializeAction((InputStream)is);
        ModuleUtilTest.assertNotNull((Object)action);
        ModuleUtilTest.assertEquals((String)"/BIRT/\u4e2d\u6587.html", (String)action.getURI());
        ActionHandle actionHandle = ModuleUtil.deserializeAction(null);
        ModuleUtilTest.assertNotNull((Object)actionHandle);
        ModuleUtilTest.assertEquals((String)"hyperlink", (String)actionHandle.getLinkType());
    }

    public void testSerialize() throws Exception {
        this.openDesign("ActionSerializeTest.xml");
        ImageHandle image1 = (ImageHandle)this.designHandle.findElement("image1");
        ActionHandle action1 = image1.getActionHandle();
        ImageHandle image2 = (ImageHandle)this.designHandle.findElement("image2");
        ActionHandle action2 = image2.getActionHandle();
        String str = ModuleUtil.serializeAction((ActionHandle)action1);
        this.os = new ByteArrayOutputStream();
        this.os.write(str.getBytes());
        this.os.close();
        ModuleUtilTest.assertTrue((boolean)this.compareFile("ActionSerializeTest1_golden.xml"));
        str = ModuleUtil.serializeAction((ActionHandle)action2);
        this.os = new ByteArrayOutputStream();
        this.os.write(str.getBytes());
        this.os.close();
        ModuleUtilTest.assertTrue((boolean)this.compareFile("ActionSerializeTest2_golden.xml"));
    }

    public void testCheckModule() throws Exception {
        this.sessionHandle = new DesignEngine(null).newSessionHandle(ULocale.ENGLISH);
        ModuleUtilTest.assertNotNull((Object)this.sessionHandle);
        String fileName = "input/CellHandleTest.xml";
        InputStream inputStream = this.getResourceAStream(fileName);
        int rtnType = ModuleUtil.checkModule((SessionHandle)this.sessionHandle, (String)this.getResource(fileName).toString(), (InputStream)inputStream);
        ModuleUtilTest.assertEquals((int)1, (int)rtnType);
        fileName = "input/Library_1.xml";
        inputStream = this.getResourceAStream(fileName);
        rtnType = ModuleUtil.checkModule((SessionHandle)this.sessionHandle, (String)this.getResource(fileName).toString(), (InputStream)inputStream);
        ModuleUtilTest.assertEquals((int)0, (int)rtnType);
        fileName = "input/InValidDesign.xml";
        inputStream = this.getResourceAStream(fileName);
        rtnType = ModuleUtil.checkModule((SessionHandle)this.sessionHandle, (String)this.getResource(fileName).toString(), (InputStream)inputStream);
        ModuleUtilTest.assertEquals((int)2, (int)rtnType);
        fileName = "input/InValidLibrary.xml";
        inputStream = this.getResourceAStream(fileName);
        rtnType = ModuleUtil.checkModule((SessionHandle)this.sessionHandle, (String)this.getResource(fileName).toString(), (InputStream)inputStream);
        ModuleUtilTest.assertEquals((int)2, (int)rtnType);
    }

    public void testCheckVersion() throws Exception {
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        List infos = ModuleUtil.checkVersion((String)this.getResource("input/DesignWithoutLibrary.xml").toString());
        ModuleUtilTest.assertEquals((int)1, (int)infos.size());
        VersionInfo versionInfo = (VersionInfo)infos.get(0);
        ModuleUtilTest.assertEquals((String)"1", (String)versionInfo.getDesignFileVersion());
        ModuleUtilTest.assertEquals((int)1, (int)versionInfo.getInfoCode());
        infos = ModuleUtil.checkVersion((String)this.getResource("input/ScalarParameterHandleTest.xml").toString());
        ModuleUtilTest.assertEquals((int)0, (int)infos.size());
        infos = ModuleUtil.checkVersion((String)this.getResource("input/CheckVersionDesign.xml").toString());
        ModuleUtilTest.assertEquals((int)1, (int)infos.size());
        versionInfo = (VersionInfo)infos.get(0);
        ModuleUtilTest.assertEquals((String)"3.4.20.1", (String)versionInfo.getDesignFileVersion());
        ModuleUtilTest.assertEquals((int)2, (int)versionInfo.getInfoCode());
        infos = ModuleUtil.checkVersion((String)this.getResource("input/PeerExtensionTest.xml").toString());
        ModuleUtilTest.assertEquals((int)1, (int)infos.size());
        versionInfo = (VersionInfo)infos.get(0);
        ModuleUtilTest.assertEquals((int)4, (int)versionInfo.getInfoCode());
    }

    public void testIsEqualHierarchyForJointCondition() throws DesignFileException {
        this.openDesign("testIsEqualHierarchyForJointCondition_report.xml");
        TabularCubeHandle cube1 = (TabularCubeHandle)this.designHandle.findCube("Customer Cube");
        ModuleUtilTest.assertNotNull((Object)cube1);
        TabularCubeHandle cube2 = (TabularCubeHandle)this.designHandle.findCube("Customer Cube1");
        ModuleUtilTest.assertNotNull((Object)cube2);
        Iterator iter = cube1.joinConditionsIterator();
        DimensionConditionHandle condition = (DimensionConditionHandle)iter.next();
        HierarchyHandle conditionHierarchy = condition.getHierarchy();
        HierarchyHandle cubeHierarchy = cube1.getDimension("Group1").getDefaultHierarchy();
        ModuleUtilTest.assertNotNull((Object)cubeHierarchy);
        ModuleUtilTest.assertTrue((boolean)ModuleUtil.isEqualHierarchiesForJointCondition((HierarchyHandle)conditionHierarchy, (HierarchyHandle)cubeHierarchy));
        iter = cube2.joinConditionsIterator();
        condition = (DimensionConditionHandle)iter.next();
        conditionHierarchy = condition.getHierarchy();
        cubeHierarchy = cube2.getDimension("Group4").getDefaultHierarchy();
        ModuleUtilTest.assertNotNull((Object)cubeHierarchy);
        ModuleUtilTest.assertTrue((boolean)ModuleUtil.isEqualHierarchiesForJointCondition((HierarchyHandle)conditionHierarchy, (HierarchyHandle)cubeHierarchy));
        condition = (DimensionConditionHandle)iter.next();
        conditionHierarchy = condition.getHierarchy();
        cubeHierarchy = cube2.getDimension("Group3").getDefaultHierarchy();
        ModuleUtilTest.assertNotNull((Object)cubeHierarchy);
        ModuleUtilTest.assertTrue((boolean)ModuleUtil.isEqualHierarchiesForJointCondition((HierarchyHandle)conditionHierarchy, (HierarchyHandle)cubeHierarchy));
    }

    public void testIsValidElementName() throws DesignFileException, ContentException, NameException {
        this.openDesign("emptyDesign.xml");
        OdaDataSetHandle dataset = this.designHandle.getElementFactory().newOdaDataSet("validName");
        ModuleUtilTest.assertTrue((boolean)ModuleUtil.isValidElementName((DesignElementHandle)dataset));
        this.designHandle.getDataSets().add((DesignElementHandle)dataset);
        OdaDataSetHandle datasetA = this.designHandle.getElementFactory().newOdaDataSet(null);
        datasetA.getElement().setName(dataset.getName());
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidElementName((DesignElementHandle)datasetA));
        datasetA.getElement().setName("name/");
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidElementName((DesignElementHandle)datasetA));
        datasetA.getElement().setName("name\\");
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidElementName((DesignElementHandle)datasetA));
        datasetA.getElement().setName("name.");
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidElementName((DesignElementHandle)datasetA));
        datasetA.getElement().setName("name!");
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidElementName((DesignElementHandle)datasetA));
        datasetA.getElement().setName("name;");
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidElementName((DesignElementHandle)datasetA));
        datasetA.getElement().setName("name,");
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidElementName((DesignElementHandle)datasetA));
        datasetA.getElement().setName("");
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidElementName((DesignElementHandle)datasetA));
        datasetA.getElement().setName(null);
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isValidElementName((DesignElementHandle)datasetA));
        LabelHandle label = this.designHandle.getElementFactory().newLabel("style");
        label.getElement().setName("");
        ModuleUtilTest.assertTrue((boolean)ModuleUtil.isValidElementName((DesignElementHandle)label));
        label.getElement().setName(null);
        ModuleUtilTest.assertTrue((boolean)ModuleUtil.isValidElementName((DesignElementHandle)label));
    }

    public void testTransferParamTypeAndColumnType() {
        ModuleUtilTest.assertEquals((String)"string", (String)ModuleUtil.convertParamTypeToColumnType((String)"string"));
        ModuleUtilTest.assertEquals((String)"date-time", (String)ModuleUtil.convertParamTypeToColumnType((String)"dateTime"));
        ModuleUtilTest.assertEquals((String)"string", (String)ModuleUtil.convertColumnTypeToParamType((String)"string"));
        ModuleUtilTest.assertEquals((String)"dateTime", (String)ModuleUtil.convertColumnTypeToParamType((String)"date-time"));
        ModuleUtilTest.assertEquals((String)"any", (String)ModuleUtil.convertColumnTypeToParamType((String)"blob"));
    }

    public void testIsListStyleRuleValue() throws Exception {
        this.createDesign();
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("table");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        PropertyHandle propHandle = style.getPropertyHandle("highlightRules");
        HighlightRule rule = StructureFactory.createHighlightRule();
        rule.setOperator("in");
        propHandle.addItem((IStructure)rule);
        HighlightRule rule2 = StructureFactory.createHighlightRule();
        rule2.setOperator("eq");
        propHandle.addItem((IStructure)rule2);
        HighlightRuleHandle handle = (HighlightRuleHandle)propHandle.get(0);
        ModuleUtilTest.assertTrue((boolean)ModuleUtil.isListStyleRuleValue((StyleRuleHandle)handle));
        HighlightRuleHandle handle2 = (HighlightRuleHandle)propHandle.get(1);
        ModuleUtilTest.assertFalse((boolean)ModuleUtil.isListStyleRuleValue((StyleRuleHandle)handle2));
    }

    public void testScriptuid() throws Exception {
        this.openDesign("ModuleUtilTest.xml");
        LabelHandle label1 = (LabelHandle)this.designHandle.getElementByID(62L);
        PropertyHandle propHandle = label1.getPropertyHandle("onPrepare");
        String path = ModuleUtil.getScriptUID((Object)propHandle);
        ModuleUtilTest.assertEquals((String)"/report/body/label[@id=\"62\"]/method[@name=\"onPrepare\"]", (String)path);
        String value = ModuleUtil.getScript((ModuleHandle)this.designHandle, (String)"/report/body/label[@id=\"62\"]/method[@name=\"onPrepare\"]");
        ModuleUtilTest.assertEquals((String)"\"prepare\"", (String)value);
    }

    public void testGetElementsByType() throws Exception {
        this.openDesign("ModuleUtilTest_1.xml");
        ModuleUtilTest.assertTrue((boolean)ModuleUtil.getElementsByType((ModuleHandle)this.designHandle, (String)"Image").isEmpty());
        List elements = ModuleUtil.getElementsByType((ModuleHandle)this.designHandle, (String)"Label");
        ModuleUtilTest.assertEquals((int)2, (int)elements.size());
        ModuleUtilTest.assertTrue((boolean)(elements.get(0) instanceof LabelHandle));
        ModuleUtilTest.assertTrue((boolean)(elements.get(1) instanceof LabelHandle));
        ModuleUtilTest.assertEquals((int)1, (int)ModuleUtil.getElementsByType((ModuleHandle)this.designHandle, (String)"Text").size());
        ModuleUtilTest.assertEquals((int)2, (int)ModuleUtil.getElementsByType((ModuleHandle)this.designHandle, (String)"Table").size());
        ModuleUtilTest.assertEquals((int)3, (int)ModuleUtil.getElementsByType((ModuleHandle)this.designHandle, (String)"Listing").size());
    }
}

