/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class BoundDataColumnsUtilTest
extends BaseTestCase {
    public void testUniqueColumnNameWithList() throws Exception {
        this.openDesign("BoundDataColumnsUtilTest_1.xml");
        ListHandle list = (ListHandle)this.designHandle.findElement("MyList1");
        Iterator boundColumns = list.columnBindingsIterator();
        ComputedColumnHandle column = (ComputedColumnHandle)boundColumns.next();
        try {
            column.setName("COLUMN_2");
            BoundDataColumnsUtilTest.fail();
        }
        catch (SemanticException e) {
            BoundDataColumnsUtilTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        column.setName("COLUMN_4");
        this.designHandle.getCommandStack().undo();
        DataItemHandle data2 = (DataItemHandle)this.designHandle.findElement("InnerData2");
        boundColumns = data2.columnBindingsIterator();
        column = (ComputedColumnHandle)boundColumns.next();
        column.setName("COLUMN_5");
    }

    public void testAddColumnBinding() throws SemanticException, DesignFileException {
        this.openDesign("ReportItemHandleTest_1.xml");
        TableHandle tableHandle = (TableHandle)this.designHandle.getElementByID(7L);
        ComputedColumn column = StructureFactory.createComputedColumn();
        column.setName("CITY");
        column.setExpression("row[\"CITY\"]");
        try {
            tableHandle.addColumnBinding(column, false);
            BoundDataColumnsUtilTest.fail();
        }
        catch (SemanticException e) {
            BoundDataColumnsUtilTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        column = StructureFactory.createComputedColumn();
        column.setName("NEWCITY");
        column.setExpression("row[\"NEWCITY\"]");
        tableHandle.addColumnBinding(column, false);
        DataItemHandle withBindingItem = (DataItemHandle)this.designHandle.getElementByID(24L);
        column = StructureFactory.createComputedColumn();
        column.setName("NewADDRESSLINE1");
        column.setExpression("row[\"NewADDRESSLINE1\"]");
        try {
            withBindingItem.addColumnBinding(column, false);
            BoundDataColumnsUtilTest.fail();
        }
        catch (SemanticException e) {
            BoundDataColumnsUtilTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        column = StructureFactory.createComputedColumn();
        column.setName("CITY");
        column.setExpression("row[\"CITY\"]");
        withBindingItem.addColumnBinding(column, false);
    }

    public void testUniqueColumnNameWithTable() throws Exception {
        this.openDesign("BoundDataColumnsUtilTest.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("MyTable1");
        Iterator boundColumns = table.columnBindingsIterator();
        ComputedColumnHandle column = (ComputedColumnHandle)boundColumns.next();
        try {
            column.setName("COLUMN_2");
            BoundDataColumnsUtilTest.fail();
        }
        catch (SemanticException e) {
            BoundDataColumnsUtilTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        column.setName("COLUMN_4");
        this.designHandle.getCommandStack().undo();
        DataItemHandle data3 = (DataItemHandle)this.designHandle.findElement("InnerData3");
        boundColumns = data3.columnBindingsIterator();
        column = (ComputedColumnHandle)boundColumns.next();
        column.setName("COLUMN_1");
    }

    public void testRemoveUnusedColumns() throws Exception {
        this.openDesign("BoundDataColumnsUtilTest_2.xml");
        ListHandle myList = (ListHandle)this.designHandle.findElement("MyList1");
        myList.removedUnusedColumnBindings();
        DataItemHandle data = (DataItemHandle)this.designHandle.findElement("InnerData3");
        data.removedUnusedColumnBindings();
        myList = (ListHandle)this.designHandle.findElement("MyList2");
        myList.removedUnusedColumnBindings();
        TableHandle myTable = (TableHandle)this.designHandle.findElement("MyTable1");
        myTable.removedUnusedColumnBindings();
        ScalarParameterHandle param1 = (ScalarParameterHandle)this.designHandle.findParameter("MyParam1");
        param1.removedUnusedColumnBindings();
        myTable = (TableHandle)this.designHandle.findElement("MyTable2");
        myTable.removedUnusedColumnBindings();
        myTable = (TableHandle)this.designHandle.findElement("MyTable3");
        myTable.removedUnusedColumnBindings();
        this.save();
        BoundDataColumnsUtilTest.assertTrue((boolean)this.compareFile("BoundDataColumnsUtilTest_golden_2.xml"));
    }
}

