/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatementTest {
    private static final String SELECT_SQL = "select * from \"test_oda_jdbc\"";
    private static final String SELECT_SQL_W_PARAMS = "select * from \"test_oda_jdbc\" WHERE   col0 = ?      AND col1 = ?      AND col2 = ?      AND col3 = ?      AND col4 = ?      AND col5 = ?      AND col6 = ? ";
    private Connection conn = null;
    private Statement stmt = null;
    private java.sql.Connection jdbcConn = null;
    private java.sql.Statement jdbcStmt = null;
    private PreparedStatement jdbcPrepStmt = null;

    @Before
    public void statementSetUp() throws Exception {
        TestUtil.createTestData();
        this.conn = TestUtil.openConnection();
        this.stmt = (Statement)this.conn.newQuery("");
        this.jdbcConn = TestUtil.openJDBCConnection();
        this.jdbcStmt = this.jdbcConn.createStatement();
        this.jdbcPrepStmt = this.jdbcConn.prepareStatement(SELECT_SQL);
    }

    @After
    public void statementTearDown() throws Exception {
        this.stmt.close();
        this.conn.close();
        this.jdbcStmt.close();
        this.jdbcPrepStmt.close();
        this.jdbcConn.close();
        TestUtil.deleteTestData();
    }

    @Test
    public void testPrepare() throws Exception {
        this.stmt.prepare(SELECT_SQL);
        Assert.assertTrue((boolean)this.stmt.execute());
    }

    @Test
    public void testClose() {
        try {
            this.stmt.close();
            this.stmt.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Should not throw exception. Exception message: " + e.getLocalizedMessage()));
        }
        try {
            this.stmt.prepare(SELECT_SQL);
            this.stmt.executeQuery();
            this.stmt.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Should not throw exception. Exception message: " + e.getLocalizedMessage()));
        }
        try {
            this.stmt.getMetaData();
            Assert.fail((String)"Statement already closed. Should throw exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSetGetMaxRows() throws Exception {
        Assert.assertEquals((long)this.stmt.getMaxRows(), (long)-1L);
        this.stmt.setMaxRows(1);
        this.stmt.prepare(SELECT_SQL);
        ResultSet rs = (ResultSet)this.stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((long)this.stmt.getMaxRows(), (long)1L);
    }

    @Test
    public void testGetMetaData() throws Exception {
        try {
            this.stmt.getMetaData();
            Assert.fail((String)"Should throw DriverException");
        }
        catch (OdaException e) {
            Assert.assertTrue((boolean)(e instanceof JDBCException));
        }
        this.stmt.prepare(SELECT_SQL);
        Assert.assertNotNull((Object)this.stmt.getMetaData());
    }

    @Test
    public void testExecuteQuery() throws Exception {
        this.stmt.prepare(SELECT_SQL);
        Assert.assertNotNull((Object)this.stmt.executeQuery());
    }

    @Test
    public void testSetIntintint() throws Exception {
        this.stmt.prepare("select * from \"test_oda_jdbc\" where col3 = ?");
        this.stmt.setInt(1, 0);
        ResultSet rs = (ResultSet)this.stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testSetDoubleintdouble() throws Exception {
        this.stmt.prepare("select * from \"test_oda_jdbc\" where col2 = ?");
        this.stmt.setDouble(1, 0.0);
        ResultSet rs = (ResultSet)this.stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testSetBigDecimalintBigDecimal() throws Exception {
        this.stmt.prepare("select * from \"test_oda_jdbc\" where col0 = ?");
        this.stmt.setBigDecimal(1, new BigDecimal("1111"));
        ResultSet rs = (ResultSet)this.stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testSetStringintString() throws Exception {
        this.stmt.prepare("select * from \"test_oda_jdbc\" where col4 = ?");
        this.stmt.setString(1, "00");
        ResultSet rs = (ResultSet)this.stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testSetDateintDate() throws Exception {
        this.stmt.prepare("select * from \"test_oda_jdbc\" where col1 = ?");
        this.stmt.setDate(1, Date.valueOf("2000-01-01"));
        ResultSet rs = (ResultSet)this.stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testSetTimeintTime() throws Exception {
        this.stmt.prepare("select * from \"test_oda_jdbc\" where col5 = ?");
        this.stmt.setTime(1, Time.valueOf("12:00:01"));
        ResultSet rs = (ResultSet)this.stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testSetTimestampintTimestamp() throws Exception {
        this.stmt.prepare("select * from \"test_oda_jdbc\" where col6 = ?");
        this.stmt.setTimestamp(1, Timestamp.valueOf("2000-01-01 12:00:00.0000"));
        ResultSet rs = (ResultSet)this.stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testGetParameterMetaData() throws Exception {
        this.stmt.prepare(SELECT_SQL_W_PARAMS);
        this.jdbcPrepStmt = this.jdbcConn.prepareStatement(SELECT_SQL_W_PARAMS);
        IParameterMetaData md = this.stmt.getParameterMetaData();
        Assert.assertNotNull((Object)md);
        int i = 1;
        while (i <= 7) {
            Assert.assertEquals((long)md.getParameterType(i), (long)this.jdbcPrepStmt.getParameterMetaData().getParameterType(i));
            ++i;
        }
    }

    @Test
    public void testClearInParameters() throws Exception {
        this.stmt.prepare("select * from \"test_oda_jdbc\" where col6 = ?");
        this.stmt.setTimestamp(1, Timestamp.valueOf("2000-01-01 12:00:00.0000"));
        ResultSet rs = (ResultSet)this.stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        this.stmt.clearInParameters();
        try {
            rs = (ResultSet)this.stmt.executeQuery();
            Assert.fail();
        }
        catch (JDBCException jDBCException) {
            // empty catch block
        }
    }
}

