/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.util.HashMap;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.junit.Assert;
import org.junit.Test;

public class OdaJdbcDriverTest {
    @Test
    public void testGetConnection() throws Exception {
        OdaJdbcDriver connFact = new OdaJdbcDriver();
        Connection conn = (Connection)connFact.getConnection("");
        Assert.assertNotNull((Object)conn);
    }

    @Test
    public void testSetAppContext() throws Exception {
        OdaJdbcDriver connFact = new OdaJdbcDriver();
        IConnection odaConnection = connFact.getConnection("");
        Assert.assertFalse((boolean)odaConnection.isOpen());
        try {
            odaConnection.open(null);
            Assert.fail((String)"The connction should not have been opened!");
        }
        catch (IllegalArgumentException e) {
            odaConnection.close();
        }
        Properties props = new Properties();
        props.setProperty("odaURL", TestUtil.getURL());
        props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
        props.setProperty("odaUser", TestUtil.getUser());
        props.setProperty("odaPassword", "");
        try {
            odaConnection.open(props);
            Assert.assertTrue((boolean)odaConnection.isOpen());
        }
        catch (IllegalArgumentException e) {
            odaConnection.close();
        }
        HashMap<String, java.sql.Connection> context = new HashMap<String, java.sql.Connection>();
        java.sql.Connection passInConn = TestUtil.openJDBCConnection();
        context.put("OdaJDBCDriverPassInConnection", passInConn);
        IConnection connection = connFact.getConnection("");
        connection.setAppContext(context);
        try {
            connection.open(null);
            Assert.assertTrue((boolean)connection.isOpen());
        }
        catch (OdaException e) {
            Assert.fail((String)"Exception occurrs when opening a connection!");
        }
    }
}

