/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.DataSourceMetaData;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConnectionTest {
    @Before
    public void connectionSetUp() throws Exception {
        TestUtil.createTestData();
    }

    @After
    public void connectionTearDown() throws Exception {
        TestUtil.deleteTestData();
    }

    @Test
    public void testConnection() throws Exception {
        Connection conn = new Connection();
        Assert.assertFalse((boolean)conn.isOpen());
    }

    @Test
    public void testClose() throws Exception {
        Connection conn = TestUtil.openConnection();
        conn.close();
        Assert.assertFalse((boolean)conn.isOpen());
        try {
            conn.close();
            Connection tempConn = new Connection();
            tempConn.close();
        }
        catch (OdaException e) {
            Assert.fail((String)"Close the closed operation should do nothing, no exception should be thrown.");
        }
    }

    @Test
    public void testCommit() throws Exception {
        Connection conn = TestUtil.openConnection();
        Statement stmt = (Statement)conn.newQuery("");
        String sql = "update \"test_oda_jdbc\" set col0 = 7777 where col3=1";
        stmt.prepare(sql);
        stmt.execute();
        conn.commit();
        stmt.close();
        sql = "select col0 from \"test_oda_jdbc\" where col3 = 1";
        stmt.prepare(sql);
        ResultSet rs = (ResultSet)stmt.executeQuery();
        rs.next();
        Assert.assertEquals((double)rs.getDouble(1), (double)7777.0, (double)Double.MIN_VALUE);
        rs.close();
        stmt.close();
        sql = "update \"test_oda_jdbc\" set col0 = 1111 where col3=1";
        stmt.prepare(sql);
        stmt.execute();
        conn.commit();
        sql = "select col0 from \"test_oda_jdbc\" where col3 = 1";
        stmt.prepare(sql);
        rs = (ResultSet)stmt.executeQuery();
        rs.next();
        Assert.assertEquals((double)rs.getDouble(1), (double)1111.0, (double)Double.MIN_VALUE);
        conn.close();
    }

    @Test
    public void testCreateStatement() throws Exception {
        Connection conn = TestUtil.openConnection();
        Assert.assertNotNull((Object)conn.newQuery(""));
        conn.close();
        try {
            Assert.assertNotNull((Object)conn.newQuery(""));
            Assert.fail();
        }
        catch (JDBCException jDBCException) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGetMetaDataString() throws Exception {
        Connection conn = TestUtil.openConnection();
        Assert.assertNotNull((Object)conn.getMetaData(""));
        Assert.assertTrue((boolean)(conn.getMetaData("") instanceof DataSourceMetaData));
        conn.close();
    }

    @Test
    public void testIsOpen() throws Exception {
        Connection conn = TestUtil.openConnection();
        Assert.assertTrue((boolean)conn.isOpen());
        conn.close();
        Assert.assertFalse((boolean)conn.isOpen());
    }

    @Test
    public void testJndiConnection() throws Exception {
        Connection conn = TestUtil.openJndiConnection();
        Assert.assertTrue((boolean)conn.isOpen());
        conn.close();
        Assert.assertFalse((boolean)conn.isOpen());
    }

    @Test
    public void testOpen() throws Exception {
        block6: {
            Connection conn = new Connection();
            Properties props = new Properties();
            props.setProperty("odaURL", TestUtil.getURL());
            props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
            props.setProperty("odaUser", TestUtil.getUser());
            props.setProperty("odaPassword", TestUtil.getPassword());
            conn.open(props);
            Assert.assertTrue((boolean)conn.isOpen());
            conn.close();
            try {
                conn = new Connection();
                props = new Properties();
                props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
                props.setProperty("odaUser", TestUtil.getUser());
                props.setProperty("odaPassword", TestUtil.getPassword());
                conn.open(props);
                Assert.fail((String)"Open Connection with null URL info should throw exception");
            }
            catch (OdaException odaException) {
                // empty catch block
            }
            try {
                conn = new Connection();
                props = new Properties();
                props.setProperty("odaURL", TestUtil.getURL() + ";user=" + TestUtil.getUser() + ";password=" + TestUtil.getPassword());
                props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
                props.setProperty("odaPassword", TestUtil.getPassword());
                conn.open(props);
                conn.close();
            }
            catch (OdaException e) {
                Assert.fail((String)"Open Connection should succeed");
            }
            try {
                conn = new Connection();
                props = new Properties();
                props.setProperty("odaURL", "wrong url");
                props.setProperty("odaDriverClass", TestUtil.getDriverClassName());
                props.setProperty("odaUser", TestUtil.getUser());
                conn.open(props);
                Assert.fail((String)"Open Connection with wrong property should throw exception");
            }
            catch (Throwable e1) {
                if (e1 instanceof OdaException || e1 instanceof NoClassDefFoundError) break block6;
                throw new OdaException(e1);
            }
        }
    }

    @Test
    public void testRollback() throws Exception {
        Connection conn = TestUtil.openConnection();
        try {
            conn.rollback();
        }
        catch (Exception e) {
            Assert.fail((String)"Exception occurred when calling rollback()");
        }
        conn.close();
    }
}

