/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCEntry;

public abstract class TOCTestCase
extends EngineCase {
    protected void createEntry(TOCBuilder builder, TOCEntry parent, String name, String hiddenFormats) {
        TOCEntry entry = this.startEntry(builder, parent, name, hiddenFormats);
        this.closeEntry(builder, entry);
    }

    protected void createEntry(TOCBuilder builder, TOCEntry parent, String name) {
        TOCEntry entry = this.startEntry(builder, parent, name);
        this.closeEntry(builder, entry);
    }

    protected TOCEntry startEntry(TOCBuilder builder, TOCEntry parent, String name) {
        return builder.startEntry(parent, (Object)name, null, -1L);
    }

    protected TOCEntry startEntry(TOCBuilder builder, TOCEntry parent, String name, String hiddenFormats) {
        return builder.startEntry(parent, (Object)name, null, hiddenFormats, -1L);
    }

    protected void closeEntry(TOCBuilder builder, TOCEntry entry) {
        builder.closeEntry(entry);
    }

    protected TOCEntry startGroupEntry(TOCBuilder builder, TOCEntry parent, String name) {
        return builder.startGroupEntry(parent, (Object)name, null, null, -1L);
    }

    protected TOCEntry startGroupEntry(TOCBuilder builder, TOCEntry parent, String name, String hiddenFormats) {
        return builder.startGroupEntry(parent, (Object)name, null, hiddenFormats, -1L);
    }

    protected void closeGroupEntry(TOCBuilder builder, TOCEntry entry) {
        builder.closeEntry(entry);
    }

    protected TOCEntry startDummyEntry(TOCBuilder builder, TOCEntry parent, String hiddenFormats) {
        return builder.startDummyEntry(parent, hiddenFormats);
    }

    protected ITreeNode createTree() {
        TOCBuilder builder = new TOCBuilder();
        TOCEntry reportHeader = this.startEntry(builder, null, "report-header");
        this.closeEntry(builder, reportHeader);
        TOCEntry list = this.startEntry(builder, null, "list");
        TOCEntry listHeader = this.startEntry(builder, list, "list-header");
        this.closeEntry(builder, listHeader);
        TOCEntry group = this.startGroupEntry(builder, list, "group");
        TOCEntry group21Header = this.startEntry(builder, group, "list-group-header");
        this.closeEntry(builder, group21Header);
        TOCEntry detail = this.startEntry(builder, group, "detail");
        this.closeEntry(builder, detail);
        TOCEntry group21Footer = this.startEntry(builder, group, "group-footer");
        this.closeEntry(builder, group21Footer);
        this.closeGroupEntry(builder, group);
        TOCEntry listFooter = this.startEntry(builder, list, "list-footer");
        this.closeEntry(builder, listFooter);
        this.closeEntry(builder, list);
        TOCEntry footer = this.startEntry(builder, null, "footer");
        this.closeEntry(builder, footer);
        return builder.getTOCTree();
    }

    String toString(ITreeNode node) {
        StringBuffer buffer = new StringBuffer();
        this.outputTreeNode(buffer, node, 0);
        return buffer.toString();
    }

    void outputTreeNode(StringBuffer buffer, ITreeNode node, int level) {
        Collection children;
        String nodeId = node.getNodeId();
        String bookmark = node.getBookmark();
        long elementId = node.getElementId();
        String hiddenFormats = node.getHiddenFormats();
        Object tocValue = node.getTOCValue();
        boolean isGroup = node.isGroup();
        this.indent(buffer, level);
        buffer.append("<");
        buffer.append(isGroup ? "group" : "entry");
        buffer.append(" nodeId=\"");
        buffer.append(nodeId);
        buffer.append("\"");
        if (tocValue != null) {
            buffer.append(" tocValue=\"");
            buffer.append(tocValue);
            buffer.append("\"");
        }
        if (bookmark != null && !nodeId.equals(bookmark)) {
            buffer.append(" bookmark=\"");
            buffer.append(bookmark);
            buffer.append("\"");
        }
        if (elementId != -1L) {
            buffer.append(" elementId=\"");
            buffer.append(elementId);
            buffer.append("\"");
        }
        if (hiddenFormats != null) {
            buffer.append(" hiddenFormats=\"");
            buffer.append(hiddenFormats);
            buffer.append("\"");
        }
        if (!(children = node.getChildren()).isEmpty()) {
            buffer.append(">");
            buffer.append("\r\n");
            for (ITreeNode child : children) {
                this.outputTreeNode(buffer, child, level + 1);
            }
            this.indent(buffer, level);
            buffer.append("</");
            buffer.append(isGroup ? "group" : "entry");
            buffer.append(">");
        } else {
            buffer.append("/>");
        }
        buffer.append("\r\n");
    }

    String toString(TOCNode node) {
        StringBuffer buffer = new StringBuffer();
        this.outputTOCNode(buffer, node, 0, false);
        return buffer.toString();
    }

    String toStringWithStyle(TOCNode node) {
        StringBuffer buffer = new StringBuffer();
        this.outputTOCNode(buffer, node, 0, true);
        return buffer.toString();
    }

    void outputTOCNode(StringBuffer buffer, TOCNode node, int level, boolean withStyle) {
        List children;
        String nodeId = node.getNodeID();
        String displayText = node.getDisplayString();
        String bookmark = node.getBookmark();
        IScriptStyle style = node.getTOCStyle();
        this.indent(buffer, level);
        buffer.append("<toc");
        buffer.append(" nodeId=\"");
        buffer.append(nodeId);
        buffer.append("\"");
        if (displayText != null) {
            buffer.append(" displayText=\"");
            buffer.append(displayText);
            buffer.append("\"");
        }
        if (bookmark != null && !nodeId.equals(bookmark)) {
            buffer.append(" bookmark=\"");
            buffer.append(bookmark);
            buffer.append("\"");
        }
        if (withStyle && style != null) {
            buffer.append(" style=\"");
            buffer.append(style.toString());
            buffer.append("\"");
        }
        if (!(children = node.getChildren()).isEmpty()) {
            buffer.append(">");
            buffer.append("\r\n");
            int i = 0;
            while (i < children.size()) {
                TOCNode child = (TOCNode)children.get(i);
                this.outputTOCNode(buffer, child, level + 1, withStyle);
                ++i;
            }
            this.indent(buffer, level);
            buffer.append("</toc>");
        } else {
            buffer.append("/>");
        }
        buffer.append("\r\n");
    }

    private void indent(StringBuffer buffer, int level) {
        int i = 0;
        while (i < level) {
            buffer.append("    ");
            ++i;
        }
    }
}

