/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.parser.ReportParser;

public class ReportQueryBuilderTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testQueryBuilder() throws Exception {
        String SAMPLE_DESIGN = "report.xml";
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(SAMPLE_DESIGN);
        ReportQueryBuilderTest.assertTrue((in != null ? 1 : 0) != 0);
        ReportParser parser = new ReportParser();
        Report report = parser.parse("", in);
        ReportQueryBuilderTest.assertTrue((report != null ? 1 : 0) != 0);
        this.getQueryBuilder(report).build();
        this.testGrid(report, report.getContent(2));
        this.testList(report, report.getContent(1));
        this.testTable(report, report.getContent(0));
    }

    private ReportQueryBuilder getQueryBuilder(Report report) throws BirtException {
        DataSessionContext context = new DataSessionContext(3);
        DataRequestSession dteSession = DataRequestSession.newSession((DataSessionContext)context);
        ReportQueryBuilder reportQueryBuilder = new ReportQueryBuilder(report, new ExecutionContext(), dteSession);
        return reportQueryBuilder;
    }

    private void testGrid(Report report, ReportItemDesign item) {
        ReportQueryBuilderTest.assertTrue((boolean)(item.getQuery() instanceof QueryDefinition));
        ReportQueryBuilderTest.assertTrue((boolean)report.getQueries().contains(item.getQuery()));
        ReportQueryBuilderTest.assertEquals((int)1, (int)((QueryDefinition)item.getQuery()).getBindings().size());
    }

    private void testList(Report report, ReportItemDesign item) {
        ListItemDesign list = (ListItemDesign)item;
        ReportQueryBuilderTest.assertTrue((boolean)(item.getQuery() instanceof QueryDefinition));
        ReportQueryBuilderTest.assertTrue((boolean)report.getQueries().contains(item.getQuery()));
        ReportQueryBuilderTest.assertEquals((int)1, (int)((QueryDefinition)item.getQuery()).getBindings().size());
        ReportQueryBuilderTest.assertEquals((int)1, (int)((QueryDefinition)item.getQuery()).getGroups().size());
        ReportQueryBuilderTest.assertTrue((boolean)((QueryDefinition)item.getQuery()).usesDetails());
        ReportQueryBuilderTest.assertEquals((int)1, (int)((QueryDefinition)item.getQuery()).getSubqueries().size());
        ListBandDesign listHeader = (ListBandDesign)list.getHeader();
        TableItemDesign table = (TableItemDesign)listHeader.getContent(0);
        ReportQueryBuilderTest.assertTrue((boolean)(table.getQuery() instanceof QueryDefinition));
        ReportQueryBuilderTest.assertTrue((boolean)report.getQueries().contains(table.getQuery()));
        table = (TableItemDesign)listHeader.getContent(1);
        ReportQueryBuilderTest.assertTrue((boolean)(table.getQuery() instanceof SubqueryDefinition));
        ReportQueryBuilderTest.assertTrue((boolean)((QueryDefinition)list.getQuery()).getSubqueries().contains(table.getQuery()));
        GroupDesign group = list.getGroup(0);
        ReportQueryBuilderTest.assertEquals((int)1, (int)((QueryDefinition)list.getQuery()).getGroups().size());
        GroupDefinition grp = (GroupDefinition)((QueryDefinition)list.getQuery()).getGroups().get(0);
        ListBandDesign groupHeader = (ListBandDesign)group.getHeader();
        table = (TableItemDesign)groupHeader.getContent(0);
        ReportQueryBuilderTest.assertTrue((boolean)(table.getQuery() instanceof QueryDefinition));
        ReportQueryBuilderTest.assertTrue((boolean)report.getQueries().contains(table.getQuery()));
        table = (TableItemDesign)groupHeader.getContent(1);
        ReportQueryBuilderTest.assertTrue((boolean)(table.getQuery() instanceof SubqueryDefinition));
        ReportQueryBuilderTest.assertTrue((boolean)grp.getSubqueries().contains(table.getQuery()));
        ListBandDesign groupFooter = (ListBandDesign)group.getFooter();
        table = (TableItemDesign)groupFooter.getContent(0);
        ReportQueryBuilderTest.assertTrue((boolean)(table.getQuery() instanceof QueryDefinition));
        ReportQueryBuilderTest.assertTrue((boolean)report.getQueries().contains(table.getQuery()));
        table = (TableItemDesign)group.getFooter().getContent(1);
        ReportQueryBuilderTest.assertTrue((boolean)(table.getQuery() instanceof SubqueryDefinition));
        ReportQueryBuilderTest.assertTrue((boolean)grp.getSubqueries().contains(table.getQuery()));
        ListBandDesign listDetail = (ListBandDesign)list.getDetail();
        ReportQueryBuilderTest.assertTrue((boolean)report.getQueries().contains(listDetail.getContent(0).getQuery()));
        ReportQueryBuilderTest.assertTrue((boolean)(listDetail.getContent(0).getQuery() instanceof QueryDefinition));
    }

    private void testTable(Report report, ReportItemDesign item) {
        ReportQueryBuilderTest.assertTrue((boolean)(item.getQuery() instanceof QueryDefinition));
        IQueryDefinition query = (IQueryDefinition)item.getQuery();
        ReportQueryBuilderTest.assertTrue((query.getSorts().size() == 2 ? 1 : 0) != 0);
        ReportQueryBuilderTest.assertTrue((query.getFilters().size() == 1 ? 1 : 0) != 0);
        ReportQueryBuilderTest.assertTrue((query.getBindings().size() == 14 ? 1 : 0) != 0);
        GroupDefinition grp = (GroupDefinition)((QueryDefinition)item.getQuery()).getGroups().get(0);
        ReportQueryBuilderTest.assertTrue((grp.getSorts().size() == 2 ? 1 : 0) != 0);
        ReportQueryBuilderTest.assertTrue((grp.getFilters().size() == 1 ? 1 : 0) != 0);
    }
}

