/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.List;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;

public class ReportDocumentReaderTest
extends EngineCase {
    static final String DOCUMENT_V0 = "org/eclipse/birt/report/engine/api/impl/reportdocument_v0.rptdocument";
    static final String DOCUMENT_V1 = "org/eclipse/birt/report/engine/api/impl/reportdocument_v1.rptdocument";

    public void setUp() throws Exception {
        super.setUp();
        this.removeFile("reportdocument");
    }

    public void tearDown() throws Exception {
        this.removeFile("reportdocument");
        super.tearDown();
    }

    public void testVersion0() throws Exception {
        this.copyResource(DOCUMENT_V0, "reportdocument");
        try (ReportDocumentReader docReader = null;){
            IReportDocument document = this.engine.openReportDocument("reportdocument");
            if (document instanceof ReportDocumentReader) {
                docReader = (ReportDocumentReader)document;
                List list = docReader.getBookmarks();
                ReportDocumentReaderTest.assertTrue((list.size() > 0 ? 1 : 0) != 0);
                list = docReader.getBookmarkContents();
                ReportDocumentReaderTest.assertTrue((list.size() == 0 ? 1 : 0) != 0);
            }
        }
    }

    public void testVersion1() throws Exception {
        this.copyResource(DOCUMENT_V1, "reportdocument");
        try (ReportDocumentReader docReader = null;){
            IReportDocument document = this.engine.openReportDocument("reportdocument");
            if (document instanceof ReportDocumentReader) {
                docReader = (ReportDocumentReader)document;
                List list = docReader.getBookmarks();
                ReportDocumentReaderTest.assertTrue((list.size() > 0 ? 1 : 0) != 0);
                list = docReader.getBookmarkContents();
                ReportDocumentReaderTest.assertTrue((list.size() > 0 ? 1 : 0) != 0);
            }
        }
    }
}

