/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.script.scale;

import java.util.Date;
import org.eclipse.birt.chart.model.attribute.ScaleUnitType;
import org.eclipse.birt.chart.script.api.scale.IScale;
import org.eclipse.birt.chart.script.api.scale.ITimeScale;
import org.eclipse.birt.chart.tests.script.BaseChartTestCase;

public class TimeScaleTest
extends BaseChartTestCase {
    protected IScale getValueAxisScale() {
        return this.getChartWithAxes().getValueAxes()[0].getScale();
    }

    public void testStepSize() {
        IScale scale = this.getValueAxisScale();
        TimeScaleTest.assertTrue((boolean)(scale instanceof ITimeScale));
        ITimeScale ls = (ITimeScale)scale;
        TimeScaleTest.assertEquals((int)ls.getStepSize(), (int)2);
        ls.setStepSize(3);
        TimeScaleTest.assertEquals((int)ls.getStepSize(), (int)3);
    }

    public void testStepTimeUnit() {
        IScale scale = this.getValueAxisScale();
        TimeScaleTest.assertTrue((boolean)(scale instanceof ITimeScale));
        ITimeScale ls = (ITimeScale)scale;
        TimeScaleTest.assertEquals((String)ls.getStepTimeUnit(), (String)ScaleUnitType.WEEKS_LITERAL.getName());
        ls.setStepTimeUnit(ScaleUnitType.MONTHS_LITERAL.getName());
        TimeScaleTest.assertEquals((String)ls.getStepTimeUnit(), (String)ScaleUnitType.MONTHS_LITERAL.getName());
    }

    public void testMin() {
        IScale scale = this.getValueAxisScale();
        TimeScaleTest.assertTrue((boolean)(scale instanceof ITimeScale));
        ITimeScale ls = (ITimeScale)scale;
        TimeScaleTest.assertEquals((long)1037635200984L, (long)ls.getMin().getTime());
        ls.setMin(null);
        TimeScaleTest.assertNull((Object)ls.getMin());
    }

    public void testMax() {
        IScale scale = this.getValueAxisScale();
        TimeScaleTest.assertTrue((boolean)(scale instanceof ITimeScale));
        ITimeScale ls = (ITimeScale)scale;
        TimeScaleTest.assertNull((Object)ls.getMax());
        Date date = new Date();
        ls.setMax(date);
        TimeScaleTest.assertEquals((Object)ls.getMax(), (Object)date);
    }
}

