/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.tests.engine.BaseEmitter;

public class IDataContentTest
extends BaseEmitter {
    private IReportContent reportContent = new ReportContent();
    private IDataContent data;
    private String reportName = "IDataContentTest.rptdesign";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.reportName, this.reportName);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource();
    }

    @Override
    protected String getReportName() {
        return this.reportName;
    }

    public void testValue() {
        this.data = this.reportContent.createDataContent();
        IDataContentTest.assertNull((Object)this.data.getValue());
        Object value = new Object();
        this.data.setValue(value);
        IDataContentTest.assertEquals((Object)value, (Object)this.data.getValue());
    }

    public void testLabelKey() {
        this.data = this.reportContent.createDataContent();
        IDataContentTest.assertNull((Object)this.data.getLabelKey());
        this.data.setLabelKey("key");
        IDataContentTest.assertEquals((String)"key", (String)this.data.getLabelKey());
    }

    public void testLabelText() {
        this.data = this.reportContent.createDataContent();
        IDataContentTest.assertNull((Object)this.data.getLabelText());
        this.data.setLabelText("data");
        IDataContentTest.assertEquals((String)"data", (String)this.data.getLabelText());
    }

    public void testIDataContentFromReport() throws EngineException {
        this.runandrender_emitter("html", false);
    }

    @Override
    public void startData(IDataContent data) {
        IDataContentTest.assertEquals((String)"data help", (String)data.getHelpText());
        IDataContentTest.assertEquals((String)"data help key", (String)data.getHelpKey());
        IDataContentTest.assertEquals((String)"my data", (String)data.getValue().toString());
    }
}

