/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.tests.engine.BaseEmitter;

public class IActionTest
extends BaseEmitter {
    static final String INPUT = "IActionTest.rptdesign";
    private String reportName = "IActionTest.rptdesign";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource();
    }

    @Override
    protected String getReportName() {
        return this.reportName;
    }

    public void testActionFromReport() throws EngineException {
        this.runandrender_emitter("html", false);
    }

    public void testBookmarkAction() {
        ActionContent hyperAction = new ActionContent();
        hyperAction.setBookmark("bk");
        Action action = new Action((IHyperlinkAction)hyperAction);
        IActionTest.assertEquals((String)"bk", (String)action.getBookmark());
        IActionTest.assertEquals((String)"bk", (String)action.getActionString());
        IActionTest.assertEquals((int)2, (int)action.getType());
        IActionTest.assertFalse((boolean)action.isBookmark());
        IActionTest.assertNull((Object)action.getFormat());
        IActionTest.assertNull((Object)action.getParameterBindings());
        IActionTest.assertNull((Object)action.getSearchCriteria());
        IActionTest.assertNull((Object)action.getReportName());
        IActionTest.assertNull((Object)action.getSystemId());
        IActionTest.assertNull((Object)action.getTargetWindow());
        hyperAction.setBookmark("");
        IActionTest.assertEquals((String)"", (String)action.getBookmark());
        String bookmark = "longbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmarklongbookmark";
        hyperAction.setBookmark(bookmark);
        IActionTest.assertEquals((int)276, (int)action.getBookmark().length());
    }

    public void testHyperlinkAction() {
        ActionContent hyperAction = new ActionContent();
        hyperAction.setHyperlink("http://test", "_blank");
        Action action = new Action((IHyperlinkAction)hyperAction);
        IActionTest.assertEquals((String)"http://test", (String)action.getActionString());
        IActionTest.assertEquals((String)"_blank", (String)action.getTargetWindow());
        IActionTest.assertEquals((int)1, (int)action.getType());
        IActionTest.assertNull((Object)action.getBookmark());
        IActionTest.assertFalse((boolean)action.isBookmark());
        IActionTest.assertNull((Object)action.getFormat());
        IActionTest.assertNull((Object)action.getParameterBindings());
        IActionTest.assertNull((Object)action.getSearchCriteria());
        IActionTest.assertNull((Object)action.getReportName());
        IActionTest.assertNull((Object)action.getSystemId());
        hyperAction.setHyperlink("", "target");
        IActionTest.assertEquals((String)"", (String)action.getActionString());
        hyperAction.setHyperlink(null, "_blank");
        IActionTest.assertNull((Object)action.getActionString());
        hyperAction.setHyperlink("http://test", null);
        IActionTest.assertNull((Object)action.getTargetWindow());
        hyperAction.setHyperlink(null, null);
        IActionTest.assertNull((Object)action.getActionString());
        IActionTest.assertNull((Object)action.getTargetWindow());
    }

    public void testDrillthroughAction() {
        ActionContent hyperAction = new ActionContent();
        String bk = "bookmark";
        String name = "report1";
        String target = "_blank";
        String format = "html";
        boolean isBk = true;
        HashMap paramBindings = new HashMap();
        HashMap searchCriteria = new HashMap();
        hyperAction.setDrillThrough(bk, isBk, name, paramBindings, searchCriteria, target, format);
        Action action = new Action((IHyperlinkAction)hyperAction);
        IActionTest.assertEquals((int)3, (int)action.getType());
        IActionTest.assertEquals((boolean)isBk, (boolean)action.isBookmark());
        IActionTest.assertEquals(paramBindings, (Object)action.getParameterBindings());
        IActionTest.assertEquals(searchCriteria, (Object)action.getSearchCriteria());
        IActionTest.assertEquals((String)target, (String)action.getTargetWindow());
        IActionTest.assertEquals((String)format, (String)action.getFormat());
        hyperAction.setDrillThrough(null, true, null, null, null, null, null);
        IActionTest.assertEquals((int)3, (int)action.getType());
        IActionTest.assertTrue((boolean)action.isBookmark());
        IActionTest.assertNull((Object)action.getParameterBindings());
        IActionTest.assertNull((Object)action.getSearchCriteria());
        IActionTest.assertNull((Object)action.getTargetWindow());
        IActionTest.assertNull((Object)action.getFormat());
    }

    public void testSystemID() {
        Action action = new Action("id", null);
        IActionTest.assertEquals((String)"id", (String)action.getSystemId());
        action = new Action(null, null);
        IActionTest.assertNull((Object)action.getSystemId());
    }

    @Override
    public void startImage(IImageContent image) {
        Action action = new Action(image.getHyperlinkAction());
        IActionTest.assertEquals((int)3, (int)action.getType());
        IActionTest.assertEquals((String)this.reportName, (String)action.getReportName());
        IActionTest.assertTrue((action.getParameterBindings().size() > 0 ? 1 : 0) != 0);
        Object value = action.getParameterBindings().get("p1");
        IActionTest.assertTrue((boolean)(value instanceof List));
        List valueList = (List)value;
        IActionTest.assertTrue((valueList.size() > 0 ? 1 : 0) != 0);
        IActionTest.assertEquals((String)"target value", (String)((String)valueList.get(0)));
        IActionTest.assertEquals((String)"html", (String)action.getFormat());
        IActionTest.assertEquals((String)"_self", (String)action.getTargetWindow());
        IActionTest.assertEquals((String)"labelbk", (String)action.getBookmark());
        IActionTest.assertTrue((boolean)action.isBookmark());
    }

    @Override
    public void startData(IDataContent data) {
        Action action = new Action(data.getHyperlinkAction());
        IActionTest.assertEquals((int)2, (int)action.getType());
        IActionTest.assertEquals((String)"labelbk", (String)action.getBookmark());
        IActionTest.assertEquals((String)"labelbk", (String)action.getActionString());
    }

    @Override
    public void startLabel(ILabelContent label) {
        Action action;
        if (label.getLabelText().equals("label1")) {
            action = new Action(label.getHyperlinkAction());
            IActionTest.assertEquals((int)1, (int)action.getType());
            IActionTest.assertEquals((String)"http://label.com", (String)action.getActionString());
            IActionTest.assertEquals((String)"_blank", (String)action.getTargetWindow());
        }
        if (label.getLabelText().equals("label2")) {
            action = new Action(label.getHyperlinkAction());
            IActionTest.assertEquals((int)3, (int)action.getType());
            IActionTest.assertEquals((String)"IActionTest.rptdocument", (String)action.getReportName());
            IActionTest.assertEquals((String)"_blank", (String)action.getTargetWindow());
            IActionTest.assertEquals((int)0, (int)action.getParameterBindings().size());
            IActionTest.assertNull((Object)action.getSearchCriteria());
            IActionTest.assertEquals((String)"pdf", (String)action.getFormat());
            IActionTest.assertTrue((boolean)action.isBookmark());
            IActionTest.assertNull((Object)action.getBookmark());
        }
    }
}

