/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.DocumentUtil;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_136241
extends BaseTestCase {
    private static final String OUTPUT = "regression_136241.out";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test_regression_136241() throws SemanticException, FileNotFoundException, IOException, DesignFileException {
        DesignEngine engine = new DesignEngine(new DesignConfig());
        SessionHandle session = engine.newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle designHandle = session.createDesign();
        ElementFactory factory = designHandle.getElementFactory();
        LabelHandle label = factory.newLabel("label");
        designHandle.getBody().add((DesignElementHandle)label);
        TemplateReportItemHandle templateLabel = (TemplateReportItemHandle)label.createTemplateElement("templateLabel");
        templateLabel.setDescription("template label description");
        String TempFile = this.genOutputFile(OUTPUT);
        DocumentUtil.serialize((ReportDesignHandle)designHandle, (OutputStream)new FileOutputStream(TempFile));
        designHandle = session.openDesign(TempFile);
        TemplateReportItemHandle template = (TemplateReportItemHandle)designHandle.findElement("templateLabel");
        Regression_136241.assertNotNull((Object)template);
        TemplateParameterDefinition defn = designHandle.getModule().findTemplateParameterDefinition("NewTemplateParameterDefinition");
        Regression_136241.assertNotNull((Object)defn);
        Regression_136241.assertEquals((String)"Label", (String)defn.getAllowedType(designHandle.getModule()));
        Regression_136241.assertEquals((String)"template label description", (String)defn.getDescription(designHandle.getModule()));
    }
}

