/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SimpleGroupElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.metadata.BooleanPropertyType;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StringPropertyType;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_117823
extends BaseTestCase {
    public void test_regression_117823() throws SemanticException {
        DesignEngine engine = new DesignEngine(new DesignConfig());
        SessionHandle session = engine.newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle designHandle = session.createDesign();
        ElementFactory factory = designHandle.getElementFactory();
        LabelHandle label = factory.newLabel("label");
        UserPropertyDefn userProp1 = new UserPropertyDefn();
        userProp1.setName("prop1");
        userProp1.setType((PropertyType)new StringPropertyType());
        userProp1.setDefault((Object)"default value");
        UserPropertyDefn userProp2 = new UserPropertyDefn();
        userProp2.setName("prop2");
        userProp2.setType((PropertyType)new BooleanPropertyType());
        userProp2.setDefault((Object)Boolean.FALSE);
        label.addUserPropertyDefn(userProp1);
        label.addUserPropertyDefn(userProp2);
        ArrayList<LabelHandle> elements = new ArrayList<LabelHandle>();
        elements.add(label);
        SimpleGroupElementHandle groupHandle = new SimpleGroupElementHandle((ModuleHandle)designHandle, elements);
        groupHandle.setStringProperty("prop1", "Learning abc");
        groupHandle.setStringProperty("prop2", "true");
        Regression_117823.assertEquals((String)"Learning abc", (String)groupHandle.getStringProperty("prop1"));
        Regression_117823.assertEquals((String)"true", (String)groupHandle.getStringProperty("prop2"));
    }
}

