/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitterTestCase;

public class HTMLEmitterOptimizeTest
extends HTMLReportEmitterTestCase {
    private static String designFile = "org/eclipse/birt/report/engine/emitter/html/TableTextDecoration.xml";

    @Override
    public String getWorkSpace() {
        return "./htmlEmitterOptimizeTest";
    }

    public void testPerformanceOptimize() throws EngineException, IOException {
        HTMLRenderOption options = new HTMLRenderOption();
        options.setEnableAgentStyleEngine(true);
        options.setEmbeddable(true);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ArrayList instanceIDs = new ArrayList();
        options.setInstanceIDs(instanceIDs);
        options.setOutputStream((OutputStream)output);
        IRenderTask task = this.createRenderTask(designFile);
        task.setRenderOption((IRenderOption)options);
        task.render();
        task.close();
        String content = new String(output.toByteArray());
        output.close();
        String regex = "text-decoration: underline;";
        Matcher matcher = Pattern.compile(regex).matcher(content);
        HTMLEmitterOptimizeTest.assertEquals((boolean)true, (boolean)matcher.find());
        regex = "<div style=\" text-decoration: underline;\">";
        matcher = Pattern.compile(regex).matcher(content);
        HTMLEmitterOptimizeTest.assertEquals((boolean)false, (boolean)matcher.find());
    }

    public void testVisionOptimize() throws EngineException, IOException {
        HTMLRenderOption options = new HTMLRenderOption();
        options.setEnableAgentStyleEngine(false);
        options.setEmbeddable(true);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ArrayList instanceIDs = new ArrayList();
        options.setInstanceIDs(instanceIDs);
        options.setOutputStream((OutputStream)output);
        IRenderTask task = this.createRenderTask(designFile);
        task.setRenderOption((IRenderOption)options);
        task.render();
        task.close();
        String content = new String(output.toByteArray());
        output.close();
        String regex = "<div style=\" text-decoration: underline;";
        Matcher matcher = Pattern.compile(regex).matcher(content);
        HTMLEmitterOptimizeTest.assertEquals((boolean)true, (boolean)matcher.find());
    }
}

