/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Renamer {
    Renamer() throws IOException {
        this.start();
    }

    public void start() throws IOException {
        String path = this.getClassFolder();
        File packDir = new File(path);
        File[] regressionClasses = packDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith("Regression_");
            }
        });
        int i = 0;
        while (i < regressionClasses.length) {
            System.out.println(regressionClasses[i].getName());
            this.rename(regressionClasses[i]);
            ++i;
        }
        this.rename(regressionClasses[0]);
    }

    protected String getClassFolder() {
        CodeSource source;
        Object pathBase = null;
        ProtectionDomain domain = this.getClass().getProtectionDomain();
        if (domain != null && (source = domain.getCodeSource()) != null) {
            URL url = source.getLocation();
            pathBase = url.getPath();
            if (((String)pathBase).endsWith("bin/")) {
                pathBase = ((String)pathBase).substring(0, ((String)pathBase).length() - 4);
            }
            if (((String)pathBase).endsWith("bin")) {
                pathBase = ((String)pathBase).substring(0, ((String)pathBase).length() - 3);
            }
        }
        pathBase = pathBase + "src/";
        Object className = this.getClass().getName();
        int lastDotIndex = ((String)className).lastIndexOf(".");
        className = ((String)className).substring(0, lastDotIndex);
        className = (String)pathBase + ((String)className).replace('.', '/');
        return className;
    }

    boolean rename(File javaFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(javaFile));
        StringBuilder sb = new StringBuilder();
        Pattern pattern = Pattern.compile(".*test_Regression_[\\d]+.*");
        String line = null;
        while ((line = br.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) {
                sb.append(line);
                sb.append('\n');
                continue;
            }
            String fileName = javaFile.getName();
            String caseNo = fileName.substring(fileName.indexOf(95) + 1, fileName.indexOf(46));
            int start = line.indexOf("test_Regression_");
            int end = line.indexOf(40, start + "test_Regression_".length());
            System.out.println(line.substring(start, end));
            String newLine = line.substring(0, start) + "test_regression_" + caseNo + line.substring(end);
            System.out.println(newLine);
            sb.append(newLine);
            sb.append('\n');
        }
        br.close();
        PrintWriter writer = new PrintWriter(new FileWriter(javaFile));
        writer.print(sb.toString());
        writer.flush();
        writer.close();
        return true;
    }

    public static void main(String[] args) throws IOException {
        new Renamer().start();
    }
}

