/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class LibraryCreateTest
extends BaseTestCase {
    private static String fileName = "Library_Creat_Test.xml";
    private static String outFileName = "LibraryCreatLib.xml";
    private static String goldenFileName = "LibraryCreatLib_golden.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + fileName);
        this.copyInputToFile("input/" + outFileName);
        this.copyGoldenToFile("golden/" + goldenFileName);
        this.openDesign(fileName);
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public LibraryCreateTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(LibraryCreateTest.class);
    }

    public void testCreatLibrary() throws Exception {
        DataSourceHandle dataSourceHandle = this.designHandle.findDataSource("db2d");
        LibraryCreateTest.assertNotNull((String)"Datasource should not be null", (Object)dataSourceHandle);
        DataSetHandle dataSetHandle = this.designHandle.findDataSet("db2ds");
        LibraryCreateTest.assertNotNull((String)"Dataset should not be null", (Object)dataSetHandle);
        TextItemHandle textHandle = (TextItemHandle)this.designHandle.findElement("myText");
        LibraryCreateTest.assertNotNull((String)"Text should not be null", (Object)textHandle);
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("myTable");
        LibraryCreateTest.assertNotNull((String)"Table should not be null", (Object)tableHandle);
        SharedStyleHandle styleHandle = this.designHandle.findStyle("myStyle");
        LibraryCreateTest.assertNotNull((String)"Style should not be null", (Object)styleHandle);
        ParameterHandle parameterHandle = this.designHandle.findParameter("Parameter1");
        LibraryCreateTest.assertNotNull((String)"Parameter should not be null", (Object)parameterHandle);
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("myLabel");
        LibraryCreateTest.assertNotNull((String)"Label should not be null", (Object)labelHandle);
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("myImage");
        LibraryCreateTest.assertNotNull((String)"Image should not be null", (Object)imageHandle);
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.findElement("myData");
        LibraryCreateTest.assertNotNull((String)"Data should not be null", (Object)dataHandle);
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.libraryHandle = this.sessionHandle.createLibrary();
        ElementExportUtil.exportElement((DesignElementHandle)dataSourceHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)dataSetHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)textHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)tableHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)styleHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)parameterHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)imageHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        ElementExportUtil.exportElement((DesignElementHandle)dataHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        String TempFile = this.genOutputFile(outFileName);
        this.libraryHandle.saveAs(TempFile);
        LibraryCreateTest.assertTrue((boolean)this.compareTextFile(goldenFileName, outFileName));
    }

    public void testNoNameText() throws Exception {
        TextItemHandle textHandle = this.designHandle.getElementFactory().newTextItem("");
        this.designHandle.getBody().add((DesignElementHandle)textHandle);
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.libraryHandle = this.sessionHandle.createLibrary();
        try {
            ElementExportUtil.exportElement((DesignElementHandle)textHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        }
        catch (Exception e) {
            LibraryCreateTest.assertNotNull((Object)e);
        }
    }

    public void testNoNameTable() throws Exception {
        TableHandle tableHandle = this.designHandle.getElementFactory().newTableItem("");
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.libraryHandle = this.sessionHandle.createLibrary();
        try {
            ElementExportUtil.exportElement((DesignElementHandle)tableHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        }
        catch (Exception e) {
            LibraryCreateTest.assertNotNull((Object)e);
        }
    }

    public void testNoNameStyle() throws Exception {
        SharedStyleHandle styleHandle = this.designHandle.getElementFactory().newStyle("");
        this.designHandle.getStyles().add((DesignElementHandle)styleHandle);
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.libraryHandle = this.sessionHandle.createLibrary();
        try {
            ElementExportUtil.exportElement((DesignElementHandle)styleHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        }
        catch (Exception e) {
            LibraryCreateTest.assertNotNull((Object)e);
        }
    }

    public void testDuplicateLibrary() throws Exception {
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel("label1");
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.libraryHandle = this.sessionHandle.createLibrary();
        ElementExportUtil.exportElement((DesignElementHandle)labelHandle, (LibraryHandle)this.libraryHandle, (boolean)false);
        labelHandle.drop();
        LabelHandle label2Handle = this.designHandle.getElementFactory().newLabel("label1");
        this.designHandle.getBody().add((DesignElementHandle)label2Handle);
        try {
            ElementExportUtil.exportElement((DesignElementHandle)label2Handle, (LibraryHandle)this.libraryHandle, (boolean)false);
        }
        catch (Exception e) {
            LibraryCreateTest.assertNotNull((Object)e);
        }
    }
}

