/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatLayoutPeer;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatStringAdapter;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.FormatStringPattern;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FormatStringLayoutPeer
extends FormatLayoutPeer {
    private static final String LABEL_GENERAL_PREVIEW_GROUP = Messages.getString((String)"FormatStringPage.label.previewWithFormat");
    private static final String LABEL_CUSTOM_PREVIEW_STRING = Messages.getString((String)"FormatStringPage.label.preview.string");
    private static final String SAMPLE_TEXT_ZIP_CODE = Messages.getString((String)"FormatStringPage.SimpleTextZipCode");
    private static final String SAMPLE_TEXT_ZIP_C0DE4 = Messages.getString((String)"FormatStringPage.SimpleTextZipCode4");
    private static final String SAMPLE_TEXT_PHONE_NUMBER = Messages.getString((String)"FormatStringPage.PhoneNumber");
    private static final String SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER = Messages.getString((String)"FormatStringPage.SocialSecurityNumber");
    private static final String SAMPLE_TEXT_PRESERVE_SPACE = Messages.getString((String)"FormatStringPage.Preview.PreserveWhiteSpaces");
    private static final String DEFAULT_PREVIEW_TEXT = Messages.getString((String)"FormatStringPage.default.preview.text");
    private static final int FORMAT_TYPE_INDEX = 0;
    private Label generalPreviewLabel;

    public FormatStringLayoutPeer(int pageAlignment, boolean isFormStyle, boolean showLocale) {
        super(pageAlignment, isFormStyle, showLocale);
        this.formatAdapter = new FormatStringAdapter();
    }

    @Override
    protected void fireFormatChanged(String newCategory, String newPattern, String newLocale) {
        this.fireFormatChanged("stringFormat", newCategory, newPattern, newLocale);
    }

    @Override
    protected void createCategoryPages(Composite parent) {
        this.categoryPageMaps = new HashMap();
        this.categoryPageMaps.put("Unformatted", this.getGeneralPage(parent));
        this.categoryPageMaps.put(">", this.getGeneralPage(parent));
        this.categoryPageMaps.put("<", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Custom", this.getCustomPage(parent, false, LABEL_CUSTOM_PREVIEW_STRING));
    }

    private Composite getGeneralPage(Composite parent) {
        if (this.generalPage == null) {
            this.generalPage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            this.generalPage.setLayout((Layout)layout);
            this.generalPreviewLabel = this.createGeneralPreviewPart(this.generalPage);
        }
        return this.generalPage;
    }

    private Label createGeneralPreviewPart(Composite parent) {
        Group group = this.isFormStyle ? FormWidgetFactory.getInstance().createGroup(parent, "") : new Group(parent, 0);
        group.setText(LABEL_GENERAL_PREVIEW_GROUP);
        GridData data = this.pageAlignment == 1 ? new GridData(1808) : new GridData(768);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(1, false));
        Label previewText = FormWidgetFactory.getInstance().createLabel((Composite)group, 0x1000300, this.isFormStyle);
        previewText.setLayoutData((Object)new GridData(768));
        return previewText;
    }

    @Override
    protected void createTable(Composite parent) {
        super.createTable(parent);
        ULocale locale = this.getLocale();
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        TableColumn tableColumValue = new TableColumn(this.customFormatTable, 0);
        tableColumValue.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE);
        tableColumValue.setWidth(150);
        tableColumValue.setResizable(true);
        TableColumn tableColumnDisplay = new TableColumn(this.customFormatTable, 0);
        tableColumnDisplay.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT);
        tableColumnDisplay.setWidth(200);
        tableColumnDisplay.setResizable(true);
        new TableItem(this.customFormatTable, 0).setText(new String[]{this.formatAdapter.getDisplayName4Category(">"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)">", (ULocale)locale), locale).format(DEFAULT_PREVIEW_TEXT)});
        new TableItem(this.customFormatTable, 0).setText(new String[]{this.formatAdapter.getDisplayName4Category("<"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"<", (ULocale)locale), locale).format(DEFAULT_PREVIEW_TEXT)});
        new TableItem(this.customFormatTable, 0).setText(new String[]{this.formatAdapter.getDisplayName4Category("Zip Code + 4"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"Zip Code + 4", (ULocale)locale), locale).format(SAMPLE_TEXT_ZIP_C0DE4)});
        new TableItem(this.customFormatTable, 0).setText(new String[]{this.formatAdapter.getDisplayName4Category("Phone Number"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"Phone Number", (ULocale)locale), locale).format(SAMPLE_TEXT_PHONE_NUMBER)});
        new TableItem(this.customFormatTable, 0).setText(new String[]{this.formatAdapter.getDisplayName4Category("Social Security Number"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"Social Security Number", (ULocale)locale), locale).format(SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER)});
        new TableItem(this.customFormatTable, 0).setText(new String[]{this.formatAdapter.getDisplayName4Category("^"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"^", (ULocale)locale), locale).format(SAMPLE_TEXT_PRESERVE_SPACE)});
        this.customFormatTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String displayName = ((TableItem)e.item).getText(0);
                String pattern = FormatStringLayoutPeer.this.formatAdapter.getPattern4DisplayName(displayName, FormatStringLayoutPeer.this.getLocale());
                FormatStringLayoutPeer.this.customFormatCodeTextBox.setText(pattern);
                FormatStringLayoutPeer.this.updatePreview();
                FormatStringLayoutPeer.this.notifyFormatChange();
            }
        });
    }

    @Override
    protected String getDefaultPreviewText() {
        return DEFAULT_PREVIEW_TEXT;
    }

    @Override
    protected void initiatePageLayout(String categoryStr, String patternStr, String localeStr) {
        this.initiatePageLayout("Custom", categoryStr, patternStr, localeStr);
    }

    @Override
    protected void reLayoutSubPages() {
        this.reLayoutSubPages("Custom");
    }

    @Override
    protected void setControlsEnabled(boolean enabled) {
        this.typeChoicer.setEnabled(enabled);
        this.localeChoicer.setEnabled(enabled);
        this.customFormatCodeTextBox.setEnabled(enabled);
        this.customPreviewTextBox.setEnabled(enabled);
        this.customFormatTable.setEnabled(enabled);
    }

    @Override
    protected void setDefaultPreviewText(String text) {
        this.previewText = text == null || StringUtil.isBlank((String)text) ? null : text;
    }

    @Override
    protected void updatePreview() {
        this.markDirty(this.hasLoaded);
        ULocale locale = this.getLocaleByDisplayName(this.locale);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        String gText = this.getPreviewText() == null ? DEFAULT_PREVIEW_TEXT : this.getPreviewText();
        String category = this.formatAdapter.getCategory4DisplayName(this.typeChoicer.getText());
        this.setCategory(category);
        if ("Unformatted".equals(category)) {
            String pattern = null;
            String fmtStr = new StringFormatter(pattern, locale).format(gText);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(null);
        } else if (">".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category, (ULocale)locale);
            String fmtStr = new StringFormatter(pattern, locale).format(gText);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("<".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category, (ULocale)locale);
            String fmtStr = new StringFormatter(pattern, locale).format(gText);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("Zip Code".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category, (ULocale)locale);
            String fmtStr = new StringFormatter(pattern, locale).format(SAMPLE_TEXT_ZIP_CODE);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("Zip Code + 4".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category, (ULocale)locale);
            String fmtStr = new StringFormatter(pattern, locale).format(SAMPLE_TEXT_ZIP_C0DE4);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("Phone Number".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category, (ULocale)locale);
            String fmtStr = new StringFormatter(pattern, locale).format(SAMPLE_TEXT_PHONE_NUMBER);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("Social Security Number".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category, (ULocale)locale);
            String fmtStr = new StringFormatter(pattern, locale).format(SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("Custom".equals(category)) {
            String pattern = this.customFormatCodeTextBox.getText();
            String fmtStr = StringUtil.isBlank((String)this.customPreviewTextBox.getText()) ? new StringFormatter(pattern, locale).format(gText) : new StringFormatter(pattern, locale).format(this.customPreviewTextBox.getText());
            this.customPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        }
    }

    @Override
    protected void updateTextByLocale() {
        this.setLocale(this.localeChoicer.getText());
        ULocale locale = this.getLocaleByDisplayName(this.locale);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        this.customFormatTable.getItem(0).setText(new String[]{this.formatAdapter.getDisplayName4Category(">"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)">", (ULocale)locale), locale).format(DEFAULT_PREVIEW_TEXT)});
        this.customFormatTable.getItem(1).setText(new String[]{this.formatAdapter.getDisplayName4Category("<"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"<", (ULocale)locale), locale).format(DEFAULT_PREVIEW_TEXT)});
        this.customFormatTable.getItem(2).setText(new String[]{this.formatAdapter.getDisplayName4Category("Zip Code + 4"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"Zip Code + 4", (ULocale)locale), locale).format(SAMPLE_TEXT_ZIP_C0DE4)});
        this.customFormatTable.getItem(3).setText(new String[]{this.formatAdapter.getDisplayName4Category("Phone Number"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"Phone Number", (ULocale)locale), locale).format(SAMPLE_TEXT_PHONE_NUMBER)});
        this.customFormatTable.getItem(4).setText(new String[]{this.formatAdapter.getDisplayName4Category("Social Security Number"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"Social Security Number", (ULocale)locale), locale).format(SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER)});
        this.customFormatTable.getItem(5).setText(new String[]{this.formatAdapter.getDisplayName4Category("^"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"^", (ULocale)locale), locale).format(SAMPLE_TEXT_PRESERVE_SPACE)});
    }

    @Override
    public String getFormatString() {
        if (this.category == null && this.pattern == null) {
            return "Unformatted";
        }
        if (this.category == null) {
            this.category = "";
        }
        if (this.pattern == null) {
            this.pattern = "";
        }
        if (this.category.equals(this.pattern)) {
            return this.category;
        }
        return this.category + ":" + this.pattern;
    }

    @Override
    public void setPreviewText(String text) {
        if (text == null) {
            this.customPreviewTextBox.setText(DEFAULT_PREVIEW_TEXT);
        } else {
            this.customPreviewTextBox.setText(text);
        }
    }
}

