/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.LogicalUndoable;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalUndoOperation;
import org.apache.derby.impl.store.raw.data.PageBasicOperation;
import org.apache.derby.impl.store.raw.data.RecordId;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class LogicalPageOperation
extends PageBasicOperation
implements LogicalUndoable {
    protected LogicalUndo undo;
    protected int recordId;

    public LogicalPageOperation() {
    }

    LogicalPageOperation(BasePage page, LogicalUndo undo, int recordId) {
        super(page);
        this.undo = undo;
        this.recordId = recordId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.recordId);
        out.writeObject(this.undo);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.recordId = CompressedNumber.readInt(in);
        this.undo = (LogicalUndo)in.readObject();
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        if (this.undo == null) {
            BasePage undoPage = this.findpage(xact);
            undoPage.preDirty();
            return new LogicalUndoOperation(undoPage, this.recordId, this);
        }
        RawTransaction rtran = (RawTransaction)xact;
        rtran.checkLogicalOperationOk();
        BasePage logicalUndoPage = this.findLogicalPage(xact, this.undo, in);
        logicalUndoPage.preDirty();
        return new LogicalUndoOperation(logicalUndoPage, this.recordId, this);
    }

    @Override
    public ContainerHandle getContainer() {
        SanityManager.ASSERT(this.containerHdl != null, "accessing null container handle");
        return this.containerHdl;
    }

    @Override
    public void resetRecordHandle(RecordHandle rh) {
        this.resetPageNumber(rh.getPageNumber());
        this.recordId = rh.getId();
    }

    @Override
    public RecordHandle getRecordHandle() {
        return new RecordId(this.getPageId(), this.recordId);
    }

    @Override
    public void reclaimPrepareLocks(Transaction t, LockingPolicy locking_policy) throws StandardException {
        SanityManager.DEBUG_PRINT("", "reclaimPrepareLocks().");
        SanityManager.ASSERT(this.getRecordHandle() != null);
        ContainerHandle ch = t.openContainer(this.getPageId().getContainerId(), locking_policy, 196);
        SanityManager.ASSERT(ch != null);
        if (ch != null) {
            ch.close();
        }
        boolean lock_granted = locking_policy.lockRecordForWrite(t, this.getRecordHandle(), false, false);
        this.releaseResource(t);
        SanityManager.ASSERT(lock_granted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasePage findLogicalPage(Transaction xact, LogicalUndo undo, LimitObjectInput in) throws StandardException, IOException {
        this.releaseResource(xact);
        SanityManager.ASSERT(this.containerHdl == null);
        SanityManager.ASSERT(this.page == null);
        boolean okExit = false;
        try {
            RawTransaction rtran = (RawTransaction)xact;
            this.containerHdl = rtran.openDroppedContainer(this.getPageId().getContainerId(), null);
            SanityManager.ASSERT(this.containerHdl != null, "cannot open container");
            SanityManager.ASSERT(this.containerHdl.getContainerStatus() != 4, "finding a page for undo in a committed dropped container");
            this.page = (BasePage)undo.findUndo(xact, this, in);
            SanityManager.ASSERT(this.page != null, "findUndo returns null page");
            SanityManager.ASSERT(this.page.getPageNumber() == this.getPageId().getPageNumber(), "undo.findUndo did not reset the log op's recordHandle");
            okExit = true;
        }
        finally {
            if (!okExit && this.containerHdl != null) {
                this.containerHdl.close();
                this.containerHdl = null;
            }
        }
        this.foundHere = true;
        return this.page;
    }

    public abstract void undoMe(Transaction var1, BasePage var2, int var3, LogInstant var4, LimitObjectInput var5) throws StandardException, IOException;
}

