/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.ui.ModelConverterDescriptorSelectionPage;
import org.eclipse.emf.converter.ui.contribution.ModelConverterDescriptor;
import org.eclipse.emf.converter.ui.contribution.ModelConverterManager;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ui.contribution.IModelImporterWizard;
import org.eclipse.emf.importer.ui.contribution.ModelImporterDescriptor;
import org.eclipse.emf.importer.ui.contribution.ModelImporterManager;
import org.eclipse.emf.importer.ui.contribution.base.ModelImporterWizard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class EMFModelWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected IPath genModelContainerPath;
    protected String genModelFileName;
    protected IFile reloadFile;
    protected IFile modelFile;
    protected ModelConverterDescriptorSelectionPage selectionPage;
    protected IPath defaultPath;
    protected String defaultDescriptorID;

    public EMFModelWizard() {
        this.setWindowTitle(ImporterPlugin.INSTANCE.getString("_UI_EMFWizardModel_title"));
    }

    public EMFModelWizard(IFile reloadFile) {
        this.setWindowTitle(ImporterPlugin.INSTANCE.getString("_UI_ReloadWizard_title"));
        this.reloadFile = reloadFile;
    }

    public void dispose() {
        this.selection = null;
        this.workbench = null;
        this.genModelContainerPath = null;
        this.reloadFile = null;
        this.selectionPage = null;
        super.dispose();
    }

    protected ImageDescriptor getDefaultImageDescriptor() {
        return ExtendedImageRegistry.INSTANCE.getImageDescriptor(ImporterPlugin.INSTANCE.getImage("full/wizban/NewGenModel"));
    }

    public void addPages() {
        if (this.reloadFile == null) {
            NewGenModelFileCreationPage page = new NewGenModelFileCreationPage("NewModelFileCreationPageID");
            page.setTitle(ImporterPlugin.INSTANCE.getString("_UI_EMFModelWizard_name"));
            page.setDescription(ImporterPlugin.INSTANCE.getString("_UI_CreateGeneratorModel_label"));
            this.addPage((IWizardPage)page);
            if (this.defaultPath != null) {
                page.setContainerFullPath(this.defaultPath.removeLastSegments(1));
                page.setFileName(this.defaultPath.lastSegment());
                page.setPageComplete(page.isPageComplete());
            }
        } else {
            this.setForcePreviousAndNextButtons(true);
        }
        this.addSelectionPage();
    }

    protected void addSelectionPage() {
        this.selectionPage = new SelectionPage("ModelImporterDescriptorSelectionPage", this.workbench, this.selection);
        this.selectionPage.setTitle(ImporterPlugin.INSTANCE.getString("_UI_SelectModelImporters_title"));
        this.selectionPage.setModeConverterWizardDefaultImageDescriptor(this.getDefaultImageDescriptor());
        this.selectionPage.setModelConverterDescriptor((ModelConverterDescriptor)this.computeSuggestedDescriptor());
        this.addPage((IWizardPage)this.selectionPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.init();
    }

    protected void init() {
        this.setDefaultPageImageDescriptor(this.getDefaultImageDescriptor());
    }

    protected String getDefaultGenModelFileName() {
        return this.defaultPath == null ? "My.genmodel" : this.defaultPath.removeFirstSegments(this.defaultPath.segmentCount() - 1).toString();
    }

    protected List<ModelImporterDescriptor> getModelImporterDescriptors() {
        return ModelImporterManager.INSTANCE.filterModelImporterDescriptors(2);
    }

    protected ModelImporterDescriptor computeSuggestedDescriptor() {
        Object element;
        ModelImporterDescriptor descriptor = null;
        if (this.defaultDescriptorID != null && (descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor(this.defaultDescriptorID)) != null) {
            return descriptor;
        }
        if (this.reloadFile != null) {
            Object content;
            URI reloadURI = URI.createPlatformResourceURI((String)this.reloadFile.getFullPath().toString(), (boolean)true);
            ResourceSet resourceSet = ConverterUtil.createResourceSet();
            Resource reloadResource = null;
            try {
                reloadResource = resourceSet.getResource(reloadURI, true);
            }
            catch (RuntimeException e) {
                reloadResource = resourceSet.getResource(reloadURI, false);
            }
            if (reloadResource != null && !reloadResource.getContents().isEmpty() && (content = reloadResource.getContents().get(0)) instanceof GenModel) {
                GenModel genModel = (GenModel)content;
                if (genModel.getImporterID() != null) {
                    descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor(genModel.getImporterID());
                } else if (!genModel.getForeignModel().isEmpty()) {
                    String foreignModel = (String)genModel.getForeignModel().get(0);
                    if (foreignModel.endsWith(".mdl")) {
                        descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor("org.eclipse.emf.importer.rose");
                    } else if (foreignModel.endsWith(".xsd") || foreignModel.endsWith(".wsdl")) {
                        descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor("org.eclipse.xsd.ecore.importer");
                    } else if (foreignModel.endsWith("@model")) {
                        descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor("org.eclipse.emf.importer.java");
                    } else if (foreignModel.endsWith(".ecore") || foreignModel.endsWith(".emof")) {
                        descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor("org.eclipse.emf.importer.ecore");
                    }
                }
            }
        }
        if (descriptor == null && this.selection != null && !this.selection.isEmpty() && (element = this.selection.getFirstElement()) instanceof IFile) {
            List<ModelImporterDescriptor> descriptors;
            String fileExtension = ((IFile)element).getFileExtension();
            descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor(this.selectionPage.getLastModelConverterDescriptorId());
            if (!(descriptor != null && descriptor.getExtensions().contains(fileExtension) || (descriptors = ModelImporterManager.INSTANCE.filterModelImporterDescriptors(fileExtension)).isEmpty())) {
                descriptor = descriptors.get(0);
            }
            if (descriptor != null) {
                this.modelFile = (IFile)element;
            }
        }
        return descriptor;
    }

    protected boolean isValidNewValue(Object newValue, Object oldValue) {
        return newValue == null ? oldValue != null : !newValue.equals(oldValue);
    }

    protected void adjustModelImporterWizard(IModelImporterWizard modelImporterWizard, ModelImporterDescriptor modelImporterDescriptor) {
        if (this.isValidNewValue(this.reloadFile, modelImporterWizard.getOriginalGenModelFile())) {
            modelImporterWizard.setOriginalGenModelFile(this.reloadFile);
        }
        if (this.isValidNewValue(this.genModelContainerPath, modelImporterWizard.getGenModelContainerPath())) {
            modelImporterWizard.setGenModelContainerPath(this.genModelContainerPath);
        }
        if (this.isValidNewValue(this.genModelFileName, modelImporterWizard.getGenModelFileName())) {
            modelImporterWizard.setGenModelFileName(this.genModelFileName);
        }
        if (this.isValidNewValue(this.modelFile, modelImporterWizard.getModelFile()) && (this.modelFile == null || modelImporterDescriptor.getExtensions().contains(this.modelFile.getFileExtension()))) {
            modelImporterWizard.setModelFile(this.modelFile);
        }
        modelImporterWizard.getFileExtensions().clear();
        modelImporterWizard.getFileExtensions().addAll(modelImporterDescriptor.getExtensions());
    }

    public boolean canFinish() {
        return false;
    }

    public boolean performFinish() {
        this.selectionPage.performFinish();
        return true;
    }

    public void setDefaultModelImporterDescriptorID(String id) {
        this.defaultDescriptorID = id;
    }

    public String getDefaultModelImporterDescriptorID() {
        return this.defaultDescriptorID;
    }

    public void setDefaultPath(IPath path) {
        this.defaultPath = path.makeAbsolute();
    }

    public IPath getDefaultPath() {
        return this.defaultPath;
    }

    public class NewGenModelFileCreationPage
    extends WizardNewFileCreationPage {
        protected boolean firstTime;

        public NewGenModelFileCreationPage(String pageId) {
            super(pageId, EMFModelWizard.this.selection);
            this.firstTime = true;
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !extension.equals("genmodel")) {
                    this.setErrorMessage(ImporterPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameMustEndWithGenModel_message"));
                    return false;
                }
                EMFModelWizard.this.genModelContainerPath = this.getContainerFullPath();
                EMFModelWizard.this.genModelFileName = this.getFileName();
                return true;
            }
            return false;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.firstTime) {
                this.firstTime = false;
                if (EMFModelWizard.this.modelFile != null) {
                    String fileName = EMFModelWizard.this.modelFile.getFullPath().removeFileExtension().lastSegment();
                    this.setFileName(String.valueOf(fileName) + ".genmodel");
                } else if (this.getFileName() == null) {
                    this.setFileName(EMFModelWizard.this.getDefaultGenModelFileName());
                }
            }
        }

        public void setFileName(String value) {
            super.setFileName(value);
            EMFModelWizard.this.genModelFileName = value;
        }
    }

    public class SelectionPage
    extends ModelConverterDescriptorSelectionPage {
        public SelectionPage(String pageId, IWorkbench workbench, IStructuredSelection selection) {
            super(pageId, (ModelConverterManager)ModelImporterManager.INSTANCE, workbench, selection);
        }

        protected Object[] getTableInput() {
            return EMFModelWizard.this.getModelImporterDescriptors().toArray();
        }

        protected String getSelectModelConverterLabel() {
            return ImporterPlugin.INSTANCE.getString("_UI_SelectModelImporters_label");
        }

        public void setModelImporterDescriptor(ModelImporterDescriptor modelImporterDescriptor) {
            this.setModelConverterDescriptor(modelImporterDescriptor);
        }

        public ModelImporterDescriptor getModelImporterDescriptor() {
            return (ModelImporterDescriptor)this.getModelConverterDescriptor();
        }

        protected String getNoModelConverterMessage() {
            return ImporterPlugin.INSTANCE.getString("_UI_NoModelImporters_error");
        }

        protected void adjustModelConverterWizard(IWizard modelConverterWizard) {
            EMFModelWizard.this.adjustModelImporterWizard((ModelImporterWizard)modelConverterWizard, this.getModelImporterDescriptor());
        }
    }
}

