/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.presentation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IStateValidationSupport;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.jet.JETAttributeItem;
import org.eclipse.emf.codegen.jet.JETAttributeListItem;
import org.eclipse.emf.codegen.jet.JETCommentItem;
import org.eclipse.emf.codegen.jet.JETCompilationUnit;
import org.eclipse.emf.codegen.jet.JETCompileTemplateOperation;
import org.eclipse.emf.codegen.jet.JETDirectiveItem;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETExpressionItem;
import org.eclipse.emf.codegen.jet.JETItem;
import org.eclipse.emf.codegen.jet.JETJavaItem;
import org.eclipse.emf.codegen.jet.JETLiteralItem;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.jet.JETParser;
import org.eclipse.emf.codegen.jet.JETRootItem;
import org.eclipse.emf.codegen.jet.JETScriptletItem;
import org.eclipse.emf.codegen.jet.JETSkeleton;
import org.eclipse.emf.codegen.jet.JETSubItem;
import org.eclipse.emf.codegen.jet.JETTokenItem;
import org.eclipse.emf.codegen.jet.JETValueElementItem;
import org.eclipse.emf.codegen.jet.JETValueItem;
import org.eclipse.emf.codegen.presentation.CodeGenUIPlugin;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.CollapseAllAction;
import org.eclipse.jdt.internal.ui.actions.JDTQuickMenuCreator;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.BreadcrumbViewer;
import org.eclipse.jdt.internal.ui.text.ContentAssistPreference;
import org.eclipse.jdt.internal.ui.text.HTMLAnnotationHover;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionAssistant;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.undo.DocumentUndoEvent;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoListener;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.NavigationLocation;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.themes.ColorUtil;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public final class JETEditor
extends AbstractDecoratedTextEditor {
    public static final String ID = "org.eclipse.emf.codegen.presentation.JETEditorID";
    static final String REFACTOR_QUICKMENU_COMMAND_ID = "org.eclipse.codegen.ui.jet.refactor.quickmenu";
    private static final String REFACTOR_QUICKMENU_MENU_ID = "org.eclipse.codegen.ui.jet.refactor";
    static final String SOURCE_QUICKMENU_COMMAND_ID = "org.eclipse.codegen.ui.jet.source.quickmenu";
    static final String SOURCE_QUICKMENU_MENU_ID = "org.eclipse.codegen.ui.jet.source";
    static final String SELECT_ENCLOSING_JET_ELEMENT_ACTION_ID = "SelectEnclosingJETElement";
    static final String EXTRACT_LOCAL_VARIABLE_ACTION_ID = "ExtractLocalVariable";
    static final String GOTO_BRACKET_COMMAND_ID = "org.eclipse.emf.codegen.ui.jet.goto.matching.bracket";
    static final String SELECT_ENCLOSING_JET_ELEMENT_COMMAND_ID = "org.eclipse.emf.codegen.ui.jet.select.enclosing";
    static final String RENAME_COMMAND_ID = "org.eclipse.codegen.ui.jet.rename";
    static final String RENAME_ACTION_ID = "Rename";
    static final String FORMAT_COMMAND_ID = "org.eclipse.codegen.ui.jet.format";
    static final String FORMAT_ACTION_ID = "Format";
    private static boolean trace;
    private final BracketInserter bracketInserter = new BracketInserter(this);
    private final DelegatingTextHover delegatingTextHover = new DelegatingTextHover(this);
    private final JETDocumentManager jetDocumentManager = new JETDocumentManager(this);
    private final JETBracketMatcher jetBracketMatcher = new JETBracketMatcher(this);
    private final List<Runnable> disposables = new ArrayList<Runnable>();
    private final AtomicReference<JETCompilerResult> pendingJETCompilerResult = new AtomicReference();
    private JETCompilerResult jetCompilerResult;
    private JavaEditor javaEditor;
    private long expectedModificationStamp;
    private JETContentOutlinePage contentOutlinePage;
    private JETBreadcrumbViewer breadcrumbViewer;
    private Runnable pendingUntilDocumentsAvailable;
    private Runnable dismissLandingPage;
    private boolean isSaving;
    private boolean isShowingContentAssist;
    private TrackedPosition jetPosition = new TrackedPosition(TrackedPosition.Type.JET);
    private TrackedPosition javaPosition = new TrackedPosition(TrackedPosition.Type.JAVA);
    private int[] styleRangeOffsets;
    private JETToken[] jetTokens;
    private SelectionSynchronizer selectionSynchronizer;
    private Runnable deferredInvalidatePresentation;
    private boolean editorContextMenuAboutToShow;

    public JETEditor() {
        this.jetPosition.setOpposite(this.javaPosition);
    }

    JETNature getJETNature() {
        IFile file = this.getEditorInputFile();
        return file == null ? null : JETNature.getRuntime((IProject)file.getProject());
    }

    public IEditorInput getEditorInput() {
        if (this.editorContextMenuAboutToShow) {
            try {
                this.editorContextMenuAboutToShow = false;
                IEditorInput iEditorInput = this.jetDocumentManager.getEditorInput();
                return iEditorInput;
            }
            finally {
                this.editorContextMenuAboutToShow = true;
            }
        }
        return super.getEditorInput();
    }

    SourceViewer getJETSourceViewer() {
        return (SourceViewer)this.getSourceViewer();
    }

    JavaEditor getJavaEditor() {
        return this.javaEditor;
    }

    SourceViewer getJavaSourceViewer() {
        return this.getJavaEditor().getJavaSourceViewer();
    }

    TrackedPosition getJavaPosition() {
        return this.javaPosition;
    }

    TrackedPosition getJETPosition() {
        return this.jetPosition;
    }

    boolean isJavaEditorInSync() {
        return this.expectedModificationStamp == this.getModificationStamp();
    }

    long getModificationStamp() {
        IDocument document = this.getSourceViewer().getDocument();
        return document == null ? 0L : ((IDocumentExtension4)document).getModificationStamp();
    }

    void resetExpectedModificationStamp() {
        this.expectedModificationStamp = 0L;
    }

    void setExpectedModificationStamp() {
        this.expectedModificationStamp = this.getModificationStamp();
    }

    JETDocumentManager getDocumentManager() {
        return this.jetDocumentManager;
    }

    int getFileID() {
        return this.jetDocumentManager.getFileID();
    }

    IFile getEditorInputFile() {
        return JETEditor.toFile(this.getEditorInput());
    }

    JETBreadcrumbViewer getBreadcrumbViewer() {
        return this.breadcrumbViewer;
    }

    JETCompilerResult getCompilerResult() {
        return this.jetCompilerResult;
    }

    JETCompilationUnit getCompilationUnit() {
        return this.jetCompilerResult == null ? null : this.jetCompilerResult.getCompilationUnit();
    }

    void setShowingContentAssist(boolean isShowingContentAssist) {
        this.isShowingContentAssist = isShowingContentAssist;
        if (!isShowingContentAssist) {
            this.jetDocumentManager.setEnableJavaSynchronization(true);
        }
    }

    void handleCompilerResult(JETCompilerResult jetCompilerResult) {
        JETCompilerResult oldJETCompilerResult = this.pendingJETCompilerResult.getAndSet(jetCompilerResult);
        if (oldJETCompilerResult == null) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JETCompilerResult newJETCompilerResult = JETEditor.this.pendingJETCompilerResult.getAndSet(null);
                    if (newJETCompilerResult != null) {
                        JETEditor.this.setCompilerResult(newJETCompilerResult);
                    }
                }
            });
        }
    }

    void waitForCompilerResult(long timeInMillis) {
        long count = timeInMillis / 100L;
        int i = 0;
        while ((long)i < count) {
            JETCompilerResult jetCompilerResult = this.pendingJETCompilerResult.getAndSet(null);
            if (jetCompilerResult == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException exception) {
                    Thread.interrupted();
                }
            } else {
                this.setCompilerResult(jetCompilerResult);
                break;
            }
            ++i;
        }
    }

    void setCompilerResult(JETCompilerResult jetCompilerResult) {
        if (!this.isShowingContentAssist) {
            this.jetCompilerResult = jetCompilerResult;
            this.jetDocumentManager.setCompilerResult(jetCompilerResult);
            this.handleProblems(this.getFileID());
            IFile javaFile = jetCompilerResult.getJavaFile();
            JETCompilationUnit jetCompilationUnit = jetCompilerResult.getCompilationUnit();
            if (javaFile != null) {
                ISourceViewer jetSourceViewer = this.getSourceViewer();
                this.setExpectedModificationStamp();
                SourceViewer javaSourceViewer = this.getJavaSourceViewer();
                StyledText javaTextWidget = javaSourceViewer.getTextWidget();
                try {
                    javaTextWidget.setRedraw(false);
                    String compilationUnit = jetCompilationUnit.getJavaCompilationUnit();
                    this.javaEditor.setInput(javaFile, compilationUnit);
                    IDocument document = javaSourceViewer.getDocument();
                    if (document != null) {
                        String oldDocument = document.get();
                        if (!compilationUnit.equals(oldDocument)) {
                            document.set(compilationUnit);
                        } else {
                            this.invalidateVisibleTextPresentation(true);
                        }
                        jetSourceViewer.getTextWidget().notifyListeners(13, new Event());
                    }
                }
                finally {
                    javaTextWidget.setRedraw(true);
                }
            }
            if (jetCompilationUnit != null && this.pendingUntilDocumentsAvailable != null) {
                try {
                    this.pendingUntilDocumentsAvailable.run();
                }
                finally {
                    this.pendingUntilDocumentsAvailable = null;
                }
            }
            if (this.dismissLandingPage != null) {
                this.dismissLandingPage.run();
            }
            this.selectionSynchronizer.sync(this.getSourceViewer());
        }
    }

    List<JETCompilationUnit.JETJavaRange> getRanges() {
        JETCompilationUnit compilerResult = this.getCompilationUnit();
        return compilerResult == null ? Collections.emptyList() : compilerResult.getRanges();
    }

    JETItem getJETItem(int templateOffset, boolean leaf) {
        JETCompilationUnit compilerResult = this.getCompilationUnit();
        return compilerResult == null ? null : compilerResult.getJETItem(this.getFileID(), templateOffset, leaf);
    }

    Position getCorrespondingJavaPosition(int templateOffset, int templateLength) {
        int[] correspondingJavaPoint;
        JETCompilationUnit compilerResult = this.getCompilationUnit();
        if (compilerResult != null && (correspondingJavaPoint = compilerResult.getCorrespondingJavaPoint(this.getFileID(), templateOffset, templateLength)) != null) {
            return new Position(correspondingJavaPoint[0], correspondingJavaPoint[1]);
        }
        return null;
    }

    int getCorrespondingTemplateFileID(int javaOffset) {
        JETCompilationUnit compilerResult = this.getCompilationUnit();
        return compilerResult == null ? -1 : compilerResult.getCorrespondingTemplateFileID(javaOffset);
    }

    Position getCorrespondingTemplatePosition(int javaOffset, int javaLength) {
        int[] correspondingTemplatePoint;
        JETCompilationUnit compilerResult = this.getCompilationUnit();
        if (compilerResult != null && (correspondingTemplatePoint = compilerResult.getCorrespondingTemplatePoint(this.getFileID(), javaOffset, javaLength)) != null) {
            return new Position(correspondingTemplatePoint[0], correspondingTemplatePoint[1]);
        }
        return null;
    }

    void handleFileIDChanged(int fileID) {
        this.firePropertyChange(257);
        this.handleProblems(fileID);
    }

    void handleProblems(int fileID) {
        if (this.jetCompilerResult != null) {
            this.applyProblemAnnotations(this.jetCompilerResult.getProblems(fileID));
        }
    }

    void applyProblemAnnotations(List<JETProblemAnnotation> jetProblemAnnotations) {
        Position position;
        SourceViewer sourceViewer = this.getJETSourceViewer();
        IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
        ArrayList<Annotation> annotationsToRemove = new ArrayList<Annotation>();
        Iterator i = annotationModel.getAnnotationIterator();
        while (i.hasNext()) {
            Annotation annotation = (Annotation)i.next();
            if (annotation instanceof JETProblemAnnotation) {
                annotationsToRemove.add(annotation);
                continue;
            }
            if (!(annotation instanceof MarkerAnnotation) || !this.isDirty()) continue;
            position = annotationModel.getPosition(annotation);
            annotationModel.addAnnotation((Annotation)new JETProblemAnnotation((MarkerAnnotation)annotation, position), position);
        }
        for (Annotation annotation : annotationsToRemove) {
            annotationModel.removeAnnotation(annotation);
        }
        for (JETProblemAnnotation jetProblemAnnotation : jetProblemAnnotations) {
            position = jetProblemAnnotation.getPosition();
            annotationModel.addAnnotation((Annotation)jetProblemAnnotation, position);
        }
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.configureInsertMode(SMART_INSERT, true);
        this.configureInsertMode(INSERT, false);
        this.configureInsertMode(INSERT, true);
        this.setInsertMode(SMART_INSERT);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        IPreferenceStore jetPreferenceStore = CodeGenUIPlugin.getPlugin().getPreferenceStore();
        ChainedPreferenceStore chainedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{jetPreferenceStore, preferenceStore}){

            public boolean getBoolean(String name) {
                if ("matchingBrackets".equals(name)) {
                    return true;
                }
                return !"spellingEnabled".equals(name) && super.getBoolean(name);
            }
        };
        this.setPreferenceStore((IPreferenceStore)chainedPreferenceStore);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new JETSourceViewerConfiguration((IPreferenceStore)chainedPreferenceStore, this));
    }

    public void createPartControl(Composite parent) {
        final SashForm sashForm = new SashForm(parent, 512);
        final Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.breadcrumbViewer = new JETBreadcrumbViewer(composite, 256){

            @Override
            public void configureDropDownViewer(TreeViewer viewer, Object input) {
                viewer.setLabelProvider((IBaseLabelProvider)JETEditor.this.contentOutlinePage.newLabelProvider());
                viewer.setContentProvider((IContentProvider)JETEditor.this.contentOutlinePage.getContentProvider());
            }
        };
        GridData breadcrumbLayoutData = new GridData(4, 4, true, false);
        this.breadcrumbViewer.getControl().setLayoutData((Object)breadcrumbLayoutData);
        Composite jetSourceViewerComposite = new Composite(composite, 0);
        jetSourceViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        jetSourceViewerComposite.setLayout((Layout)new FillLayout());
        super.createPartControl(jetSourceViewerComposite);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        final ImageDescriptor up = CodeGenUIPlugin.getPlugin().getImage("full/up.png");
        final ImageDescriptor down = CodeGenUIPlugin.getPlugin().getImage("full/down.png");
        final Action toggleAction = new Action("", 1){

            public void run() {
                if (sashForm.getMaximizedControl() == null) {
                    sashForm.setMaximizedControl((Control)composite);
                    this.setImageDescriptor(up);
                } else {
                    sashForm.setMaximizedControl(null);
                    this.setImageDescriptor(down);
                }
            }
        };
        toggleAction.setImageDescriptor(down);
        toolBarManager.add((IAction)toggleAction);
        ToolBar toolBar = toolBarManager.createControl(composite);
        GridData toolBarLayoutData = new GridData(0x1000000, 1024, true, false);
        toolBarLayoutData.heightHint = 11;
        toolBar.setLayoutData((Object)toolBarLayoutData);
        StyledText sourceViewerStyledText = this.getSourceViewer().getTextWidget();
        Color sourceViewerBackground = sourceViewerStyledText.getBackground();
        this.breadcrumbViewer.getControl().setBackground(sourceViewerBackground);
        composite.setBackground(sourceViewerStyledText.getBackground());
        IMenuManager contextMenu = (IMenuManager)sourceViewerStyledText.getMenu().getData("org.eclipse.jface.action.MenuManager.managerKey");
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JETEditor.this.editorContextMenuAboutToShow = false;
            }
        });
        JETContentOutlinePage contentOutlinePage = this.getContentOutlinePage();
        this.breadcrumbViewer.setLabelProvider((IBaseLabelProvider)contentOutlinePage.newLabelProvider());
        this.breadcrumbViewer.setContentProvider((IContentProvider)contentOutlinePage.getContentProvider());
        this.breadcrumbViewer.setInput(contentOutlinePage.itemManager.getRootItem());
        this.jetDocumentManager.initializeDocumentManager();
        try {
            this.javaEditor = new JavaEditor(this);
            this.javaEditor.init(this.getEditorSite(), this.getEditorInput());
            final Composite javaComposite = new Composite((Composite)sashForm, 0);
            final StackLayout stackLayout = new StackLayout();
            javaComposite.setLayout((Layout)stackLayout);
            this.javaEditor.createPartControl(javaComposite);
            final Control[] javaEditorChildren = javaComposite.getChildren();
            final ScrolledComposite scrolledComposite = new ScrolledComposite(javaComposite, 768);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setAlwaysShowScrollBars(false);
            final StyledText landingPage = new StyledText((Composite)scrolledComposite, 524296);
            landingPage.setBackground(sourceViewerStyledText.getBackground());
            scrolledComposite.setContent((Control)landingPage);
            final Runnable updateLandingPageInfo = new Runnable(){

                @Override
                public void run() {
                    StyledString landingPageInfo = JETEditor.this.generateLandingPageInfo(landingPage.getLineDelimiter());
                    landingPage.setText(landingPageInfo.toString());
                    landingPage.setStyleRanges(landingPageInfo.getStyleRanges());
                    landingPage.redraw();
                    landingPage.pack(true);
                    Point landingPageSize = landingPage.getSize();
                    scrolledComposite.setMinWidth(landingPageSize.x);
                    scrolledComposite.setMinHeight(landingPageSize.y);
                }
            };
            updateLandingPageInfo.run();
            stackLayout.topControl = scrolledComposite;
            ImageDescriptor star = CodeGenUIPlugin.getPlugin().getImage("full/star.png");
            ImageDescriptor blank = CodeGenUIPlugin.getPlugin().getImage("full/blank.png");
            Action showInfoAction = new Action("", 1){

                public void run() {
                    if (stackLayout.topControl == scrolledComposite) {
                        stackLayout.topControl = javaEditorChildren[0];
                    } else {
                        stackLayout.topControl = scrolledComposite;
                        updateLandingPageInfo.run();
                    }
                    if (sashForm.getMaximizedControl() == composite) {
                        sashForm.setMaximizedControl(null);
                        toggleAction.setImageDescriptor(down);
                    }
                    javaComposite.layout();
                }
            };
            showInfoAction.setImageDescriptor(star);
            showInfoAction.setId("show-info");
            toolBarManager.add((IAction)showInfoAction);
            toolBarManager.update(true);
            class HyperlinkListener
            implements MouseTrackListener,
            MouseMoveListener,
            MouseListener {
                final Cursor defaultCursor;
                final Cursor handCursor;
                final Runnable infoActionAnimator;
                StyleRange hyperLinkRange;
                private final /* synthetic */ Action val$showInfoAction;
                private final /* synthetic */ StyledText val$landingPage;

                HyperlinkListener(final StyledText styledText, final Action action, final ImageDescriptor imageDescriptor, final ImageDescriptor imageDescriptor2) {
                    this.val$landingPage = styledText;
                    this.val$showInfoAction = action;
                    this.defaultCursor = styledText.getCursor();
                    this.handCursor = styledText.getDisplay().getSystemCursor(21);
                    this.infoActionAnimator = new Runnable(){

                        @Override
                        public void run() {
                            if (hyperLinkRange != null && hyperLinkRange.length == 1) {
                                action.setImageDescriptor(action.getImageDescriptor() == imageDescriptor ? imageDescriptor2 : imageDescriptor);
                                styledText.getDisplay().timerExec(300, (Runnable)this);
                            } else {
                                action.setImageDescriptor(imageDescriptor2);
                            }
                        }
                    };
                }

                public void mouseDoubleClick(MouseEvent event) {
                    this.clearHyperlink();
                }

                public void mouseDown(MouseEvent event) {
                    if (this.hyperLinkRange != null) {
                        if (this.hyperLinkRange.length == 1) {
                            this.val$showInfoAction.run();
                        } else {
                            this.val$landingPage.getDisplay().asyncExec(new Runnable(this.val$landingPage){
                                final URI documentURI;
                                {
                                    this.documentURI = URI.createPlatformResourceURI((String)styledText.getText(hyperLinkRange.start, hyperLinkRange.start + hyperLinkRange.length - 1), (boolean)true);
                                }

                                @Override
                                public void run() {
                                    IEditorPart editorPart = JETEditor.open(JETEditor.this.getEditorSite(), this.documentURI.toString());
                                    if (editorPart instanceof JETEditor) {
                                        ((JETEditor)editorPart).selectAndReveal(JETEditor.this.getEditorInput(), 0, 0);
                                    }
                                }
                            });
                        }
                    }
                    this.clearHyperlink();
                }

                public void mouseUp(MouseEvent event) {
                    this.clearHyperlink();
                }

                public void mouseEnter(MouseEvent event) {
                    this.clearHyperlink();
                }

                public void mouseExit(MouseEvent event) {
                    this.clearHyperlink();
                }

                public void mouseHover(MouseEvent event) {
                }

                public void mouseMove(MouseEvent event) {
                    this.updateStyleRange(event);
                }

                private void clearHyperlink() {
                    if (this.hyperLinkRange != null) {
                        this.hyperLinkRange.fontStyle = 0;
                        this.hyperLinkRange.underline = false;
                        this.val$landingPage.setStyleRange(this.hyperLinkRange);
                        this.hyperLinkRange = null;
                        this.val$landingPage.setCursor(this.defaultCursor);
                    }
                }

                private int getOffset(MouseEvent event) {
                    try {
                        try {
                            return (Integer)this.val$landingPage.getClass().getMethod("getOffsetAtPoint", Point.class).invoke((Object)this.val$landingPage, new Point(event.x, event.y));
                        }
                        catch (Exception exception) {
                            return this.val$landingPage.getOffsetAtLocation(new Point(event.x, event.y));
                        }
                    }
                    catch (IllegalArgumentException exception) {
                        return -1;
                    }
                }

                private void updateStyleRange(MouseEvent event) {
                    StyleRange styleRange;
                    StyleRange oldHyperLinkRange = this.hyperLinkRange;
                    this.hyperLinkRange = null;
                    int offsetAtPoint = this.getOffset(event);
                    if (offsetAtPoint != -1 && (styleRange = this.val$landingPage.getStyleRangeAtOffset(offsetAtPoint)) != null && styleRange.data instanceof StyleRange) {
                        this.hyperLinkRange = (StyleRange)styleRange.data;
                        this.hyperLinkRange.underline = true;
                        this.hyperLinkRange.fontStyle = 1;
                        this.val$landingPage.setStyleRange(this.hyperLinkRange);
                        this.val$landingPage.setCursor(this.handCursor);
                        this.infoActionAnimator.run();
                    }
                    if (oldHyperLinkRange != null && oldHyperLinkRange != this.hyperLinkRange) {
                        oldHyperLinkRange.fontStyle = 0;
                        oldHyperLinkRange.underline = false;
                        this.val$landingPage.setStyleRange(oldHyperLinkRange);
                        if (this.hyperLinkRange == null) {
                            this.val$landingPage.setCursor(this.defaultCursor);
                        }
                    }
                }
            }
            HyperlinkListener hyperlinkListener = new HyperlinkListener(landingPage, showInfoAction, blank, star);
            landingPage.addMouseTrackListener((MouseTrackListener)hyperlinkListener);
            landingPage.addMouseListener((MouseListener)hyperlinkListener);
            landingPage.addMouseMoveListener((MouseMoveListener)hyperlinkListener);
            this.dismissLandingPage = new Runnable(){

                @Override
                public void run() {
                    JETEditor.this.dismissLandingPage = null;
                    JETCompilationUnit compilationUnit = JETEditor.this.getCompilationUnit();
                    if (compilationUnit != null) {
                        for (JETException problem : compilationUnit.getProblems()) {
                            String problemKey = problem.getProblemKey();
                            if (!"jet.error.not.a.template".equals(problemKey) && !"jet.error.not.on.source.path".equals(problemKey)) continue;
                            return;
                        }
                        stackLayout.topControl = javaEditorChildren[0];
                        toggleAction.run();
                        javaComposite.layout();
                    }
                }
            };
            this.selectionSynchronizer = new SelectionSynchronizer(this, this.javaEditor);
            this.delegatingTextHover.setEditor((IEditorPart)this.javaEditor);
            new VisibleCaretHandler(sourceViewerStyledText, this.javaEditor.getJavaSourceViewer().getTextWidget());
        }
        catch (PartInitException exception) {
            throw new RuntimeException(exception);
        }
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        }
        new ViewPortHandler(this);
        this.setAction(SELECT_ENCLOSING_JET_ELEMENT_ACTION_ID, (IAction)new SelectEnclosingJETElementAction(this));
        this.setAction(RENAME_ACTION_ID, (IAction)new JETRenameLocalVariableAction(this));
        this.setAction(FORMAT_ACTION_ID, (IAction)new JETFormatAction(this));
    }

    private StyledString generateLandingPageInfo(String lineDelimiter) {
        StyledString styledString = new StyledString(lineDelimiter);
        IEditorInput editorInput = this.getEditorInput();
        IFile file = JETEditor.toFile(editorInput);
        String indent = "      ";
        if (file == null) {
            URI uri = JETEditor.toURI(editorInput);
            String name = uri == null ? editorInput.getName() : uri.toString();
            styledString.append(indent);
            styledString.append("The file ");
            styledString.append(name, StyledString.DECORATIONS_STYLER);
            styledString.append(" cannot be compiled because it is not located in the workspace.");
        } else if (this.getJETNature() == null) {
            styledString.append(indent);
            styledString.append("The file ");
            styledString.append(file.getFullPath().toString(), StyledString.DECORATIONS_STYLER);
            styledString.append(" cannot be compiled because it is not in a project with a JET nature.");
            styledString.append(lineDelimiter);
            styledString.append(lineDelimiter);
            IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
            boolean isWellFormedJavaProject = false;
            try {
                isWellFormedJavaProject = javaProject.isStructureKnown();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            if (!isWellFormedJavaProject) {
                styledString.append(indent);
                styledString.append("Furthermore, its containing project ");
                styledString.append(file.getParent().getFullPath().toString(), StyledString.DECORATIONS_STYLER);
                styledString.append(" is not in a project with a properly configured Java nature.");
                styledString.append(lineDelimiter);
                styledString.append(lineDelimiter);
            }
            styledString.append(indent);
            styledString.append("Use ");
            styledString.append("File \u2192 New \u2192 Other... \u2192 Java Emitter Templates \u2192 Convert Projects to JET Projects", JETContentOutlinePage.Item.getFontStyler(2));
            styledString.append(" to convert a Java project into a JET project.");
            styledString.append(lineDelimiter);
            styledString.append(lineDelimiter);
            styledString.append(indent);
            styledString.append("You will need to reopen this editor after having done so.");
        } else if (this.getJETNature().getJavaSourceContainer() == null) {
            styledString.append(indent);
            styledString.append("The file ");
            styledString.append(file.getFullPath().toString(), StyledString.DECORATIONS_STYLER);
            styledString.append(" cannot be compiled because the JET nature is not properly configured.");
            styledString.append(lineDelimiter);
        } else {
            boolean isNotTemplate;
            JETCompilationUnit compilationUnit = this.getCompilationUnit();
            String className = null;
            boolean notOnSourcePath = false;
            if (compilationUnit != null) {
                className = compilationUnit.getClassName();
                for (JETException problem : compilationUnit.getProblems()) {
                    if (!"jet.error.not.on.source.path".equals(problem.getProblemKey())) continue;
                    notOnSourcePath = true;
                    break;
                }
            }
            styledString.append(indent);
            styledString.append("The file ");
            styledString.append(file.getFullPath().toString(), StyledString.DECORATIONS_STYLER);
            styledString.append(" is being compiled.");
            styledString.append(lineDelimiter);
            styledString.append(lineDelimiter);
            StyledString.Styler problemStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.foreground = ColorManager.INSTANCE.getForeground("directive");
                }
            };
            String fileExtension = file.getFileExtension();
            boolean bl = isNotTemplate = fileExtension == null || !fileExtension.endsWith("jet");
            if (isNotTemplate) {
                styledString.append(indent);
                styledString.append("However, the file is not a root JET template.", problemStyler);
                styledString.append(lineDelimiter);
                styledString.append(lineDelimiter);
                styledString.append(indent);
                styledString.append("A root JET template must have have a file extension that ends with ");
                styledString.append("jet", StyledString.DECORATIONS_STYLER);
                styledString.append(", e.g, ");
                styledString.append("MyTemplate.jet", StyledString.DECORATIONS_STYLER);
                styledString.append(" or ");
                styledString.append("MyTemplate.xmljet", StyledString.DECORATIONS_STYLER);
                styledString.append(".");
                styledString.append(lineDelimiter);
                styledString.append(lineDelimiter);
            } else if (notOnSourcePath) {
                styledString.append(indent);
                styledString.append("The class ");
                if (className != null) {
                    styledString.append(className, StyledString.DECORATIONS_STYLER);
                    styledString.append(' ');
                }
                styledString.append("would be generated in ");
                styledString.append(this.getJETNature().getJavaSourceContainer().getFullPath().toString(), StyledString.DECORATIONS_STYLER);
                styledString.append(", but the template is not on the template path and it will not be built when the project builds.");
                styledString.append(lineDelimiter);
                styledString.append(lineDelimiter);
            } else {
                styledString.append(indent);
                styledString.append("The class ");
                if (className != null) {
                    styledString.append(className, StyledString.DECORATIONS_STYLER);
                    styledString.append(' ');
                }
                styledString.append("will be generated in ");
                styledString.append(this.getJETNature().getJavaSourceContainer().getFullPath().toString(), StyledString.DECORATIONS_STYLER);
                styledString.append(".");
                styledString.append(lineDelimiter);
                styledString.append(lineDelimiter);
            }
            styledString.append(indent);
            styledString.append("The following template path is used:");
            styledString.append(lineDelimiter);
            styledString.append(lineDelimiter);
            List templateSourceContainers = this.getJETNature().getTemplateSourceContainers();
            for (Object container : this.getJETNature().getTemplateContainers()) {
                String string = container instanceof IContainer ? ((IContainer)container).getFullPath().toString() : container.toString();
                styledString.append(indent);
                styledString.append("    ");
                styledString.append("@ ", templateSourceContainers.contains(container) ? new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.foreground = JETEditor.this.getSourceViewer().getTextWidget().getBackground();
                    }
                } : StyledString.COUNTER_STYLER);
                styledString.append(string, StyledString.DECORATIONS_STYLER);
                styledString.append(lineDelimiter);
            }
            styledString.append(lineDelimiter);
            styledString.append(indent);
            styledString.append("Click the tiny ", StyledString.COUNTER_STYLER);
            styledString.append("\u2605", new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.data = textStyle;
                    textStyle.foreground = ColorManager.INSTANCE.getColor(230, 179, 60);
                }
            });
            styledString.append(" icon on the divider above to preview the Java results.", StyledString.COUNTER_STYLER);
            if (isNotTemplate) {
                styledString.append("  Unresolved names will not be reported.", problemStyler);
            }
            styledString.append(lineDelimiter);
            styledString.append(lineDelimiter);
            Set includingTemplates = JETNature.getIncludingTemplates((URI)JETEditor.toURI((IResource)file));
            if (!includingTemplates.isEmpty()) {
                TreeSet<String> values = new TreeSet<String>();
                for (URI uRI : includingTemplates) {
                    values.add(uRI.isPlatformResource() ? uRI.toPlatformString(true) : uRI.toString());
                }
                styledString.append(indent);
                styledString.append("This template is included by the following templates. Click any of these links to open this template in the including context:");
                styledString.append(lineDelimiter);
                styledString.append(lineDelimiter);
                for (String string : values) {
                    styledString.append(indent);
                    styledString.append(indent);
                    StyledString.Styler linkStyler = new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            StyledString.DECORATIONS_STYLER.applyStyles(textStyle);
                            textStyle.data = textStyle;
                        }
                    };
                    styledString.append(string, linkStyler);
                    styledString.append(lineDelimiter);
                }
            }
        }
        return styledString;
    }

    void invalidateVisibleTextPresentation(boolean defer) {
        ISourceViewer jetSourceViewer = this.getSourceViewer();
        if (defer) {
            final StyledText textWidget = jetSourceViewer.getTextWidget();
            this.deferredInvalidatePresentation = new Runnable(){

                @Override
                public void run() {
                    if (JETEditor.this.deferredInvalidatePresentation == this && !textWidget.isDisposed()) {
                        JETEditor.this.invalidateVisibleTextPresentation(false);
                    }
                }
            };
            textWidget.getDisplay().timerExec(200, this.deferredInvalidatePresentation);
        } else {
            this.deferredInvalidatePresentation = null;
            int start = jetSourceViewer.getTopIndexStartOffset();
            int end = jetSourceViewer.getBottomIndexEndOffset();
            ((ITextViewerExtension2)jetSourceViewer).invalidateTextPresentation(start, end - start);
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.jetDocumentManager.handleInputChanged(input);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer sourceViewer = super.createSourceViewer(parent, ruler, styles);
        ColorManager.INSTANCE.register(sourceViewer);
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.bracketInserter);
        }
        return sourceViewer;
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(CodeGenUIPlugin.getResourceBundle(), "_UI_ContentAssistProposal_", (ITextEditor)this);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        action.setActionDefinitionId(id);
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        final IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        JDTQuickMenuCreator refactorMenuCreator = new JDTQuickMenuCreator((org.eclipse.jdt.internal.ui.javaeditor.JavaEditor)this.getJavaEditor()){

            protected void fillMenu(IMenuManager menu) {
                JETEditor.this.addRefactorActions(menu);
            }
        };
        final IHandlerActivation refactorHandlerActivation = service.activateHandler(REFACTOR_QUICKMENU_COMMAND_ID, refactorMenuCreator.createHandler());
        JDTQuickMenuCreator sourceMenuCreator = new JDTQuickMenuCreator((org.eclipse.jdt.internal.ui.javaeditor.JavaEditor)this.getJavaEditor()){

            protected void fillMenu(IMenuManager menu) {
                JETEditor.this.addSourceActions(menu);
            }
        };
        final IHandlerActivation sourceHandlerActivation = service.activateHandler(SOURCE_QUICKMENU_COMMAND_ID, sourceMenuCreator.createHandler());
        this.disposables.add(new Runnable(){

            @Override
            public void run() {
                service.deactivateHandler(refactorHandlerActivation);
                service.deactivateHandler(sourceHandlerActivation);
            }
        });
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        this.editorContextMenuAboutToShow = true;
        super.editorContextMenuAboutToShow(menu);
        Action colorPreferencesAction = new Action(CodeGenUIPlugin.getPlugin().getString("_UI_JETColorPreferences_label"), CodeGenUIPlugin.getPlugin().getImage("full/obj16/JETFile")){

            public void run() {
                JETToken token = JETEditor.this.getTokenAtSelection(0);
                String matchingProperty = "selectColor:" + ColorManager.INSTANCE.getProperty(token);
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)JETEditor.this.getSite().getShell(), (String)"org.eclipse.ui.preferencePages.ColorsAndFonts", null, (Object)matchingProperty);
                preferenceDialog.open();
            }
        };
        menu.insertAfter("Preferences.ContextAction", (IAction)colorPreferencesAction);
        IContributionItem quickAssist = menu.find("QuickAssist");
        if (quickAssist != null) {
            MenuManager refactorSubmenu = new MenuManager("Refac&tor", REFACTOR_QUICKMENU_MENU_ID);
            refactorSubmenu.setActionDefinitionId(REFACTOR_QUICKMENU_COMMAND_ID);
            this.addRefactorActions((IMenuManager)refactorSubmenu);
            menu.insertAfter("QuickAssist", (IContributionItem)refactorSubmenu);
            MenuManager sourceSubmenu = new MenuManager("&Source", SOURCE_QUICKMENU_MENU_ID);
            sourceSubmenu.setActionDefinitionId(SOURCE_QUICKMENU_COMMAND_ID);
            this.addSourceActions((IMenuManager)sourceSubmenu);
            menu.insertAfter("QuickAssist", (IContributionItem)sourceSubmenu);
        }
    }

    void addRefactorActions(IMenuManager refactorSubmenu) {
        IAction action = this.getAction(RENAME_ACTION_ID);
        refactorSubmenu.add(action);
        action = this.javaEditor.getAction(EXTRACT_LOCAL_VARIABLE_ACTION_ID);
        refactorSubmenu.add(action);
    }

    void addSourceActions(IMenuManager sourceSubmenu) {
        IAction action = this.getAction(FORMAT_ACTION_ID);
        sourceSubmenu.add(action);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        this.jetDocumentManager.dispose();
        super.dispose();
        if (this.javaEditor != null) {
            this.javaEditor.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        this.javaPosition.dispose();
        this.jetPosition.dispose();
        for (Runnable runnable : this.disposables) {
            runnable.run();
        }
        this.disposables.clear();
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("document-id", this.getDocumentManager().getDocumentID());
    }

    protected void doRestoreState(IMemento memento) {
        String documentID = memento.getString("document-id");
        if (documentID != null) {
            this.getDocumentManager().setDocumentID(documentID);
        }
        super.doRestoreState(memento);
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new JETTextSelectionNavigationLocation(this, false);
    }

    public INavigationLocation createNavigationLocation() {
        return new JETTextSelectionNavigationLocation(this, true);
    }

    protected void editorSaved() {
        INavigationLocation[] locations = this.getSite().getPage().getNavigationHistory().getLocations();
        IEditorInput input = this.getEditorInput();
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof JETTextSelectionNavigationLocation && input.equals(locations[i].getInput())) {
                JETTextSelectionNavigationLocation location = (JETTextSelectionNavigationLocation)locations[i];
                location.partSaved((IEditorPart)this);
            }
            ++i;
        }
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        this.isSaving = true;
        try {
            this.jetDocumentManager.performSave(overwrite, progressMonitor);
        }
        finally {
            this.isSaving = false;
        }
    }

    protected void safelySanityCheckState(IEditorInput input) {
        if (!this.isSaving) {
            super.safelySanityCheckState(input);
        }
    }

    protected void performRevert() {
        this.jetDocumentManager.performRevert();
    }

    void selectAndReveal(IDocument document, int selectionStart, int selectionLength) {
        this.jetDocumentManager.selectAndReveal(document, selectionStart, selectionLength);
    }

    void selectAndReveal(final JETTextSelectionNavigationLocation navigationLocation, final int selectionStart, final int selectionLength) {
        IDocument document = this.jetDocumentManager.setDocumentID(navigationLocation.getDocumentID());
        if (document != null) {
            navigationLocation.restoreDocument(this, document);
            this.selectAndReveal(selectionStart, selectionLength);
            this.selectionSynchronizer.sync(this.getSourceViewer());
        } else {
            this.pendingUntilDocumentsAvailable = new Runnable(){

                @Override
                public void run() {
                    JETEditor.this.selectAndReveal(navigationLocation, selectionStart, selectionLength);
                }
            };
        }
    }

    void selectAndReveal(final IEditorInput editorInput, final int selectionStart, final int selectionLength) {
        String documentID = this.jetDocumentManager.getDocumentID(editorInput);
        if (documentID != null) {
            this.jetDocumentManager.setDocumentID(documentID);
            this.selectAndReveal(selectionStart, selectionLength);
            this.selectionSynchronizer.sync(this.getSourceViewer());
        } else {
            this.pendingUntilDocumentsAvailable = new Runnable(){

                @Override
                public void run() {
                    JETEditor.this.selectAndReveal(editorInput, selectionStart, selectionLength);
                }
            };
        }
    }

    protected void selectAndReveal(int selectionStart, int selectionLength, int revealStart, int revealLength) {
        super.selectAndReveal(selectionStart, selectionLength, revealStart, revealLength);
        this.invalidateVisibleTextPresentation(false);
    }

    public Saveable[] getSaveables() {
        return this.jetDocumentManager.getSaveables();
    }

    public boolean isDirty() {
        return this.jetDocumentManager != null && this.jetDocumentManager.isDirty();
    }

    public boolean isEditable() {
        return this.jetDocumentManager.isEditable();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        if (adapter.equals(IShowInSource.class)) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext((Object)JETEditor.this.jetDocumentManager.getEditorInput(), JETEditor.this.getSelectionProvider().getSelection());
                }
            };
        }
        return super.getAdapter(adapter);
    }

    JETContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new JETContentOutlinePage(this);
        }
        return this.contentOutlinePage;
    }

    JETBracketMatcher getJetBracketMatcher() {
        return this.jetBracketMatcher;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.jetBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.emf.codegen.ui.jetEditorScope"});
    }

    IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        JETItem leafJETItem;
        URI templateURI;
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
        JETCompilationUnit compilerResult = this.getCompilationUnit();
        if (compilerResult != null && (templateURI = JETEditor.toPlatformResourceURI(this.getEditorInput())) != null && (leafJETItem = compilerResult.getJETItem(this.getFileID(), region.getOffset(), true)) != null) {
            JETItem rootJETItem = leafJETItem.getRoot();
            if (rootJETItem instanceof JETDirectiveItem) {
                JETDirectiveItem otherEndItem;
                JETDirectiveItem jetDirectiveItem = (JETDirectiveItem)rootJETItem;
                String directiveName = jetDirectiveItem.getNameItem().getText();
                if ("include".equals(directiveName)) {
                    Object data = jetDirectiveItem.getData("include");
                    if (data != null && Boolean.TRUE.equals(jetDirectiveItem.getData("include-success"))) {
                        JETAttributeItem fileAttribute = jetDirectiveItem.getAttribute("file");
                        JETValueItem valueItem = fileAttribute.getValueToken().getValueItem();
                        hyperlinks.add(new JETHyperLink(this, JETEditor.toRegion((JETItem)valueItem), (Integer)jetDirectiveItem.getData("include-file-id"), (String)data));
                    }
                } else if ("jet".equals(directiveName)) {
                    JETAttributeItem importsAttribute;
                    Object data;
                    JETAttributeItem skeletonAttribute = jetDirectiveItem.getAttribute("skeleton");
                    if (skeletonAttribute != null && skeletonAttribute.isAncestor(leafJETItem) && (data = jetDirectiveItem.getData("resolved-skeleton")) != null) {
                        JETValueItem valueItem = skeletonAttribute.getValueToken().getValueItem();
                        hyperlinks.add(new JETHyperLink(this, JETEditor.toRegion((JETItem)valueItem), -1, (String)data));
                    }
                    if ((importsAttribute = jetDirectiveItem.getAttribute("imports")) != null && importsAttribute.isAncestor(leafJETItem) && leafJETItem instanceof JETValueElementItem) {
                        this.detectedJavaHyperlinks(hyperlinks, compilerResult, region, canShowMultipleHyperlinks);
                    }
                } else if (("start".equals(directiveName) || "end".equals(directiveName)) && (otherEndItem = (JETDirectiveItem)jetDirectiveItem.getData("section-other-end")) != null) {
                    hyperlinks.add(new JETNavigationHyperLink(this, JETEditor.toRegion(jetDirectiveItem.getNameItem()), JETEditor.toRegion(otherEndItem.getNameItem())));
                }
            } else if (rootJETItem instanceof JETScriptletItem || rootJETItem instanceof JETExpressionItem) {
                this.detectedJavaHyperlinks(hyperlinks, compilerResult, region, canShowMultipleHyperlinks);
            }
        }
        return hyperlinks.isEmpty() ? null : hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    void detectedJavaHyperlinks(List<IHyperlink> hyperlinks, JETCompilationUnit compilerResult, IRegion region, boolean canShowMultipleHyperlinks) {
        int fileID = this.getFileID();
        int[] correspondingJavaPoint = compilerResult.getCorrespondingJavaPoint(fileID, region.getOffset(), 0);
        if (correspondingJavaPoint != null) {
            this.javaEditor.selectAndReveal(correspondingJavaPoint[0], 0);
            SourceViewer javaSourceViewer = this.javaEditor.getJavaSourceViewer();
            StyledText textWidget = javaSourceViewer.getTextWidget();
            Rectangle bounds = textWidget.getCaret().getBounds();
            textWidget.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
            IHyperlinkDetector[] hyperlinkDetectors = this.javaEditor.getHyperlinkDetectors();
            if (hyperlinkDetectors != null) {
                IHyperlinkDetector[] iHyperlinkDetectorArray = hyperlinkDetectors;
                int n = hyperlinkDetectors.length;
                int n2 = 0;
                while (n2 < n) {
                    IHyperlinkDetector javaHyperlinkDetector = iHyperlinkDetectorArray[n2];
                    IHyperlink[] javaHyperlinks = javaHyperlinkDetector.detectHyperlinks((ITextViewer)javaSourceViewer, (IRegion)new Region(correspondingJavaPoint[0], 0), canShowMultipleHyperlinks);
                    if (javaHyperlinks != null) {
                        IHyperlink[] iHyperlinkArray = javaHyperlinks;
                        int n3 = javaHyperlinks.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IRegion hyperlinkRegion;
                            int[] correspondingTemplatePoint;
                            IHyperlink javaHyperlink = iHyperlinkArray[n4];
                            if (!(javaHyperlink instanceof JETHyperLink) && (correspondingTemplatePoint = compilerResult.getCorrespondingTemplatePoint(fileID, (hyperlinkRegion = javaHyperlink.getHyperlinkRegion()).getOffset(), hyperlinkRegion.getLength())) != null) {
                                hyperlinks.add(new JavaHyperLink(this, (IRegion)new Region(correspondingTemplatePoint[0], correspondingTemplatePoint[1]), javaHyperlink));
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    void setTokenData(int[] styleRangeOffsets, JETToken[] jetTokens) {
        this.styleRangeOffsets = styleRangeOffsets;
        this.jetTokens = jetTokens;
    }

    JETToken getTokenAtSelection(int relativeOffsetFromSelection) {
        Point selectedRange = this.getSourceViewer().getSelectedRange();
        return this.getTokenAt(selectedRange.x + relativeOffsetFromSelection);
    }

    JETToken getTokenAt(int offset) {
        JETToken token;
        JETTokenRegion tokenRegion;
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText textWidget = sourceViewer.getTextWidget();
        int charCount = textWidget.getCharCount();
        if (charCount != 0 && (tokenRegion = this.getTokenRegionAt(offset)) != null && (token = tokenRegion.getToken()) instanceof JETToken) {
            return token;
        }
        return JETContentRule.TOKEN;
    }

    Point getTokenRangeAt(int offset) {
        JETTokenRegion tokenRegion = this.getTokenRegionAt(offset);
        if (tokenRegion != null) {
            return new Point(tokenRegion.getOffset(), tokenRegion.getLength());
        }
        return new Point(offset, 0);
    }

    JETTokenRegion getTokenRegionAt(int offset) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText textWidget = sourceViewer.getTextWidget();
        int charCount = textWidget.getCharCount();
        if (charCount > 0) {
            int index = Arrays.binarySearch(this.styleRangeOffsets, offset);
            if (index < 0) {
                index = -index - 2;
            }
            if (index + 1 < this.styleRangeOffsets.length) {
                JETTokenRegion jetTokenRegion = new JETTokenRegion(this.styleRangeOffsets[index], this.styleRangeOffsets[index + 1] - this.styleRangeOffsets[index], this.jetTokens[index]);
                return jetTokenRegion;
            }
        }
        return null;
    }

    void openDialog(String title, IStatus status) {
        if (status != null && !status.isOK()) {
            Throwable exception;
            String message = status.getMessage();
            if (message.length() == 0 && (exception = status.getException()) != null) {
                message = exception.getClass().getName();
            }
            switch (status.getSeverity()) {
                case 1: {
                    MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)title, (String)message);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)title, (String)message);
                    break;
                }
                default: {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)message);
                }
            }
        }
    }

    static IEditorPart open(IEditorSite site, String locationURI) {
        IFile file = JETEditor.toFile(URI.createURI((String)locationURI));
        if (file != null && file.exists()) {
            try {
                String editorID = site.getWorkbenchWindow().getWorkbench().getEditorRegistry().getDefaultEditor(file.getName()).getId();
                return site.getPage().openEditor((IEditorInput)new FileEditorInput(file), editorID);
            }
            catch (PartInitException exception) {
                CodeGenUIPlugin.write((Exception)((Object)exception));
            }
        }
        return null;
    }

    static IFile toFile(URI uri) {
        return uri.isPlatformResource() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))) : null;
    }

    static URI toPlatformResourceURI(IEditorInput input) {
        return JETEditor.toURI((IResource)JETEditor.toFile(input));
    }

    static IFile toFile(IEditorInput input) {
        if (input instanceof StorageEditorInput) {
            return ((StorageEditorInput)input).getFile();
        }
        return input instanceof IAdaptable ? (IFile)input.getAdapter(IFile.class) : null;
    }

    static URI toURI(IResource resource) {
        return resource == null ? null : URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
    }

    static IRegion toRegion(JETItem jetItem) {
        int start = jetItem.getStartOffset();
        int stop = jetItem.getStopOffset();
        return new Region(start, stop - start);
    }

    static IEditorInput toEditorInput(URI uri) {
        IFile file;
        if (uri != null && uri.isPlatformResource() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)))).isAccessible()) {
            return new FileEditorInput(file);
        }
        return new StorageEditorInput(JETNature.resolve((URI)uri));
    }

    static IFile toFile(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    static URI toURI(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return JETEditor.toURI((IResource)((IFileEditorInput)input).getFile());
        }
        if (input instanceof StorageEditorInput) {
            return URI.createURI((String)((StorageEditorInput)input).getURI().toString());
        }
        if (input instanceof IURIEditorInput) {
            return URI.createURI((String)((IURIEditorInput)input).getURI().toString());
        }
        return null;
    }

    static boolean installOnDocument(IDocument document, Position position, String category, IPositionUpdater positionUpdater) {
        if (document != null && position != null) {
            if (!document.containsPositionCategory(category)) {
                document.addPositionCategory(category);
                document.addPositionUpdater(positionUpdater);
            }
            try {
                document.addPosition(category, position);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    static boolean uninstallFromDocument(IDocument document, Position position, String category, IPositionUpdater positionUpdater) {
        if (document != null && position != null) {
            try {
                document.removePosition(category, position);
                Position[] positions = document.getPositions(category);
                if (positions == null || positions.length == 0) {
                    document.removePositionCategory(category);
                    document.removePositionUpdater(positionUpdater);
                }
                return true;
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
        return false;
    }

    static /* synthetic */ void access$2(JETEditor jETEditor, CoreException coreException, IProgressMonitor iProgressMonitor) {
        jETEditor.handleExceptionOnSave(coreException, iProgressMonitor);
    }

    static class BracketInserter
    implements VerifyKeyListener {
        private final JETEditor jetEditor;
        private final ISelectionProvider jetSelectionProvider;

        public BracketInserter(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
            this.jetSelectionProvider = jetEditor.getSelectionProvider();
        }

        private boolean edit(ITextViewer jetSourceViewer, int offset, int length, String replacement, int selectionOffset) {
            try {
                IDocument document = jetSourceViewer.getDocument();
                document.replace(offset, length, replacement);
                jetSourceViewer.setSelectedRange(selectionOffset, 0);
                return false;
            }
            catch (BadLocationException exception) {
                return true;
            }
        }

        public void verifyKey(VerifyEvent event) {
            if (event.doit && this.jetEditor.getInsertMode() == SMART_INSERT && !this.isMultilineSelection()) {
                ISourceViewer jetSourceViewer = this.jetEditor.getSourceViewer();
                Point selection = jetSourceViewer.getSelectedRange();
                int offset = selection.x;
                int length = selection.y;
                if (length == 0 && offset > 0) {
                    JETTokenRegion tokenRegion;
                    if (event.character == '%') {
                        String text;
                        JETToken tokenAtSelection = this.jetEditor.getTokenAtSelection(0);
                        JETToken tokenBeforeSelection = this.jetEditor.getTokenAtSelection(-1);
                        if ((tokenAtSelection != null && tokenAtSelection.getBaseToken() == JETContentRule.TOKEN || tokenBeforeSelection != null && tokenBeforeSelection.getBaseToken() == JETContentRule.TOKEN) && "<".equals(text = jetSourceViewer.getTextWidget().getTextRange(offset - 1, 1))) {
                            event.doit = this.edit((ITextViewer)jetSourceViewer, offset, 0, "%%>", offset + 1);
                        }
                    } else if (event.character == '-') {
                        JETToken token = this.jetEditor.getTokenAt(offset);
                        if (token == JETScriptletRule.TOKEN) {
                            IDocument document = jetSourceViewer.getDocument();
                            try {
                                if ("<%%>".equals(document.get(offset - 2, 4))) {
                                    event.doit = this.edit((ITextViewer)jetSourceViewer, offset, 0, "--", offset + 1);
                                }
                            }
                            catch (BadLocationException text) {}
                        }
                    } else if (event.character == '>') {
                        JETToken tokenAtSelection = this.jetEditor.getTokenAtSelection(0);
                        if (tokenAtSelection == JETScriptletRule.TOKEN) {
                            IDocument document = jetSourceViewer.getDocument();
                            try {
                                char character = document.getChar(offset - 1);
                                if (character == '%') {
                                    int documentLength = document.getLength();
                                    StringBuilder additionalWhiteSpace = new StringBuilder();
                                    int i = offset;
                                    while (i < documentLength) {
                                        character = document.getChar(i);
                                        if (!Character.isWhitespace(character)) {
                                            if (character == '}') break;
                                            additionalWhiteSpace.setLength(0);
                                            break;
                                        }
                                        additionalWhiteSpace.append(character);
                                        ++i;
                                    }
                                    event.doit = this.edit((ITextViewer)jetSourceViewer, offset, additionalWhiteSpace.length(), ">" + additionalWhiteSpace + "<%", offset + 1);
                                }
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    } else if (event.keyCode == 8 && (tokenRegion = this.jetEditor.getTokenRegionAt(offset)) != null) {
                        JETToken token = tokenRegion.getToken();
                        if (token == JETCommentRule.TOKEN) {
                            if (offset - tokenRegion.getOffset() == 3 && tokenRegion.getLength() == 6) {
                                event.doit = this.edit((ITextViewer)jetSourceViewer, offset - 1, 2, "", offset - 1);
                            }
                        } else if (token == JETScriptletRule.TOKEN && offset - tokenRegion.getOffset() == 2 && tokenRegion.getLength() == 4) {
                            event.doit = this.edit((ITextViewer)jetSourceViewer, offset - 1, 3, "", offset - 1);
                        }
                    }
                }
            }
        }

        private boolean isMultilineSelection() {
            ISelection selection = this.jetSelectionProvider.getSelection();
            if (selection instanceof ITextSelection) {
                ITextSelection ts = (ITextSelection)selection;
                return ts.getStartLine() != ts.getEndLine();
            }
            return false;
        }
    }

    static class ColorManager
    implements IPropertyChangeListener {
        private static ColorManager INSTANCE = new ColorManager();
        private static final String PROPERTY_PREFIX = "org.eclipse.emf.codegen.ui.jet.";
        private final Set<JETToken> tokens = new LinkedHashSet<JETToken>();
        private final Map<Control, ISourceViewer> sourceViewers = new HashMap<Control, ISourceViewer>();
        private final Map<Color, Map<Color, Color>> blendedColors = new HashMap<Color, Map<Color, Color>>();
        private final Map<RGB, Color> colors = new HashMap<RGB, Color>();
        private final DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                sourceViewers.remove(event.widget);
                if (sourceViewers.isEmpty()) {
                    if (trace) {
                        System.out.println("unhook color");
                    }
                    JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
                }
            }
        };

        private ColorManager() {
        }

        public Color getColor(int red, int green, int blue) {
            RGB rgb = new RGB(red, green, blue);
            Color color = this.colors.get(rgb);
            if (color == null) {
                color = new Color((Device)Display.getDefault(), rgb);
                this.colors.put(rgb, color);
            }
            return color;
        }

        public Color getBlendedColor(Color foreground, Color background) {
            Color blendedColor;
            Map<Color, Color> blendedBackgroundColors = this.blendedColors.get(foreground);
            if (blendedBackgroundColors == null) {
                blendedBackgroundColors = new HashMap<Color, Color>();
                this.blendedColors.put(foreground, blendedBackgroundColors);
            }
            if ((blendedColor = blendedBackgroundColors.get(background)) == null) {
                blendedColor = new Color(foreground.getDevice(), ColorUtil.blend((RGB)foreground.getRGB(), (RGB)background.getRGB(), (int)50));
                blendedBackgroundColors.put(background, blendedColor);
            }
            return blendedColor;
        }

        public String getProperty(JETToken token) {
            return PROPERTY_PREFIX + (token == null ? JETContentRule.TOKEN : token.getBaseToken()).getType() + "Background";
        }

        public void register(ISourceViewer sourceViewer) {
            if (this.sourceViewers.isEmpty()) {
                JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
            }
            StyledText control = sourceViewer.getTextWidget();
            this.sourceViewers.put((Control)control, sourceViewer);
            control.addDisposeListener(this.disposeListener);
        }

        public void register(JETToken token) {
            this.tokens.add(token);
            this.update(token);
        }

        private void update(JETToken token) {
            String type = token.getBaseToken().getType();
            token.setData(new JETTextAttribute(this.getForeground(type), this.getBackground(type), token.getTextStyle(), token.getBorderStyle(), null, token));
        }

        private Color getForeground(String type) {
            return JFaceResources.getColorRegistry().get(PROPERTY_PREFIX + type + "Foreground");
        }

        private Color getBackground(String type) {
            return JFaceResources.getColorRegistry().get(PROPERTY_PREFIX + type + "Background");
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().startsWith(PROPERTY_PREFIX)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (JETToken token : tokens) {
                            this.update(token);
                        }
                        for (ISourceViewer sourceViewer : sourceViewers.values()) {
                            sourceViewer.invalidateTextPresentation();
                        }
                    }
                });
            }
        }

        private static class JETTextAttribute
        extends TextAttribute {
            private final JETToken token;
            private final int borderStyle;

            public JETTextAttribute(Color foreground, Color background, int textStyle, int borderStyle, Font font, JETToken token) {
                super(foreground, background, textStyle, font);
                this.token = token;
                this.borderStyle = borderStyle;
            }

            public JETToken getToken() {
                return this.token;
            }

            public int getBorderStyle() {
                return this.borderStyle;
            }

            public boolean equals(Object object) {
                return object == this;
            }
        }
    }

    static class CompletionProposalDelegate
    implements ICompletionProposal,
    ICompletionProposalExtension2,
    ICompletionProposalExtension3,
    ICompletionProposalExtension4,
    ICompletionProposalExtension5,
    ICompletionProposalExtension6 {
        private final JETEditor jetEditor;
        private final ICompletionProposal delegate;
        private final ITextViewer delegateViewer;
        final IDocument delegateDocument;
        final TrackedPosition javaPosition;
        final TrackedPosition jetPosition;

        public CompletionProposalDelegate(ICompletionProposal delelgate, JETEditor jetEditor) {
            this.delegate = delelgate;
            this.jetEditor = jetEditor;
            this.delegateViewer = jetEditor.getJavaSourceViewer();
            this.delegateDocument = this.delegateViewer.getDocument();
            this.jetPosition = jetEditor.getJETPosition();
            this.javaPosition = jetEditor.getJavaPosition();
        }

        public void apply(IDocument document) {
            CompletionTransaction javaDocumentTransaction = new CompletionTransaction(this.jetEditor);
            javaDocumentTransaction.modify(this.delegateDocument, new SneakyRunnable(){

                @Override
                public void execute() throws Exception {
                    Method performChangeMethod = null;
                    Class<?> delegateClass = delegate.getClass();
                    while (delegateClass != null) {
                        try {
                            performChangeMethod = delegateClass.getDeclaredMethod("performChange", IEditorPart.class, IDocument.class);
                            performChangeMethod.setAccessible(true);
                            break;
                        }
                        catch (Exception exception) {
                            delegateClass = delegateClass.getSuperclass();
                        }
                    }
                    if (performChangeMethod != null) {
                        performChangeMethod.invoke((Object)delegate, new Object[]{jetEditor.getJavaEditor(), delegateDocument});
                    } else {
                        delegate.apply(delegateDocument);
                    }
                }
            });
            this.jetEditor.openDialog("Proposal Failed", javaDocumentTransaction.getStatus());
        }

        public void apply(ITextViewer viewer, final char trigger, final int stateMask, int offset) {
            if (this.delegate instanceof ICompletionProposalExtension2) {
                CompletionTransaction javaDocumentTransaction = new CompletionTransaction(this.jetEditor);
                javaDocumentTransaction.modify(this.delegateDocument, new Runnable(){

                    @Override
                    public void run() {
                        ((ICompletionProposalExtension2)delegate).apply(delegateViewer, trigger, stateMask, ((CompletionProposalDelegate)this).delegateViewer.getSelectedRange().x);
                    }
                });
                this.jetEditor.openDialog("Proposal Failed", javaDocumentTransaction.getStatus());
            } else {
                this.apply(this.delegateDocument);
            }
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return this.delegate.getAdditionalProposalInfo();
        }

        public String getDisplayString() {
            return this.delegate.getDisplayString();
        }

        public Image getImage() {
            return this.delegate.getImage();
        }

        public IContextInformation getContextInformation() {
            return this.delegate.getContextInformation();
        }

        public StyledString getStyledDisplayString() {
            return this.delegate instanceof ICompletionProposalExtension6 ? ((ICompletionProposalExtension6)this.delegate).getStyledDisplayString() : new StyledString(this.getDisplayString());
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            return this.delegate instanceof ICompletionProposalExtension5 ? ((ICompletionProposalExtension5)this.delegate).getAdditionalProposalInfo(monitor) : null;
        }

        public boolean isAutoInsertable() {
            return this.delegate instanceof ICompletionProposalExtension4 && ((ICompletionProposalExtension4)this.delegate).isAutoInsertable();
        }

        public IInformationControlCreator getInformationControlCreator() {
            return this.delegate instanceof ICompletionProposalExtension3 ? ((ICompletionProposalExtension3)this.delegate).getInformationControlCreator() : null;
        }

        private int jetToJava(int templateOffset) {
            return this.javaPosition.getOffset() + templateOffset - this.jetPosition.getOffset();
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return this.delegate instanceof ICompletionProposalExtension3 ? ((ICompletionProposalExtension3)this.delegate).getPrefixCompletionText(this.delegateDocument, this.jetToJava(completionOffset)) : null;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return this.delegate instanceof ICompletionProposalExtension3 ? Integer.valueOf(((ICompletionProposalExtension3)this.delegate).getPrefixCompletionStart(this.delegateDocument, this.jetToJava(completionOffset))) : null;
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
            if (this.delegate instanceof ICompletionProposalExtension2) {
                ((ICompletionProposalExtension2)this.delegate).selected(this.delegateViewer, smartToggle);
            }
        }

        public void unselected(ITextViewer viewer) {
            if (this.delegate instanceof ICompletionProposalExtension2) {
                ((ICompletionProposalExtension2)this.delegate).unselected(this.delegateViewer);
            }
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            return this.delegate instanceof ICompletionProposalExtension2 && ((ICompletionProposalExtension2)this.delegate).validate(this.delegateDocument, this.jetToJava(offset), event);
        }

        class CompletionTransaction
        extends JavaDocumentTransaction {
            public CompletionTransaction(JETEditor jetEditor) {
                super(jetEditor, Collections.singletonList(jetEditor.getJETPosition()), true, false);
            }

            @Override
            protected void postCommit(List<TrackedPosition> jetPositions) {
                int offset;
                Point finalJavaSelectionRange = CompletionProposalDelegate.this.delegate.getSelection(CompletionProposalDelegate.this.delegateDocument);
                if (finalJavaSelectionRange != null && (offset = finalJavaSelectionRange.x - CompletionProposalDelegate.this.javaPosition.getOffset()) > 0) {
                    this.jetEditor.getSourceViewer().setSelectedRange(CompletionProposalDelegate.this.jetPosition.getOffset() + offset, finalJavaSelectionRange.y);
                }
                Event event = new Event();
                event.character = (char)27;
                event.keyCode = 27;
                this.jetEditor.getJavaSourceViewer().getTextWidget().notifyListeners(1, event);
            }
        }
    }

    static final class CompositeUndoManager
    implements IUndoManager,
    IUndoManagerExtension,
    ITextInputListener {
        private final JETEditor jetEditor;
        private final int undoLevel;
        private int compoundChange;
        private final Map<IDocument, SharedTextViewerUndoManager> managers = new HashMap<IDocument, SharedTextViewerUndoManager>();
        private final IUndoContext undoContext = new IUndoContext(){

            public boolean matches(IUndoContext context) {
                for (SharedTextViewerUndoManager undoManager : managers.values()) {
                    IUndoContext undoContext = undoManager.getUndoContext();
                    if (!undoContext.matches(context)) continue;
                    return true;
                }
                return false;
            }

            public String getLabel() {
                return "Shared Undo Context";
            }
        };
        private ITextViewer textViewer;
        private IDocument document;

        public CompositeUndoManager(JETEditor jetEditor, int undoLevel) {
            this.jetEditor = jetEditor;
            this.undoLevel = undoLevel;
        }

        protected SharedTextViewerUndoManager getUndoManager() {
            return this.managers.get(this.document);
        }

        public IUndoContext getUndoContext() {
            return this.undoContext;
        }

        public void connect(ITextViewer textViewer) {
            if (this.textViewer == null) {
                textViewer.addTextInputListener((ITextInputListener)this);
            }
            this.textViewer = textViewer;
            this.inputDocumentAboutToBeChanged(this.document, textViewer.getDocument());
        }

        public void disconnect() {
            this.textViewer.removeTextInputListener((ITextInputListener)this);
            this.textViewer = null;
            this.document = null;
            for (SharedTextViewerUndoManager undoManager : this.managers.values()) {
                undoManager.disconnect();
            }
            this.managers.clear();
        }

        public void reset() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            SharedTextViewerUndoManager undoManager = this.getUndoManager();
            if (undoManager != null) {
                undoManager.removeListeners();
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            this.document = newInput;
            SharedTextViewerUndoManager undoManager = this.getUndoManager();
            if (undoManager == null) {
                undoManager = new SharedTextViewerUndoManager(this.undoLevel, this.jetEditor, this.textViewer, this.document);
                this.managers.put(this.document, undoManager);
            }
            undoManager.addListeners();
        }

        public void beginCompoundChange() {
            if (this.compoundChange++ == 0) {
                for (SharedTextViewerUndoManager sharedTextViewerUndoManager : this.managers.values()) {
                    sharedTextViewerUndoManager.beginCompoundChange();
                }
            }
        }

        public void endCompoundChange() {
            if (--this.compoundChange == 0) {
                for (SharedTextViewerUndoManager sharedTextViewerUndoManager : this.managers.values()) {
                    sharedTextViewerUndoManager.endCompoundChange();
                }
            }
        }

        public void setMaximalUndoLevel(int undoLevel) {
            this.getUndoManager().setMaximalUndoLevel(undoLevel);
        }

        public boolean undoable() {
            return this.getUndoManager().undoable();
        }

        public boolean redoable() {
            return this.getUndoManager().redoable();
        }

        public void undo() {
            this.getUndoManager().undo();
        }

        public void redo() {
            this.getUndoManager().redo();
        }
    }

    static class DelegatingContentAssistProcessor
    implements IContentAssistProcessor {
        private static final Pattern IGNORED_PROPOSAL_PATTERN = Pattern.compile("^(((TEXT)?_([0-9]+))|nl|(NL(_[0-9]+)?)) : String");
        private final JETEditor jetEditor;
        private final JETContentAssistProcessor jetContentAssistProcessor;
        private IContentAssistProcessor javaContentAssistProcessor;
        private IContentAssistProcessor delegate;

        public DelegatingContentAssistProcessor(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
            this.jetContentAssistProcessor = new JETContentAssistProcessor(jetEditor);
        }

        protected IContentAssistProcessor getJavaAssistProcessor() {
            if (this.javaContentAssistProcessor == null) {
                IContentAssistant contentAssist = this.jetEditor.getJavaEditor().getContentAssist();
                this.javaContentAssistProcessor = contentAssist.getContentAssistProcessor("__dftl_partition_content_type");
            }
            return this.javaContentAssistProcessor;
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            JETToken token = this.jetEditor.getTokenAt(offset);
            if (token == JETContentRule.TOKEN || token == JETTrailingWhitespaceContentRule.TOKEN || token == JETDirectiveRule.TOKEN || token == null) {
                this.delegate = this.jetContentAssistProcessor;
                return this.jetContentAssistProcessor.computeCompletionProposals(viewer, offset);
            }
            if (token == JETScriptletRule.TOKEN || token == JETExpressionRule.TOKEN) {
                this.delegate = this.getJavaAssistProcessor();
                SourceViewer javaSourceViewer = this.jetEditor.getJavaEditor().getJavaSourceViewer();
                Point javaSelectionRange = javaSourceViewer.getSelectedRange();
                int javaCaretOffset = javaSelectionRange.x + javaSelectionRange.y;
                ICompletionProposal[] proposals = this.delegate.computeCompletionProposals((ITextViewer)javaSourceViewer, javaCaretOffset);
                ArrayList<CompletionProposalDelegate> filteredProposals = new ArrayList<CompletionProposalDelegate>();
                HashSet<String> duplicates = new HashSet<String>();
                ICompletionProposal[] iCompletionProposalArray = proposals;
                int n = proposals.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompletionProposal completionProposal = iCompletionProposalArray[n2];
                    String displayString = completionProposal.getDisplayString();
                    if (duplicates.add(displayString) && !IGNORED_PROPOSAL_PATTERN.matcher(displayString).find()) {
                        filteredProposals.add(new CompletionProposalDelegate(completionProposal, this.jetEditor));
                    }
                    ++n2;
                }
                return filteredProposals.toArray(new ICompletionProposal[filteredProposals.size()]);
            }
            return null;
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            JETToken token = this.jetEditor.getTokenAtSelection(0);
            return (char[])(token == JETScriptletRule.TOKEN || token == JETExpressionRule.TOKEN ? this.getJavaAssistProcessor().getCompletionProposalAutoActivationCharacters() : null);
        }

        public char[] getContextInformationAutoActivationCharacters() {
            JETToken token = this.jetEditor.getTokenAtSelection(0);
            return (char[])(token == JETScriptletRule.TOKEN || token == JETExpressionRule.TOKEN ? this.getJavaAssistProcessor().getContextInformationAutoActivationCharacters() : null);
        }

        public String getErrorMessage() {
            return this.delegate != null ? this.delegate.getErrorMessage() : null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }
    }

    static class DelegatingQuickAssistProcessor
    implements IQuickAssistProcessor {
        private JETEditor jetEditor;

        public DelegatingQuickAssistProcessor(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
        }

        protected IQuickAssistProcessor getJavaAssistProcessor(IQuickAssistInvocationContext invocationContext) {
            JavaEditor javaEditor = this.jetEditor.getJavaEditor();
            IQuickAssistAssistant quickAssistAssistant = javaEditor.getQuickAssistAssistant();
            if (invocationContext != null) {
                try {
                    ArrayList resultingAnnotations = new ArrayList();
                    JavaCorrectionAssistant.collectQuickFixableAnnotations((ITextEditor)javaEditor, (int)invocationContext.getOffset(), (invocationContext.getLength() != 0 ? 1 : 0) != 0, resultingAnnotations);
                    Field fCurrentAnnotationsField = quickAssistAssistant.getClass().getDeclaredField("fCurrentAnnotations");
                    fCurrentAnnotationsField.setAccessible(true);
                    fCurrentAnnotationsField.set(quickAssistAssistant, resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return quickAssistAssistant.getQuickAssistProcessor();
        }

        protected IQuickAssistInvocationContext getJavaInvocationContext(IQuickAssistInvocationContext invocationContext) {
            JETToken token = this.jetEditor.getTokenAt(invocationContext.getOffset());
            if (token == JETScriptletRule.TOKEN || token == JETExpressionRule.TOKEN) {
                SourceViewer javaSourceViewer = this.jetEditor.getJavaEditor().getJavaSourceViewer();
                Point javaSelectionRange = javaSourceViewer.getSelectedRange();
                return new TextInvocationContext((ISourceViewer)javaSourceViewer, javaSelectionRange.x, javaSelectionRange.y);
            }
            return null;
        }

        public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
            IQuickAssistInvocationContext javaInvocationContext = this.getJavaInvocationContext(invocationContext);
            return javaInvocationContext != null && this.getJavaAssistProcessor(javaInvocationContext).canAssist(javaInvocationContext);
        }

        public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
            ICompletionProposal[] quickAssistProposals;
            IQuickAssistInvocationContext javaInvocationContext = this.getJavaInvocationContext(invocationContext);
            if (javaInvocationContext != null && (quickAssistProposals = this.getJavaAssistProcessor(javaInvocationContext).computeQuickAssistProposals(javaInvocationContext)) != null) {
                ArrayList<CompletionProposalDelegate> delegatingProposals = new ArrayList<CompletionProposalDelegate>(quickAssistProposals.length);
                ICompletionProposal[] iCompletionProposalArray = quickAssistProposals;
                int n = quickAssistProposals.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompletionProposal completionProposal = iCompletionProposalArray[n2];
                    delegatingProposals.add(new CompletionProposalDelegate(completionProposal, this.jetEditor));
                    ++n2;
                }
                return delegatingProposals.toArray(new ICompletionProposal[delegatingProposals.size()]);
            }
            return null;
        }

        public String getErrorMessage() {
            return this.getJavaAssistProcessor(null).getErrorMessage();
        }

        public boolean canFix(Annotation annotation) {
            return this.getJavaAssistProcessor(null).canFix(annotation);
        }
    }

    static class DelegatingTextHover
    implements IJavaEditorTextHover,
    ITextHoverExtension,
    ITextHoverExtension2 {
        private final JavadocHover javadocHover = new JavadocHover();
        private final JETEditor jetEditor;
        private DefaultTextHover defaultTextHover;
        private ISourceViewer javaTextViewer;

        public DelegatingTextHover(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
        }

        public void setEditor(IEditorPart editor) {
            this.javadocHover.setEditor(editor);
            this.javaTextViewer = ((JavaEditor)editor).getJavaSourceViewer();
            this.defaultTextHover = new DefaultTextHover(this.jetEditor.getSourceViewer());
        }

        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            return this.defaultTextHover.getHoverRegion(textViewer, offset);
        }

        public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
            IRegion javaRegion = this.toJava(hoverRegion);
            return javaRegion == null ? this.defaultTextHover.getHoverInfo(textViewer, hoverRegion) : this.javadocHover.getHoverInfo((ITextViewer)this.javaTextViewer, javaRegion);
        }

        public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
            IRegion javaRegion = this.toJava(hoverRegion);
            return javaRegion == null ? null : this.javadocHover.getHoverInfo2((ITextViewer)this.javaTextViewer, javaRegion);
        }

        public IInformationControlCreator getHoverControlCreator() {
            return this.javadocHover.getHoverControlCreator();
        }

        private IRegion toJava(IRegion templateRegion) {
            Position correspondingJavaPoint = this.jetEditor.getCorrespondingJavaPosition(templateRegion.getOffset(), templateRegion.getLength());
            if (correspondingJavaPoint != null) {
                return new Region(correspondingJavaPoint.getOffset(), correspondingJavaPoint.getLength());
            }
            return null;
        }
    }

    static abstract class JETAbstractBaseAction
    extends Action {
        protected final JETEditor jetEditor;

        public JETAbstractBaseAction(JETEditor jetEditor, String text, ImageDescriptor imageDescriptor) {
            super(text, imageDescriptor);
            this.jetEditor = jetEditor;
        }

        public void run() {
            SourceViewer jetSourceViewer = this.jetEditor.getJETSourceViewer();
            final IDocument jetDocument = jetSourceViewer.getDocument();
            final SourceViewer javaSourceViewer = this.jetEditor.getJavaSourceViewer();
            IDocument javaDocument = javaSourceViewer.getDocument();
            JETCompilationUnit compilationUnit = this.jetEditor.getCompilationUnit();
            List javaItems = compilationUnit.getJavaItems(this.jetEditor.getFileID());
            ArrayList<TrackedPosition> jetPositions = new ArrayList<TrackedPosition>(javaItems.size());
            try {
                for (JETJavaItem jetJavaItem : javaItems) {
                    if (!(jetJavaItem instanceof JETScriptletItem) && !(jetJavaItem instanceof JETExpressionItem)) continue;
                    TrackedPosition jetPosition = new TrackedPosition(TrackedPosition.Type.JET);
                    jetPosition.addToDocument(jetDocument);
                    jetPosition.update(jetJavaItem);
                    TrackedPosition javaPosition = new TrackedPosition(TrackedPosition.Type.JAVA);
                    javaPosition.addToDocument(javaDocument);
                    javaPosition.update(jetJavaItem);
                    jetPosition.setOpposite(javaPosition);
                    jetPositions.add(jetPosition);
                }
                JavaDocumentTransaction javaDocumentTransaction = new JavaDocumentTransaction(this.jetEditor, jetPositions, this.isTransformBraces(), this.isIgnoreOutOfScopeChanges()){

                    @Override
                    protected void start() {
                        DocumentRewriteSessionType documentRewriteSessionType = this.getDocumentRewriteSessionType();
                        if (documentRewriteSessionType != null) {
                            this.startDocumentRewriteSession((ISourceViewer)javaSourceViewer, documentRewriteSessionType, this.isRememberSelection());
                        }
                        this.start();
                    }

                    @Override
                    protected void postCommit(List<TrackedPosition> jetPositions) {
                        this.postProcess(jetDocument, jetPositions);
                    }

                    @Override
                    protected void stop() {
                        for (TrackedPosition jetPosition : this.jetPositions) {
                            TrackedPosition javaPosition = jetPosition.getOpposite();
                            jetPosition.dispose();
                            javaPosition.dispose();
                        }
                        this.stop();
                        DocumentRewriteSessionType documentRewriteSessionType = this.getDocumentRewriteSessionType();
                        if (documentRewriteSessionType != null) {
                            this.stopDocumentRewriteSession((ISourceViewer)javaSourceViewer, this.isRememberSelection());
                        }
                    }
                };
                javaDocumentTransaction.modify(javaDocument, new SneakyRunnable(){

                    @Override
                    public void execute() throws Exception {
                        this.doRun();
                    }
                });
                this.jetEditor.openDialog(String.valueOf(this.getText().replace("&", "")) + " Failure", javaDocumentTransaction.getStatus());
            }
            catch (Exception exception) {
                CodeGenUIPlugin.getPlugin().log(exception);
            }
        }

        protected DocumentRewriteSessionType getDocumentRewriteSessionType() {
            return null;
        }

        protected boolean isRememberSelection() {
            return this.getDocumentRewriteSessionType() != null;
        }

        protected boolean isTransformBraces() {
            return false;
        }

        boolean isIgnoreOutOfScopeChanges() {
            return false;
        }

        protected void start() {
        }

        protected abstract void doRun() throws Exception;

        protected void postProcess(IDocument jetDocument, List<TrackedPosition> jetPositions) {
        }

        protected void stop() {
        }
    }

    static class JETBaseErrorRule
    extends JETRule
    implements IRule {
        public JETBaseErrorRule(JETToken successToken, char[] prefix) {
            super(successToken, prefix);
        }

        @Override
        protected IToken doEvaluate(ICharacterScanner scanner) {
            if (this.scanForStart(scanner)) {
                int read = this.read(scanner);
                while (read != -1) {
                    read = this.read(scanner);
                }
                return this.getSuccessToken();
            }
            if (this.read(scanner) == -1) {
                return Token.EOF;
            }
            this.unreadAll(scanner);
            return Token.UNDEFINED;
        }
    }

    static class JETBracketMatcher
    extends DefaultCharacterPairMatcher {
        private static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>', '%', '%', '=', '%', '@', '%'};
        private final JETEditor jetEditor;
        private int customAnchor;

        public JETBracketMatcher(JETEditor jetEditor) {
            super(BRACKETS);
            this.jetEditor = jetEditor;
        }

        private JETToken getToken(int offset) {
            return this.jetEditor.getTokenAt(offset);
        }

        private Point getTokenRange(int offset) {
            return this.jetEditor.getTokenRangeAt(offset);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IRegion match(IDocument document, int offset) {
            JavaEditor javaEditor;
            IRegion jetMatch;
            Point tokenRange;
            JETToken token = this.getToken(offset);
            if (token == null) {
                return null;
            }
            if (token.getBaseToken() == JETContentRule.TOKEN) {
                if (offset <= 1) return null;
                token = this.getToken(offset - 1);
                if (token == null || token.getBaseToken() == JETContentRule.TOKEN) {
                    return null;
                }
                tokenRange = this.getTokenRange(offset - 1);
            } else {
                tokenRange = this.getTokenRange(offset);
            }
            try {
                while (document.getChar(tokenRange.x) == ' ') {
                    ++tokenRange.x;
                    --tokenRange.y;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            int effectiveOffset = offset;
            boolean isCloseBrace = false;
            if (token == JETScriptletRule.TOKEN && tokenRange.y == 5) {
                try {
                    isCloseBrace = "<%}%>".equals(document.get(tokenRange.x, tokenRange.y));
                    if (isCloseBrace) {
                        effectiveOffset = tokenRange.x + 3;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (!isCloseBrace && (jetMatch = token.match(tokenRange, offset)) != null) {
                this.customAnchor = offset > jetMatch.getOffset() + jetMatch.getLength() - 2 ? 0 : 1;
                return jetMatch;
            }
            if ((token == JETScriptletRule.TOKEN || token == JETExpressionRule.TOKEN) && (javaEditor = this.jetEditor.getJavaEditor()) != null) {
                SourceViewer javaSourceViewer = javaEditor.getJavaSourceViewer();
                IDocument javaDocument = javaSourceViewer.getDocument();
                DefaultCharacterPairMatcher javaBracketMatcher = javaEditor.getJavaBracketMatcher();
                if (javaBracketMatcher != null) {
                    Position correspondingJavaPoint = this.jetEditor.getCorrespondingJavaPosition(effectiveOffset, 0);
                    if (correspondingJavaPoint == null) {
                        return null;
                    }
                    IRegion javaRegion = javaBracketMatcher.match(javaDocument, correspondingJavaPoint.offset);
                    if (javaRegion == null) {
                        return null;
                    }
                    Position correspondingTemplatePointStart = this.jetEditor.getCorrespondingTemplatePosition(javaRegion.getOffset(), 0);
                    if (correspondingTemplatePointStart == null) {
                        return null;
                    }
                    Position correspondingTemplatePositionEnd = this.jetEditor.getCorrespondingTemplatePosition(javaRegion.getOffset() + javaRegion.getLength() - 1, 0);
                    if (correspondingTemplatePositionEnd == null) {
                        return null;
                    }
                    this.customAnchor = javaBracketMatcher.getAnchor();
                    if (this.customAnchor != -1) {
                        return new Region(correspondingTemplatePointStart.offset, correspondingTemplatePositionEnd.offset - correspondingTemplatePointStart.offset + 1);
                    }
                }
            }
            this.customAnchor = -1;
            return null;
        }

        public int getAnchor() {
            return this.customAnchor == -1 ? super.getAnchor() : this.customAnchor;
        }
    }

    static class JETBreadcrumbViewer
    extends BreadcrumbViewer {
        public JETBreadcrumbViewer(Composite parent, int style) {
            super(parent, style);
            this.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    Widget item = this.findItem(((ITreeContentProvider)this.getContentProvider()).getParent(element));
                    if (item != null) {
                        try {
                            Method openDropDownMenuMethod = item.getClass().getDeclaredMethod("openDropDownMenu", new Class[0]);
                            openDropDownMenuMethod.setAccessible(true);
                            openDropDownMenuMethod.invoke((Object)item, new Object[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }

        protected void configureDropDownViewer(TreeViewer viewer, Object input) {
        }

        public Control getControl() {
            return super.getControl();
        }
    }

    static class JETCommentErrorRule
    extends JETBaseErrorRule {
        public static final JETToken TOKEN = new JETToken(JETCommentRule.TOKEN, "error", 0x20000000);

        public JETCommentErrorRule() {
            super(TOKEN, JETCommentRule.PREFIX);
        }
    }

    static class JETCommentRule
    extends JETRule
    implements IRule {
        private static final char[] PREFIX = new char[]{'<', '%', '-'};
        public static final JETToken TOKEN = new JETToken("comment");

        public JETCommentRule() {
            super(TOKEN, PREFIX);
        }

        @Override
        protected boolean scanForEnd(ICharacterScanner scanner) {
            int character = this.read(scanner);
            while (character != -1) {
                if (character == 45) {
                    if (this.read(scanner) == 37) {
                        if (this.read(scanner) == 62) {
                            return true;
                        }
                        this.unread(scanner);
                    } else {
                        this.unread(scanner);
                    }
                }
                character = this.read(scanner);
            }
            return false;
        }
    }

    static class JETCompilerResult {
        private final IFile javaFile;
        private final JETCompilationUnit compilationUnit;
        private final List<IProblem> javaProblems;
        private final JETException jetException;
        private final Map<Integer, List<JETProblemAnnotation>> problemAnnotations = new HashMap<Integer, List<JETProblemAnnotation>>();

        public JETCompilerResult(IFile javaFile, JETCompilationUnit compilationUnit, List<IProblem> javaProblems, JETException jetException) {
            this.javaFile = javaFile;
            this.compilationUnit = compilationUnit;
            this.javaProblems = javaProblems;
            this.jetException = jetException;
        }

        public JETCompilerResult(JETException jetException) {
            this.javaFile = null;
            this.compilationUnit = null;
            this.javaProblems = Collections.emptyList();
            this.jetException = jetException;
        }

        public IFile getJavaFile() {
            return this.javaFile;
        }

        public JETException getJETException() {
            return this.jetException;
        }

        public List<IProblem> getJavaProblems() {
            return this.javaProblems;
        }

        public JETCompilationUnit getCompilationUnit() {
            return this.compilationUnit;
        }

        public List<JETProblemAnnotation> getProblem(JETItem jetItem) {
            int fileID = jetItem.getFileID();
            List<JETProblemAnnotation> allProblems = this.getProblems(fileID);
            if (!allProblems.isEmpty()) {
                ArrayList<JETProblemAnnotation> result = new ArrayList<JETProblemAnnotation>();
                int startOffset = jetItem.getStartOffset();
                int stopOffset = jetItem.getStopOffset();
                for (JETProblemAnnotation problem : allProblems) {
                    Position position = problem.getPosition();
                    if (stopOffset <= position.offset || startOffset >= position.offset + position.length) continue;
                    result.add(problem);
                }
                return result;
            }
            return Collections.emptyList();
        }

        public List<JETProblemAnnotation> getProblems(int fileID) {
            if (fileID < 0) {
                JETProblemAnnotation jetOrphanProblemAnnotation = new JETProblemAnnotation(1, "This file is no longer included by the template", new Position(0, 0));
                return Collections.singletonList(jetOrphanProblemAnnotation);
            }
            List<JETProblemAnnotation> jetProblemAnnotations = this.problemAnnotations.get(fileID);
            if (jetProblemAnnotations == null) {
                JETProblemAnnotation jetExceptionProblemAnnotation;
                jetProblemAnnotations = new ArrayList<JETProblemAnnotation>();
                JETException jetException = this.getJETException();
                if (jetException != null && (jetExceptionProblemAnnotation = this.getExceptionProblem(fileID, jetException)) != null) {
                    jetProblemAnnotations.add(jetExceptionProblemAnnotation);
                }
                JETCompilationUnit result = this.getCompilationUnit();
                if (this.compilationUnit != null) {
                    List jetProblems = result.getProblems();
                    for (JETException jetProblem : jetProblems) {
                        JETProblemAnnotation jetExceptionProblemAnnotation2 = this.getExceptionProblem(fileID, jetProblem);
                        if (jetExceptionProblemAnnotation2 == null) continue;
                        jetProblemAnnotations.add(jetExceptionProblemAnnotation2);
                    }
                    List<IProblem> javaProblems = this.getJavaProblems();
                    for (IProblem problem : javaProblems) {
                        int end;
                        int start = problem.getSourceStart();
                        int[] correspondingTemplatePoint = result.getClosestCorrespondingTemplatePoint(fileID, start, (end = problem.getSourceEnd() + 1) == 0 ? 0 : end - start);
                        if (correspondingTemplatePoint == null) continue;
                        String message = problem.getMessage();
                        JETProblemAnnotation jetProblemAnnotation = new JETProblemAnnotation(problem.isError() ? 2 : (problem.isWarning() ? 1 : 0), message, new Position(correspondingTemplatePoint[0], correspondingTemplatePoint[1]));
                        jetProblemAnnotations.add(jetProblemAnnotation);
                    }
                }
            }
            this.problemAnnotations.put(fileID, jetProblemAnnotations);
            return jetProblemAnnotations;
        }

        protected JETProblemAnnotation getExceptionProblem(int fileID, JETException exception) {
            int severity;
            int index;
            String message;
            int offset = -1;
            int length = 0;
            boolean locatedInThisFile = false;
            JETMark start = exception.getStart();
            while (start != null) {
                if (start.getFileId() == fileID) {
                    offset = start.getCursor();
                    JETMark stop = exception.getStop();
                    boolean bl = locatedInThisFile = stop.getFileId() == fileID;
                    if (!locatedInThisFile) break;
                    length = stop.getCursor() - offset;
                    break;
                }
                start = start.getParentMark();
            }
            if (offset == -1) {
                message = exception.getLocalizedMessage();
                int severity2 = exception.getDiagnostic().getSeverity();
                int problemSeverity = severity2 == 1 ? 0 : (severity2 == 2 ? 1 : 2);
                JETProblemAnnotation jetProblemAnnotation = new JETProblemAnnotation(problemSeverity, message, new Position(0, length));
                return jetProblemAnnotation;
            }
            message = exception.getLocalizedMessage();
            if (locatedInThisFile && (index = message.indexOf(" in ")) != -1) {
                message = message.substring(0, index);
            }
            int problemSeverity = (severity = exception.getDiagnostic().getSeverity()) == 1 ? 0 : (severity == 2 ? 1 : 2);
            JETProblemAnnotation jetProblemAnnotation = new JETProblemAnnotation(problemSeverity, message, new Position(offset, length));
            return jetProblemAnnotation;
        }
    }

    static class JETContentAssistProcessor
    extends TemplateCompletionProcessor {
        private static final Map<String, JETTemplateContextType> JET_CONTEXT_TYPES = new HashMap<String, JETTemplateContextType>();
        private static final Map<JETToken, JETTemplateContextType> JET_TOKEN_CONTEXT_TYPES = new HashMap<JETToken, JETTemplateContextType>();
        private static Image JET_IMAGE = CodeGenUIPlugin.getPlugin().getActualImage("full/obj16/JET");
        private final JETEditor jetEditor;

        static {
            new JETContentContextType();
            new JETDirectiveContextType();
        }

        public JETContentAssistProcessor(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
        }

        protected Template[] getTemplates(String contextTypeId) {
            JETTemplateContextType jetTemplateContextType = JET_CONTEXT_TYPES.get(contextTypeId);
            return jetTemplateContextType == null ? null : jetTemplateContextType.getTemplates(this.jetEditor.getEditorInput());
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            try {
                var4_3 = super.computeCompletionProposals(viewer, offset);
                return var4_3;
            }
            finally {
                ** for (jetTemplateContextType : JETContentAssistProcessor.JET_CONTEXT_TYPES.values())
            }
lbl-1000:
            // 1 sources

            {
                jetTemplateContextType.resetContext();
                continue;
            }
lbl8:
            // 1 sources

            return var4_3;
        }

        protected String extractPrefix(ITextViewer viewer, int offset) {
            return "";
        }

        protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
            return new JETTemplateProposal(template, context, region, this.getImage(template), relevance);
        }

        protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
            JETTokenRegion tokenRegion = this.jetEditor.getTokenRegionAt(region.getOffset());
            JETToken token = tokenRegion == null || tokenRegion.getOffset() == region.getOffset() ? JETContentRule.TOKEN : tokenRegion.getToken();
            JETTemplateContextType jetTemplateContextType = JET_TOKEN_CONTEXT_TYPES.get((Object)token.getBaseToken());
            if (jetTemplateContextType != null) {
                jetTemplateContextType.setContext(this.jetEditor, region);
            }
            return jetTemplateContextType;
        }

        protected Image getImage(Template template) {
            return JET_IMAGE;
        }

        static class JETContentContextType
        extends JETTemplateContextType {
            private static String ID = "org.eclipse.code.ui.jet.content";
            private static Pattern JET_DIRECTIVE_PATTERN = Pattern.compile("\\s*<%@\\s*jet\\s+.*%>", 32);
            private static final Template JET_DIRECTIVE_TEMPLATE = new Template("<%@jet%>", "@jet directive to minimally specify the Java class name", ID, "<%@jet package=\"${java_package_name}\" class=\"${java_class_name}\" imports=\"${java_imports}\"%>\n", true);
            private static final Template JET_SCRIPTLET_TEMPLATE = new Template("<%%>", "scriptlet for specifying Java statement logic", ID, "<%${}%>", true);
            private static final Template JET_EXPRESSION_TEMPLATE = new Template("<%=%>", "expression for specifying Java expression logic", ID, "<%=${}%>", true);
            private static final Template JET_SIMPLE_INCLUDE_TEMPLATE = new Template("<%@include%>", "@include directive for including a 'jetinc' file", ID, "<%@include file=\"${file}\"%>", true);
            private static final Template JET_OPTIONAL_INCLUDE_TEMPLATE = new Template("<%@include fail=\"silent\"%>", "@include directive for including a 'jetinc' file, ignoring when it doesn't exist", ID, "<%@include file=\"${file}\" fail=\"silent\"%>", true);
            private static final Template JET_ALTERNATIVE_INCLUDE_TEMPLATE = new Template("<%@include fail=\"alternative\"%>", "@include directive for including a 'jetinc' file, using the @start/@end block when it doesn't exist", ID, "<%@include file=\"${file}\" fail=\"alternative\"%>\n<%@start%>\n${}<%@end%>\n", true);
            private static final Template JET_COPYRIGHT_COMMENT_TEMPLATE = new Template("<%--copyright--%>", "a comment at the start of the file for specifying the copyright", ID, "<%--\nCopyright " + System.getProperty("user.name") + " " + Calendar.getInstance().get(1) + "\n--%>\n", true);
            private static final Template JET_COMMENT_TEMPLATE = new Template("<%--%>", "comment for specifying excluded content", ID, "<%-${}-%>", true);
            private static final Template JET_COMMENT_TEMPLATE_WITH_TAG = new Template("<%-[]-%>", "comment for specifying a tag in the content outline", ID, "<%-[${Tag}]-%>", true);

            public JETContentContextType() {
                super(ID, JETContentRule.TOKEN);
            }

            private Template convert(Template template, String lineDelimeter) {
                return new Template(template.getName(), template.getDescription(), template.getContextTypeId(), template.getPattern().replace("\n", lineDelimeter), template.isAutoInsertable());
            }

            @Override
            public Template[] getTemplates(IEditorInput input) {
                boolean isJET;
                ISourceViewer viewer = this.getEditor().getSourceViewer();
                IDocument document = viewer.getDocument();
                String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                ArrayList<Template> result = new ArrayList<Template>();
                if (viewer.getSelectedRange().x == 0) {
                    result.add(this.convert(JET_COPYRIGHT_COMMENT_TEMPLATE, lineDelimiter));
                }
                boolean bl = isJET = input == null || input.getName() == null || input.getName().endsWith("jet");
                if (isJET) {
                    try {
                        JETCompilationUnit compilationUnit;
                        IRegion lineInformation = document.getLineInformation(0);
                        String firstLine = document.get(lineInformation.getOffset(), lineInformation.getLength());
                        if (!(JET_DIRECTIVE_PATTERN.matcher(firstLine).matches() || (compilationUnit = this.getEditor().getCompilationUnit()) != null && compilationUnit.getJETJETDirectiveItem() != null && compilationUnit.getJETJETDirectiveItem().getLength() != 0)) {
                            result.add(this.convert(JET_DIRECTIVE_TEMPLATE, lineDelimiter));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                result.add(this.convert(JET_SCRIPTLET_TEMPLATE, lineDelimiter));
                result.add(this.convert(JET_EXPRESSION_TEMPLATE, lineDelimiter));
                result.add(this.convert(JET_SIMPLE_INCLUDE_TEMPLATE, lineDelimiter));
                result.add(this.convert(JET_OPTIONAL_INCLUDE_TEMPLATE, lineDelimiter));
                result.add(this.convert(JET_ALTERNATIVE_INCLUDE_TEMPLATE, lineDelimiter));
                result.add(this.convert(JET_COMMENT_TEMPLATE, lineDelimiter));
                result.add(this.convert(JET_COMMENT_TEMPLATE_WITH_TAG, lineDelimiter));
                return result.toArray(new Template[result.size()]);
            }
        }

        private static class JETDirectiveContextType
        extends JETTemplateContextType {
            private static String ID = "org.eclipse.code.ui.jet.directive";
            private static final Map<String, List<Template>> ATTRIBUTE_TEMPLATES = new HashMap<String, List<Template>>();

            static {
                ArrayList<Template> jetTemplates = new ArrayList<Template>();
                jetTemplates.add(new Template("class", "specify the Java class name of the class", ID, "class=\"${java_class_name}\"", false));
                jetTemplates.add(new Template("package", "specify the Java package name of the class", ID, "package=\"${java_package_name}\"", false));
                jetTemplates.add(new Template("imports", "specify the Java imports for the class", ID, "imports=\"${java_imports}\"", false));
                jetTemplates.add(new Template("builder", "specify the builder to be used in the generate method of the class", ID, "builder=\"StringBuilder ${builder} = new StringBuilder()\"", false));
                jetTemplates.add(new Template("minimize", "whether to mimize the footprint of the literal constants of the class", ID, "minimize=\"${true}\"", false));
                jetTemplates.add(new Template("nlString", "specify the Java expression used to extract the default line delimiter of the class", ID, "nlString=\"${global_expression}\"", false));
                jetTemplates.add(new Template("skeleton", "specify a Java class to be used as the skeleton of the class", ID, "skeleton=\"${skeleton_java_file}\"", false));
                jetTemplates.add(new Template("version", "specify and arbtirary used version for the templates", ID, "version=\"${version}\"", false));
                ATTRIBUTE_TEMPLATES.put("jet", jetTemplates);
                ArrayList<Template> includeTemplates = new ArrayList<Template>();
                includeTemplates.add(new Template("file", "specify file to include in the template", ID, "file=\"${file}\"", false));
                includeTemplates.add(new Template("fail", "specify to ignore a missing file", ID, "fail=\"${silent}\"", false));
                ATTRIBUTE_TEMPLATES.put("include", includeTemplates);
            }

            public JETDirectiveContextType() {
                super(ID, JETDirectiveRule.TOKEN);
            }

            private Template convert(Template template, String prefix, String suffix) {
                return new Template(template.getName(), template.getDescription(), template.getContextTypeId(), String.valueOf(prefix) + template.getPattern() + suffix, template.isAutoInsertable());
            }

            @Override
            public Template[] getTemplates(IEditorInput input) {
                JETEditor jetEditor = this.getEditor();
                IRegion region = this.getRegion();
                int offset = region.getOffset() + region.getLength();
                JETTokenRegion tokenRegion = jetEditor.getTokenRegionAt(offset);
                try {
                    ArrayList<Template> result = new ArrayList<Template>();
                    int tokenRegionOffset = tokenRegion.getOffset();
                    int tokenRegionLength = tokenRegion.getLength();
                    String directive = jetEditor.getSourceViewer().getDocument().get(tokenRegionOffset, tokenRegionLength);
                    JETDirectiveItem jetDirectiveItem = JETParser.parseDirective((String)directive);
                    JETAttributeListItem attributes = jetDirectiveItem.getAttributes();
                    int relativeOffset = offset - tokenRegionOffset;
                    JETItem nameItem = jetDirectiveItem.getNameItem();
                    String directiveName = nameItem.getText();
                    List<Template> templates = ATTRIBUTE_TEMPLATES.get(directiveName);
                    if (templates != null) {
                        boolean valid = false;
                        JETItem previousItem = nameItem;
                        for (JETAttributeItem jetAttributeItem : attributes.getAttributes()) {
                            int previousStopOffset = previousItem.getStopOffset();
                            int nextStartOffset = jetAttributeItem.getStartOffset();
                            if (relativeOffset >= previousStopOffset && relativeOffset <= nextStartOffset) {
                                valid = true;
                                break;
                            }
                            previousItem = jetAttributeItem;
                        }
                        if (!valid && relativeOffset >= attributes.getStopOffset() && relativeOffset <= tokenRegionLength - 2) {
                            valid = true;
                        }
                        if (valid) {
                            char characterBeforeInsertion = directive.charAt(relativeOffset - 1);
                            char characterAfterInsertion = directive.charAt(relativeOffset);
                            String prefix = Character.isWhitespace(characterBeforeInsertion) ? "" : " ";
                            String suffix = Character.isWhitespace(characterAfterInsertion) || characterAfterInsertion == '%' ? "" : " ";
                            for (Template template : templates) {
                                if (jetDirectiveItem.getAttribute(template.getName()) != null) continue;
                                result.add(this.convert(template, prefix, suffix));
                            }
                        }
                    }
                    return result.toArray(new Template[result.size()]);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }

        static class JETTemplateContextType
        extends TemplateContextType {
            private JETEditor jetEditor;
            private IRegion region;

            public JETTemplateContextType(String id, JETToken token) {
                super(id);
                JET_CONTEXT_TYPES.put(id, this);
                JET_TOKEN_CONTEXT_TYPES.put(token, this);
            }

            public JETEditor getEditor() {
                return this.jetEditor;
            }

            public IRegion getRegion() {
                return this.region;
            }

            public void setContext(JETEditor jetEditor, IRegion region) {
                this.jetEditor = jetEditor;
                this.region = region;
            }

            public void resetContext() {
                this.jetEditor = null;
                this.region = null;
            }

            public Template[] getTemplates(IEditorInput input) {
                return null;
            }
        }

        private static class JETTemplateProposal
        extends TemplateProposal
        implements ICompletionProposalExtension6 {
            private StyledString displayString;

            public JETTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
                super(template, context, region, image, relevance);
            }

            public String getDisplayString() {
                return this.getStyledDisplayString().toString();
            }

            public StyledString getStyledDisplayString() {
                if (this.displayString == null) {
                    String name = this.getTemplate().getName();
                    String description = this.getTemplate().getDescription();
                    this.displayString = new StyledString(name, StyledString.COUNTER_STYLER);
                    this.displayString.append(" - ");
                    this.displayString.append(description, StyledString.QUALIFIER_STYLER);
                }
                return this.displayString;
            }
        }
    }

    static class JETContentOutlinePage
    extends ContentOutlinePage {
        private final ItemManager itemManager = new ItemManager();
        private final LabelProvider labelProvider = new LabelProvider();
        private final ContentProvider contentProvider = new ContentProvider();
        private final ISelectionChangedListener jetSourceViewerSynchronizer = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (treeViewer != null && !treeViewer.getControl().isFocusControl()) {
                    Item correspondingItem;
                    ITextSelection selection = (ITextSelection)event.getSelection();
                    int offset = selection.getOffset();
                    JETItem jetItem = jetEditor.getJETItem(offset, false);
                    if (jetItem != null && (correspondingItem = itemManager.getRootItem().getCorrespondingItem(jetItem)) != null) {
                        this.setSelection((ISelection)new StructuredSelection((Object)correspondingItem), true);
                    }
                }
            }
        };
        private final JETEditor jetEditor;
        private TreeViewer treeViewer;

        public JETContentOutlinePage(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
        }

        public StyledCellLabelProvider newLabelProvider() {
            return new LabelProvider(){

                @Override
                protected StyledString getStyledText(Object element) {
                    Item item;
                    StyledString styledText = super.getStyledText(element);
                    if (element instanceof Item && (item = (Item)element).isBreadcumbSurrogate()) {
                        int fileID = itemManager.getFileID(item);
                        if (jetEditor.getDocumentManager().isDirty(fileID)) {
                            StyledString newStyledString = new StyledString();
                            newStyledString.append('*');
                            newStyledString.append(styledText);
                            styledText = newStyledString;
                        }
                        if (fileID == jetEditor.getFileID()) {
                            styledText.setStyle(0, styledText.length(), Item.getFontStyler(1));
                        }
                    }
                    return styledText;
                }
            };
        }

        public ITreeContentProvider getContentProvider() {
            return this.contentProvider;
        }

        public Item getSelectionForDocumentID(String documentID) {
            return this.itemManager.getSelectionForDocumentID(documentID);
        }

        public void setSelection(ISelection selection, boolean reveal) {
            if (this.treeViewer != null && !this.treeViewer.getControl().isFocusControl()) {
                this.treeViewer.setSelection(selection, reveal);
            }
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.treeViewer = this.getTreeViewer();
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
            this.treeViewer.setInput((Object)this.itemManager.getRootItem());
            this.jetEditor.getSelectionProvider().addSelectionChangedListener(this.jetSourceViewerSynchronizer);
            this.registerToolBarActions();
        }

        private void registerToolBarActions() {
            IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
            class ExpandAllAction
            extends Action {
                public ExpandAllAction() {
                    super("", CodeGenUIPlugin.getPlugin().getImage("full/ctool16/ExpandAll.png"));
                    this.setToolTipText("Expand all");
                    this.setActionDefinitionId("org.eclipse.ui.navigate.expandAll");
                }

                public void run() {
                    try {
                        JETContentOutlinePage.this.treeViewer.getControl().setRedraw(false);
                        JETContentOutlinePage.this.treeViewer.expandAll();
                    }
                    finally {
                        JETContentOutlinePage.this.treeViewer.getControl().setRedraw(true);
                    }
                }
            }
            toolBarManager.add((IAction)new ExpandAllAction());
            CollapseAllAction collapseAllAction = new CollapseAllAction(this.treeViewer);
            collapseAllAction.setActionDefinitionId("org.eclipse.ui.navigate.collapseAll");
            toolBarManager.add((IAction)collapseAllAction);
        }

        public void dispose() {
            this.treeViewer = null;
            ISelectionProvider selectionProvider = this.jetEditor.getSelectionProvider();
            if (selectionProvider != null) {
                selectionProvider.removeSelectionChangedListener(this.jetSourceViewerSynchronizer);
            }
            super.dispose();
        }

        public void setCompilerResult(JETCompilerResult jetCompilerResult, Map<Integer, String> documentIDs) {
            this.itemManager.setCompilerResult(jetCompilerResult, documentIDs);
            if (this.treeViewer != null) {
                this.treeViewer.refresh();
            }
        }

        public int getFileID(ISelection selection) {
            Item item = this.getSelectedItem(selection);
            return item == null ? 0 : this.itemManager.getFileID(item);
        }

        public Item getSelectedItem(ISelection selection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return (Item)structuredSelection.getFirstElement();
        }

        protected JETItem getSelectedJETItem(ISelection selection) {
            Item selectedItem = this.getSelectedItem(selection);
            return selectedItem == null ? null : selectedItem.getJETItem();
        }

        public Region getRegion(ISelection selection) {
            JETItem selectedJETItem = this.getSelectedJETItem(selection);
            if (selectedJETItem != null) {
                int start = selectedJETItem.getStartOffset();
                int stop = selectedJETItem.getStopOffset();
                return new Region(start, stop - start);
            }
            return null;
        }

        private static class ContentProvider
        implements ITreeContentProvider {
            private ContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                return ((Item)parentElement).getChildren().toArray();
            }

            public Object getParent(Object element) {
                return ((Item)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        private static class Item {
            private static final Map<String, Image> IMAGES = new HashMap<String, Image>();
            private static final Map<String, Image> ERROR_IMAGES = new HashMap<String, Image>();
            private static final Map<String, Image> WARNING_IMAGES = new HashMap<String, Image>();
            private static final Map<String, Image> INFO_IMAGES = new HashMap<String, Image>();
            private static final Map<Integer, Map<String, Image>> ALL_IMAGES = new HashMap<Integer, Map<String, Image>>();
            private static final StyledString.Styler STRIKE_OUT_STYLER;
            private static final StyledString.Styler[] FONT_STYLERS;
            private final List<Item> children = new ArrayList<Item>();
            private final String type;
            private final String signature;
            private Item parent;
            private JETItem jetItem;
            private int problemSeverity = -1;
            private static final Method INFO_METHOD;

            static {
                CodeGenUIPlugin plugin = CodeGenUIPlugin.getPlugin();
                IMAGES.put("start", plugin.getActualImage("full/obj16/DirectiveStart"));
                IMAGES.put("end", plugin.getActualImage("full/obj16/DirectiveEnd"));
                IMAGES.put("include", plugin.getActualImage("full/obj16/DirectiveInclude"));
                IMAGES.put("jet", plugin.getActualImage("full/obj16/JET"));
                IMAGES.put("skeleton", plugin.getActualImage("full/obj16/Skeleton"));
                IMAGES.put("nlstring", plugin.getActualImage("full/obj16/NLString"));
                IMAGES.put("comment", plugin.getActualImage("full/obj16/Comment.png"));
                Image content = plugin.getActualImage("full/obj16/IncludeContent");
                IMAGES.put("content", content);
                IMAGES.put("root", content);
                IMAGES.put("orphan", content);
                ISharedImages sharedImages = JavaUI.getSharedImages();
                IMAGES.put("package", sharedImages.getImage("org.eclipse.jdt.ui.package_obj.gif"));
                IMAGES.put("class", sharedImages.getImage("org.eclipse.jdt.ui.class_obj.gif"));
                IMAGES.put("import", sharedImages.getImage("org.eclipse.jdt.ui.imp_obj.gif"));
                Point size = new Point(16, 16);
                for (Map.Entry<String, Image> entry : IMAGES.entrySet()) {
                    int info = 32;
                    try {
                        info = (Integer)JavaElementImageDescriptor.class.getField("INFO").get(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Image image = new JavaElementImageDescriptor(ImageDescriptor.createFromImage((Image)entry.getValue()), info, size).createImage();
                    INFO_IMAGES.put(entry.getKey(), image);
                }
                for (Map.Entry<String, Image> entry : IMAGES.entrySet()) {
                    Image image = new JavaElementImageDescriptor(ImageDescriptor.createFromImage((Image)entry.getValue()), 32, size).createImage();
                    WARNING_IMAGES.put(entry.getKey(), image);
                }
                for (Map.Entry<String, Image> entry : IMAGES.entrySet()) {
                    Image image = new JavaElementImageDescriptor(ImageDescriptor.createFromImage((Image)entry.getValue()), 64, size).createImage();
                    ERROR_IMAGES.put(entry.getKey(), image);
                }
                ALL_IMAGES.put(-1, IMAGES);
                ALL_IMAGES.put(0, INFO_IMAGES);
                ALL_IMAGES.put(1, WARNING_IMAGES);
                ALL_IMAGES.put(2, ERROR_IMAGES);
                STRIKE_OUT_STYLER = new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.strikeout = true;
                    }
                };
                FONT_STYLERS = new StyledString.Styler[3];
                Method infoMethod = null;
                try {
                    infoMethod = IProblem.class.getMethod("isInfo", new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                INFO_METHOD = infoMethod;
            }

            private static final StyledString.Styler getFontStyler(final int fontStyle) {
                if (fontStyle > 0 && fontStyle < 3) {
                    StyledString.Styler styler = FONT_STYLERS[fontStyle];
                    if (styler == null) {
                        Item.FONT_STYLERS[fontStyle] = styler = new StyledString.Styler(){

                            public void applyStyles(TextStyle textStyle) {
                                ((StyleRange)textStyle).fontStyle = fontStyle;
                            }
                        };
                    }
                    return styler;
                }
                return null;
            }

            public Item(String signature, JETItem jetItem, String type) {
                this.signature = signature;
                this.jetItem = jetItem;
                String string = this.type = type == null ? Item.getDirectiveType(jetItem) : type;
                if ("jet".equals(type)) {
                    this.createJETChildren();
                }
            }

            public Item getCorrespondingItem(JETItem jetItem) {
                for (Item child : this.children) {
                    Item result = child.getCorrespondingItem(jetItem);
                    if (result == null) continue;
                    return result;
                }
                return this.jetItem == jetItem ? this : null;
            }

            public boolean isBreadcumbSurrogate() {
                return "root".equals(this.type) || "orphan".equals(this.type);
            }

            public int handleProblems(JETCompilerResult compilerResult) {
                int maxSeverity = -1;
                for (Item child : this.children) {
                    maxSeverity = Math.max(maxSeverity, child.handleProblems(compilerResult));
                }
                if ("class".equals(this.type)) {
                    int overallSeverity = this.getJavaProblemSeverity(compilerResult.getJavaProblems());
                    maxSeverity = Math.max(maxSeverity, overallSeverity);
                } else if ("content".equals(this.type) || "root".equals(this.type)) {
                    int overallSeverity = this.getProblemSeverity(compilerResult.getProblems(this.jetItem.getFileID()));
                    maxSeverity = Math.max(maxSeverity, overallSeverity);
                } else if ("jet".equals(this.type) && Boolean.TRUE.equals(((JETDirectiveItem)this.jetItem).getData("missing-jet-directive"))) {
                    maxSeverity = 2;
                } else if ("orphan".equals(this.type)) {
                    maxSeverity = 1;
                } else if (this.jetItem != null) {
                    int localSeverity = this.getProblemSeverity(compilerResult.getProblem(this.jetItem));
                    maxSeverity = Math.max(maxSeverity, localSeverity);
                }
                this.problemSeverity = maxSeverity;
                return maxSeverity;
            }

            private static boolean isInfo(IProblem problem) {
                try {
                    return (Boolean)INFO_METHOD.invoke((Object)problem, new Object[0]);
                }
                catch (Exception exception) {
                    return false;
                }
            }

            private int getJavaProblemSeverity(List<IProblem> problems) {
                int result = -1;
                for (IProblem problem : problems) {
                    int severity = Item.isInfo(problem) ? 0 : (problem.isWarning() ? 1 : (problem.isError() ? 2 : -1));
                    if ((result = Math.max(result, severity)) != 2) continue;
                    return 2;
                }
                return result;
            }

            private int getProblemSeverity(List<JETProblemAnnotation> problems) {
                int result = -1;
                for (JETProblemAnnotation problem : problems) {
                    if ((result = Math.max(result, problem.getSeverity())) != 2) continue;
                    return 2;
                }
                return result;
            }

            protected void rebuildMap(HashMap<String, Item> managedItems) {
                managedItems.put(this.signature, this);
                for (Item child : this.children) {
                    child.rebuildMap(managedItems);
                }
            }

            protected void reconcile(Item newItem) {
                Item[] newChildren;
                Item[] existingChildren = this.children.toArray(new Item[this.children.size()]);
                HashMap<String, Item> signatures = new HashMap<String, Item>();
                Item[] itemArray = existingChildren;
                int n = existingChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    Item child = itemArray[n2];
                    child.setParent(null);
                    signatures.put(child.getSignature(), child);
                    ++n2;
                }
                Item[] itemArray2 = newChildren = newItem.children.toArray(new Item[newItem.children.size()]);
                int n3 = newChildren.length;
                n = 0;
                while (n < n3) {
                    Item newChild = itemArray2[n];
                    Item correspondingOldChild = (Item)signatures.get(newChild.getSignature());
                    if (correspondingOldChild == null) {
                        newChild.setParent(this);
                    } else {
                        correspondingOldChild.setParent(this);
                        correspondingOldChild.jetItem = newChild.jetItem;
                        correspondingOldChild.reconcile(newChild);
                    }
                    ++n;
                }
            }

            private void createJETChildren() {
                JETDirectiveItem jetDirectiveItem = (JETDirectiveItem)this.jetItem;
                if (!Boolean.TRUE.equals(jetDirectiveItem.getData("duplicate-jet-directive"))) {
                    JETAttributeItem nlString;
                    JETAttributeItem skeletonAttribute;
                    JETAttributeItem importsAttribute;
                    JETAttributeItem classAttributeItem;
                    JETAttributeItem packageAttributeItem = jetDirectiveItem.getAttribute("package");
                    Item rootItem = this;
                    if (packageAttributeItem != null) {
                        JETValueItem packageValueItem = packageAttributeItem.getValueToken().getValueItem();
                        Item packageItem = new Item(String.valueOf(this.signature) + "~package", (JETItem)packageValueItem, "package");
                        packageItem.setParent(this);
                        rootItem = packageItem;
                    }
                    if ((classAttributeItem = jetDirectiveItem.getAttribute("class")) != null) {
                        JETValueItem classValueItem = classAttributeItem.getValueToken().getValueItem();
                        Item classItem = new Item(String.valueOf(rootItem.getSignature()) + "~class", (JETItem)classValueItem, "class");
                        classItem.setParent(rootItem);
                        rootItem = classItem;
                    }
                    if ((importsAttribute = jetDirectiveItem.getAttribute("imports")) != null) {
                        for (JETValueElementItem jetImportItem : importsAttribute.getValueToken().getValueItem().getElements()) {
                            String importValue = jetImportItem.getValue();
                            Item importItem = new Item(String.valueOf(rootItem.getSignature()) + importValue + "~import", (JETItem)jetImportItem, "import");
                            importItem.setParent(rootItem);
                        }
                    }
                    if ((skeletonAttribute = jetDirectiveItem.getAttribute("skeleton")) != null) {
                        JETValueItem skeletonValueItem = skeletonAttribute.getValueToken().getValueItem();
                        Item skeletonItem = new Item(String.valueOf(this.signature) + "~skeleton", (JETItem)skeletonValueItem, "skeleton");
                        skeletonItem.setParent(this);
                    }
                    if ((nlString = jetDirectiveItem.getAttribute("nlString")) != null) {
                        JETValueItem nlStringValue = nlString.getValueToken().getValueItem();
                        Item skeletonItem = new Item(String.valueOf(this.signature) + "~nlstring", (JETItem)nlStringValue, "nlstring");
                        skeletonItem.setParent(this);
                    }
                }
            }

            protected void setJetItem(JETItem jetItem) {
                this.jetItem = jetItem;
            }

            public Item getParent() {
                return this.parent;
            }

            protected void setParent(Item parent) {
                if (this.parent != null) {
                    this.parent.children.remove(this);
                }
                this.parent = parent;
                if (parent != null) {
                    parent.children.add(this);
                }
            }

            public String getSignature() {
                return this.signature;
            }

            public JETItem getJETItem() {
                return this.jetItem;
            }

            public Image getImage() {
                return ALL_IMAGES.get(this.problemSeverity).get(this.type);
            }

            public List<Item> getChildren() {
                return this.children;
            }

            public StyledString getStyledText() {
                if ("jet".equals(this.type)) {
                    JETDirectiveItem jetDirectiveItem = (JETDirectiveItem)this.jetItem;
                    JETSkeleton skeleton = (JETSkeleton)jetDirectiveItem.getData("skeleton");
                    String className = skeleton.getClassName();
                    String packageName = skeleton.getPackageName();
                    StyledString result = new StyledString(className);
                    if (packageName.length() != 0) {
                        result.append(" - " + packageName, StyledString.DECORATIONS_STYLER);
                    }
                    if (Boolean.TRUE.equals(jetDirectiveItem.getData("duplicate-jet-directive"))) {
                        result.setStyle(0, result.length(), STRIKE_OUT_STYLER);
                    }
                    return result;
                }
                if ("include".equals(this.type)) {
                    JETDirectiveItem jetDirectiveItem = (JETDirectiveItem)this.jetItem;
                    boolean resolvedIncludeSuccess = Boolean.TRUE.equals(jetDirectiveItem.getData("include-success"));
                    return new StyledString(jetDirectiveItem.getAttribute("file").getValueToken().getValueItem().getText(), resolvedIncludeSuccess ? (jetDirectiveItem.isSkipped() ? STRIKE_OUT_STYLER : Item.getFontStyler(1)) : (this.getChildren().isEmpty() ? STRIKE_OUT_STYLER : Item.getFontStyler(2)));
                }
                if ("content".equals(this.type) || "root".equals(this.type) || "orphan".equals(this.type)) {
                    URI deresolvedURI;
                    URI rootURI;
                    String relativeLocation;
                    if (this.jetItem == null && !"orphan".equals(this.type)) {
                        return new StyledString("Analyzing...");
                    }
                    JETMark start = this.jetItem == null ? null : this.jetItem.getStart();
                    URI uri = URI.createURI((String)(start == null ? this.signature.substring(0, this.signature.lastIndexOf("~orphan")) : start.getResolvedURI()));
                    String fileName = uri.lastSegment();
                    StyledString result = new StyledString(fileName);
                    URI baseURI = uri.trimSegments(1);
                    String string = relativeLocation = baseURI.isPlatformResource() ? baseURI.toPlatformString(true) : baseURI.toString();
                    if (start != null) {
                        while (start.getParentMark() != null) {
                            start = start.getParentMark();
                        }
                    }
                    if ((rootURI = URI.createURI((String)(start == null ? this.parent.getChildren().get((int)0).jetItem.getStart().getResolvedURI() : start.getResolvedURI()))).isPlatformResource() && uri.isPlatformResource() && (deresolvedURI = uri.deresolve(rootURI, true, true, false)).segmentCount() > 1 && !"..".equals(deresolvedURI.segment(0))) {
                        relativeLocation = deresolvedURI.trimSegments(1).toString();
                    }
                    result.append(" - " + relativeLocation, StyledString.DECORATIONS_STYLER);
                    if ("content".equals(this.type) && ((JETDirectiveItem)this.parent.jetItem).isSkipped() || "orphan".equals(this.type)) {
                        result.setStyle(0, result.length(), STRIKE_OUT_STYLER);
                    }
                    return result;
                }
                if ("top".equals(this.type)) {
                    return new StyledString("top");
                }
                if ("start".equals(this.type) || "end".equals(this.type)) {
                    JETDirectiveItem jetDirectiveItem = (JETDirectiveItem)this.jetItem;
                    return new StyledString(this.jetItem.getText(), (StyledString.Styler)(jetDirectiveItem.isSkipped() ? STRIKE_OUT_STYLER : null));
                }
                if ("comment".equals(this.type)) {
                    return new StyledString(this.signature.substring(0, this.signature.lastIndexOf("~comment")));
                }
                if (this.jetItem instanceof JETValueItem) {
                    return new StyledString(((JETValueItem)this.jetItem).getValue());
                }
                if (this.jetItem instanceof JETValueElementItem) {
                    return new StyledString(((JETValueElementItem)this.jetItem).getValue());
                }
                return new StyledString(this.jetItem == null ? "" : this.jetItem.getText());
            }

            private static String getDirectiveType(JETItem jetItem) {
                if (jetItem instanceof JETDirectiveItem) {
                    return ((JETDirectiveItem)jetItem).getNameItem().getText();
                }
                return null;
            }
        }

        private static class ItemManager
        extends Item {
            private static final Pattern COMMENT_PATTERN = Pattern.compile("^[^\n\r]*\\[([^\\]\n\r]*)\\]");
            private final HashMap<String, Item> managedItems = new HashMap();
            private final HashMap<String, Integer> documementIDsToFileIDs = new HashMap();

            public ItemManager() {
                super("~top", null, "top");
                Item rootItem = this.createItem(this.managedItems, "~root", null, "root");
                rootItem.setParent(this);
                this.documementIDsToFileIDs.put("~root", 0);
            }

            public Item getRootItem() {
                return this.getChildren().get(0);
            }

            public int getFileID(Item item) {
                if (item.jetItem != null) {
                    return item.jetItem.getFileID();
                }
                if ("orphan".equals(item.type)) {
                    return this.documementIDsToFileIDs.get(item.signature.substring(0, item.signature.lastIndexOf("~orphan")));
                }
                return 0;
            }

            public Item getSelectionForDocumentID(String documentID) {
                Item result = this.managedItems.get(String.valueOf(documentID) + "~content");
                if (result == null && (result = this.managedItems.get(String.valueOf(documentID) + "~orphan")) == null) {
                    result = this.managedItems.get(documentID);
                }
                return result;
            }

            public void setCompilerResult(JETCompilerResult comilerResult, Map<Integer, String> documentIDs) {
                JETCompilationUnit compilerResult = comilerResult.getCompilationUnit();
                if (compilerResult != null) {
                    Item newTopItem = this.createItems(compilerResult, documentIDs);
                    this.reconcile(newTopItem);
                    this.handleProblems(comilerResult);
                }
            }

            @Override
            protected void reconcile(Item newItem) {
                super.reconcile(newItem);
                this.managedItems.clear();
                this.rebuildMap(this.managedItems);
            }

            private Item createTopItem(Map<String, Item> managedItems) {
                Item topItem = this.createItem(managedItems, "~top", null, "top");
                Item rootItem = this.createItem(managedItems, "~root", null, "root");
                rootItem.setParent(topItem);
                return topItem;
            }

            protected Item createItems(JETCompilationUnit compilerResult, Map<Integer, String> documentIDs) {
                this.documementIDsToFileIDs.clear();
                HashMap<String, Item> newManagedItems = new HashMap<String, Item>();
                Item newTopItem = this.createTopItem(newManagedItems);
                Item newRootItem = newTopItem.getChildren().get(0);
                ArrayList<Item> items = new ArrayList<Item>();
                List jetItems = compilerResult.getItems();
                if (!jetItems.isEmpty()) {
                    newRootItem.setJetItem((JETItem)jetItems.get(0));
                    ArrayList<Item> resolvedIncludeSuccessItems = new ArrayList<Item>();
                    ArrayList<Item> flatContentItems = new ArrayList<Item>();
                    for (JETItem jetItem : jetItems) {
                        Matcher matcher;
                        if (jetItem instanceof JETDirectiveItem) {
                            JETDirectiveItem jETDirectiveItem = (JETDirectiveItem)jetItem;
                            JETSkeleton skeleton = (JETSkeleton)jETDirectiveItem.getData("skeleton");
                            if (skeleton != null) {
                                if (jETDirectiveItem.getLength() == 0) continue;
                                String qualifiedClassName = skeleton.getQualifiedClassName();
                                Item directiveItem = this.createItem(newManagedItems, qualifiedClassName, jetItem, "jet");
                                directiveItem.setParent(newRootItem);
                                items.add(directiveItem);
                                continue;
                            }
                            String resolvedInclude = (String)jETDirectiveItem.getData("include");
                            if (resolvedInclude == null) continue;
                            Item includeItem = this.createItem(newManagedItems, resolvedInclude, jetItem, "include");
                            items.add(includeItem);
                            includeItem.setParent(newRootItem);
                            if (!Boolean.TRUE.equals(jETDirectiveItem.getData("include-success"))) continue;
                            resolvedIncludeSuccessItems.add(includeItem);
                            JETItem contentStartItem = (JETItem)jETDirectiveItem.getData("include-start");
                            Item item = this.createItem(newManagedItems, String.valueOf(documentIDs.get(contentStartItem.getFileID())) + "~content", contentStartItem, "content");
                            item.setParent(includeItem);
                            flatContentItems.add(item);
                            continue;
                        }
                        if (!(jetItem instanceof JETCommentItem) || !(matcher = COMMENT_PATTERN.matcher(jetItem.getText())).find()) continue;
                        String signature = matcher.group(1);
                        Item commentItem = this.createItem(newManagedItems, String.valueOf(signature) + "~comment", jetItem, "comment");
                        items.add(commentItem);
                        commentItem.setParent(newRootItem);
                    }
                    ArrayList<Item> originalItems = new ArrayList<Item>(items);
                    List<Item> rootItems = this.refactorIncludes(items, jetItems, newManagedItems);
                    this.refactorInclusion(resolvedIncludeSuccessItems, originalItems, rootItems);
                    for (Item item : flatContentItems) {
                        int fileID = item.getJETItem().getFileID();
                        Item indexItem = this.createItem(newManagedItems, String.valueOf(documentIDs.get(fileID)) + "~root", item.getJETItem(), "root");
                        indexItem.setParent(newRootItem.getParent());
                    }
                    for (Map.Entry entry : documentIDs.entrySet()) {
                        int fileID = (Integer)entry.getKey();
                        String documentID = (String)entry.getValue();
                        this.documementIDsToFileIDs.put(documentID, fileID);
                        if (fileID >= 0) continue;
                        Item indexItem = this.createItem(newManagedItems, String.valueOf(documentID) + "~orphan", null, "orphan");
                        indexItem.setParent(newRootItem.getParent());
                    }
                }
                return newTopItem;
            }

            private void refactorInclusion(List<Item> resolvedIncludeSuccessItems, List<Item> items, List<Item> rootItems) {
                for (Item item : items) {
                    JETItem jetItem = item.getJETItem();
                    int fileID = jetItem.getFileID();
                    if (fileID == 0 || item.getParent().getJETItem().getFileID() == fileID) continue;
                    Item inclusionItem = resolvedIncludeSuccessItems.get(fileID - 1);
                    item.setParent(inclusionItem);
                    rootItems.remove(item);
                }
            }

            private List<Item> refactorIncludes(List<Item> items, List<JETItem> jetItems, Map<String, Item> managedItems) {
                ArrayList<Item> result = new ArrayList<Item>();
                while (!items.isEmpty()) {
                    Item item = items.remove(0);
                    this.captureChildren(item, items, jetItems, managedItems);
                    result.add(item);
                }
                return result;
            }

            private void captureChildren(Item item, List<Item> remainingItems, List<JETItem> jetItems, Map<String, Item> managedItems) {
                JETItem jetItem = item.getJETItem();
                if (jetItem instanceof JETDirectiveItem) {
                    JETDirectiveItem parentJETItem = (JETDirectiveItem)jetItem;
                    JETDirectiveItem start = (JETDirectiveItem)parentJETItem.getData("section-start");
                    JETDirectiveItem end = (JETDirectiveItem)parentJETItem.getData("section-end");
                    if (start != null && end != null) {
                        String signature = item.getSignature();
                        this.createItem(managedItems, String.valueOf(signature) + "~start", (JETItem)start, "start").setParent(item);
                        int startIndex = jetItems.indexOf(start) + 1;
                        int endIndex = jetItems.indexOf(end) - 1;
                        int i = startIndex;
                        while (i <= endIndex) {
                            JETItem jetChildItem = jetItems.get(i);
                            if (jetChildItem instanceof JETDirectiveItem || jetChildItem instanceof JETCommentItem) {
                                for (Item managedItem : managedItems.values()) {
                                    if (managedItem.getJETItem() != jetChildItem || !remainingItems.remove(managedItem)) continue;
                                    managedItem.setParent(item);
                                    this.captureChildren(managedItem, remainingItems, jetItems, managedItems);
                                    break;
                                }
                            }
                            ++i;
                        }
                        this.createItem(managedItems, String.valueOf(signature) + "~end", (JETItem)end, "end").setParent(item);
                    }
                }
            }

            private Item createItem(Map<String, Item> managedItems, String signature, JETItem jetItem, String type) {
                String uniqueSignature = signature;
                Item item = managedItems.get(uniqueSignature);
                while (item != null) {
                    uniqueSignature = String.valueOf(uniqueSignature) + "_";
                    item = managedItems.get(uniqueSignature);
                }
                item = new Item(uniqueSignature, jetItem, type);
                managedItems.put(uniqueSignature, item);
                return item;
            }
        }

        private static class LabelProvider
        extends StyledCellLabelProvider
        implements ILabelProvider {
            private static final Map<Font, Font[]> FONTS = new HashMap<Font, Font[]>();

            private LabelProvider() {
            }

            public void update(ViewerCell cell) {
                Object[] newStyleRanges;
                Object element = cell.getElement();
                StyledString styledString = this.getStyledText(element);
                String newText = styledString.toString();
                Object[] oldStyleRanges = cell.getStyleRanges();
                Object[] objectArray = newStyleRanges = this.isOwnerDrawEnabled() ? styledString.getStyleRanges() : null;
                if (!Arrays.equals(oldStyleRanges, newStyleRanges)) {
                    cell.setStyleRanges((StyleRange[])newStyleRanges);
                    if (cell.getText().equals(newText)) {
                        cell.setText("");
                    }
                }
                cell.setText(newText);
                cell.setImage(this.getImage(element));
                super.update(cell);
            }

            private FontData[] getFontData(int style) {
                FontData[] fontDatas = this.getViewer().getControl().getFont().getFontData();
                int i = 0;
                while (i < fontDatas.length) {
                    fontDatas[i].setStyle(style);
                    ++i;
                }
                return fontDatas;
            }

            private Font getFont(int fontStyle) {
                if (fontStyle > 0 && fontStyle <= 3) {
                    Font font;
                    Font baseFont = this.getViewer().getControl().getFont();
                    Font[] fonts = FONTS.get(baseFont);
                    if (fonts == null) {
                        fonts = new Font[3];
                        FONTS.put(baseFont, fonts);
                    }
                    if ((font = fonts[fontStyle - 1]) == null) {
                        fonts[fontStyle - 1] = font = new Font(baseFont.getDevice(), this.getFontData(fontStyle));
                    }
                    return font;
                }
                return null;
            }

            protected StyleRange prepareStyleRange(StyleRange styleRange, boolean applyColors) {
                StyleRange preparedStyledRange = super.prepareStyleRange(styleRange, applyColors);
                preparedStyledRange.font = this.getFont(styleRange.fontStyle);
                return preparedStyledRange;
            }

            public Image getImage(Object element) {
                if (element instanceof Item) {
                    return ((Item)element).getImage();
                }
                return null;
            }

            protected StyledString getStyledText(Object element) {
                if (element instanceof Item) {
                    return ((Item)element).getStyledText();
                }
                if (element instanceof JETItem) {
                    return new StyledString(((JETItem)element).getText());
                }
                return new StyledString("Root");
            }

            public String getText(Object element) {
                return this.getStyledText(element).toString();
            }

            /* synthetic */ LabelProvider(LabelProvider labelProvider, LabelProvider labelProvider2) {
                this();
            }
        }
    }

    static class JETContentRule
    extends JETRule
    implements IRule {
        private static final char[] PREFIX = new char[0];
        public static final JETToken TOKEN = new JETToken("content");

        public JETContentRule() {
            super(TOKEN, PREFIX);
        }

        @Override
        protected IToken doEvaluate(ICharacterScanner scanner) {
            int trailingWhitespaceCount = 0;
            int read = this.read(scanner);
            while (read != -1) {
                if (read == 60) {
                    if (this.read(scanner) == 37) {
                        this.unread(scanner);
                        this.unread(scanner);
                        if (this.getCount() == 0) {
                            return Token.UNDEFINED;
                        }
                        return this.getSuccessToken();
                    }
                    this.unread(scanner);
                } else {
                    if (read == 10) {
                        if (trailingWhitespaceCount != 0) {
                            int i = 0;
                            while (i <= trailingWhitespaceCount) {
                                this.unread(scanner);
                                ++i;
                            }
                            return this.getCount() == 0 ? Token.UNDEFINED : this.getSuccessToken();
                        }
                        return this.getSuccessToken();
                    }
                    if (read == 13) {
                        if (trailingWhitespaceCount != 0) {
                            ++trailingWhitespaceCount;
                        }
                    } else {
                        trailingWhitespaceCount = read == 32 || read == 9 ? ++trailingWhitespaceCount : 0;
                    }
                }
                read = this.read(scanner);
            }
            if (this.getCount() == 1) {
                return Token.EOF;
            }
            if (trailingWhitespaceCount != 0) {
                int i = 0;
                while (i <= trailingWhitespaceCount) {
                    this.unread(scanner);
                    ++i;
                }
            }
            return this.getCount() == 0 ? Token.UNDEFINED : this.getSuccessToken();
        }
    }

    static class JETDamageRepairer
    extends DefaultDamagerRepairer {
        private final JETEditor jetEditor;
        private int capacity = 8;
        private int size = 0;
        private int[] offsets = new int[this.capacity];
        private JETToken[] tokens = new JETToken[this.capacity];

        public JETDamageRepairer(JETEditor jetEditor, ITokenScanner scanner) {
            super(scanner);
            this.jetEditor = jetEditor;
        }

        private void ensureCapacity(int capacity) {
            if (this.capacity < capacity) {
                int newCapacity = capacity << 1;
                int[] newOffsets = new int[newCapacity];
                JETToken[] newTokens = new JETToken[newCapacity];
                System.arraycopy(this.offsets, 0, newOffsets, 0, this.capacity);
                System.arraycopy(this.tokens, 0, newTokens, 0, this.capacity);
                this.offsets = newOffsets;
                this.tokens = newTokens;
                this.capacity = newCapacity;
            }
        }

        private void add(int offset, int length, JETToken token) {
            this.ensureCapacity(this.size + 2);
            this.tokens[this.size] = token;
            this.offsets[this.size] = offset;
            this.tokens[++this.size] = null;
            this.offsets[this.size] = offset + length;
        }

        public void createPresentation(TextPresentation presentation, ITypedRegion region) {
            try {
                super.createPresentation(presentation, region);
            }
            finally {
                int[] offsets = new int[this.size + 1];
                JETToken[] tokens = new JETToken[this.size + 1];
                System.arraycopy(this.offsets, 0, offsets, 0, this.size + 1);
                System.arraycopy(this.tokens, 0, tokens, 0, this.size + 1);
                this.jetEditor.setTokenData(offsets, tokens);
                this.size = 0;
                this.offsets[0] = 0;
                this.offsets[1] = 0;
            }
        }

        protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute textAttribute) {
            if (textAttribute instanceof ColorManager.JETTextAttribute) {
                ColorManager.JETTextAttribute jetTextAttribute = (ColorManager.JETTextAttribute)textAttribute;
                JETToken token = jetTextAttribute.getToken();
                this.add(offset, length, token);
                int style = textAttribute.getStyle();
                int fontStyle = style & 3;
                StyleRange styleRange = new StyleRange(offset, length, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
                styleRange.strikeout = (style & 0x20000000) != 0;
                styleRange.underline = (style & 0x40000000) != 0;
                styleRange.font = textAttribute.getFont();
                styleRange.data = token;
                styleRange.borderStyle = jetTextAttribute.getBorderStyle();
                if (styleRange.borderStyle != 0) {
                    styleRange.borderColor = styleRange.foreground;
                }
                presentation.addStyleRange(styleRange);
            }
        }
    }

    static class JETDirectiveErrorRule
    extends JETBaseErrorRule {
        public static final JETToken TOKEN = new JETToken(JETDirectiveRule.TOKEN, "error", 0x20000000);

        public JETDirectiveErrorRule() {
            super(TOKEN, JETDirectiveRule.PREFIX);
        }
    }

    static class JETDirectiveRule
    extends JETRule
    implements IRule {
        private static final char[] PREFIX = new char[]{'<', '%', '@'};
        public static final JETToken TOKEN = new JETToken("directive");

        @Override
        protected boolean isGreedy() {
            return false;
        }

        public JETDirectiveRule() {
            super(TOKEN, PREFIX);
        }
    }

    static class JETDocumentManager {
        private final JETEditor jetEditor;
        private final Map<IEditorInput, IDocument> managedDocuments = new LinkedHashMap<IEditorInput, IDocument>();
        private final Map<Integer, IDocument> fileIDs = new LinkedHashMap<Integer, IDocument>();
        private final Map<Integer, String> documentIDs = new LinkedHashMap<Integer, String>();
        private final Set<JETEditorSaveable> saveables = new LinkedHashSet<JETEditorSaveable>();
        private final JavaSynchronizer javaSynchronizer;
        private JETDynamicCompilerJob jetDynamicCompilerJob;
        private int currentFileID;
        private IEditorInput currentEditorInput;

        public JETDocumentManager(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
            this.javaSynchronizer = new JavaSynchronizer(jetEditor);
        }

        public void setEnableJavaSynchronization(boolean enable) {
            this.javaSynchronizer.setEnableJavaSynchronization(enable);
            if (this.jetDynamicCompilerJob != null) {
                this.jetDynamicCompilerJob.setDisabled(!enable);
            }
        }

        public void initializeDocumentManager() {
            this.jetEditor.getDocumentProvider().addElementStateListener(new IElementStateListener(){

                public void elementMoved(Object originalElement, Object movedElement) {
                }

                public void elementDirtyStateChanged(Object element, boolean isDirty) {
                    jetEditor.firePropertyChange(257);
                }

                public void elementDeleted(Object element) {
                }

                public void elementContentReplaced(Object element) {
                    jetEditor.firePropertyChange(257);
                }

                public void elementContentAboutToBeReplaced(Object element) {
                }
            });
            this.registerOutlineHandler();
            this.registerBreadcrumbHandler();
            ISourceViewer jetSourceViewer = this.jetEditor.getSourceViewer();
            IDocument document = jetSourceViewer.getDocument();
            if (document != null) {
                this.registerDocument(this.currentEditorInput, document, 0, "~root");
            }
            this.updateDynamicCompilerJob(this.currentEditorInput);
            this.registerSaveable(this.currentEditorInput);
        }

        protected void registerBreadcrumbHandler() {
            this.jetEditor.getBreadcrumbViewer().addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    this.handleItemSelection(event.getSelection());
                    jetEditor.setFocus();
                }
            });
        }

        protected void registerOutlineHandler() {
            this.jetEditor.getContentOutlinePage().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (jetEditor.getContentOutlinePage().getControl().isFocusControl()) {
                        this.handleItemSelection(event.getSelection());
                    }
                }
            });
        }

        /*
         * Unable to fully structure code
         */
        public void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
            block11: {
                block10: {
                    changedEditorInputs = new ArrayList<IEditorInput>();
                    provider = this.jetEditor.getDocumentProvider();
                    try {
                        try {
                            for (Map.Entry<IEditorInput, IDocument> entry : this.managedDocuments.entrySet()) {
                                editorInput = entry.getKey();
                                document = entry.getValue();
                                if (!provider.canSaveDocument((Object)editorInput)) continue;
                                provider.aboutToChange((Object)editorInput);
                                provider.saveDocument(progressMonitor, (Object)editorInput, document, overwrite);
                                changedEditorInputs.add(editorInput);
                            }
                            this.jetEditor.editorSaved();
                            break block10;
                        }
                        catch (CoreException exception) {
                            status = exception.getStatus();
                            if (status == null || status.getSeverity() != 8) {
                                JETEditor.access$2(this.jetEditor, exception, progressMonitor);
                            }
                            ** for (editorInput : changedEditorInputs)
                        }
                    }
                    catch (Throwable var9_17) {
                        ** for (editorInput : changedEditorInputs)
                    }
lbl-1000:
                    // 1 sources

                    {
                        provider.changed((Object)editorInput);
                        continue;
                    }
lbl23:
                    // 1 sources

                    this.refreshBreadcrumbs();
                    break block11;
lbl-1000:
                    // 1 sources

                    {
                        provider.changed((Object)editorInput);
                        continue;
                    }
lbl29:
                    // 1 sources

                    this.refreshBreadcrumbs();
                    throw var9_17;
                }
                for (IEditorInput editorInput : changedEditorInputs) {
                    provider.changed((Object)editorInput);
                }
                this.refreshBreadcrumbs();
            }
            if (ResourcesPlugin.getWorkspace().isAutoBuilding() && this.jetDynamicCompilerJob != null) {
                job = new Job("Wait for build"){

                    protected IStatus run(IProgressMonitor monitor) {
                        boolean wasInterrupted = false;
                        while (true) {
                            try {
                                4.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                                jetDynamicCompilerJob.documentChanged(null);
                            }
                            catch (OperationCanceledException exception) {
                            }
                            catch (InterruptedException exception) {
                                if (wasInterrupted = true) continue;
                            }
                            break;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }

        /*
         * Unable to fully structure code
         */
        public void performRevert() {
            block10: {
                block9: {
                    changedEditorInputs = new ArrayList<IEditorInput>();
                    provider = this.jetEditor.getDocumentProvider();
                    try {
                        try {
                            for (IEditorInput editorInput : this.managedDocuments.keySet()) {
                                if (!provider.canSaveDocument((Object)editorInput)) continue;
                                provider.aboutToChange((Object)editorInput);
                                provider.resetDocument((Object)editorInput);
                                changedEditorInputs.add(editorInput);
                            }
                            this.jetEditor.editorSaved();
                            break block9;
                        }
                        catch (CoreException exception) {
                            status = exception.getStatus();
                            if (status == null || status.getSeverity() != 8) {
                                shell = this.jetEditor.getSite().getShell();
                                title = "Problems while reverting to saved state";
                                msg = "Could not revert to saved state.";
                                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)exception.getStatus());
                            }
                            ** for (editorInput : changedEditorInputs)
                        }
                    }
                    catch (Throwable var8_16) {
                        ** for (editorInput : changedEditorInputs)
                    }
lbl-1000:
                    // 1 sources

                    {
                        provider.changed((Object)editorInput);
                        continue;
                    }
lbl25:
                    // 1 sources

                    this.refreshBreadcrumbs();
                    break block10;
lbl-1000:
                    // 1 sources

                    {
                        provider.changed((Object)editorInput);
                        continue;
                    }
lbl31:
                    // 1 sources

                    this.refreshBreadcrumbs();
                    throw var8_16;
                }
                for (IEditorInput editorInput : changedEditorInputs) {
                    provider.changed((Object)editorInput);
                }
                this.refreshBreadcrumbs();
            }
        }

        public Saveable[] getSaveables() {
            return this.saveables.toArray(new Saveable[this.saveables.size()]);
        }

        public int getFileID() {
            return this.currentFileID;
        }

        public String getDocumentID() {
            return this.getDocumentID(this.currentFileID);
        }

        private String getDocumentID(int fileID) {
            return this.documentIDs.get(fileID);
        }

        public IDocument getDocument(int fileID) {
            return this.fileIDs.get(fileID);
        }

        String getDocumentID(IEditorInput editorInput) {
            for (Map.Entry<Integer, String> entry : this.documentIDs.entrySet()) {
                String documentID = entry.getValue();
                if (!editorInput.equals(this.getEditorInput(documentID))) continue;
                return documentID;
            }
            return null;
        }

        public int getFileID(IDocument document) {
            for (Map.Entry<Integer, IDocument> entry : this.fileIDs.entrySet()) {
                if (entry.getValue() != document) continue;
                return entry.getKey();
            }
            return -1;
        }

        public IDocument setDocumentID(String documentID) {
            for (Map.Entry<Integer, String> entry : this.documentIDs.entrySet()) {
                if (!entry.getValue().equals(documentID)) continue;
                return this.setFileID(entry.getKey());
            }
            if (documentID != null) {
                IEditorInput editorInput = this.getEditorInput(documentID);
                int fileID = -1;
                while (this.fileIDs.containsKey(fileID)) {
                    --fileID;
                }
                this.getRegisteredDocument(editorInput, fileID, documentID);
                return this.setFileID(fileID);
            }
            return null;
        }

        public void selectAndReveal(IDocument document, int offset, int length) {
            ISourceViewer jetSourceViewer = this.jetEditor.getSourceViewer();
            if (jetSourceViewer.getDocument() != document) {
                for (Map.Entry<Integer, IDocument> entry : this.fileIDs.entrySet()) {
                    if (entry.getValue() != document) continue;
                    this.basicSetFileID(entry.getKey());
                    break;
                }
            }
            if (!jetSourceViewer.overlapsWithVisibleRegion(offset, length)) {
                jetSourceViewer.resetVisibleRegion();
            }
            jetSourceViewer.setSelectedRange(offset, length);
            jetSourceViewer.revealRange(offset, length);
        }

        public IDocument setFileID(int fileID) {
            IDocument document = this.basicSetFileID(fileID);
            JETContentOutlinePage.Item selectionForFileID = this.jetEditor.getContentOutlinePage().getSelectionForDocumentID(this.getDocumentID(fileID));
            if (selectionForFileID != null) {
                this.jetEditor.getBreadcrumbViewer().setInput(selectionForFileID);
                this.jetEditor.getContentOutlinePage().setSelection((ISelection)new StructuredSelection((Object)selectionForFileID), true);
            }
            return document;
        }

        public IEditorInput getEditorInput() {
            IEditorInput editorInput = this.getEditorInput(this.getDocument(this.currentFileID));
            return editorInput == null ? this.jetEditor.getEditorInput() : editorInput;
        }

        protected IEditorInput getEditorInput(IDocument document) {
            for (Map.Entry<IEditorInput, IDocument> entry : this.managedDocuments.entrySet()) {
                if (entry.getValue() != document) continue;
                return entry.getKey();
            }
            return null;
        }

        protected IEditorInput getEditorInput(int fileID) {
            if (fileID == 0) {
                return this.jetEditor.getEditorInput();
            }
            String documentID = this.documentIDs.get(fileID);
            return this.getEditorInput(documentID);
        }

        private IEditorInput getEditorInput(String documentID) {
            String templateURI = documentID.replaceAll("~[0-9]+$", "");
            return JETEditor.toEditorInput(URI.createURI((String)templateURI));
        }

        protected IDocument basicSetFileID(int fileID) {
            IEditorInput editorInput = this.getEditorInput(fileID);
            IDocument registeredDocument = this.getRegisteredDocument(editorInput, fileID, this.documentIDs.get(fileID));
            ISourceViewer jetSourceViewer = this.jetEditor.getSourceViewer();
            if (registeredDocument != null && registeredDocument != jetSourceViewer.getDocument()) {
                IAnnotationModel model = this.jetEditor.getDocumentProvider().getAnnotationModel((Object)editorInput);
                if (model == null) {
                    model = new AnnotationModel();
                }
                boolean javaEditorInSync = this.jetEditor.isJavaEditorInSync();
                this.setDocument(editorInput, registeredDocument, model);
                if (javaEditorInSync) {
                    this.jetEditor.setExpectedModificationStamp();
                }
                this.currentFileID = fileID;
                this.jetEditor.handleFileIDChanged(fileID);
                this.registerSaveable(editorInput);
                this.hookDynamicCompilerJob(registeredDocument);
            } else if (this.currentFileID != fileID) {
                this.currentFileID = fileID;
                this.jetEditor.handleFileIDChanged(fileID);
            }
            return registeredDocument;
        }

        protected void setDocument(IEditorInput editorInput, IDocument document, IAnnotationModel annotationModel) {
            ISourceViewer jetSourceViewer = this.jetEditor.getSourceViewer();
            jetSourceViewer.setDocument(document, annotationModel);
            IDocumentProvider documentProvider = this.jetEditor.getDocumentProvider();
            if (documentProvider instanceof IDocumentProviderExtension) {
                jetSourceViewer.setEditable(!((IDocumentProviderExtension)documentProvider).isReadOnly((Object)editorInput));
            }
        }

        public boolean isEditable() {
            IDocumentProviderExtension documentProvider = (IDocumentProviderExtension)this.jetEditor.getDocumentProvider();
            IDocument document = this.fileIDs.get(this.currentFileID);
            IEditorInput editorInput = this.getEditorInput(document);
            return editorInput != null && !documentProvider.isReadOnly((Object)editorInput);
        }

        public boolean isDirty(int fileID) {
            IDocument document = this.fileIDs.get(fileID);
            IEditorInput editorInput = this.getEditorInput(document);
            return editorInput != null && this.jetEditor.getDocumentProvider().canSaveDocument((Object)editorInput);
        }

        public boolean isDirty() {
            IDocumentProvider documentProvider = this.jetEditor.getDocumentProvider();
            if (documentProvider != null) {
                for (IEditorInput editorInput : this.managedDocuments.keySet()) {
                    if (!documentProvider.canSaveDocument((Object)editorInput)) continue;
                    return true;
                }
            }
            return false;
        }

        protected void registerSaveable(IEditorInput editorInput) {
            ISaveablesLifecycleListener listener;
            JETEditorSaveable saveable = new JETEditorSaveable(this.jetEditor, editorInput);
            if (this.saveables.add(saveable) && this.saveables.size() > 1 && (listener = (ISaveablesLifecycleListener)this.jetEditor.getSite().getService(ISaveablesLifecycleListener.class)) != null) {
                listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this.jetEditor, 1, new Saveable[]{saveable}, false));
            }
        }

        public void handleInputChanged(IEditorInput editorInput) {
            ISaveablesLifecycleListener listener = (ISaveablesLifecycleListener)this.jetEditor.getSite().getService(ISaveablesLifecycleListener.class);
            if (listener != null) {
                if (!this.saveables.isEmpty()) {
                    listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this.jetEditor, 3, this.getSaveables(), false));
                    this.discardSaveables();
                }
                this.registerSaveable(editorInput);
            }
            this.currentEditorInput = editorInput;
            this.updateDynamicCompilerJob(editorInput);
        }

        public void dispose() {
            if (this.jetDynamicCompilerJob != null) {
                this.jetDynamicCompilerJob.cancel();
                for (IDocument document : this.managedDocuments.values()) {
                    this.unhookDynamicCompilerJob(document);
                }
            }
            IDocumentProvider documentProvider = this.jetEditor.getDocumentProvider();
            for (IEditorInput editorInput : this.managedDocuments.keySet()) {
                if (editorInput.equals(this.currentEditorInput)) continue;
                documentProvider.disconnect((Object)editorInput);
            }
            this.discardSaveables();
            for (IDocument document : this.managedDocuments.values()) {
                document.removeDocumentListener((IDocumentListener)this.javaSynchronizer);
            }
            this.managedDocuments.clear();
            this.fileIDs.clear();
            this.documentIDs.clear();
        }

        protected void discardSaveables() {
            for (JETEditorSaveable saveable : this.saveables) {
                saveable.disconnectEditor();
            }
            this.saveables.clear();
        }

        protected void updateDynamicCompilerJob(IEditorInput input) {
            IFile file;
            if (this.jetDynamicCompilerJob != null) {
                this.jetDynamicCompilerJob.cancel();
                for (IDocument document : this.managedDocuments.values()) {
                    this.unhookDynamicCompilerJob(document);
                }
                this.jetDynamicCompilerJob = null;
            }
            if ((file = JETEditor.toFile(input)) != null) {
                this.jetDynamicCompilerJob = new JETDynamicCompilerJob(this.jetEditor, file);
                this.jetDynamicCompilerJob.schedule();
                for (IDocument document : this.managedDocuments.values()) {
                    this.hookDynamicCompilerJob(document);
                }
            }
        }

        protected void hookDynamicCompilerJob(IDocument document) {
            document.addDocumentListener((IDocumentListener)this.jetDynamicCompilerJob);
        }

        protected void unhookDynamicCompilerJob(IDocument document) {
            document.removeDocumentListener((IDocumentListener)this.jetDynamicCompilerJob);
        }

        protected void handleItemSelection(ISelection selection) {
            if (!selection.isEmpty()) {
                JETContentOutlinePage.Item selectedItem;
                JETContentOutlinePage contentOutlinePage = this.jetEditor.getContentOutlinePage();
                int fileID = contentOutlinePage.getFileID(selection);
                this.basicSetFileID(fileID);
                Region region = contentOutlinePage.getRegion(selection);
                if (region != null) {
                    this.jetEditor.selectAndReveal(region.getOffset(), region.getLength());
                }
                if ((selectedItem = contentOutlinePage.getSelectionForDocumentID(this.getDocumentID(fileID))) != null) {
                    this.jetEditor.getBreadcrumbViewer().setInput(selectedItem);
                    contentOutlinePage.setSelection((ISelection)new StructuredSelection((Object)selectedItem), true);
                }
            }
        }

        protected IDocument getRegisteredDocument(IEditorInput editorInput, int fileID, String documentID) {
            IDocument document = this.fileIDs.get(fileID);
            if (document == null && editorInput != null) {
                IDocumentProvider documentProvider = this.jetEditor.getDocumentProvider();
                if (!this.managedDocuments.containsKey(editorInput)) {
                    try {
                        documentProvider.connect((Object)editorInput);
                    }
                    catch (CoreException exception) {
                        CodeGenUIPlugin.getPlugin().log((Object)exception);
                    }
                }
                if ((document = documentProvider.getDocument((Object)editorInput)) != null) {
                    this.registerDocument(editorInput, document, fileID, documentID);
                }
            }
            return document;
        }

        protected void registerDocument(IEditorInput editorInput, IDocument document, int fileID, String documentID) {
            this.managedDocuments.put(editorInput, document);
            this.fileIDs.put(fileID, document);
            this.documentIDs.put(fileID, documentID);
            document.addDocumentListener((IDocumentListener)this.javaSynchronizer);
            this.jetEditor.getJETPosition().addToDocument(document);
        }

        public void setCompilerResult(JETCompilerResult jetCompilerResult) {
            String currentDocumentID = this.getDocumentID();
            LinkedHashSet<IDocument> orphanDocuments = new LinkedHashSet<IDocument>(this.fileIDs.values());
            JETCompilationUnit compilationUnit = jetCompilerResult.getCompilationUnit();
            if (compilationUnit != null) {
                this.fileIDs.clear();
                this.documentIDs.clear();
                int fileID = 0;
                for (String templateURI : compilationUnit.getTemplateURIs()) {
                    String documentID;
                    if (fileID == 0) {
                        documentID = "~root";
                        this.documentIDs.put(0, documentID);
                    } else {
                        documentID = templateURI;
                        String collision = this.documentIDs.put(fileID, templateURI);
                        int count = 1;
                        while (collision != null) {
                            this.documentIDs.put(fileID, collision);
                            documentID = String.valueOf(templateURI) + "~" + count;
                            collision = this.documentIDs.put(fileID, documentID);
                            ++count;
                        }
                    }
                    IDocument document = this.managedDocuments.get(JETEditor.toEditorInput(URI.createURI((String)templateURI)));
                    if (document != null) {
                        this.fileIDs.put(fileID, document);
                        if (documentID.equals(currentDocumentID)) {
                            this.currentFileID = fileID;
                        }
                    }
                    ++fileID;
                }
                orphanDocuments.removeAll(this.fileIDs.values());
                if (!orphanDocuments.isEmpty()) {
                    fileID = -1;
                    for (IDocument orphanDocument : orphanDocuments) {
                        this.fileIDs.put(fileID, orphanDocument);
                        for (Map.Entry<IEditorInput, IDocument> entry : this.managedDocuments.entrySet()) {
                            if (entry.getValue() != orphanDocument) continue;
                            URI templateURI = JETEditor.toURI(entry.getKey());
                            this.documentIDs.put(fileID, templateURI.toString());
                            break;
                        }
                        --fileID;
                    }
                }
            }
            JETContentOutlinePage contentOutlinePage = this.jetEditor.getContentOutlinePage();
            contentOutlinePage.setCompilerResult(jetCompilerResult, this.documentIDs);
            this.refreshBreadcrumbs();
        }

        private void refreshBreadcrumbs() {
            JETContentOutlinePage.Item newCurrentInput;
            JETBreadcrumbViewer breadcrumbViewer = this.jetEditor.getBreadcrumbViewer();
            JETContentOutlinePage.Item currentInput = (JETContentOutlinePage.Item)breadcrumbViewer.getInput();
            if (currentInput != (newCurrentInput = this.jetEditor.getContentOutlinePage().getSelectionForDocumentID(this.getDocumentID(this.currentFileID))) && newCurrentInput != null) {
                breadcrumbViewer.setInput(newCurrentInput);
                this.jetEditor.getContentOutlinePage().setSelection((ISelection)new StructuredSelection((Object)newCurrentInput), true);
            } else {
                breadcrumbViewer.refresh(true);
                JETContentOutlinePage.Item item = currentInput;
                while (item != null) {
                    breadcrumbViewer.update(item, null);
                    item = item.getParent();
                }
            }
        }

        static class JavaSynchronizer
        implements IDocumentListener {
            private final JETEditor jetEditor;
            private boolean disabled;

            public JavaSynchronizer(JETEditor jetEditor) {
                this.jetEditor = jetEditor;
            }

            public void setEnableJavaSynchronization(boolean enable) {
                this.disabled = !enable;
            }

            public void documentChanged(DocumentEvent event) {
                JETToken token;
                int eventOffset;
                JETTokenRegion tokenRegion;
                if (!(this.disabled || (tokenRegion = this.jetEditor.getTokenRegionAt(eventOffset = event.getOffset())) == null || (token = tokenRegion.getToken()) != JETScriptletRule.TOKEN && token != JETExpressionRule.TOKEN)) {
                    tokenRegion.shrinkToJava(event.getDocument());
                    int tokenJavaStart = tokenRegion.getOffset();
                    Position correspondingJavaPosition = this.jetEditor.getCorrespondingJavaPosition(tokenJavaStart, 0);
                    if (correspondingJavaPosition != null) {
                        try {
                            SourceViewer javaSourceViewer = this.jetEditor.getJavaSourceViewer();
                            int javaOffset = correspondingJavaPosition.getOffset() + eventOffset - tokenJavaStart;
                            int eventLength = event.getLength();
                            javaSourceViewer.getDocument().replace(javaOffset, eventLength, event.getText());
                            javaSourceViewer.setSelectedRange(javaOffset + 1 - eventLength, 0);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        }
    }

    static class JETDynamicCompilerJob
    extends Job
    implements IDocumentListener {
        private final JETEditor jetEditor;
        private final IFile file;
        private volatile boolean disabled;

        public JETDynamicCompilerJob(JETEditor jetEditor, IFile file) {
            super("JET Dynamic Compiler");
            this.setSystem(true);
            this.jetEditor = jetEditor;
            this.file = file;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
            if (disabled) {
                this.cancel();
            } else {
                this.documentChanged(null);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!this.disabled) {
                try {
                    final WorkingCopyCompilationMonitor compilationMonitor = new WorkingCopyCompilationMonitor();
                    JETCompileTemplateOperation jetCompileTemplateOperation = new JETCompileTemplateOperation(this.file, compilationMonitor){

                        public void run(IProgressMonitor progressMonitor) throws CoreException {
                            if (this.files.isEmpty()) {
                                this.files.add(file);
                            }
                            super.run(progressMonitor);
                        }
                    };
                    long startTime = System.currentTimeMillis();
                    jetCompileTemplateOperation.run(monitor);
                    if (!monitor.isCanceled()) {
                        final JETCompilationUnit compilerResult = compilationMonitor.getResult();
                        if (compilerResult != null) {
                            JETNature nature = this.jetEditor.getJETNature();
                            IContainer sourceContainer = nature.getJavaSourceContainer();
                            IProject project = sourceContainer.getProject();
                            IJavaProject javaProject = JavaCore.create((IProject)project);
                            String className = compilerResult.getClassName();
                            final IFile javaFile = sourceContainer.getFile((IPath)new Path(String.valueOf(className.replace('.', '/')) + ".java"));
                            ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)javaFile);
                            LocalWorkingCopy localWorkingCopy = new LocalWorkingCopy(compilerResult.getJavaCompilationUnit());
                            ICompilationUnit workingCopy = compilationUnit.getWorkingCopy((WorkingCopyOwner)localWorkingCopy, null);
                            ASTParser astParser = CodeGenUtil.EclipseUtil.newASTParser((boolean)true);
                            String fileExtension = this.file.getFileExtension();
                            if (fileExtension != null && fileExtension.endsWith("jet")) {
                                astParser.setResolveBindings(true);
                            }
                            astParser.setProject(javaProject);
                            ASTRequestor astRequestor = new ASTRequestor(){

                                public void acceptAST(ICompilationUnit sourceUnit, CompilationUnit compiledUnit) {
                                    IProblem[] problems = compiledUnit.getProblems();
                                    JETCompilerResult jetCompilerResult = new JETCompilerResult(javaFile, compilerResult, Arrays.asList(problems), compilationMonitor.getException());
                                    this.handleJavaResult(jetCompilerResult);
                                }
                            };
                            astParser.createASTs(new ICompilationUnit[]{workingCopy}, new String[0], astRequestor, null);
                        } else if (compilationMonitor.getException() != null) {
                            JETCompilerResult jetCompilerResult = new JETCompilerResult(compilationMonitor.getException());
                            this.handleJavaResult(jetCompilerResult);
                        }
                    }
                    long stop = System.currentTimeMillis();
                    if (trace) {
                        System.out.println("elapsed=" + (stop - startTime));
                    }
                }
                catch (CoreException exception) {
                    CodeGenUIPlugin.getPlugin().log((Object)exception);
                }
            }
            return Status.OK_STATUS;
        }

        private void handleJavaResult(JETCompilerResult jetCompilerResult) {
            if (!this.disabled) {
                this.jetEditor.handleCompilerResult(jetCompilerResult);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (!this.disabled) {
                this.cancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
            if (!this.disabled) {
                this.jetEditor.resetExpectedModificationStamp();
                this.schedule(100L);
            }
        }
    }

    static class JETEditorSaveable
    extends Saveable {
        private JETEditor jetEditor;
        private IEditorInput editorInput;
        private IDocument fDocument;

        public JETEditorSaveable(JETEditor jetEditor, IEditorInput editorInput) {
            this.jetEditor = jetEditor;
            this.editorInput = editorInput;
        }

        public IEditorInput getEditorInput() {
            return this.editorInput;
        }

        public void disconnectEditor() {
            this.getAdapter(IDocument.class);
            this.jetEditor = null;
        }

        public String getName() {
            return this.editorInput.getName();
        }

        public String getToolTipText() {
            return this.editorInput.getToolTipText();
        }

        public ImageDescriptor getImageDescriptor() {
            return this.editorInput.getImageDescriptor();
        }

        public void doSave(IProgressMonitor monitor) throws CoreException {
            this.jetEditor.doSave(monitor);
        }

        public boolean isDirty() {
            return this.jetEditor.getDocumentProvider().canSaveDocument((Object)this.editorInput);
        }

        public int hashCode() {
            Object document = this.getAdapter(IDocument.class);
            return document == null ? 0 : document.hashCode();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Saveable)) {
                return false;
            }
            Object thisDocument = this.getAdapter(IDocument.class);
            Object thatDocument = ((Saveable)that).getAdapter(IDocument.class);
            return thisDocument == null ? thatDocument == null : thisDocument.equals(thatDocument);
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IDocument.class) {
                IDocumentProvider documentProvider;
                if (this.fDocument == null && (documentProvider = this.jetEditor.getDocumentProvider()) != null) {
                    this.fDocument = documentProvider.getDocument((Object)this.editorInput);
                }
                return this.fDocument;
            }
            return super.getAdapter(adapter);
        }
    }

    static class JETExpressionErrorRule
    extends JETBaseErrorRule {
        public static final JETToken TOKEN = new JETToken(JETExpressionRule.TOKEN, "error", 0x20000000);

        public JETExpressionErrorRule() {
            super(TOKEN, JETExpressionRule.PREFIX);
        }
    }

    static class JETExpressionRule
    extends JETRule
    implements IRule {
        private static final char[] PREFIX = new char[]{'<', '%', '='};
        public static final JETToken TOKEN = new JETToken("expression");

        public JETExpressionRule() {
            super(TOKEN, PREFIX);
        }

        @Override
        protected boolean isGreedy() {
            return false;
        }
    }

    static class JETExtractLocalVariableAction
    extends JETAbstractBaseAction {
        private final IAction javaAction;

        public JETExtractLocalVariableAction(JETEditor jetEditor, IAction javaAction) {
            super(jetEditor, javaAction.getText(), javaAction.getImageDescriptor());
            this.javaAction = javaAction;
            this.setActionDefinitionId(javaAction.getActionDefinitionId());
        }

        @Override
        protected void doRun() {
            this.javaAction.run();
        }
    }

    static class JETFormatAction
    extends JETAbstractBaseAction {
        private static final Map<String, String[]> JET_DIRECTIVE_ORDERED_ATTRIBUTES = new HashMap<String, String[]>();
        private static final Comparator<SegmentSequence> COMPARATOR;

        static {
            JET_DIRECTIVE_ORDERED_ATTRIBUTES.put("jet", new String[]{"package", "class", "imports", "builder", "nlString", "minimize", "skeleton", "version"});
            JET_DIRECTIVE_ORDERED_ATTRIBUTES.put("include", new String[]{"file", "fail"});
            COMPARATOR = new Comparator<SegmentSequence>(){
                Comparator<String> comparator = CommonPlugin.INSTANCE.getComparator();

                @Override
                public int compare(SegmentSequence o1, SegmentSequence o2) {
                    int count1 = o1.segmentCount();
                    int count2 = o2.segmentCount();
                    int i = 0;
                    while (i < count1 && i < count2) {
                        int comparision = this.comparator.compare(o1.segment(i), o2.segment(i));
                        if (comparision != 0) {
                            return comparision;
                        }
                        ++i;
                    }
                    return count1 == count2 ? 0 : (count1 < count2 ? -1 : 1);
                }
            };
        }

        public JETFormatAction(JETEditor jetEditor) {
            super(jetEditor, "&Format", null);
            this.setActionDefinitionId(JETEditor.FORMAT_COMMAND_ID);
        }

        @Override
        protected DocumentRewriteSessionType getDocumentRewriteSessionType() {
            return DocumentRewriteSessionType.UNRESTRICTED;
        }

        @Override
        boolean isIgnoreOutOfScopeChanges() {
            return true;
        }

        @Override
        protected void start() {
        }

        @Override
        protected void stop() {
            this.jetEditor.waitForCompilerResult(1000L);
        }

        @Override
        protected void doRun() throws Exception {
            IJavaProject javaProject = JavaCore.create((IProject)this.jetEditor.getJETNature().getProject());
            Map options = javaProject.getOptions(true);
            for (Map.Entry entry : options.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.contains(".formatter.brace_position_for")) continue;
                entry.setValue("end_of_line");
            }
            options.put("org.eclipse.jdt.core.formatter.align_with_spaces", "true");
            options.put("org.eclipse.jdt.core.formatter.tabulation.char", "space");
            options.put("org.eclipse.jdt.core.formatter.tabulation.size", "2");
            options.put("org.eclipse.jdt.core.formatter.indentation.size", "2");
            options.put("org.eclipse.jdt.core.formatter.insert_new_line_before_else_in_if_statement", "false");
            options.put("org.eclipse.jdt.core.formatter.keep_else_statement_on_same_line", "true");
            options.put("org.eclipse.jdt.core.formatter.compact_else_if", "true");
            CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)options);
            JavaEditor javaEditor = this.jetEditor.getJavaEditor();
            IDocument document = javaEditor.getJavaSourceViewer().getDocument();
            String source = document.get();
            TextEdit edit = codeFormatter.format(4104, source, 0, source.length(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)document));
            if (edit != null) {
                edit.apply(document);
            }
        }

        @Override
        protected void postProcess(IDocument jetDocument, List<TrackedPosition> jetPositions) {
            int stop;
            int start;
            IDocument javaDocument = this.jetEditor.getJavaSourceViewer().getDocument();
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            List rootItems = JETParser.parseRootItems((String)jetDocument.get());
            for (JETRootItem jetRootItem : rootItems) {
                start = jetRootItem.getStartOffset();
                stop = jetRootItem.getStopOffset();
                if (jetRootItem instanceof JETScriptletItem) {
                    JETScriptletItem jetScriptletItem = (JETScriptletItem)jetRootItem;
                    String body = jetScriptletItem.getText();
                    this.reformatScriptletBody(jetDocument, jetPositions, javaDocument, multiTextEdit, start, stop, body);
                    continue;
                }
                if (!(jetRootItem instanceof JETDirectiveItem)) continue;
                JETDirectiveItem jetDirectiveItem = (JETDirectiveItem)jetRootItem;
                String directive = jetDirectiveItem.getText();
                String directiveName = jetDirectiveItem.getNameItem().getText();
                if (directiveName.length() != 0 && Character.isUpperCase(directiveName.codePointAt(0))) {
                    multiTextEdit.addChild((TextEdit)new ReplaceEdit(start + 2, 0, " "));
                    this.reformatScriptletBody(jetDocument, jetPositions, javaDocument, multiTextEdit, start + 2, stop - 2, directive.substring(2, directive.length() - 2));
                    continue;
                }
                this.reformatDirective(jetDocument, multiTextEdit, start, stop, directiveName, directive, jetDirectiveItem);
            }
            this.stripTrailingWhitespace(jetDocument, multiTextEdit);
            if (multiTextEdit.hasChildren()) {
                try {
                    multiTextEdit.apply(jetDocument);
                    multiTextEdit = new MultiTextEdit();
                    rootItems = JETParser.parseRootItems((String)jetDocument.get());
                    for (JETRootItem jetRootItem : rootItems) {
                        if (!(jetRootItem instanceof JETScriptletItem)) continue;
                        start = jetRootItem.getStartOffset();
                        stop = jetRootItem.getStopOffset();
                        try {
                            int lineOffset;
                            int i = jetDocument.getLineOfOffset(start) + 1;
                            while ((lineOffset = jetDocument.getLineOffset(i)) < stop) {
                                if (jetDocument.getChar(lineOffset) == ' ' && jetDocument.getChar(lineOffset + 1) == ' ') {
                                    multiTextEdit.addChild((TextEdit)new ReplaceEdit(lineOffset, 2, ""));
                                }
                                ++i;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    if (multiTextEdit.hasChildren()) {
                        multiTextEdit.apply(jetDocument);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void reformatDirective(IDocument jetDocument, MultiTextEdit multiTextEdit, int start, int stop, String directiveName, String directive, JETDirectiveItem jetDirectiveItem) {
            StringBuilder result = new StringBuilder();
            result.append(directiveName);
            boolean isMultiLine = directive.contains("\n");
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)jetDocument);
            JETAttributeListItem attributes = jetDirectiveItem.getAttributes();
            ArrayList<JETAttributeItem> items = new ArrayList<JETAttributeItem>(attributes.getAttributes());
            String[] orderedAttributes = JET_DIRECTIVE_ORDERED_ATTRIBUTES.get(directiveName);
            if (orderedAttributes != null) {
                int i = orderedAttributes.length;
                while (--i >= 0) {
                    JETAttributeItem attribute = attributes.getAttribute(orderedAttributes[i]);
                    if (!items.remove(attribute)) continue;
                    items.add(0, attribute);
                }
            }
            for (JETAttributeItem jetAttributeItem : items) {
                if (isMultiLine) {
                    result.append(lineDelimiter);
                    result.append("  ");
                } else if (result.length() != 0) {
                    result.append(' ');
                }
                String nameText = jetAttributeItem.getNameToken().getText();
                result.append(nameText);
                result.append('=');
                JETTokenItem valueToken = jetAttributeItem.getValueToken();
                String valueText = valueToken.getText();
                if ("imports".equals(nameText)) {
                    char quote = valueText.length() == 0 ? (char)'\"' : (char)valueText.charAt(0);
                    boolean isMultiLineImport = valueText.contains("\n");
                    if (isMultiLineImport) {
                        result.append(lineDelimiter).append("    ");
                    }
                    result.append(quote);
                    List<String> imports = this.sortImports(valueToken);
                    int count = 0;
                    for (String importedName : imports) {
                        if (isMultiLineImport) {
                            result.append(lineDelimiter).append("      ");
                        } else if (count++ != 0) {
                            result.append(' ');
                        }
                        result.append(importedName);
                    }
                    if (isMultiLineImport) {
                        result.append(lineDelimiter).append("    ");
                    }
                    result.append(quote);
                    continue;
                }
                result.append(valueText);
            }
            multiTextEdit.addChild((TextEdit)new ReplaceEdit(start + 3, stop - start - 5, result.toString()));
        }

        private List<String> sortImports(JETTokenItem imports) {
            TreeSet<SegmentSequence> importedNames = new TreeSet<SegmentSequence>(COMPARATOR);
            for (JETValueElementItem jetValueElementItem : imports.getValueItem().getElements()) {
                importedNames.add(SegmentSequence.create((String)".", (String)jetValueElementItem.getText()));
            }
            ArrayList<String> result = new ArrayList<String>();
            for (SegmentSequence name : importedNames) {
                result.add(name.toString());
            }
            return result;
        }

        protected void stripTrailingWhitespace(IDocument jetDocument, MultiTextEdit multiTextEdit) {
            try {
                int numberOfLines = jetDocument.getNumberOfLines();
                int i = 0;
                while (i < numberOfLines) {
                    int lineOffset = jetDocument.getLineOffset(i);
                    int lineLength = jetDocument.getLineLength(i);
                    String lineDelimiter = jetDocument.getLineDelimiter(i);
                    int lineDelimiterLength = lineDelimiter == null ? 0 : lineDelimiter.length();
                    int count = 0;
                    int j = lineOffset + lineLength - lineDelimiterLength - 1;
                    while (j >= 0) {
                        char character = jetDocument.getChar(j);
                        if (character != ' ' && character != '\t') break;
                        ++count;
                        --j;
                    }
                    if (count > 0) {
                        try {
                            multiTextEdit.addChild((TextEdit)new ReplaceEdit(lineOffset + lineLength - lineDelimiterLength - count, count, ""));
                        }
                        catch (MalformedTreeException malformedTreeException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected TrackedPosition getTrackedPosition(List<TrackedPosition> positions, int offset) {
            for (Position position : positions) {
                if (!position.overlapsWith(offset, 0)) continue;
                return (TrackedPosition)position;
            }
            return null;
        }

        protected void reformatScriptletBody(IDocument jetDocument, List<TrackedPosition> positions, IDocument javaDocument, MultiTextEdit multiTextEdit, int start, int stop, String body) {
            TrackedPosition jetPosition;
            int length;
            int trim = -1;
            int i = length = body.length();
            while (--i >= 0) {
                if (!Character.isWhitespace(body.charAt(i))) break;
                trim = i;
            }
            if (trim != -1) {
                multiTextEdit.addChild((TextEdit)new ReplaceEdit(start + trim, length - trim, ""));
            }
            if ((jetPosition = this.getTrackedPosition(positions, start)) != null) {
                int javaIndentation;
                TrackedPosition javaPosition = jetPosition.getOpposite();
                int jetIndentation = this.computeIndentation(jetDocument, jetPosition.offset - 2);
                if (jetIndentation != -1 && (javaIndentation = this.computeIndentation(javaDocument, javaPosition.offset)) >= 4) {
                    int baseJavaIndentation = javaIndentation - 4;
                    int delta = baseJavaIndentation - jetIndentation;
                    if (delta > 0) {
                        StringBuilder spaces = new StringBuilder();
                        int i2 = 0;
                        while (i2 < delta) {
                            spaces.append(' ');
                            ++i2;
                        }
                        multiTextEdit.addChild((TextEdit)new ReplaceEdit(start - 2, 0, spaces.toString()));
                    } else if (delta < 0) {
                        multiTextEdit.addChild((TextEdit)new ReplaceEdit(start + delta - 2, -delta, ""));
                    }
                }
            }
        }

        protected int computeIndentation(IDocument document, int offset) {
            int indent = 0;
            int i = offset;
            while (--i >= 0) {
                try {
                    char character = document.getChar(i);
                    if (character == ' ') {
                        ++indent;
                        continue;
                    }
                    if (character == '\n') break;
                    return -1;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return indent;
        }
    }

    static class JETHyperLink
    implements IHyperlink {
        private final IRegion region;
        private JETEditor jetEditor;
        private final int fileID;
        private final String locationURI;

        public JETHyperLink(JETEditor jetEditor, IRegion region, int fileID, String locationURI) {
            this.jetEditor = jetEditor;
            this.region = region;
            this.fileID = fileID;
            this.locationURI = locationURI;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return "Open";
        }

        public String getHyperlinkText() {
            URI uri = URI.createURI((String)this.locationURI);
            return "Open JET " + (uri.isPlatformResource() ? uri.toPlatformString(true) : uri.toString());
        }

        public void open() {
            this.jetEditor.markInNavigationHistory();
            if (this.fileID == -1) {
                JETEditor.open(this.jetEditor.getEditorSite(), this.locationURI);
            } else {
                this.jetEditor.getDocumentManager().setFileID(this.fileID);
                Position correspondingTemplatePoint = this.jetEditor.getCorrespondingTemplatePosition(this.region.getOffset(), this.region.getLength());
                if (correspondingTemplatePoint != null) {
                    this.jetEditor.selectAndReveal(correspondingTemplatePoint.offset, correspondingTemplatePoint.length);
                } else {
                    this.jetEditor.markInNavigationHistory();
                }
            }
        }
    }

    static class JETNavigationHyperLink
    implements IHyperlink {
        protected final JETEditor jetEditor;
        private final IRegion region;
        protected final IRegion targetRegion;

        public JETNavigationHyperLink(JETEditor jetEditor, IRegion region, IRegion targetRegion) {
            this.jetEditor = jetEditor;
            this.region = region;
            this.targetRegion = targetRegion;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return "Navigate";
        }

        public String getHyperlinkText() {
            return "Navigate in Template";
        }

        public void open() {
            this.jetEditor.markInNavigationHistory();
            this.jetEditor.selectAndReveal(this.targetRegion.getOffset(), this.targetRegion.getLength());
        }
    }

    static class JETPresentationReconciler
    extends PresentationReconciler {
        private final JETEditor jetEditor;
        private IDocument document;

        public JETPresentationReconciler(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
        }

        public TextPresentation createPresentation(IRegion damage, IDocument document) {
            JETCompilationUnit compilerResult;
            if (document != this.document) {
                this.setDocument(document);
            }
            List javaItems = null;
            List skippedItems = null;
            ITextViewerExtension5 javaViewer = null;
            StyledText javaStyledText = null;
            if (this.jetEditor.isJavaEditorInSync() && (compilerResult = this.jetEditor.getCompilationUnit()) != null) {
                SourceViewer underlyingSourceViewer = this.jetEditor.getJavaEditor().getJavaSourceViewer();
                if (compilerResult.getJavaCompilationUnit().equals(underlyingSourceViewer.getDocument().get())) {
                    int fileID = this.jetEditor.getFileID();
                    int templateOffset = damage.getOffset();
                    int templateLength = damage.getLength();
                    javaItems = compilerResult.getJavaItems(fileID, templateOffset, templateLength);
                    skippedItems = compilerResult.getSkippedItems(fileID, templateOffset, templateLength);
                    javaStyledText = underlyingSourceViewer.getTextWidget();
                    javaViewer = (ITextViewerExtension5)underlyingSourceViewer;
                }
            }
            Region fullRegion = new Region(0, document.getLength());
            TextPresentation fullTextPresentation = super.createPresentation((IRegion)fullRegion, document);
            if (javaItems == null && damage.equals(fullRegion)) {
                return fullTextPresentation;
            }
            TextPresentation textPresentation = new TextPresentation(damage, 1000);
            int offset = damage.getOffset();
            int end = offset + damage.getLength();
            Iterator i = fullTextPresentation.getAllStyleRangeIterator();
            while (i.hasNext()) {
                StyleRange styleRange = (StyleRange)i.next();
                if (styleRange.start + styleRange.length < offset || styleRange.start > end) continue;
                if (javaItems == null) {
                    textPresentation.addStyleRange(styleRange);
                    continue;
                }
                this.applySemanticStyle(textPresentation, styleRange, javaItems, skippedItems, javaStyledText, javaViewer);
            }
            return textPresentation;
        }

        private void applySemanticStyle(TextPresentation textPresentation, StyleRange styleRange, List<JETJavaItem> javaItems, List<JETRootItem> skippedItems, StyledText textWidget, ITextViewerExtension5 javaModelViewer) {
            IToken token = (IToken)styleRange.data;
            int start = styleRange.start;
            int end = styleRange.start + styleRange.length;
            for (JETRootItem jetRootItem : skippedItems) {
                Color blendedColor;
                if (jetRootItem.getStartOffset() >= end || jetRootItem.getStopOffset() <= start) continue;
                styleRange.strikeout = true;
                styleRange.strikeoutColor = blendedColor = ColorManager.INSTANCE.getBlendedColor(styleRange.foreground, styleRange.background);
                styleRange.foreground = blendedColor;
                break;
            }
            Color defaultForeground = textWidget.getForeground();
            if (token == JETScriptletRule.TOKEN || token == JETExpressionRule.TOKEN) {
                for (JETJavaItem javaItem : javaItems) {
                    String javaText;
                    String text;
                    int delta = javaItem.getStartOffset() - start;
                    if (delta < 0 || javaItem.getStopOffset() > end) continue;
                    int javaOffset = javaItem.getJavaOffset();
                    int javaLength = javaItem.getJavaLength();
                    int javaWidgetOffset = javaModelViewer.modelOffset2WidgetOffset(javaOffset);
                    StyleRange[] styleRanges = textWidget.getStyleRanges(javaWidgetOffset, javaLength);
                    if (trace && !(text = javaItem.getText()).equals(javaText = textWidget.getTextRange(javaWidgetOffset, javaLength))) {
                        if (!trace) break;
                        System.out.println("mismatched text when applying styles");
                        break;
                    }
                    ArrayList<StyleRange> newStyleRanges = new ArrayList<StyleRange>();
                    StyleRange leadingNewStyleRanage = (StyleRange)styleRange.clone();
                    leadingNewStyleRanage.length = delta;
                    newStyleRanges.add(leadingNewStyleRanage);
                    start += delta;
                    int consumedLength = 0;
                    StyleRange[] styleRangeArray = styleRanges;
                    int n = styleRanges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StyleRange javaStyleRange = styleRangeArray[n2];
                        StyleRange newStyleRange = (StyleRange)styleRange.clone();
                        newStyleRange.start = start + consumedLength;
                        newStyleRange.length = javaStyleRange.length;
                        if (javaStyleRange.foreground == null || !javaStyleRange.foreground.equals((Object)defaultForeground)) {
                            newStyleRange.foreground = javaStyleRange.foreground;
                        }
                        newStyleRange.foreground = newStyleRange.strikeout ? ColorManager.INSTANCE.getBlendedColor(newStyleRange.foreground, newStyleRange.background) : newStyleRange.foreground;
                        newStyleRange.fontStyle = javaStyleRange.fontStyle;
                        consumedLength += newStyleRange.length;
                        newStyleRanges.add(newStyleRange);
                        ++n2;
                    }
                    StyleRange trailingNewStyleRange = (StyleRange)styleRange.clone();
                    trailingNewStyleRange.start = start + consumedLength;
                    trailingNewStyleRange.length = end - trailingNewStyleRange.start;
                    newStyleRanges.add(trailingNewStyleRange);
                    for (StyleRange newStyleRange : newStyleRanges) {
                        textPresentation.addStyleRange(newStyleRange);
                    }
                    return;
                }
            }
            textPresentation.addStyleRange(styleRange);
        }

        protected void setDocument(IDocument document) {
            this.setDocumentToDamagers(document);
            this.setDocumentToRepairers(document);
            this.document = document;
        }
    }

    static class JETProblemAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        private static final Image[] SEVERITY_IMAGES;
        private static final Image[] DISABLED_SEVERITY_IMAGES;
        private static final String[] SEVERITY_TYPES;
        private final boolean disabled;
        private final int severity;
        private final Position position;

        static {
            org.eclipse.ui.ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            SEVERITY_IMAGES = new Image[]{sharedImages.getImage("IMG_OBJS_INFO_TSK"), sharedImages.getImage("IMG_OBJS_WARN_TSK"), sharedImages.getImage("IMG_OBJS_ERROR_TSK")};
            DISABLED_SEVERITY_IMAGES = new Image[]{new Image(SEVERITY_IMAGES[0].getDevice(), SEVERITY_IMAGES[0], 2), new Image(SEVERITY_IMAGES[1].getDevice(), SEVERITY_IMAGES[1], 2), new Image(SEVERITY_IMAGES[2].getDevice(), SEVERITY_IMAGES[2], 2)};
            SEVERITY_TYPES = new String[]{"org.eclipse.ui.workbench.texteditor.info", "org.eclipse.ui.workbench.texteditor.warning", "org.eclipse.ui.workbench.texteditor.error"};
        }

        public JETProblemAnnotation(int severity, String message, Position position) {
            super(SEVERITY_TYPES[severity], false, message);
            this.severity = severity;
            this.position = position;
            this.disabled = false;
        }

        public JETProblemAnnotation(MarkerAnnotation annotation, Position position) {
            super(SEVERITY_TYPES[JETProblemAnnotation.getSeverity(annotation)], false, annotation.getText());
            this.severity = JETProblemAnnotation.getSeverity(annotation);
            this.position = position;
            this.disabled = true;
        }

        public Position getPosition() {
            return this.position;
        }

        public int getSeverity() {
            return this.severity;
        }

        public int getLayer() {
            return 6 + this.severity + (this.disabled ? 1 : 0);
        }

        private Image getImage() {
            return (this.disabled ? DISABLED_SEVERITY_IMAGES : SEVERITY_IMAGES)[this.severity];
        }

        public void paint(GC gc, Canvas canvas, Rectangle bounds) {
            ImageUtilities.drawImage((Image)this.getImage(), (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000, (int)128);
        }

        private static int getSeverity(MarkerAnnotation markerAnnotation) {
            try {
                IMarker marker = markerAnnotation.getMarker();
                if (marker != null) {
                    Object severity = marker.getAttribute("severity");
                    return severity instanceof Integer ? (Integer)severity : 0;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return 2;
        }
    }

    static class JETRenameLocalVariableAction
    extends JETAbstractBaseAction {
        public JETRenameLocalVariableAction(JETEditor jetEditor) {
            super(jetEditor, "Re&name...", null);
            this.setActionDefinitionId(JETEditor.RENAME_COMMAND_ID);
        }

        @Override
        protected void doRun() throws Exception {
            IJavaElement[] selectedElements = this.jetEditor.getJavaEditor().getSelectedElements();
            if (selectedElements != null) {
                IJavaElement[] iJavaElementArray = selectedElements;
                int n = selectedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement element = iJavaElementArray[n2];
                    if (element instanceof ILocalVariable) {
                        ILocalVariable localVariable = (ILocalVariable)element;
                        RenameSupport renameLocalVariableSupport = RenameSupport.create((ILocalVariable)localVariable, (String)localVariable.getElementName(), (int)1);
                        renameLocalVariableSupport.openDialog(this.jetEditor.getSite().getShell());
                        return;
                    }
                    ++n2;
                }
            }
            throw new CoreException((IStatus)new Status(4, CodeGenUIPlugin.getPlugin().getBundle().getSymbolicName(), "A local variable must be selected"));
        }
    }

    static abstract class JETRule {
        private final JETToken successToken;
        private final char[] prefix;
        private int count;

        public JETRule(JETToken successToken, char[] prefix) {
            this.successToken = successToken;
            this.prefix = prefix;
        }

        protected int getCount() {
            return this.count;
        }

        public final JETToken getSuccessToken() {
            return this.successToken;
        }

        protected boolean scanForStart(ICharacterScanner scanner) {
            int i = 0;
            while (i < this.prefix.length) {
                if (this.prefix[i] != this.read(scanner)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected boolean scanForEnd(ICharacterScanner scanner) {
            int character = this.read(scanner);
            while (character != -1) {
                if (character == 37) {
                    if (this.read(scanner) == 62) {
                        return true;
                    }
                    this.unread(scanner);
                }
                character = this.read(scanner);
            }
            return false;
        }

        protected int read(ICharacterScanner scanner) {
            ++this.count;
            int read = scanner.read();
            if (trace) {
                if (read == -1) {
                    System.out.print("'eof'");
                } else if (read == 32) {
                    System.out.print("~");
                } else if (read == 10) {
                    System.out.print("\\n");
                } else if (read == 13) {
                    System.out.print("\\r");
                } else {
                    System.out.print((char)read);
                }
            }
            return read;
        }

        protected void unread(ICharacterScanner scanner) {
            --this.count;
            scanner.unread();
        }

        protected void unreadAll(ICharacterScanner scanner) {
            while (this.count-- > 0) {
                scanner.unread();
            }
            this.count = 0;
        }

        protected boolean isGreedy() {
            return true;
        }

        protected void skipLeading(ICharacterScanner scanner) {
            if (trace) {
                System.out.println("-----------");
            }
            if (this.isGreedy()) {
                int read = this.read(scanner);
                while (read == 32 || read == 9) {
                    read = this.read(scanner);
                }
                this.unread(scanner);
            }
        }

        public final IToken evaluate(ICharacterScanner scanner) {
            try {
                IToken iToken = this.doEvaluate(scanner);
                return iToken;
            }
            finally {
                this.count = 0;
            }
        }

        protected IToken doEvaluate(ICharacterScanner scanner) {
            this.skipLeading(scanner);
            if (this.scanForStart(scanner) && this.scanForEnd(scanner)) {
                return this.getSuccessToken();
            }
            this.unreadAll(scanner);
            return Token.UNDEFINED;
        }
    }

    static class JETScriptletErrorRule
    extends JETBaseErrorRule {
        public static final JETToken TOKEN = new JETToken(JETScriptletRule.TOKEN, "error", 0x20000000);

        public JETScriptletErrorRule() {
            super(TOKEN, JETScriptletRule.PREFIX);
        }
    }

    static class JETScriptletRule
    extends JETRule
    implements IRule {
        private static final char[] PREFIX = new char[]{'<', '%'};
        public static final JETToken TOKEN = new JETToken("scriptlet");

        public JETScriptletRule() {
            super(TOKEN, PREFIX);
        }

        @Override
        protected boolean scanForStart(ICharacterScanner scanner) {
            if (super.scanForStart(scanner)) {
                int read = this.read(scanner);
                this.unread(scanner);
                return read != 64 && read != 61 && read != 45;
            }
            return false;
        }
    }

    static class JETSourceViewerConfiguration
    extends TextSourceViewerConfiguration {
        private final DelegatingContentAssistProcessor delegatingContentAssistProcessor;
        private final DelegatingQuickAssistProcessor delegatingQuickAssistProcessor;
        private final BufferedRuleBasedScanner scanner = new BufferedRuleBasedScanner(1000);
        private final CompletionListener completionListener;
        private final JETEditor jetEditor;

        public JETSourceViewerConfiguration(IPreferenceStore preferenceStore, JETEditor jetEditor) {
            super(preferenceStore);
            this.jetEditor = jetEditor;
            this.delegatingContentAssistProcessor = new DelegatingContentAssistProcessor(jetEditor);
            this.delegatingQuickAssistProcessor = new DelegatingQuickAssistProcessor(jetEditor);
            this.completionListener = new CompletionListener(jetEditor);
            this.scanner.setRules(new IRule[]{new JETCommentRule(), new JETExpressionRule(), new JETDirectiveRule(), new JETScriptletRule(), new JETContentRule(), new JETTrailingWhitespaceContentRule(), new JETCommentErrorRule(), new JETExpressionErrorRule(), new JETDirectiveErrorRule(), new JETScriptletErrorRule()});
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            PresentationReconciler reconciler = this.createPresentationReconciler();
            reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            JETDamageRepairer damageRepairer = new JETDamageRepairer(this.jetEditor, (ITokenScanner)this.scanner);
            reconciler.setDamager((IPresentationDamager)damageRepairer, "__dftl_partition_content_type");
            reconciler.setRepairer((IPresentationRepairer)damageRepairer, "__dftl_partition_content_type");
            return reconciler;
        }

        protected PresentationReconciler createPresentationReconciler() {
            return new JETPresentationReconciler(this.jetEditor);
        }

        public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
            return new HTMLAnnotationHover(false){

                protected boolean isIncluded(Annotation annotation) {
                    return this.isShowInVerticalRuler(annotation);
                }
            };
        }

        public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
            int undoLevel = this.fPreferenceStore == null || !this.fPreferenceStore.contains("undoHistorySize") ? 25 : this.fPreferenceStore.getInt("undoHistorySize");
            return new CompositeUndoManager(this.jetEditor, undoLevel);
        }

        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
            ContentAssistant contentAssistant = new ContentAssistant();
            contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.delegatingContentAssistProcessor, "__dftl_partition_content_type");
            contentAssistant.addCompletionListener((ICompletionListener)this.completionListener);
            ContentAssistPreference.configure((ContentAssistant)contentAssistant, (IPreferenceStore)JavaPlugin.getDefault().getPreferenceStore());
            contentAssistant.enableColoredLabels(true);
            return contentAssistant;
        }

        public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
            QuickAssistAssistant assistant = new QuickAssistAssistant();
            assistant.setQuickAssistProcessor((IQuickAssistProcessor)this.delegatingQuickAssistProcessor);
            try {
                assistant.getClass().getMethod("setRestoreCompletionProposalSize", IDialogSettings.class).invoke((Object)assistant, CodeGenUIPlugin.getPlugin().getDialogSettingsSection("quick_assist_proposal_size"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            assistant.setInformationControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, EditorsPlugin.getAdditionalInfoAffordanceString());
                }
            });
            assistant.addCompletionListener((ICompletionListener)this.completionListener);
            return assistant;
        }

        public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, false);
                }
            };
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
            return this.jetEditor.delegatingTextHover;
        }

        protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
            Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
            targets.put("org.eclipse.emf.codegen.ui.jetTemplate", this.jetEditor);
            return targets;
        }

        static class CompletionListener
        implements ICompletionListener {
            private final JETEditor jetEditor;

            public CompletionListener(JETEditor jetEditor) {
                this.jetEditor = jetEditor;
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                this.jetEditor.setShowingContentAssist(true);
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                this.jetEditor.setShowingContentAssist(false);
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        }
    }

    static class JETTextSelectionNavigationLocation
    extends NavigationLocation {
        private static final String TAG_X = "x";
        private static final String TAG_Y = "y";
        private static final String TAG_DOCUMENT_ID = "document_id";
        private static final String TAG_INFO = "info";
        private static final String INFO_DELETED = "deleted";
        private static final String INFO_NOT_DELETED = "not_deleted";
        private static final String CATEGORY = "__navigation_" + JETTextSelectionNavigationLocation.class.hashCode();
        private static final IPositionUpdater POSITION_UPDATER = new DefaultPositionUpdater(CATEGORY);
        private Position position;
        private String documentID;
        private IDocument document;
        private Position savedPosition;

        public JETTextSelectionNavigationLocation(JETEditor jetEditor, boolean initialize) {
            super((IEditorPart)jetEditor);
            if (initialize) {
                Position position;
                ITextSelection selection = (ITextSelection)jetEditor.getSelectionProvider().getSelection();
                IDocument document = this.getDocument(jetEditor);
                if (JETEditor.installOnDocument(document, position = new Position(selection.getOffset(), selection.getLength()), CATEGORY, POSITION_UPDATER)) {
                    this.document = document;
                    this.documentID = this.getDocumentID(jetEditor);
                    Assert.isNotNull((Object)this.documentID, (String)"The document ID must be specified");
                    this.position = position;
                    if (!jetEditor.isDirty()) {
                        this.savedPosition = new Position(position.offset, position.length);
                    }
                }
            }
        }

        public String getDocumentID() {
            return this.documentID;
        }

        private String getDocumentID(JETEditor jetEditor) {
            return jetEditor.getDocumentManager().getDocumentID();
        }

        private IDocument getDocument(JETEditor jetEditor) {
            return jetEditor.getSourceViewer().getDocument();
        }

        public void dispose() {
            this.free();
            super.dispose();
        }

        private void free() {
            JETEditor.uninstallFromDocument(this.document, this.position, CATEGORY, POSITION_UPDATER);
            this.document = null;
            this.position = null;
            this.savedPosition = null;
            this.documentID = null;
        }

        public void releaseState() {
            this.free();
            super.releaseState();
        }

        public boolean mergeInto(INavigationLocation location) {
            if (location == null || location.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            JETTextSelectionNavigationLocation jetLocation = (JETTextSelectionNavigationLocation)location;
            if (!jetLocation.documentID.equals(this.documentID)) {
                return false;
            }
            if (this.position == null || this.position.isDeleted || this.document == null) {
                return true;
            }
            if (jetLocation.position == null || jetLocation.position.isDeleted) {
                JETEditor.uninstallFromDocument(this.document, this.position, CATEGORY, POSITION_UPDATER);
                jetLocation.document = this.document;
                jetLocation.position = this.position;
                jetLocation.savedPosition = this.savedPosition;
                jetLocation.documentID = this.documentID;
                return true;
            }
            if (jetLocation.document == this.document && (jetLocation.position.overlapsWith(this.position.offset, this.position.length) || this.position.offset + this.position.length == jetLocation.position.offset || jetLocation.position.offset + jetLocation.position.length == this.position.offset)) {
                jetLocation.position.offset = this.position.offset;
                jetLocation.position.length = this.position.length;
                return true;
            }
            return false;
        }

        public void restoreLocation() {
            IEditorPart part;
            if (this.position != null && !this.position.isDeleted && (part = this.getEditorPart()) instanceof JETEditor) {
                JETEditor editor = (JETEditor)this.getEditorPart();
                editor.selectAndReveal(this, this.position.offset, this.position.length);
            }
        }

        public void saveState(IMemento memento) {
            if (this.savedPosition != null) {
                memento.putInteger(TAG_X, this.savedPosition.offset);
                memento.putInteger(TAG_Y, this.savedPosition.length);
                memento.putString(TAG_INFO, this.savedPosition.isDeleted ? INFO_DELETED : INFO_NOT_DELETED);
                memento.putString(TAG_DOCUMENT_ID, this.documentID);
            }
        }

        public void restoreState(IMemento memento) {
            IEditorPart part = this.getEditorPart();
            if (part instanceof JETEditor) {
                this.documentID = memento.getString(TAG_DOCUMENT_ID);
                Integer offset = memento.getInteger(TAG_X);
                Integer length = memento.getInteger(TAG_Y);
                String deleted = memento.getString(TAG_INFO);
                if (offset != null && length != null) {
                    Position position;
                    this.position = position = new Position(offset.intValue(), length.intValue());
                    if (deleted != null) {
                        position.isDeleted = INFO_DELETED.equals(deleted);
                    }
                }
            }
        }

        public void restoreDocument(JETEditor jetEditor, IDocument document) {
            this.document = document;
            if (JETEditor.installOnDocument(document, this.position, CATEGORY, POSITION_UPDATER) && !jetEditor.isDirty()) {
                this.savedPosition = new Position(this.position.offset, this.position.length);
            }
        }

        public void partSaved(IEditorPart part) {
            this.savedPosition = this.position == null || this.position.isDeleted() ? null : new Position(this.position.offset, this.position.length);
        }

        private boolean samePosition(JETEditor jetEditor) {
            String text;
            if (this.position == null) {
                return true;
            }
            if (this.position.isDeleted) {
                return false;
            }
            if (!this.getDocumentID(jetEditor).equals(this.documentID)) {
                return false;
            }
            ITextSelection textSelection = (ITextSelection)jetEditor.getSelectionProvider().getSelection();
            if (textSelection.getOffset() == this.position.offset && textSelection.getLength() == this.position.length && (text = textSelection.getText()) != null) {
                try {
                    return text.equals(this.document.get(this.position.offset, this.position.length));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return false;
        }

        public void update() {
            ITextSelection selection;
            JETEditor textEditor;
            IEditorPart part = this.getEditorPart();
            if (part instanceof JETEditor && !this.samePosition(textEditor = (JETEditor)part) && ((selection = (ITextSelection)textEditor.getSelectionProvider().getSelection()).getOffset() != 0 || selection.getLength() != 0)) {
                this.position.offset = selection.getOffset();
                this.position.length = selection.getLength();
                this.position.isDeleted = false;
                if (!part.isDirty()) {
                    this.savedPosition = new Position(this.position.offset, this.position.length);
                }
            }
        }

        public String toString() {
            return "Selection<" + this.position + ">";
        }
    }

    static final class JETToken
    extends Token {
        private final String type;
        private final int textStyle;
        private final int borderStyle;
        private final JETToken baseToken;

        public JETToken(String type) {
            this(type, 0, 0);
        }

        public JETToken(String type, int textStyle, int borderStyle) {
            super(null);
            this.type = type;
            this.textStyle = textStyle;
            this.borderStyle = borderStyle;
            this.baseToken = this;
            ColorManager.INSTANCE.register(this);
        }

        public JETToken(JETToken baseToken, String type, int textStyle) {
            this(baseToken, type, textStyle, 0);
        }

        public JETToken(JETToken baseToken, String type, int textStyle, int borderStyle) {
            super(null);
            this.type = String.valueOf(type) + '.' + baseToken.getType();
            this.textStyle = textStyle;
            this.baseToken = baseToken;
            this.borderStyle = borderStyle;
            ColorManager.INSTANCE.register(this);
        }

        public final String getType() {
            return this.type;
        }

        public final JETToken getBaseToken() {
            return this.baseToken;
        }

        public final int getTextStyle() {
            return this.textStyle;
        }

        public final int getBorderStyle() {
            return this.borderStyle;
        }

        public final void setData(TextAttribute textAttribute) {
            super.setData((Object)textAttribute);
        }

        public final void setData(Object data) {
            super.setData((Object)((TextAttribute)data));
        }

        public final String toString() {
            return "JETToken:" + this.type;
        }

        public final IRegion match(Point tokenRange, int offset) {
            int prefixLength = -1;
            if (this.type.equals("scriptlet")) {
                prefixLength = 2;
            } else if (this.type.equals("expression") || this.type.equals("directive") || this.type.equals("comment")) {
                prefixLength = 3;
            }
            if (prefixLength != -1) {
                if (offset == tokenRange.x + tokenRange.y || offset == tokenRange.x + 1) {
                    return new Region(tokenRange.x, tokenRange.y);
                }
                if (offset == tokenRange.x + tokenRange.y - 1 || offset == tokenRange.x + 2) {
                    return new Region(tokenRange.x + 1, tokenRange.y - 2);
                }
                if (prefixLength == 3 && (offset == tokenRange.x + tokenRange.y - 1 || offset == tokenRange.x + 3)) {
                    return new Region(tokenRange.x + 2, tokenRange.y - 3);
                }
            }
            return null;
        }
    }

    static class JETTokenRegion {
        private final JETToken token;
        private int offset;
        private int length;

        public JETTokenRegion(int offset, int length, JETToken token) {
            this.offset = offset;
            this.length = length;
            this.token = token;
        }

        public JETToken getToken() {
            return this.token;
        }

        public void shrinkToJava(IDocument document) {
            if (this.token == JETScriptletRule.TOKEN) {
                int delta = 0;
                try {
                    while (Character.isWhitespace(document.getChar(this.offset + delta))) {
                        ++delta;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.offset += delta + 2;
                this.length -= delta + 2;
            } else if (this.token == JETExpressionRule.TOKEN) {
                this.offset += 3;
                this.length -= 5;
            }
        }

        public void expand() {
            --this.offset;
            this.length += 2;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }
    }

    static class JETTrailingWhitespaceContentRule
    extends JETRule
    implements IRule {
        private static final char[] PREFIX = new char[0];
        public static final JETToken TOKEN = new JETToken(JETContentRule.TOKEN, "trailing-whitespace-content", 0, 1);

        public JETTrailingWhitespaceContentRule() {
            super(TOKEN, PREFIX);
        }

        @Override
        protected IToken doEvaluate(ICharacterScanner scanner) {
            int read = this.read(scanner);
            while (read != -1) {
                if (read == 10) {
                    return this.getSuccessToken();
                }
                if (read != 32 && read != 9 && read != 13) {
                    this.unreadAll(scanner);
                    return Token.UNDEFINED;
                }
                read = this.read(scanner);
            }
            return this.getCount() == 1 ? Token.EOF : this.getSuccessToken();
        }
    }

    static class JavaDocumentTransaction
    implements IDocumentListener {
        private static final Pattern IMPORT_PATTERN = Pattern.compile("import ([^;]+);");
        protected final JETEditor jetEditor;
        protected final List<TrackedPosition> jetPositions;
        private final boolean transformBraces;
        private final boolean ignoreOutOfScopeChanges;
        private List<String> imports = new ArrayList<String>();
        private IStatus status;
        private static Pattern BRACE_COLLAPSE_PATTERN = Pattern.compile("\\s\\s+\\{");
        private static Pattern TAB_REPLACEMENT_PATTERN = Pattern.compile("\t");
        private static Pattern INDENT_FIX_PATTERN_ = Pattern.compile("(\r?\n)  ");

        public JavaDocumentTransaction(JETEditor jetEditor, List<TrackedPosition> jetPositions, boolean transformBraces, boolean ignoreOutOfScopeChanges) {
            this.jetEditor = jetEditor;
            this.jetPositions = jetPositions;
            this.transformBraces = transformBraces;
            this.ignoreOutOfScopeChanges = ignoreOutOfScopeChanges;
        }

        public void modify(IDocument document, Runnable javaModifier) {
            this.start();
            this.jetEditor.getDocumentManager().setEnableJavaSynchronization(false);
            document.addDocumentListener((IDocumentListener)this);
            try {
                try {
                    javaModifier.run();
                    if (this.status == null) {
                        this.commit(document);
                    }
                }
                catch (Exception exception) {
                    this.status = CodeGenUIPlugin.toStatus(4, exception);
                    document.removeDocumentListener((IDocumentListener)this);
                    this.jetEditor.getDocumentManager().setEnableJavaSynchronization(true);
                    this.stop();
                }
            }
            finally {
                document.removeDocumentListener((IDocumentListener)this);
                this.jetEditor.getDocumentManager().setEnableJavaSynchronization(true);
                this.stop();
            }
        }

        protected void startDocumentRewriteSession(ISourceViewer sourceViewer, DocumentRewriteSessionType type, boolean rememberSelection) {
            if (rememberSelection) {
                try {
                    Method rememberSelectionMethod = SourceViewer.class.getDeclaredMethod("rememberSelection", new Class[0]);
                    rememberSelectionMethod.setAccessible(true);
                    rememberSelectionMethod.invoke((Object)sourceViewer, new Object[0]);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            ((IDocumentExtension4)sourceViewer.getDocument()).startRewriteSession(type);
        }

        protected void stopDocumentRewriteSession(ISourceViewer sourceViewer, boolean restoreSelection) {
            IDocumentExtension4 extension = (IDocumentExtension4)sourceViewer.getDocument();
            extension.stopRewriteSession(extension.getActiveRewriteSession());
            if (restoreSelection) {
                try {
                    Method rememberSelectionMethod = SourceViewer.class.getDeclaredMethod("restoreSelection", new Class[0]);
                    rememberSelectionMethod.setAccessible(true);
                    rememberSelectionMethod.invoke((Object)sourceViewer, new Object[0]);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }

        protected void start() {
        }

        protected void stop() {
        }

        public IStatus getStatus() {
            return this.status == null ? Status.OK_STATUS : this.status;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (this.status == null) {
                for (TrackedPosition jetPosition : this.jetPositions) {
                    TrackedPosition javaPosition = jetPosition.getOpposite();
                    if (!javaPosition.overlapsWith(event.getOffset(), event.getLength())) continue;
                    return;
                }
                String replacement = event.getText();
                Matcher matcher = IMPORT_PATTERN.matcher(replacement);
                if (matcher.matches()) {
                    String newImport = matcher.group(1);
                    this.imports.add(newImport);
                } else if (!this.ignoreOutOfScopeChanges && replacement.trim().length() != 0) {
                    this.status = new Status(4, CodeGenUIPlugin.getPlugin().getBundle().getSymbolicName(), "Changes outside the scope of the current document occurred.");
                }
            }
        }

        protected void commit(IDocument delegateDocument) throws Exception {
            SourceViewer jetSourceViewer = this.jetEditor.getJETSourceViewer();
            IUndoManager undoManager = jetSourceViewer.getUndoManager();
            undoManager.beginCompoundChange();
            try {
                MultiTextEdit textEdit = new MultiTextEdit();
                for (TrackedPosition jetPosition : this.jetPositions) {
                    TrackedPosition javaPosition = jetPosition.getOpposite();
                    if (javaPosition.isDeleted()) continue;
                    String finalJavaText = javaPosition.getText();
                    String originalTemplateJavaText = jetPosition.getText();
                    if (originalTemplateJavaText.equals(finalJavaText)) continue;
                    int orginalTemplateJavaTextLength = jetPosition.getLength();
                    int finalJavaTextLength = javaPosition.getLength();
                    int start = 0;
                    while (start < finalJavaTextLength && start < orginalTemplateJavaTextLength && finalJavaText.charAt(start) == originalTemplateJavaText.charAt(start)) {
                        ++start;
                    }
                    if (start == orginalTemplateJavaTextLength - 1 && orginalTemplateJavaTextLength == finalJavaTextLength) continue;
                    int end = 0;
                    while (finalJavaTextLength - end > 0 && orginalTemplateJavaTextLength - end > 0 && finalJavaText.charAt(finalJavaTextLength - end - 1) == originalTemplateJavaText.charAt(orginalTemplateJavaTextLength - end - 1)) {
                        ++end;
                    }
                    int replacementOffset = jetPosition.getOffset() + start;
                    int replacementLength = orginalTemplateJavaTextLength - end - start;
                    while (replacementLength < 0) {
                        ++replacementLength;
                        --end;
                    }
                    int finalJavaTextEnd = finalJavaTextLength - end;
                    String replacementText = finalJavaTextEnd < start ? "" : this.handleReplacement(finalJavaText.substring(start, finalJavaTextEnd));
                    ReplaceEdit replaceEdit = new ReplaceEdit(replacementOffset, replacementLength, replacementText);
                    textEdit.addChild((TextEdit)replaceEdit);
                }
                int jetDirectiveFileID = -1;
                int importsOffset = -1;
                boolean needsImportsAttribute = false;
                StringBuilder newImports = new StringBuilder();
                if (!this.imports.isEmpty()) {
                    JETDirectiveItem jetJETDirectiveItem = this.jetEditor.getCompilationUnit().getJETJETDirectiveItem();
                    jetDirectiveFileID = jetJETDirectiveItem.getFileID();
                    JETAttributeItem imports = jetJETDirectiveItem.getAttribute("imports");
                    for (String newImport : this.imports) {
                        if (imports == null) {
                            importsOffset = jetJETDirectiveItem.getAttributes().getStopOffset();
                            needsImportsAttribute = true;
                            if (newImports.length() != 0) {
                                newImports.append(' ');
                            }
                        } else {
                            JETTokenItem importValue = imports.getValueToken();
                            if (importsOffset == -1) {
                                JETValueItem valueItem = importValue.getValueItem();
                                importsOffset = valueItem.getStopOffset();
                                if (!valueItem.getElements().isEmpty()) {
                                    newImports.append(' ');
                                }
                            } else {
                                newImports.append(' ');
                            }
                        }
                        newImports.append(newImport);
                    }
                }
                if (importsOffset != -1) {
                    String insertion = needsImportsAttribute ? " imports=\"" + newImports + "\"" : newImports.toString();
                    ReplaceEdit insertImportsEdit = new ReplaceEdit(importsOffset, 0, insertion);
                    if (jetDirectiveFileID != this.jetEditor.getFileID()) {
                        IDocument jetDirectiveDocument = this.jetEditor.getDocumentManager().getDocument(jetDirectiveFileID);
                        if (jetDirectiveDocument != null) {
                            try {
                                insertImportsEdit.apply(jetDirectiveDocument);
                            }
                            catch (Exception exception) {
                                CodeGenUIPlugin.getPlugin().log(exception);
                            }
                        }
                    } else {
                        textEdit.addChild((TextEdit)insertImportsEdit);
                    }
                }
                try {
                    TextEdit[] children = textEdit.getChildren();
                    if (children.length > 0) {
                        this.startDocumentRewriteSession((ISourceViewer)jetSourceViewer, children.length > 50 ? DocumentRewriteSessionType.UNRESTRICTED : DocumentRewriteSessionType.UNRESTRICTED_SMALL, false);
                        IDocument document = jetSourceViewer.getDocument();
                        textEdit.apply(document);
                    }
                    this.postCommit(this.jetPositions);
                }
                finally {
                    this.stopDocumentRewriteSession((ISourceViewer)jetSourceViewer, false);
                }
            }
            finally {
                undoManager.endCompoundChange();
            }
        }

        protected String handleReplacement(String replacement) {
            if (this.transformBraces) {
                String result = BRACE_COLLAPSE_PATTERN.matcher(replacement).replaceAll(" {");
                result = TAB_REPLACEMENT_PATTERN.matcher(result).replaceAll("  ");
                result = INDENT_FIX_PATTERN_.matcher(result).replaceAll("$1");
                return result;
            }
            return replacement;
        }

        protected void postCommit(List<TrackedPosition> jetPositions) {
        }
    }

    static final class JavaEditor
    extends CompilationUnitEditor {
        static final Map<String, String> SELECTION_ACTIONS = new LinkedHashMap<String, String>();
        private final JETEditor jetEditor;
        private boolean navigating;
        private IAction openDeclarationAction;
        private DefaultCharacterPairMatcher bracketMatcher;

        static {
            SELECTION_ACTIONS.put("SelectEnclosingElement", "org.eclipse.jdt.ui.edit.text.java.select.enclosing");
            SELECTION_ACTIONS.put("SelectNextElement", "org.eclipse.jdt.ui.edit.text.java.select.next");
            SELECTION_ACTIONS.put("SelectPreviousElement", "org.eclipse.jdt.ui.edit.text.java.select.previous");
            SELECTION_ACTIONS.put("RestoreLastSelection", "org.eclipse.jdt.ui.edit.text.java.select.last");
        }

        public JavaEditor(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
            this.setDocumentProvider((IDocumentProvider)new StatusFilteringForwardingDocumentProvider(this.getDocumentProvider()));
        }

        SourceViewer getJavaSourceViewer() {
            return (SourceViewer)this.getSourceViewer();
        }

        public IAction getAction(String actionID) {
            if ("OpenEditor".equals(actionID)) {
                return this.getOpenDeclarationAction();
            }
            final IAction action = super.getAction(actionID);
            String actionDefinitionID = SELECTION_ACTIONS.get(actionID);
            if (actionDefinitionID != null) {
                return new Action(action.getText(), action.getStyle()){

                    public void run() {
                        try {
                            navigating = true;
                            action.run();
                            jetEditor.selectionSynchronizer.sync((ISourceViewer)this.getJavaSourceViewer());
                        }
                        finally {
                            navigating = false;
                        }
                    }
                };
            }
            if (JETEditor.EXTRACT_LOCAL_VARIABLE_ACTION_ID.equals(actionID)) {
                return new JETExtractLocalVariableAction(this.jetEditor, action);
            }
            return action;
        }

        IJavaElement[] getSelectedElements() {
            ITypeRoot inputJavaElement = this.getInputJavaElement();
            Point selectedRange = this.getJavaSourceViewer().getSelectedRange();
            try {
                return inputJavaElement.codeSelect(selectedRange.x, selectedRange.y);
            }
            catch (JavaModelException e) {
                return null;
            }
        }

        DefaultCharacterPairMatcher getJavaBracketMatcher() {
            if (this.bracketMatcher == null) {
                try {
                    Field field = org.eclipse.jdt.internal.ui.javaeditor.JavaEditor.class.getDeclaredField("fBracketMatcher");
                    field.setAccessible(true);
                    this.bracketMatcher = (DefaultCharacterPairMatcher)field.get((Object)this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.bracketMatcher;
        }

        IHyperlinkDetector[] getHyperlinkDetectors() {
            IHyperlinkDetector[] hyperlinkDetectors = this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer());
            return hyperlinkDetectors;
        }

        boolean isNavigating() {
            return this.navigating;
        }

        IAction getOpenDeclarationAction() {
            if (this.openDeclarationAction == null) {
                this.openDeclarationAction = new OpenAction((org.eclipse.jdt.internal.ui.javaeditor.JavaEditor)this){

                    public void run(Object[] elements) {
                        IFileEditorInput editorInput = (IFileEditorInput)this.getEditorInput();
                        IPath editorInputPath = editorInput.getFile().getFullPath();
                        Object[] objectArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPath path;
                            Object element = objectArray[n2];
                            if (element instanceof IJavaElement && editorInputPath.equals((Object)(path = ((IJavaElement)element).getPath()))) {
                                try {
                                    navigating = true;
                                    JavaUI.revealInEditor((IEditorPart)this, (IJavaElement)((IJavaElement)element));
                                    SourceViewer javaSourceViewer = this.getJavaSourceViewer();
                                    javaSourceViewer.getTextWidget().notifyListeners(13, new Event());
                                }
                                finally {
                                    navigating = false;
                                }
                                return;
                            }
                            ++n2;
                        }
                        super.run(elements);
                    }
                };
            }
            return this.openDeclarationAction;
        }

        IAction getGotoMatchingBracketAction() {
            final IAction gotoMatchingBracketAction = this.getAction("GotoMatchingBracket");
            gotoMatchingBracketAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.matching.bracket");
            return new Action(gotoMatchingBracketAction.getText(), gotoMatchingBracketAction.getStyle()){

                public void run() {
                    JETBracketMatcher jetBracketMatcher = jetEditor.getJetBracketMatcher();
                    ISourceViewer jetSourceViewer = jetEditor.getSourceViewer();
                    Point selectedRange = jetSourceViewer.getSelectedRange();
                    IRegion jetMatch = jetBracketMatcher.match(jetSourceViewer.getDocument(), selectedRange.x);
                    if (jetMatch == null) {
                        try {
                            navigating = true;
                            gotoMatchingBracketAction.run();
                        }
                        finally {
                            navigating = false;
                        }
                    } else {
                        int offset = jetMatch.getOffset();
                        int length = jetMatch.getLength();
                        int targetOffset = jetBracketMatcher.getAnchor() == 0 ? offset + 1 : offset + length;
                        jetEditor.selectAndReveal(targetOffset, 0);
                    }
                }
            };
        }

        IContentAssistant getContentAssist() {
            try {
                Field field = SourceViewer.class.getDeclaredField("fContentAssistant");
                field.setAccessible(true);
                return (IContentAssistant)field.get(this.getSourceViewer());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        IQuickAssistAssistant getQuickAssistAssistant() {
            try {
                Field field = SourceViewer.class.getDeclaredField("fQuickAssistAssistant");
                field.setAccessible(true);
                return (IQuickAssistAssistant)field.get(this.getSourceViewer());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            JETCompilationUnit compilerResult = this.jetEditor.getCompilationUnit();
            if (compilerResult != null) {
                IRegion javaWordRegion = JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)region.getOffset());
                int correspondingTemplateFileID = compilerResult.getCorrespondingTemplateFileID(region.getOffset());
                if (correspondingTemplateFileID != -1 && correspondingTemplateFileID != this.jetEditor.getFileID()) {
                    JETHyperLink jetHyperLink = new JETHyperLink(this.jetEditor, (IRegion)(javaWordRegion == null || javaWordRegion.getLength() == 0 ? new Region(region.getOffset(), 1) : javaWordRegion), correspondingTemplateFileID, JETEditor.toURI(this.jetEditor.getDocumentManager().getEditorInput(correspondingTemplateFileID)).toString()){

                        @Override
                        public String getTypeLabel() {
                            return "Open JET";
                        }
                    };
                    return new IHyperlink[]{jetHyperLink};
                }
            }
            return null;
        }

        protected void markInNavigationHistory() {
        }

        protected ITypeRoot getInputJavaElement() {
            ITypeRoot inputJavaElement = super.getInputJavaElement();
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof JavaEditorInput) {
                return ((JavaEditorInput)editorInput).getWorkingCopy(inputJavaElement);
            }
            return inputJavaElement;
        }

        public void dispose() {
            super.dispose();
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof JavaEditorInput) {
                ((JavaEditorInput)editorInput).releaseWorkingCopy();
            }
        }

        void setInput(IFile javaFile, String compilationUnit) {
            IEditorInput oldInput;
            FileEditorInput newInput;
            IFile effectiveJavaFile = javaFile;
            boolean javaFileExists = javaFile.exists();
            if (!javaFileExists) {
                IContainer parent = javaFile.getParent();
                while (!parent.exists()) {
                    parent = parent.getParent();
                }
                if (parent.getType() == 8) {
                    parent = this.jetEditor.getEditorInputFile().getParent();
                }
                effectiveJavaFile = parent.getFile((IPath)new Path(javaFile.getName()));
            }
            if (!(newInput = javaFileExists ? new FileEditorInput(effectiveJavaFile) : new JavaEditorInput(effectiveJavaFile, compilationUnit)).equals(oldInput = this.getEditorInput())) {
                this.setInput((IEditorInput)newInput);
                this.getJavaSourceViewer().setEditable(false);
                if (oldInput instanceof JavaEditorInput) {
                    ((JavaEditorInput)oldInput).releaseWorkingCopy();
                }
            }
            this.jetEditor.getJavaPosition().addToDocument(this.getJavaSourceViewer().getDocument());
            if (newInput instanceof JavaEditorInput) {
                ((JavaEditorInput)newInput).release();
            }
        }

        public void init(IEditorSite site, IEditorInput input) throws PartInitException {
            super.init((IEditorSite)new DelegatingEditorSite(site), input);
            IPerspectiveDescriptor perspective = this.getSite().getPage().getPerspective();
            String id = "breadcrumb." + perspective.getId();
            IPreferenceStore preferenceStore = this.getPreferenceStore();
            PreferenceStore localPreferenceStore = new PreferenceStore();
            localPreferenceStore.setValue("editor_folding_enabled", false);
            this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{localPreferenceStore, preferenceStore}));
            localPreferenceStore.setValue(id, true);
        }

        public void createPartControl(Composite parent) {
            super.createPartControl(parent);
            new VisibleCaretHandler(this.getSourceViewer().getTextWidget(), this.jetEditor.getSourceViewer().getTextWidget());
            ((ITextViewerExtension4)this.getSourceViewer()).addTextPresentationListener(new ITextPresentationListener(){

                private Color getBackground(JETCompilationUnit.JETJavaRange jetRange) {
                    JETItem jetItem = jetRange.getJETItem();
                    if (jetItem instanceof JETScriptletItem) {
                        return ColorManager.INSTANCE.getBackground(JETScriptletRule.TOKEN.getType());
                    }
                    if (jetItem instanceof JETExpressionItem) {
                        return ColorManager.INSTANCE.getBackground(JETExpressionRule.TOKEN.getType());
                    }
                    if (jetItem instanceof JETLiteralItem) {
                        return ColorManager.INSTANCE.getBackground(JETContentRule.TOKEN.getType());
                    }
                    if (jetItem instanceof JETSubItem && jetItem.getParent() instanceof JETCommentItem) {
                        return ColorManager.INSTANCE.getBackground(JETCommentRule.TOKEN.getType());
                    }
                    return ColorManager.INSTANCE.getBackground(JETDirectiveRule.TOKEN.getType());
                }

                /*
                 * Unable to fully structure code
                 */
                public void applyTextPresentation(TextPresentation textPresentation) {
                    block9: {
                        ranges = JavaEditor.access$1(this).getRanges();
                        if (ranges.isEmpty() || !(i = textPresentation.getAllStyleRangeIterator()).hasNext()) break block9;
                        newStyleRanges = new ArrayList<StyleRange>();
                        r = ranges.iterator();
                        range = r.next();
                        styleRange = (StyleRange)i.next();
                        while (true) {
                            block14: {
                                block15: {
                                    block12: {
                                        block13: {
                                            rangeJavaLength = range.getJavaLength();
                                            while (rangeJavaLength == 0) {
                                                block10: {
                                                    if (r.hasNext()) break block10;
                                                    newStyleRanges.add(styleRange);
                                                    ** GOTO lbl78
                                                }
                                                range = r.next();
                                                rangeJavaLength = range.getJavaLength();
                                            }
                                            javaOffset = styleRange.start;
                                            rangeJavaOffset = range.getJavaOffset();
                                            while (rangeJavaOffset + rangeJavaLength <= javaOffset) {
                                                block11: {
                                                    if (r.hasNext()) break block11;
                                                    newStyleRanges.add(styleRange);
                                                    ** GOTO lbl78
                                                }
                                                range = r.next();
                                                rangeJavaOffset = range.getJavaOffset();
                                                rangeJavaLength = range.getJavaLength();
                                            }
                                            while (javaOffset + styleRange.length <= rangeJavaOffset) {
                                                newStyleRanges.add(styleRange);
                                                if (i.hasNext()) {
                                                    styleRange = (StyleRange)i.next();
                                                    javaOffset = styleRange.start;
                                                    continue;
                                                }
                                                ** GOTO lbl78
                                            }
                                            delta = rangeJavaOffset - javaOffset;
                                            if (delta <= 0) break block12;
                                            newStyleRange = (StyleRange)styleRange.clone();
                                            newStyleRange.length = delta;
                                            newStyleRanges.add(newStyleRange);
                                            if (styleRange.length != delta) break block13;
                                            if (i.hasNext()) {
                                                styleRange = (StyleRange)i.next();
                                                continue;
                                            }
                                            ** GOTO lbl78
                                        }
                                        javaOffset = styleRange.start += delta;
                                        styleRange.length -= delta;
                                    }
                                    if ((lengthDelta = styleRange.length - rangeJavaLength) <= 0) break block14;
                                    newStyleRange = (StyleRange)styleRange.clone();
                                    newStyleRange.length = rangeJavaLength;
                                    newStyleRange.background = this.getBackground(range);
                                    newStyleRanges.add(newStyleRange);
                                    styleRange.start += rangeJavaLength;
                                    styleRange.length = lengthDelta;
                                    if (r.hasNext()) break block15;
                                    newStyleRanges.add(styleRange);
                                    ** GOTO lbl78
                                }
                                range = r.next();
                                continue;
                            }
                            styleRange.background = this.getBackground(range);
                            newStyleRanges.add(styleRange);
                            if (!i.hasNext()) ** GOTO lbl78
                            range = range.subrange(styleRange.length);
                            styleRange = (StyleRange)i.next();
                        }
lbl-1000:
                        // 1 sources

                        {
                            newStyleRanges.add((StyleRange)i.next());
lbl78:
                            // 7 sources

                            ** while (i.hasNext())
                        }
lbl79:
                        // 1 sources

                        textPresentation.clear();
                        for (StyleRange newStyleRange : newStyleRanges) {
                            textPresentation.addStyleRange(newStyleRange);
                        }
                    }
                    if (JavaEditor.access$1(this).isJavaEditorInSync()) {
                        JavaEditor.access$1(this).invalidateVisibleTextPresentation(true);
                    }
                }
            });
            try {
                Field textListenerField = AbstractTextEditor.class.getDeclaredField("fTextListener");
                textListenerField.setAccessible(true);
                Object textListener = textListenerField.get((Object)this);
                Field runnableField = textListener.getClass().getDeclaredField("fRunnable");
                runnableField.setAccessible(true);
                runnableField.set(textListener, new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((IPostSelectionProvider)this.getSelectionProvider()).addSelectionChangedListener((ISelectionChangedListener)new JavadocUpdater(this.jetEditor));
        }

        private static class DelegatingEditorSite
        implements IEditorSite {
            private final IEditorSite editorSite;
            private SubActionBars subActionBars;

            public DelegatingEditorSite(IEditorSite editorSite) {
                this.editorSite = editorSite;
                this.subActionBars = new SubActionBars(this.getEditorSite().getActionBars());
            }

            public IEditorSite getEditorSite() {
                return this.editorSite;
            }

            public IEditorActionBarContributor getActionBarContributor() {
                return this.getEditorSite().getActionBarContributor();
            }

            public String getId() {
                return "org.eclipse.jdt.ui.CompilationUnitEditor";
            }

            public boolean hasService(Class api) {
                return false;
            }

            public Object getService(Class api) {
                return null;
            }

            public String getPluginId() {
                return this.getEditorSite().getPluginId();
            }

            public Object getAdapter(Class adapter) {
                return this.getEditorSite().getAdapter(adapter);
            }

            public IWorkbenchPage getPage() {
                return this.getEditorSite().getPage();
            }

            public ISelectionProvider getSelectionProvider() {
                return this.getEditorSite().getSelectionProvider();
            }

            public Shell getShell() {
                return this.getEditorSite().getShell();
            }

            public IActionBars getActionBars() {
                return this.subActionBars;
            }

            public IWorkbenchPart getPart() {
                return this.getEditorSite().getPart();
            }

            public IWorkbenchWindow getWorkbenchWindow() {
                return this.getEditorSite().getWorkbenchWindow();
            }

            public void setSelectionProvider(ISelectionProvider provider) {
                this.getEditorSite().setSelectionProvider(provider);
            }

            public String getRegisteredName() {
                return this.getEditorSite().getRegisteredName();
            }

            public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
            }

            public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
            }

            public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
            }

            public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
            }

            public IKeyBindingService getKeyBindingService() {
                return new DelegatingKeyBindingService();
            }

            private static class DelegatingKeyBindingService
            implements IKeyBindingService {
                private DelegatingKeyBindingService() {
                }

                public String[] getScopes() {
                    return new String[0];
                }

                public void registerAction(IAction action) {
                }

                public void setScopes(String[] scopes) {
                }

                public void unregisterAction(IAction action) {
                }
            }
        }

        private static final class JavadocUpdater
        implements ISelectionChangedListener {
            private final JETEditor jetEditor;

            public JavadocUpdater(JETEditor jetEditor) {
                this.jetEditor = jetEditor;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IViewPart[] viewStack;
                IWorkbenchPage page;
                IViewPart javadocView;
                JavaEditor javaEditor = this.jetEditor.getJavaEditor();
                ISelectionProvider selectionProvider = javaEditor.getSelectionProvider();
                ISelectionValidator selectionValidator = (ISelectionValidator)selectionProvider;
                if (selectionValidator.isValid(event.getSelection()) && (javadocView = (page = this.jetEditor.getSite().getPage()).findView("org.eclipse.jdt.ui.JavadocView")) != null && (viewStack = page.getViewStack(javadocView)) != null && viewStack.length > 0 && viewStack[0] == javadocView) {
                    ((ISelectionListener)javadocView).selectionChanged((IWorkbenchPart)javaEditor, selectionProvider.getSelection());
                }
            }
        }

        private static final class StatusFilteringForwardingDocumentProvider
        extends ForwardingDocumentProvider {
            public StatusFilteringForwardingDocumentProvider(IDocumentProvider parentProvider) {
                super("___java_partitioning", new IDocumentSetupParticipant(){

                    public void setup(IDocument document) {
                    }
                }, parentProvider);
            }

            public IStatus getStatus(Object element) {
                return Status.OK_STATUS;
            }
        }
    }

    static class JavaEditorInput
    extends FileEditorInput {
        private boolean isConnected;
        private boolean isWorkingCopy;
        private ICompilationUnit workingCopy;

        public JavaEditorInput(IFile file, String content) {
            super(file);
            try {
                IPath path = file.getFullPath();
                FileBuffers.getTextFileBufferManager().connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                this.isConnected = true;
                ITextFileBuffer textFileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(path, LocationKind.IFILE);
                if (textFileBuffer instanceof IStateValidationSupport) {
                    ((IStateValidationSupport)textFileBuffer).validationStateChanged(true, Status.OK_STATUS);
                }
                IDocument document = textFileBuffer.getDocument();
                document.set(content);
            }
            catch (CoreException exception) {
                CodeGenUIPlugin.getPlugin().log((Object)exception);
            }
        }

        public synchronized ITypeRoot getWorkingCopy(ITypeRoot inputJavaElement) {
            if (!this.isWorkingCopy && inputJavaElement instanceof ICompilationUnit) {
                try {
                    ICompilationUnit workingCopy = (ICompilationUnit)inputJavaElement;
                    workingCopy.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                    this.workingCopy = workingCopy;
                    this.isWorkingCopy = true;
                }
                catch (JavaModelException exception) {
                    this.isWorkingCopy = true;
                    CodeGenUIPlugin.getPlugin().log((Object)exception);
                }
            }
            return inputJavaElement;
        }

        public void releaseWorkingCopy() {
            if (this.workingCopy != null) {
                try {
                    this.workingCopy.discardWorkingCopy();
                }
                catch (JavaModelException exception) {
                    CodeGenUIPlugin.getPlugin().log((Object)exception);
                }
            }
        }

        public void release() {
            if (this.isConnected) {
                IPath path = this.getFile().getFullPath();
                try {
                    FileBuffers.getTextFileBufferManager().disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException exception) {
                    CodeGenUIPlugin.getPlugin().log((Object)exception);
                }
            }
        }
    }

    static class JavaHyperLink
    implements IHyperlink {
        private final JETEditor jetEditor;
        private final IRegion region;
        private final IHyperlink javaHyperlink;

        public JavaHyperLink(JETEditor jetEditor, IRegion region, IHyperlink javaHyperlink) {
            this.jetEditor = jetEditor;
            this.region = region;
            this.javaHyperlink = javaHyperlink;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return this.javaHyperlink.getTypeLabel();
        }

        public String getHyperlinkText() {
            return this.javaHyperlink.getHyperlinkText();
        }

        public void open() {
            this.jetEditor.markInNavigationHistory();
            this.javaHyperlink.open();
        }
    }

    static class LocalWorkingCopy
    extends WorkingCopyOwner {
        private String contents;

        public LocalWorkingCopy(String contents) {
            this.contents = contents;
        }

        public IBuffer createBuffer(final ICompilationUnit workingCopy) {
            return new IBuffer(){

                public IOpenable getOwner() {
                    return workingCopy;
                }

                public String getText(int offset, int length) throws IndexOutOfBoundsException {
                    return contents.substring(offset, offset + length);
                }

                public int getLength() {
                    return contents.length();
                }

                public String getContents() {
                    return contents;
                }

                public char[] getCharacters() {
                    return contents.toCharArray();
                }

                public char getChar(int position) {
                    return contents.charAt(position);
                }

                public boolean isReadOnly() {
                    return true;
                }

                public boolean isClosed() {
                    return false;
                }

                public boolean hasUnsavedChanges() {
                    return false;
                }

                public IResource getUnderlyingResource() {
                    return null;
                }

                public void close() {
                }

                public void save(IProgressMonitor progress, boolean force) throws JavaModelException {
                    throw new UnsupportedOperationException();
                }

                public void setContents(String contents) {
                    throw new UnsupportedOperationException();
                }

                public void setContents(char[] contents) {
                    throw new UnsupportedOperationException();
                }

                public void replace(int position, int length, String text) {
                    throw new UnsupportedOperationException();
                }

                public void replace(int position, int length, char[] text) {
                    throw new UnsupportedOperationException();
                }

                public void append(String text) {
                    throw new UnsupportedOperationException();
                }

                public void append(char[] text) {
                    throw new UnsupportedOperationException();
                }

                public void addBufferChangedListener(IBufferChangedListener listener) {
                }

                public void removeBufferChangedListener(IBufferChangedListener listener) {
                }
            };
        }
    }

    static class SelectEnclosingJETElementAction
    extends Action {
        private JETEditor jetEditor;

        public SelectEnclosingJETElementAction(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
        }

        public void run() {
            ISourceViewer sourceViewer = this.jetEditor.getSourceViewer();
            Point selectedRange = sourceViewer.getSelectedRange();
            JETItem startItem = this.jetEditor.getJETItem(selectedRange.x, false);
            JETItem stopItem = this.jetEditor.getJETItem(selectedRange.x + selectedRange.y, false);
            if (startItem != null) {
                Point startRange = this.getRange(startItem);
                int offset = startRange.x;
                int end = startRange.x + startRange.y;
                if (stopItem != null) {
                    Point stopRange = this.getRange(stopItem);
                    end = stopRange.x + stopRange.y;
                }
                this.jetEditor.selectAndReveal(offset, end - offset);
            }
        }

        private Point getRange(JETItem jetItem) {
            Point tokenRange;
            if ((jetItem instanceof JETScriptletItem || jetItem instanceof JETExpressionItem || jetItem instanceof JETCommentItem) && (tokenRange = this.jetEditor.getTokenRangeAt(jetItem.getStartOffset())) != null) {
                return tokenRange;
            }
            int start = jetItem.getStartOffset();
            int stop = jetItem.getStopOffset();
            return new Point(start, stop - start);
        }
    }

    static class SelectionSynchronizer {
        private final JETEditor jetEditor;
        private final JavaEditor javaEditor;
        private final ISourceViewer jetUnderlyingSourceViewer;
        private final ISourceViewer javaUnderlyingSourceViewer;
        private CaretAndSelectionListener jetToJava;
        private CaretAndSelectionListener javaToJET;

        public SelectionSynchronizer(JETEditor jetEditor, JavaEditor javaEditor) {
            this.jetEditor = jetEditor;
            this.javaEditor = javaEditor;
            this.jetUnderlyingSourceViewer = jetEditor.getSourceViewer();
            this.javaUnderlyingSourceViewer = javaEditor.getJavaSourceViewer();
            this.jetToJava = new CaretAndSelectionListener(this.jetUnderlyingSourceViewer, this.javaUnderlyingSourceViewer);
            this.javaToJET = new CaretAndSelectionListener(this.javaUnderlyingSourceViewer, this.jetUnderlyingSourceViewer);
        }

        public void sync(ISourceViewer viewer) {
            (viewer == this.jetUnderlyingSourceViewer ? this.jetToJava : this.javaToJET).handle();
        }

        class CaretAndSelectionListener
        implements CaretListener,
        SelectionListener {
            private final ISourceViewer source;
            private final ISourceViewer target;

            public CaretAndSelectionListener(ISourceViewer source, ISourceViewer target) {
                this.source = source;
                this.target = target;
                StyledText textWidget = source.getTextWidget();
                textWidget.addCaretListener((CaretListener)this);
                textWidget.addSelectionListener((SelectionListener)this);
            }

            public void widgetSelected(SelectionEvent event) {
                if (this.isEnabled((TypedEvent)event)) {
                    if (event.widget == SelectionSynchronizer.this.javaUnderlyingSourceViewer.getTextWidget() && SelectionSynchronizer.this.javaEditor.isNavigating()) {
                        Point javaSelectedRange = this.source.getSelectedRange();
                        int javaOffset = javaSelectedRange.x;
                        int correspondingTemplateFileID = SelectionSynchronizer.this.jetEditor.getCorrespondingTemplateFileID(javaOffset);
                        if (correspondingTemplateFileID != -1 && correspondingTemplateFileID != SelectionSynchronizer.this.jetEditor.getFileID()) {
                            SelectionSynchronizer.this.jetEditor.getDocumentManager().setFileID(correspondingTemplateFileID);
                        }
                    }
                    this.handle();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                if (this.isEnabled((TypedEvent)event)) {
                    this.handle();
                }
            }

            public void caretMoved(CaretEvent event) {
                if (this.isEnabled((TypedEvent)event)) {
                    final StyledText styledText = (StyledText)event.widget;
                    if (styledText.getSelectionRange().y == 0) {
                        event.widget.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Point selection = styledText.getSelectionRange();
                                if (selection.y == 0) {
                                    Event fakeEvent = new Event();
                                    fakeEvent.x = fakeEvent.y = selection.x;
                                    styledText.notifyListeners(13, fakeEvent);
                                }
                            }
                        });
                    }
                }
            }

            protected boolean isEnabled(TypedEvent event) {
                if (((Control)event.widget).isFocusControl()) {
                    return SelectionSynchronizer.this.jetEditor.isJavaEditorInSync();
                }
                return event.widget == SelectionSynchronizer.this.javaUnderlyingSourceViewer.getTextWidget() && SelectionSynchronizer.this.javaEditor.isNavigating();
            }

            protected void handle() {
                Position correspondingPoint;
                Point selectedRange = this.source.getSelectedRange();
                if (this.source == SelectionSynchronizer.this.jetUnderlyingSourceViewer) {
                    JETItem startItem = SelectionSynchronizer.this.jetEditor.getJETItem(selectedRange.x, false);
                    JETItem endItem = SelectionSynchronizer.this.jetEditor.getJETItem(selectedRange.x + selectedRange.y, false);
                    TrackedPosition jetPosition = SelectionSynchronizer.this.jetEditor.getJETPosition();
                    if (startItem == endItem && startItem instanceof JETJavaItem && !(startItem instanceof JETLiteralItem)) {
                        JETJavaItem jetJavaItem = (JETJavaItem)startItem;
                        jetPosition.update(jetJavaItem);
                        SelectionSynchronizer.this.jetEditor.getJavaPosition().update(jetJavaItem);
                    } else {
                        JETToken token;
                        int start;
                        int n = start = startItem == null ? selectedRange.x : startItem.getStartOffset();
                        int end = endItem == null ? (startItem == null ? selectedRange.x + selectedRange.y : startItem.getStopOffset()) : endItem.getStopOffset();
                        int length = end - start;
                        if (start != 0 && startItem instanceof JETLiteralItem && ((token = SelectionSynchronizer.this.jetEditor.getTokenAt(start - 1)) == JETDirectiveRule.TOKEN || token == JETCommentRule.TOKEN || token == JETScriptletRule.TOKEN)) {
                            IDocument document = SelectionSynchronizer.this.jetUnderlyingSourceViewer.getDocument();
                            try {
                                char character = document.getChar(start);
                                if (character == '\n' || character == '\r') {
                                    --length;
                                    if (character == '\r' && document.getChar(++start) == '\n') {
                                        ++start;
                                        --length;
                                    }
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        if (endItem instanceof JETLiteralItem) {
                            IDocument document = SelectionSynchronizer.this.jetUnderlyingSourceViewer.getDocument();
                            try {
                                char character = document.getChar(start + length);
                                if (character == '\n' || character == '\r') {
                                    --length;
                                    if (character == '\n' && document.getChar(start) == '\r') {
                                        --length;
                                    }
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        jetPosition.update(start, length);
                    }
                    SelectionSynchronizer.this.jetUnderlyingSourceViewer.setRangeIndication(jetPosition.getOffset(), jetPosition.getLength(), false);
                }
                Position position = correspondingPoint = this.source == SelectionSynchronizer.this.jetUnderlyingSourceViewer ? SelectionSynchronizer.this.jetEditor.getCorrespondingJavaPosition(selectedRange.x, selectedRange.y) : SelectionSynchronizer.this.jetEditor.getCorrespondingTemplatePosition(selectedRange.x, selectedRange.y);
                if (correspondingPoint != null) {
                    Position correspondingPointEnd = null;
                    int i = 0;
                    while (i < 100 && correspondingPointEnd == null && selectedRange.y > 0) {
                        int endOffset = selectedRange.x + selectedRange.y;
                        correspondingPointEnd = this.source == SelectionSynchronizer.this.jetUnderlyingSourceViewer ? SelectionSynchronizer.this.jetEditor.getCorrespondingJavaPosition(endOffset, 0) : SelectionSynchronizer.this.jetEditor.getCorrespondingTemplatePosition(endOffset, 0);
                        ++i;
                        --selectedRange.y;
                    }
                    int length = correspondingPointEnd == null ? correspondingPoint.length : correspondingPointEnd.offset + correspondingPointEnd.length - correspondingPoint.offset;
                    (this.target == SelectionSynchronizer.this.jetUnderlyingSourceViewer ? SelectionSynchronizer.this.jetEditor : SelectionSynchronizer.this.javaEditor).selectAndReveal(correspondingPoint.offset, length);
                    StyledText textWidget = this.target.getTextWidget();
                    Rectangle bounds = textWidget.getCaret().getBounds();
                    textWidget.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
                }
            }
        }
    }

    static class SharedTextViewerUndoManager
    implements IUndoManager,
    IUndoManagerExtension,
    IDocumentUndoListener,
    KeyListener,
    MouseListener {
        private final JETEditor jetEditor;
        private final ITextViewer textViewer;
        private final IDocumentUndoManager documentUndoManager;
        private final IDocument document;
        private int undoLevel;

        public SharedTextViewerUndoManager(int undoLevel, JETEditor jetEditor, ITextViewer textViewer, IDocument document) {
            this.undoLevel = undoLevel;
            this.jetEditor = jetEditor;
            this.textViewer = textViewer;
            this.document = document;
            DocumentUndoManagerRegistry.connect((IDocument)document);
            this.documentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
            this.documentUndoManager.connect((Object)this);
            this.setMaximalUndoLevel(undoLevel);
            this.documentUndoManager.addDocumentUndoListener((IDocumentUndoListener)this);
        }

        public void beginCompoundChange() {
            this.documentUndoManager.beginCompoundChange();
        }

        public void endCompoundChange() {
            this.documentUndoManager.endCompoundChange();
        }

        public void addListeners() {
            StyledText text = this.textViewer.getTextWidget();
            if (text != null) {
                text.addMouseListener((MouseListener)this);
                text.addKeyListener((KeyListener)this);
            }
        }

        public void removeListeners() {
            StyledText text = this.textViewer.getTextWidget();
            if (text != null) {
                text.removeMouseListener((MouseListener)this);
                text.removeKeyListener((KeyListener)this);
            }
        }

        public void setMaximalUndoLevel(int newUndoLevel) {
            this.undoLevel = Math.max(0, newUndoLevel);
            this.documentUndoManager.setMaximalUndoLevel(this.undoLevel);
        }

        public void connect(ITextViewer newTextViewer) {
        }

        public void disconnect() {
            this.removeListeners();
            this.documentUndoManager.disconnect((Object)this);
            DocumentUndoManagerRegistry.disconnect((IDocument)this.document);
            this.documentUndoManager.removeDocumentUndoListener((IDocumentUndoListener)this);
        }

        public void reset() {
            this.documentUndoManager.reset();
        }

        public boolean redoable() {
            return this.documentUndoManager.redoable();
        }

        public boolean undoable() {
            return this.documentUndoManager.undoable();
        }

        public void redo() {
            try {
                this.documentUndoManager.redo();
            }
            catch (ExecutionException ex) {
                this.openErrorDialog("Redo Failed", (Exception)((Object)ex));
            }
        }

        public void undo() {
            try {
                this.documentUndoManager.undo();
            }
            catch (ExecutionException ex) {
                this.openErrorDialog("Undo Failed", (Exception)((Object)ex));
            }
        }

        private void selectAndReveal(int offset, int length) {
            this.jetEditor.selectAndReveal(this.document, offset, length);
        }

        public IUndoContext getUndoContext() {
            return this.documentUndoManager.getUndoContext();
        }

        private void openErrorDialog(final String title, final Exception ex) {
            Shell shell = null;
            StyledText st = this.textViewer.getTextWidget();
            if (st != null && !st.isDisposed()) {
                shell = st.getShell();
            }
            if (Display.getCurrent() != null) {
                MessageDialog.openError((Shell)shell, (String)title, (String)ex.getLocalizedMessage());
            } else {
                final Shell finalShell = shell;
                Display display = finalShell != null ? finalShell.getDisplay() : Display.getDefault();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)finalShell, (String)title, (String)ex.getLocalizedMessage());
                    }
                });
            }
        }

        public void mouseDoubleClick(MouseEvent event) {
        }

        public void mouseUp(MouseEvent event) {
        }

        public void mouseDown(MouseEvent event) {
            if (event.button == 1) {
                this.documentUndoManager.commit();
            }
        }

        public void keyReleased(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
            switch (event.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    this.documentUndoManager.commit();
                }
            }
        }

        public void documentUndoNotification(DocumentUndoEvent event) {
            int eventType = event.getEventType();
            if ((eventType & 1) != 0 || (eventType & 2) != 0) {
                if (event.isCompound()) {
                    ((ITextViewerExtension)this.textViewer).setRedraw(false);
                }
            } else if ((eventType & 4) != 0 || (eventType & 8) != 0) {
                StyledText widget;
                if (event.isCompound()) {
                    ((ITextViewerExtension)this.textViewer).setRedraw(true);
                }
                if ((widget = this.textViewer.getTextWidget()) != null && !widget.isDisposed() && widget.isFocusControl()) {
                    this.selectAndReveal(event.getOffset(), event.getText() == null ? 0 : event.getText().length());
                }
            }
        }
    }

    static abstract class SneakyRunnable
    implements Runnable {
        SneakyRunnable() {
        }

        private static <E extends Throwable> void sneakyThrow(Throwable throwable) throws E {
            throw throwable;
        }

        @Override
        public final void run() {
            try {
                this.execute();
            }
            catch (Throwable throwable) {
                SneakyRunnable.sneakyThrow(throwable);
            }
        }

        protected abstract void execute() throws Throwable;
    }

    static final class StorageEditorInput
    extends PlatformObject
    implements IStorageEditorInput,
    IPathEditorInput,
    IURIEditorInput {
        private final URLStorage storage;

        public StorageEditorInput(URI uri) {
            this(uri, null, null);
        }

        public StorageEditorInput(URI uri, String contents, String encoding) {
            this.storage = new URLStorage(uri, contents, encoding == null ? "UTF-8" : encoding);
        }

        public Object getAdapter(Class adapter) {
            return this.storage.getAdapter(adapter);
        }

        public boolean exists() {
            return this.storage.exists();
        }

        public ImageDescriptor getImageDescriptor() {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            return registry.getImageDescriptor(this.storage.uri.fileExtension());
        }

        public String getName() {
            return this.storage.uri.lastSegment();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.storage.uri.toString();
        }

        public IEncodedStorage getStorage() throws CoreException {
            return this.storage;
        }

        public java.net.URI getURI() {
            try {
                URI resolvedURI = JETNature.resolve((URI)this.storage.uri);
                return new java.net.URI(resolvedURI.toString());
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }

        public IPath getPath() {
            IPath path = this.storage.getFullPath();
            return path == null ? new Path("") : path;
        }

        public IFile getFile() {
            return (IFile)this.storage.getAdapter(IFile.class);
        }

        public String toString() {
            return this.storage.toString();
        }

        public int hashCode() {
            return this.storage.hashCode();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || that.getClass() != StorageEditorInput.class) {
                return false;
            }
            StorageEditorInput other = (StorageEditorInput)((Object)that);
            return this.storage == null ? other.storage == null : this.storage.equals((Object)other.storage);
        }

        private static final class URLStorage
        extends PlatformObject
        implements IEncodedStorage {
            private final URI uri;
            private final String contents;
            private final String encoding;

            public URLStorage(URI uri, String contents, String encoding) {
                this.uri = uri;
                this.contents = contents;
                this.encoding = encoding;
            }

            public Object getAdapter(Class adapter) {
                IFile file;
                if (adapter == IFile.class && (file = JETEditor.toFile(this.uri)) != null) {
                    return file;
                }
                return super.getAdapter(adapter);
            }

            public boolean exists() {
                try {
                    if (this.contents == null) {
                        this.getContents().close();
                    }
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public InputStream getContents() throws CoreException {
                try {
                    if (this.contents == null) {
                        return new URL(this.uri.toString()).openStream();
                    }
                    return new ByteArrayInputStream(this.contents.getBytes(this.encoding == null ? "UTF-8" : this.encoding));
                }
                catch (Exception exception) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.codegen", exception.getLocalizedMessage(), (Throwable)exception));
                }
            }

            public IPath getFullPath() {
                if (this.uri.isPlatformResource()) {
                    return new Path(this.uri.toPlatformString(true));
                }
                if (this.uri.isFile()) {
                    return new Path(this.uri.toFileString());
                }
                return null;
            }

            public String getName() {
                return this.uri.lastSegment();
            }

            public boolean isReadOnly() {
                return true;
            }

            public String getCharset() throws CoreException {
                return this.encoding;
            }

            public int hashCode() {
                return this.uri == null ? 0 : this.uri.hashCode();
            }

            public boolean equals(Object that) {
                if (this == that) {
                    return true;
                }
                if (that == null || that.getClass() != URLStorage.class) {
                    return false;
                }
                URLStorage other = (URLStorage)((Object)that);
                return this.uri == null ? other.uri == null : this.uri.equals(other.uri);
            }

            public String toString() {
                return String.valueOf(this.uri);
            }
        }
    }

    static class TrackedPosition
    extends Position {
        private static final String CATEGORY = "__jet_" + TrackedPosition.class.hashCode();
        private static final IPositionUpdater POSITION_UPDATER = new PositionUpdater();
        private IDocument document;
        private final Type type;
        private TrackedPosition opposite;

        public TrackedPosition(Type type) {
            this.type = type;
        }

        public void setOpposite(TrackedPosition opposite) {
            this.opposite = opposite;
            opposite.opposite = this;
        }

        public TrackedPosition getOpposite() {
            return this.opposite;
        }

        public void addToDocument(IDocument document) {
            if (this.document != null) {
                JETEditor.uninstallFromDocument(document, this, CATEGORY, POSITION_UPDATER);
            }
            this.document = document;
            this.setOffset(0);
            this.setLength(0);
            this.undelete();
            JETEditor.installOnDocument(document, this, CATEGORY, POSITION_UPDATER);
        }

        public void update(JETJavaItem jetJavaItem) {
            if (this.type == Type.JAVA) {
                int javaOffset = jetJavaItem.getJavaOffset();
                int javaLength = jetJavaItem.getJavaLength();
                this.update(javaOffset, javaLength);
            } else {
                int jetOffset = jetJavaItem.getStartOffset();
                int jetLength = jetJavaItem.getLength();
                this.update(jetOffset, jetLength);
            }
        }

        public void update(int offset, int length) {
            this.undelete();
            this.setOffset(offset);
            this.setLength(length);
        }

        public String getText() {
            if (this.document != null && !this.isDeleted()) {
                try {
                    return this.document.get(this.offset, this.length);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return null;
        }

        public void dispose() {
            if (this.document != null) {
                JETEditor.uninstallFromDocument(this.document, this, CATEGORY, POSITION_UPDATER);
                this.document = null;
            }
            this.delete();
        }

        public String toString() {
            String toString = super.toString();
            return this.isDeleted() ? toString : String.valueOf(toString) + " " + JETItem.toString((String)this.getText());
        }

        public static class PositionUpdater
        implements IPositionUpdater {
            protected Position position;
            protected int originalPositionLength;
            protected int originalPositionOffset;
            protected int offset;
            protected int length;
            protected String text;
            protected int replaceLength;
            protected IDocument document;

            protected String getCategory() {
                return CATEGORY;
            }

            protected void adaptToInsert() {
                int myStart = this.position.offset;
                int myEnd2 = this.position.offset + this.position.length;
                int myEnd = this.position.offset + this.position.length - 1;
                myEnd = Math.max(myStart, myEnd);
                int yourStart = this.offset;
                int yourEnd = this.offset + this.length;
                if (myStart == yourEnd) {
                    this.position.offset = this.offset;
                    this.position.length = myEnd2 - this.offset + this.replaceLength;
                } else if (myEnd2 == yourStart) {
                    this.position.length += this.replaceLength;
                } else if (myEnd >= yourStart) {
                    if (myStart < yourStart) {
                        this.position.length += this.replaceLength;
                    } else {
                        this.position.offset += this.replaceLength;
                    }
                }
            }

            protected void adaptToRemove() {
                int myStart = this.position.offset;
                int myEnd = this.position.offset + this.position.length - 1;
                myEnd = Math.max(myStart, myEnd);
                int yoursStart = this.offset;
                int yoursEnd = this.offset + this.length - 1;
                yoursEnd = Math.max(yoursStart, yoursEnd);
                if (myEnd >= yoursStart) {
                    if (myStart <= yoursStart) {
                        this.position.length = yoursEnd <= myEnd ? (this.position.length -= this.length) : (this.position.length -= myEnd - yoursStart + 1);
                    } else if (yoursStart < myStart) {
                        if (yoursEnd < myStart) {
                            this.position.offset -= this.length;
                        } else {
                            this.position.offset -= myStart - yoursStart;
                            this.position.length -= yoursEnd - myStart + 1;
                        }
                    }
                    if (this.position.offset < 0) {
                        this.position.offset = 0;
                    }
                    if (this.position.length < 0) {
                        this.position.length = 0;
                    }
                }
            }

            protected void adaptToReplace() {
                if (this.length > 0 && this.position.offset <= this.offset && this.offset + this.length <= this.position.offset + this.position.length) {
                    this.position.length += this.replaceLength - this.length;
                } else {
                    if (this.length > 0) {
                        this.adaptToRemove();
                    }
                    if (this.replaceLength > 0) {
                        this.adaptToInsert();
                    }
                }
            }

            protected boolean notDeleted() {
                if (this.offset < this.position.offset && this.position.offset + this.position.length < this.offset + this.length) {
                    this.position.delete();
                    return false;
                }
                return true;
            }

            public void update(DocumentEvent event) {
                try {
                    try {
                        this.document = event.getDocument();
                        Position[] category = this.document.getPositions(CATEGORY);
                        if (category.length > 0) {
                            this.offset = event.getOffset();
                            this.length = event.getLength();
                            this.text = event.getText();
                            if (this.text == null) {
                                this.replaceLength = 0;
                                this.text = "";
                            } else {
                                this.replaceLength = this.text.length();
                            }
                            Position[] positionArray = category;
                            int n = category.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Position element;
                                this.position = element = positionArray[n2];
                                this.originalPositionOffset = this.position.offset;
                                this.originalPositionLength = this.position.length;
                                if (this.notDeleted()) {
                                    this.adaptToReplace();
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {
                        this.document = null;
                        this.text = null;
                    }
                }
                finally {
                    this.document = null;
                    this.text = null;
                }
            }
        }

        static enum Type {
            JET,
            JAVA;

        }
    }

    static class ViewPortHandler
    implements IViewportListener,
    Runnable {
        private final JETEditor jetEditor;
        private final StyledText jetStyledText;
        private int topIndex;

        public ViewPortHandler(JETEditor jetEditor) {
            this.jetEditor = jetEditor;
            ISourceViewer jetSourceViewer = jetEditor.getSourceViewer();
            jetSourceViewer.addViewportListener((IViewportListener)this);
            this.jetStyledText = jetSourceViewer.getTextWidget();
        }

        public void viewportChanged(int verticalOffset) {
            this.topIndex = this.jetStyledText.getTopIndex();
            this.jetStyledText.getDisplay().timerExec(200, (Runnable)this);
        }

        @Override
        public void run() {
            if (!this.jetStyledText.isDisposed() && this.topIndex == this.jetStyledText.getTopIndex()) {
                this.jetEditor.invalidateVisibleTextPresentation(false);
            }
        }
    }

    static class VisibleCaretHandler
    extends FocusAdapter
    implements PaintListener {
        private final StyledText styledText;
        private final StyledText otherStyledText;

        public VisibleCaretHandler(StyledText styledText, StyledText otherStyledText) {
            this.styledText = styledText;
            this.otherStyledText = otherStyledText;
            styledText.addFocusListener((FocusListener)this);
            otherStyledText.addFocusListener((FocusListener)this);
            styledText.addPaintListener((PaintListener)this);
        }

        public void focusGained(FocusEvent event) {
            Rectangle caretBounds = this.getCaretBounds();
            this.styledText.redraw(caretBounds.x, caretBounds.y, caretBounds.width, caretBounds.height, false);
        }

        public void focusLost(FocusEvent event) {
            Rectangle caretBounds = this.getCaretBounds();
            this.styledText.redraw(caretBounds.x, caretBounds.y, caretBounds.width, caretBounds.height, false);
        }

        public void paintControl(PaintEvent event) {
            if (!this.styledText.isFocusControl() && this.otherStyledText.isFocusControl()) {
                Color background = event.gc.getBackground();
                event.gc.setBackground(ColorManager.INSTANCE.getBlendedColor(ColorManager.INSTANCE.getForeground(JETDirectiveRule.TOKEN.getType()), background));
                Rectangle caretBounds = this.getCaretBounds();
                event.gc.fillRectangle(caretBounds);
                event.gc.setBackground(background);
            }
        }

        private Rectangle getCaretBounds() {
            return this.styledText.getCaret().getBounds();
        }
    }

    static class WorkingCopyCompilationMonitor
    extends JETCompileTemplateOperation.JETCompilationMonitor {
        WorkingCopyCompilationMonitor() {
        }

        public InputStream openInputStream(String locationURI) throws JETException {
            Path fullPath;
            ITextFileBuffer buffer;
            URI uri = URI.createURI((String)locationURI);
            if (uri.isPlatformResource() && (buffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer((IPath)(fullPath = new Path(uri.toPlatformString(true))), LocationKind.IFILE)) != null) {
                IDocument document = buffer.getDocument();
                String contents = document.get();
                return new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
            }
            return super.openInputStream(locationURI);
        }
    }
}

