/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParseErrorInfo;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.sqlbuilder.IContentChangeListener;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilder;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.SQLBuilderActionBarContributor;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.views.RDBTableDropListener;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.ConnectionContext;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLBuilderDBProposalsService;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLEditorDocumentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLSourceEditingEnvironment;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLSourceViewerConfiguration;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SourceViewerAction;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.TextViewerOperationAction;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IUpdate;

public class SQLSourceViewer
extends ContentViewer
implements ISelectionChangedListener,
IMenuListener,
IPropertyChangeListener,
DisposeListener {
    protected SQLEditorDocumentProvider documentProvider;
    protected SourceViewer sourceViewer;
    protected SQLSourceViewerConfiguration configuration;
    protected IDocument document;
    protected SQLDomainModel sqlDomainModel;
    protected Object currentSelection;
    public Map actions = new HashMap(10);
    SourceViewerAction contentAssistAction;
    SourceViewerAction contentTipAction;
    protected boolean textChanged = false;
    private boolean isParseRequired = false;
    protected IContentChangeListener qListener = null;
    private ITextListener textChangeListener;
    protected SQLBuilder sqlbuilder;
    private String lastKnownProperSource;
    private boolean handleImproper;
    private String currentSQLStr = "";
    private String fileSQLStr = "";
    private boolean fileSQLStrChanged = false;
    protected boolean reparseRunning = false;

    public SQLSourceViewer(SQLDomainModel sqlDomainModel, Composite parent) {
        this.sqlDomainModel = sqlDomainModel;
        this.sqlbuilder = null;
        this.initSourceViewer(parent);
        this.initDragAndDrop();
        this.initTextWidget();
        this.initContextMenu();
        this.setLastKnownProperSource();
        this.handleImproper = false;
    }

    public SQLSourceViewer(SQLDomainModel sqlDomainModel, Composite parent, boolean handleImproper) {
        this(sqlDomainModel, parent);
        this.handleImproper = handleImproper;
    }

    private void initSourceViewer(Composite parent) {
        this.configuration = new SQLSourceViewerConfiguration();
        this.documentProvider = new SQLEditorDocumentProvider();
        SQLSourceEditingEnvironment.connect();
        int styles = 2818;
        this.sourceViewer = new SourceViewer(parent, (IVerticalRuler)new VerticalRuler(12), styles);
        this.sourceViewer.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.sourceViewer.configure((SourceViewerConfiguration)this.configuration);
        this.sourceViewer.getTextWidget().addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent evt) {
                evt.segments = SQLSourceViewer.this.getSegments(evt.lineOffset, evt.lineText);
            }
        });
        this.textChangeListener = new ITextListener(){

            public void textChanged(TextEvent event) {
                SQLSourceViewer.this.setTextChanged(true);
                SQLSourceViewer.this.sqlDomainModel.setDirty(true);
                if (SQLSourceViewer.this.qListener != null) {
                    SQLSourceViewer.this.qListener.notifyContentChange();
                }
            }
        };
        this.sourceViewer.addTextListener(this.textChangeListener);
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                for (Object object : SQLSourceViewer.this.actions.values()) {
                    if (!(object instanceof TextViewerOperationAction)) continue;
                    ((TextViewerOperationAction)((Object)object)).update();
                }
            }
        });
    }

    protected int[] getSegments(int offset, String text) {
        if (text == null || text.equals("")) {
            return null;
        }
        boolean found = true;
        int searchIndex = 0;
        ArrayList<Integer> segmentList = new ArrayList<Integer>();
        segmentList.add(0);
        while (found) {
            int index = text.indexOf(34, searchIndex);
            if (index == -1) {
                found = false;
            }
            if (index > 0) {
                segmentList.add(index);
            }
            searchIndex = index + 1;
        }
        int[] temp = new int[segmentList.size()];
        int i = 0;
        while (i < segmentList.size()) {
            temp[i] = (Integer)segmentList.get(i);
            ++i;
        }
        return temp;
    }

    private void initTextWidget() {
        this.setEditable(true);
        StyledText styledText = this.sourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.sourceViewer.getControl().addDisposeListener((DisposeListener)this);
        styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (SQLSourceViewer.this.isRootStatement()) {
                    if (e.stateMask == 262144 && e.character == ' ' && SQLSourceViewer.this.contentAssistAction != null) {
                        SQLSourceViewer.this.contentAssistAction.run();
                    }
                    if (e.stateMask == 393216 && e.character == ' ' && SQLSourceViewer.this.contentTipAction != null) {
                        SQLSourceViewer.this.contentTipAction.run();
                    }
                }
                SQLSourceViewer.this.setParseRequired(true);
            }
        });
        styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                boolean sqlBuilderNotInValidate;
                if (SQLSourceViewer.this.contentAssistAction.isActive()) {
                    return;
                }
                if (SQLSourceViewer.this.configuration.getIsContentAssistActive()) {
                    return;
                }
                if (SQLSourceViewer.this.isTextChanged()) {
                    SQLSourceViewer.this.reparse();
                }
                boolean menuShowing = SQLSourceViewer.this.getControl().getMenu().isVisible();
                boolean bl = sqlBuilderNotInValidate = SQLSourceViewer.this.sqlbuilder != null && !SQLSourceViewer.this.sqlbuilder.inValidateEditCall();
                if (!menuShowing && (SQLSourceViewer.this.sqlbuilder == null || sqlBuilderNotInValidate)) {
                    SQLSourceViewer.this.reparse();
                    for (Object object : SQLSourceViewer.this.actions.values()) {
                        ((Action)object).setEnabled(false);
                    }
                }
            }

            public void focusGained(FocusEvent e) {
                for (Object object : SQLSourceViewer.this.actions.values()) {
                    if (object instanceof TextViewerOperationAction) {
                        TextViewerOperationAction textAction = (TextViewerOperationAction)((Object)object);
                        textAction.update();
                        continue;
                    }
                    if (!(object instanceof SourceViewerAction)) continue;
                    SourceViewerAction sourceAction = (SourceViewerAction)((Object)object);
                    sourceAction.setEnabled(true);
                }
                SQLSourceViewer.this.contentAssistAction.setAsActive(false);
            }
        });
    }

    private void initContextMenu() {
        this.createActions();
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    private void initDragAndDrop() {
        int operations = 7;
        Transfer[] types = new Transfer[]{LocalTransfer.getInstance()};
        DropTarget target = new DropTarget(this.getControl(), operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new RDBTableDropListener((Viewer)this, this.sqlDomainModel));
    }

    public void setSQLBuilder(SQLBuilder sqlbuilder) {
        this.sqlbuilder = sqlbuilder;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "org.eclipse.jface.textfont" && this.sourceViewer != null) {
            this.sourceViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        }
    }

    public void setContentChangeListener(IContentChangeListener qListener) {
        this.qListener = qListener;
    }

    public void initDBContext() {
        if (this.sqlDomainModel != null) {
            ConnectionContext connContext = new ConnectionContext();
            ISQLEditorConnectionInfo connInfo = this.sqlDomainModel.getConnectionInfo();
            if (connInfo != null) {
                SQLBuilderDBProposalsService dbProposalsService = new SQLBuilderDBProposalsService(connInfo);
                connContext.setDBProposalsService(dbProposalsService);
            }
            connContext.setDomainModel(this.sqlDomainModel);
            this.configuration.addDBContext(connContext);
        }
    }

    public void inputChanged(Object input, Object oldInput) {
        this.sourceViewer.removeTextListener(this.textChangeListener);
        if (oldInput != null) {
            this.documentProvider.disconnect(oldInput);
        }
        try {
            this.documentProvider.connect(input);
            IAnnotationModel model = this.documentProvider.getAnnotationModel(input);
            this.document = this.documentProvider.getDocument(input);
            this.sourceViewer.setDocument(this.document, model);
            if (this.currentSQLStr.length() > 0 && !this.currentSQLStr.equals(this.sqlDomainModel.getSQLStatement().getSQL())) {
                this.setTextChanged(true);
                this.sqlDomainModel.setDirty(true);
                if (this.sqlDomainModel.isUnmatchedSource()) {
                    this.currentSQLStr = this.sqlDomainModel.getInitialSource();
                    this.document.set(this.currentSQLStr);
                    this.sqlDomainModel.setUnmatchedSource(false);
                    if (!StatementHelper.isTemplateSQL((String)this.currentSQLStr)) {
                        this.sqlbuilder.updateProperStatement(false);
                    }
                } else {
                    this.currentSQLStr = this.sqlDomainModel.getSQLStatement().getSQL();
                    this.fileSQLStrChanged = true;
                }
            } else if (this.currentSQLStr.length() == 0) {
                if (this.sqlDomainModel.isUnmatchedSource()) {
                    this.currentSQLStr = this.sqlDomainModel.getInitialSource();
                    this.document.set(this.currentSQLStr);
                    this.sqlDomainModel.setUnmatchedSource(false);
                    if (!StatementHelper.isTemplateSQL((String)this.currentSQLStr)) {
                        this.sqlbuilder.updateProperStatement(false);
                    }
                } else {
                    this.currentSQLStr = this.sqlDomainModel.getSQLStatement().getSQL();
                    this.fileSQLStrChanged = true;
                }
            }
            if (this.fileSQLStr.length() > 0 && !this.fileSQLStrChanged && !StatementHelper.getSQLSourceUnformatted((String)this.fileSQLStr).trim().equals(StatementHelper.getSQLSourceUnformatted((String)this.currentSQLStr).trim())) {
                this.document.set(this.fileSQLStr);
                this.sqlbuilder.updateProperStatement(false);
            }
            if (input == this.sqlDomainModel.getSQLStatement()) {
                this.setEditable(true);
                if (this.sqlDomainModel.getImproperStatement() != null && this.sqlDomainModel.getImproperStatement().length() > 0) {
                    this.document.set(this.sqlDomainModel.getImproperStatement());
                }
            } else {
                this.setEditable(false);
            }
        }
        catch (Exception exception) {}
        this.sourceViewer.addTextListener(this.textChangeListener);
    }

    protected void handleDispose(DisposeEvent event) {
        SQLSourceEditingEnvironment.connect();
        super.handleDispose(event);
    }

    protected void setEditable(boolean isEditable) {
        this.sourceViewer.setEditable(isEditable);
        if (!isEditable) {
            this.sourceViewer.getTextWidget().setBackground(this.sourceViewer.getControl().getBackground());
        } else {
            this.sourceViewer.getTextWidget().setBackground(Display.getCurrent().getSystemColor(1));
        }
    }

    protected boolean isEditable() {
        return this.sourceViewer.isEditable();
    }

    public Control getControl() {
        return this.sourceViewer.getTextWidget();
    }

    public void refresh() {
        if (!this.isReparseRunning()) {
            this.setInput(this.getInput());
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void refreshSource() {
        this.sourceViewer.removeTextListener(this.textChangeListener);
        this.currentSelection = this.getInput();
        String str = this.documentProvider.inputToStringHelper(this.currentSelection);
        if (this.document != null) {
            this.document.set(str);
        }
        this.sourceViewer.addTextListener(this.textChangeListener);
    }

    public void refreshSource(String inputStr) {
        this.document.set(inputStr);
    }

    public void revertToLastKnownProperSource() {
        this.document.set(this.getLastKnownProperSource());
        this.forceReparse();
    }

    public void revertToDefaultSource() {
        String s = this.sqlDomainModel.getTemplateSQLForCurrentStatement();
        this.document.set(s);
        this.sqlDomainModel.setImproperStatement(null);
        this.forceReparse();
    }

    public void revertToInitialSource() {
        this.sourceViewer.removeTextListener(this.textChangeListener);
        this.document.set(this.sqlDomainModel.getInitialSource());
        this.sqlDomainModel.setImproperStatement(null);
        this.forceReparse();
        this.sourceViewer.addTextListener(this.textChangeListener);
    }

    public String getText() {
        return this.document.get();
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            this.actions.remove(actionID);
        } else {
            this.actions.put(actionID, action);
        }
    }

    public SQLDomainModel getDomainModel() {
        return this.sqlDomainModel;
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        return (IAction)this.actions.get(actionID);
    }

    protected void updateAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        IAction action = (IAction)this.actions.get(actionID);
        if (action != null && action instanceof TextViewerOperationAction) {
            ((TextViewerOperationAction)action).update();
        }
    }

    protected void addAction(IMenuManager menu, String actionID) {
        IAction action = this.getAction(actionID);
        if (action != null) {
            menu.add(action);
            if (action instanceof TextViewerOperationAction) {
                ((TextViewerOperationAction)action).update();
            } else if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
        }
    }

    protected void createActions() {
        ResourceBundle resourceBundle = SQLBuilderPlugin.getPlugin().getResourceBundle();
        this.setAction("Cut", (IAction)new TextViewerOperationAction((TextViewer)this.sourceViewer, 3));
        this.setAction("Copy", (IAction)new TextViewerOperationAction((TextViewer)this.sourceViewer, 4));
        this.setAction("Paste", (IAction)new TextViewerOperationAction((TextViewer)this.sourceViewer, 5));
        this.contentAssistAction = new SourceViewerAction(resourceBundle, "ContentAssistProposal_", (ISourceViewer)this.sourceViewer, 13);
        this.contentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.contentAssistAction.setAccelerator(262176);
        this.setAction("ContentAssistProposal", (IAction)this.contentAssistAction);
        this.contentTipAction = new SourceViewerAction(resourceBundle, "ContentTip_", (ISourceViewer)this.sourceViewer, 14);
        this.contentTipAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.contentTipAction.setAccelerator(393248);
        this.setAction("ContentTip", (IAction)this.contentTipAction);
    }

    public boolean isRootStatement() {
        return this.getInput() == this.sqlDomainModel.getSQLStatement();
    }

    public void menuAboutToShow(IMenuManager menu) {
        SQLBuilderActionBarContributor contributor = this.sqlbuilder.getActionBarContributor();
        if (contributor != null) {
            menu.removeAll();
            this.addAction(menu, "Reparse");
            menu.add((IContributionItem)new Separator("Text Operations"));
            this.addAction(menu, "Cut");
            this.addAction(menu, "Copy");
            this.addAction(menu, "Paste");
            menu.add((IContributionItem)new Separator("Content Assist Options"));
            this.addAction(menu, "ContentAssistProposal");
            this.addAction(menu, "ContentTip");
            if (this.handleImproper) {
                boolean proper;
                IAction revertToDefaultAction;
                menu.add((IContributionItem)new Separator());
                IAction revertToPreviousAction = contributor.getAction("RevertToPreviousAction");
                if (revertToPreviousAction != null) {
                    menu.add(revertToPreviousAction);
                }
                if ((revertToDefaultAction = contributor.getAction("RevertToDefaultAction")) != null) {
                    menu.add(revertToDefaultAction);
                }
                revertToPreviousAction.setEnabled(!(proper = this.sqlDomainModel.isProper()));
                revertToDefaultAction.setEnabled(!proper);
            }
            IAction changeStatementTypeAction = contributor.getAction("ChangeStatementType");
            menu.add(changeStatementTypeAction);
            changeStatementTypeAction.setEnabled(true);
            menu.add((IContributionItem)new Separator("Omit Current Schema"));
            IAction omitCurrentSchemaAction = contributor.getAction("OmitCurrentSchema");
            menu.add(omitCurrentSchemaAction);
            omitCurrentSchemaAction.setEnabled(true);
            menu.add((IContributionItem)new Separator("Run SQL"));
            IAction runSQLAction = contributor.getAction("RunSQLAction");
            if (runSQLAction != null) {
                menu.add(runSQLAction);
            }
            if (this.isRootStatement()) {
                this.contentAssistAction.setEnabled(true);
                this.contentTipAction.setEnabled(true);
            } else {
                this.contentAssistAction.setEnabled(false);
                this.contentTipAction.setEnabled(false);
            }
        }
    }

    protected boolean isReparseRunning() {
        return this.reparseRunning;
    }

    public boolean reparse() {
        boolean isParseSuccess = false;
        ArrayList errorList = new ArrayList();
        if (this.handleImproper && this.getInput() instanceof QueryStatement) {
            if (this.isTextChanged() && this.isParseRequired) {
                String currentSQL = this.getText();
                this.reparseRunning = true;
                QueryStatement previousStmt = this.sqlDomainModel.getSQLStatement();
                String name = previousStmt.getName();
                QueryStatement parsedStmt = null;
                try {
                    parsedStmt = this.sqlDomainModel.parse(currentSQL, errorList);
                }
                catch (SQLParserException sQLParserException) {
                }
                catch (SQLParserInternalException sQLParserInternalException) {}
                if (errorList.size() > 0) {
                    SQLParseErrorInfo errorInfo = (SQLParseErrorInfo)errorList.get(0);
                    if (this.sqlbuilder != null) {
                        this.sqlbuilder.getDesignViewer().setEnabled(isParseSuccess);
                        this.sqlbuilder.getGraphViewer().setEnabled(isParseSuccess);
                        String parseErrMsg = this.getParseErrorMessageString(errorInfo);
                        this.handleImproperStatement(parsedStmt.getSQL());
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages._UI_VALIDATE_FAILED_TITLE, (String)parseErrMsg);
                    }
                }
                if (parsedStmt != null && errorList.size() == 0) {
                    int previousStmtType = StatementHelper.getStatementType((QueryStatement)previousStmt);
                    int newStmtType = StatementHelper.getStatementType((QueryStatement)parsedStmt);
                    if (this.sqlDomainModel.getIsStatementTypeSupported(newStmtType)) {
                        if (newStmtType != previousStmtType && this.sqlbuilder != null) {
                            this.sqlbuilder.changeStatementType(newStmtType);
                        }
                        isParseSuccess = true;
                        parsedStmt.setName(name);
                        this.sqlDomainModel.replaceStatementContents(parsedStmt);
                        this.refreshSource();
                    }
                } else if (StatementHelper.isTemplateSQL((String)currentSQL)) {
                    this.sqlDomainModel.clearStatementToTemplate();
                    isParseSuccess = true;
                }
                if (errorList.size() == 0) {
                    this.handleParseStatusChange(isParseSuccess, this.sqlDomainModel.getSQLStatement(), currentSQL);
                }
                this.reparseRunning = false;
                this.setTextChanged(false);
            }
        } else {
            this.noUnsupportedReparse();
        }
        this.setParseRequired(false);
        return isParseSuccess;
    }

    private String getParseErrorMessageString(SQLParseErrorInfo errorInfo) {
        if (errorInfo != null) {
            String errorCode = errorInfo.getErrorCode();
            if ("SQL_?TableRefUnresolved".equalsIgnoreCase(errorCode)) {
                String tableInError = errorInfo.getErrorSourceText();
                return NLS.bind((String)Messages._UI_GRAPH_NO_TABLE_FOUND, (Object)tableInError);
            }
            if ("SQL_?ColumnRefUnresolved".equalsIgnoreCase(errorCode) || "SQL_?NoSuchColumn".equalsIgnoreCase(errorCode)) {
                String columnInError = errorInfo.getErrorSourceText();
                return NLS.bind((String)Messages._UI_GRAPH_NO_COLUMN_FOUND, (Object)columnInError);
            }
        }
        return null;
    }

    public void noUnsupportedReparse() {
        if (this.isTextChanged()) {
            this.reparseRunning = true;
            this.refreshSource();
            this.reparseRunning = false;
            this.setTextChanged(false);
        }
    }

    public boolean forceReparse() {
        this.setTextChanged(true);
        this.setParseRequired(true);
        return this.reparse();
    }

    private void handleParseStatusChange(boolean success, QueryStatement currentSQLStatement, String statement) {
        if (!success) {
            if ((currentSQLStatement instanceof QuerySelectStatement || currentSQLStatement instanceof QueryInsertStatement) && !this.sqlbuilder.isContentOutlineRootSelected()) {
                String genString = "";
                genString = currentSQLStatement.getSQL();
                this.handleImproperStatement(genString);
            } else {
                this.handleImproperStatement(statement);
            }
            this.sqlbuilder.updateProperStatement(success);
        } else {
            this.sqlbuilder.updateProperStatement(success);
            this.sqlDomainModel.setImproperStatement(null);
            this.lastKnownProperSource = statement;
        }
    }

    private void handleImproperStatement(String statement) {
        this.sqlDomainModel.setImproperStatement(statement);
    }

    public boolean getTextChanged() {
        return this.textChanged;
    }

    public boolean isTextChanged() {
        return this.getTextChanged();
    }

    public void setTextChanged(boolean changed) {
        this.textChanged = changed;
    }

    public void setParseRequired(boolean required) {
        this.isParseRequired = required;
    }

    public boolean getParseRequired() {
        return this.isParseRequired;
    }

    public void setTextDirty(boolean dirty) {
        if (dirty) {
            this.setTextChanged(true);
            this.sqlDomainModel.setDirty(true);
            if (this.qListener != null) {
                this.qListener.notifyContentChange();
            }
        }
    }

    public void widgetDisposed(DisposeEvent arg0) {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
    }

    public String getLastKnownProperSource() {
        QueryStatement stmt = this.sqlDomainModel.getSQLStatement();
        this.lastKnownProperSource = stmt != null ? stmt.getSQL() : "";
        return this.lastKnownProperSource;
    }

    private void setLastKnownProperSource() {
        QueryStatement stmt = this.sqlDomainModel.getSQLStatement();
        this.lastKnownProperSource = this.sqlDomainModel.isProper() && stmt != null ? stmt.getSQL() : "";
    }

    public String getFileSQLStr() {
        return this.fileSQLStr;
    }

    public void setFileSQLStr(String fileSQLStr) {
        this.fileSQLStr = fileSQLStr;
    }

    public IDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }
}

