/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderFileEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderInputFactory;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderStorageEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IOmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ISQLStatementInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLStatementInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStringStorage;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class SQLBuilderEditorInputUtil {
    public static SQLBuilderStorageEditorInput createSQLBuilderStorageEditorInput(String s) {
        IMemento memento = SQLBuilderEditorInputUtil.readMementoFromString(s);
        return SQLBuilderEditorInputUtil.createSQLBuilderStorageEditorInput(memento);
    }

    public static SQLBuilderStorageEditorInput createSQLBuilderStorageEditorInput(IMemento memento) {
        SQLBuilderInputFactory factory = new SQLBuilderInputFactory();
        IAdaptable element = factory.createElement(memento);
        return (SQLBuilderStorageEditorInput)element;
    }

    public static SQLBuilderStorageEditorInput createSQLBuilderStorageEditorInput(IFile file) {
        SQLBuilderFileEditorInput fileEditorInput = new SQLBuilderFileEditorInput(file);
        String sSQL = fileEditorInput.getSQL();
        ISQLEditorConnectionInfo connectionInfo = fileEditorInput.getConnectionInfo();
        IOmitSchemaInfo omitSchemaInfo = fileEditorInput.getOmitSchemaInfo();
        SQLEditorStringStorage storage = new SQLEditorStringStorage(file.getName(), sSQL);
        SQLBuilderStorageEditorInput storageEditorInput = new SQLBuilderStorageEditorInput((IStorage)storage);
        storageEditorInput.setConnectionInfo(connectionInfo);
        storageEditorInput.setOmitSchemaInfo(omitSchemaInfo);
        return storageEditorInput;
    }

    public static SQLBuilderEditorInput createSQLBuilderEditorInput(IFile file) {
        SQLBuilderFileEditorInput fileEditorInput = new SQLBuilderFileEditorInput(file);
        String sSQL = fileEditorInput.getSQL();
        ISQLEditorConnectionInfo connectionInfo = fileEditorInput.getConnectionInfo();
        IOmitSchemaInfo omitSchemaInfo = fileEditorInput.getOmitSchemaInfo();
        SQLStatementInfo sqlStatementInfo = new SQLStatementInfo(sSQL);
        SQLBuilderEditorInput editorInput = new SQLBuilderEditorInput(connectionInfo, (ISQLStatementInfo)sqlStatementInfo, omitSchemaInfo);
        return editorInput;
    }

    public static XMLMemento saveSQLBuilderStorageEditorInput(SQLBuilderStorageEditorInput storageEditorInput) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"SQLQueryBuilder");
        SQLBuilderInputFactory.saveState((IMemento)memento, storageEditorInput);
        return memento;
    }

    public static String writeXMLMementoToString(XMLMemento memento) {
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public static IMemento readMementoFromString(String s) {
        StringReader reader = new StringReader(s);
        XMLMemento memento = null;
        try {
            memento = XMLMemento.createReadRoot((Reader)reader);
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
        return memento;
    }
}

