/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.css;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.css.StyleIterator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssStyleSheet;

public class CssStyleSheetHandle
extends ElementDetailHandle {
    protected CssStyleSheet styleSheet = null;

    public CssStyleSheetHandle(ModuleHandle moduleHandle, CssStyleSheet styleSheet) {
        super(moduleHandle);
        assert (styleSheet != null);
        this.styleSheet = styleSheet;
    }

    public CssStyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public Iterator getStyleIterator() {
        return new StyleIterator(this);
    }

    public SharedStyleHandle findStyle(String name) {
        StyleElement style = this.styleSheet.findStyle(name);
        if (style == null) {
            return null;
        }
        return (SharedStyleHandle)style.getHandle(this.getModule());
    }

    public List getUnsupportedStyles() {
        return this.styleSheet.getUnsupportedStyle();
    }

    public List getWarnings(String styleName) {
        return this.styleSheet.getWarnings(styleName);
    }

    public List getParserErrors() {
        return this.styleSheet.getErrorHandler().getParserErrors();
    }

    public List getParserFatalErrors() {
        return this.styleSheet.getErrorHandler().getParserFatalErrors();
    }

    public List getParserWarnings() {
        return this.styleSheet.getErrorHandler().getParserWarnings();
    }

    public String getFileName() {
        return this.styleSheet.getFileName();
    }

    public String getExternalCssURI() {
        return this.styleSheet.getExternalCssURI();
    }

    public boolean isUseExternalCss() {
        return this.styleSheet.isUseExternalCss();
    }

    public DesignElementHandle getContainerHandle() {
        DesignElement tmpElement = this.styleSheet.getContainer();
        if (tmpElement == null) {
            return null;
        }
        return tmpElement.getHandle(this.elementHandle.getModule());
    }
}

