/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.parser.AbstractDesignTestCase;

public class GridItemDesignTest
extends AbstractDesignTestCase {
    public void setUp() throws Exception {
        this.loadDesign("griditem_test.xml");
    }

    public void testGridItem() {
        GridItemDesign grid = (GridItemDesign)this.report.getContent(0);
        GridItemDesignTest.assertTrue((grid != null ? 1 : 0) != 0);
        GridItemDesignTest.assertEquals((int)4, (int)grid.getColumnCount());
        GridItemDesignTest.assertEquals((int)2, (int)grid.getRowCount());
        ColumnDesign column = grid.getColumn(0);
        GridItemDesignTest.assertEquals((double)10.0, (double)column.getWidth().getMeasure(), (double)Double.MIN_VALUE);
        RowDesign row = grid.getRow(0);
        GridItemDesignTest.assertEquals((int)3, (int)row.getCellCount());
        CellDesign cell = row.getCell(0);
        GridItemDesignTest.assertEquals((int)2, (int)cell.getColSpan());
        GridItemDesignTest.assertEquals((int)2, (int)cell.getRowSpan());
        GridItemDesignTest.assertEquals((int)1, (int)cell.getContentCount());
    }

    public void testGridItemNesting() {
        GridItemDesign grid = (GridItemDesign)this.report.getContent(0);
        GridItemDesignTest.assertTrue((grid != null ? 1 : 0) != 0);
        grid = (GridItemDesign)grid.getRow(1).getCell(1).getContent(0);
        GridItemDesignTest.assertTrue((grid != null ? 1 : 0) != 0);
        GridItemDesignTest.assertEquals((int)4, (int)grid.getColumnCount());
        GridItemDesignTest.assertEquals((int)2, (int)grid.getRowCount());
        ColumnDesign column = grid.getColumn(0);
        GridItemDesignTest.assertEquals((double)10.0, (double)column.getWidth().getMeasure(), (double)Double.MIN_VALUE);
        RowDesign row = grid.getRow(0);
        GridItemDesignTest.assertEquals((int)2, (int)row.getCellCount());
        CellDesign cell = row.getCell(0);
        GridItemDesignTest.assertEquals((int)2, (int)cell.getColSpan());
        GridItemDesignTest.assertEquals((int)2, (int)cell.getRowSpan());
        GridItemDesignTest.assertEquals((int)2, (int)cell.getContentCount());
    }

    public void testEmptyColumn() {
        GridItemDesign grid = (GridItemDesign)this.report.getContent(1);
        GridItemDesignTest.assertEquals((int)grid.getColumnCount(), (int)10);
        GridItemDesignTest.assertEquals((int)1, (int)grid.getRowCount());
        RowDesign row = grid.getRow(0);
        GridItemDesignTest.assertEquals((int)1, (int)row.getCellCount());
        CellDesign cell = row.getCell(0);
        GridItemDesignTest.assertEquals((int)0, (int)cell.getContentCount());
    }
}

