/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IComboDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ComboPropertyDescriptor
extends PropertyDescriptor {
    protected CCombo combo;
    protected IChoiceSet choiceSet;
    protected String oldValue;
    private int style = 2056;

    public ComboPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    @Override
    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    void refresh(String value) {
        if (this.getDescriptorProvider() instanceof IComboDescriptorProvider) {
            boolean stateFlag;
            Object[] items = ((IComboDescriptorProvider)this.getDescriptorProvider()).getItems();
            if (this.combo.getItems() == null || !Arrays.equals(this.combo.getItems(), items)) {
                this.combo.setItems((String[])items);
            }
            this.oldValue = ((IComboDescriptorProvider)this.getDescriptorProvider()).load().toString();
            boolean bl = stateFlag = this.oldValue == null == this.combo.getEnabled();
            if (((IComboDescriptorProvider)this.getDescriptorProvider()).isReadOnly()) {
                this.combo.setEnabled(false);
            } else if (stateFlag) {
                this.combo.setEnabled(this.oldValue != null);
            }
            String displayName = ((IComboDescriptorProvider)this.getDescriptorProvider()).getDisplayName(this.oldValue);
            if (displayName == null) {
                if (this.oldValue != null && this.combo.indexOf(this.oldValue) > -1 && this.combo.getText().equals(this.oldValue)) {
                    return;
                }
                this.combo.deselectAll();
                this.combo.setText(this.oldValue);
            } else {
                int index = Arrays.asList(items).indexOf(displayName);
                if (this.combo.getSelectionIndex() != index) {
                    this.combo.select(index);
                }
            }
        }
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    @Override
    public Control createControl(Composite parent) {
        if (this.isFormStyle()) {
            this.combo = FormWidgetFactory.getInstance().createCCombo(parent);
        } else {
            this.combo = new CCombo(parent, this.style);
            this.combo.setVisibleItemCount(30);
        }
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                ComboPropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                ComboPropertyDescriptor.this.combo.clearSelection();
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComboPropertyDescriptor.this.handleComboSelectEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ComboPropertyDescriptor.this.handleComboSelectEvent();
            }
        });
        return this.combo;
    }

    private void handleComboSelectEvent() {
        try {
            this.save(this.combo.getText());
        }
        catch (SemanticException e) {
            this.combo.setText(this.oldValue);
            WidgetUtil.processError((Shell)this.combo.getShell(), (Exception)((Object)e));
        }
    }

    @Override
    public void save(Object value) throws SemanticException {
        this.descriptorProvider.save(value);
    }

    public String getStringValue() {
        return this.combo.getText();
    }

    public void setStringValue(String value) {
        this.combo.setText(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.combo, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.combo.setVisible(isVisible);
    }

    @Override
    public void load() {
        this.oldValue = this.getDescriptorProvider().load().toString();
        this.refresh(this.oldValue);
    }

    public void addStyle(int style) {
        this.style |= style;
    }
}

