/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBy;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupByDistinctValueTest {
    protected GroupDefinition groupDefn;
    protected GroupBy groupBy;

    @Before
    public void groupByDistinctValueSetUp() throws Exception {
        this.groupDefn = new GroupDefinition();
        this.groupDefn.setInterval(0);
        this.groupDefn.setIntervalRange(0.0);
        this.groupBy = this.getInstance(this.groupDefn);
    }

    @Test
    public void testIsInSameGroup() throws DataException {
        Object currentGroupKey = null;
        Object previousGroupKey = null;
        Assert.assertTrue((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = "test";
        previousGroupKey = null;
        Assert.assertFalse((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = "test";
        previousGroupKey = "test";
        Assert.assertTrue((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = "test";
        previousGroupKey = "test2";
        Assert.assertFalse((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = new Integer("1");
        previousGroupKey = new Integer("1");
        Assert.assertTrue((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = new Integer("1");
        previousGroupKey = new Integer("2");
        Assert.assertFalse((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
        currentGroupKey = new Integer("1");
        previousGroupKey = new Double("1");
        Assert.assertFalse((boolean)this.groupBy.isInSameGroup(currentGroupKey, previousGroupKey));
    }

    protected GroupBy getInstance(GroupDefinition groupDefn) throws DataException {
        String groupKey = groupDefn.getKeyColumn();
        IQuery.GroupSpec groupSpec = new IQuery.GroupSpec(groupKey);
        groupSpec.setName(groupDefn.getName());
        groupSpec.setInterval(groupDefn.getInterval());
        groupSpec.setIntervalRange(groupDefn.getIntervalRange());
        groupSpec.setIntervalStart(groupDefn.getIntervalStart());
        groupSpec.setSortDirection(groupDefn.getSortDirection());
        return GroupBy.newInstance((IQuery.GroupSpec)groupSpec, (int)0, null, null);
    }
}

