/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import junit.framework.TestCase;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeSerializer;
import org.eclipse.birt.core.btree.BTreeUtils;

public abstract class BTreeTestCase
extends TestCase {
    static final String BTREE_INPUT_RESOURCE = "org/eclipse/birt/core/btree/btree.input.txt";

    BTree createBTree() throws Exception {
        BTree btree = new BTree();
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BTREE_INPUT_RESOURCE);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = reader.readLine();
                while (line != null) {
                    int value = Integer.parseInt(line);
                    btree.insert((Object)new Integer(value), (Object)String.valueOf(value));
                    line = reader.readLine();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return btree;
    }

    Collection<String> createSampleInput() throws Exception {
        ArrayList<String> input = new ArrayList<String>(10000);
        Random random = new Random();
        int i = 0;
        while (i < 10000) {
            int value = random.nextInt(500);
            input.add(String.valueOf(value));
            ++i;
        }
        return input;
    }

    public static class IntegerSerializer
    implements BTreeSerializer<Integer> {
        public byte[] getBytes(Integer object) throws IOException {
            byte[] bytes = new byte[4];
            BTreeUtils.integerToBytes((int)object, (byte[])bytes);
            return bytes;
        }

        public Integer getObject(byte[] bytes) throws IOException, ClassNotFoundException {
            return new Integer(BTreeUtils.bytesToInteger((byte[])bytes));
        }
    }
}

