/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.ui.ChartExpressionButtonUtil;
import org.eclipse.birt.chart.ui.swt.interfaces.IAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ChartExpressionButton
implements IExpressionButton {
    private final ChartExpressionUtil.ExpressionCodec lastExpr = ChartModelHelper.instance().createExpressionCodec();
    protected ChartExpressionUtil.ExpressionCodec exprCodec = null;
    protected final ExpressionButton eb;
    protected final ChartExpressionButtonUtil.ChartExpressionHelper eHelper;
    protected final Vector<Listener> listeners = new Vector();
    protected ChartUIUtil.EAttributeAccessor<String> accessor;

    public ChartExpressionButton(Composite parent, Control control, ExtendedItemHandle eih, IExpressionProvider ep, ChartExpressionButtonUtil.ChartExpressionHelper eHelper) {
        this.eHelper = eHelper;
        this.exprCodec = ChartModelHelper.instance().createExpressionCodec();
        this.eb = ExpressionButtonUtil.createExpressionButton((Composite)parent, (Control)control, (IExpressionProvider)ep, (Object)eih, (Listener)new Listener(){

            public void handleEvent(Event event) {
                ChartExpressionButton.this.onChange();
            }
        }, (boolean)false, (int)8, (ExpressionButtonUtil.ExpressionHelper)eHelper);
        ExpressionButtonUtil.initExpressionButtonControl((Control)control, null);
        eHelper.initialize();
        ControlListener controlListener = new ControlListener();
        control.addListener(16, (Listener)controlListener);
        control.addListener(13, (Listener)controlListener);
        control.addListener(1, (Listener)controlListener);
    }

    private void save() {
        if (this.accessor != null) {
            String expr = this.eHelper.getExpression().length() == 0 ? null : this.getExpression();
            this.accessor.save((Object)expr);
        }
    }

    private void load() {
        if (this.accessor != null) {
            this.setExpression((String)this.accessor.load());
        }
    }

    protected boolean hasChanged() {
        String oldExpr = this.lastExpr.getExpression();
        String newExpr = this.eHelper.getExpression();
        String oldType = this.lastExpr.getType();
        String newType = this.eHelper.getExpressionType();
        if (oldExpr == null) {
            return newType != null || !oldType.equals(newType);
        }
        return !oldExpr.equals(newExpr) || !oldType.equals(newType);
    }

    private void onChange() {
        if (this.hasChanged()) {
            this.notifyChangeEvent();
        }
    }

    protected void notifyChangeEvent() {
        String newExpr = this.eHelper.getExpression();
        String newType = this.eHelper.getExpressionType();
        Event event = new Event();
        event.widget = this.eb.getControl();
        event.detail = 24;
        String[] data = new String[]{this.lastExpr.getExpression(), newExpr, this.lastExpr.getType(), newType};
        event.data = data;
        for (Listener listener : this.listeners) {
            listener.handleEvent(event);
        }
        this.save();
    }

    public void addListener(Listener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public String getExpression() {
        this.exprCodec.setExpression(this.eHelper.getExpression());
        this.exprCodec.setType(this.eHelper.getExpressionType());
        return this.exprCodec.encode();
    }

    public void setExpression(String expr) {
        this.setExpression(expr, false);
    }

    public String getDisplayExpression() {
        return this.eHelper.getExpression();
    }

    public boolean isEnabled() {
        return this.eb.isEnabled();
    }

    public void setEnabled(boolean bEnabled) {
        this.eb.setEnabled(bEnabled);
    }

    public void setAccessor(ChartUIUtil.EAttributeAccessor<String> accessor) {
        this.accessor = accessor;
        this.load();
    }

    public String getExpressionType() {
        return this.eHelper.getExpressionType();
    }

    public boolean isCube() {
        return this.eHelper.isCube();
    }

    public void setBindingName(String bindingName, boolean bNotifyEvents) {
        if (bindingName != null && bindingName.length() > 0) {
            this.exprCodec.setBindingName(bindingName, this.isCube(), this.eHelper.getExpressionType());
            this.eHelper.setExpression(this.exprCodec.getExpression());
        } else {
            this.eHelper.setExpression(bindingName);
        }
        this.eb.refresh();
        if (bNotifyEvents) {
            this.notifyChangeEvent();
        }
        this.lastExpr.setExpression(this.eHelper.getExpression());
        this.lastExpr.setType(this.eHelper.getExpressionType());
    }

    public void setExpression(String expr, boolean bNotifyEvents) {
        if (expr != null && expr.length() > 0) {
            this.exprCodec.decode(expr);
            this.eHelper.setExpressionType(this.exprCodec.getType());
            this.eHelper.setExpression(this.exprCodec.getExpression());
        } else {
            this.eHelper.setExpression(expr);
        }
        this.eb.refresh();
        if (bNotifyEvents) {
            this.notifyChangeEvent();
        }
        this.lastExpr.setExpression(this.eHelper.getExpression());
        this.lastExpr.setType(this.eHelper.getExpressionType());
    }

    public void setAssitField(IAssistField assistField) {
        this.eHelper.setAssitField(assistField);
    }

    public void setPredefinedQuery(Object[] predefinedQuery) {
        if (predefinedQuery == null) {
            return;
        }
        boolean isCube = this.isCube();
        LinkedHashSet<ChartExpressionButtonUtil.IExpressionDescriptor> set = new LinkedHashSet<ChartExpressionButtonUtil.IExpressionDescriptor>();
        Object[] objectArray = predefinedQuery;
        int n = predefinedQuery.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            set.add(ChartExpressionButtonUtil.ExpressionDescriptor.getInstance(obj, isCube));
            ++n2;
        }
        this.eHelper.setPredefinedQuerys(this.filterDuplicate(set));
    }

    private Collection<ChartExpressionButtonUtil.IExpressionDescriptor> filterDuplicate(Collection<ChartExpressionButtonUtil.IExpressionDescriptor> exprDescs) {
        LinkedHashSet<ChartExpressionButtonUtil.IExpressionDescriptor> set = new LinkedHashSet<ChartExpressionButtonUtil.IExpressionDescriptor>();
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>();
        LinkedList<ChartExpressionButtonUtil.IExpressionDescriptor> otherDescs = new LinkedList<ChartExpressionButtonUtil.IExpressionDescriptor>();
        for (ChartExpressionButtonUtil.IExpressionDescriptor desc : exprDescs) {
            if (desc.isColumnBinding()) {
                set.add(desc);
                bindingNames.add(desc.getBindingName());
                continue;
            }
            otherDescs.add(desc);
        }
        for (ChartExpressionButtonUtil.IExpressionDescriptor desc : otherDescs) {
            String bindingName = desc.getBindingName();
            if (bindingNames.contains(bindingName)) continue;
            set.add(desc);
        }
        return set;
    }

    public ChartExpressionButtonUtil.ChartExpressionHelper getExpressionHelper() {
        return this.eHelper;
    }

    private class ControlListener
    implements Listener {
        private ControlListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: {
                    if (event.keyCode != 13 && event.keyCode != 0x1000050) break;
                    ChartExpressionButton.this.onChange();
                    break;
                }
                case 13: 
                case 16: {
                    ChartExpressionButton.this.onChange();
                }
            }
        }
    }
}

