/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.jdbc.FailedProperties40;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.memory.LowMemory;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.transaction.TransactionControl;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.db.SlaveDatabase;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnectionContext;
import org.apache.derby.impl.jdbc.EmbedSavepoint;
import org.apache.derby.impl.jdbc.LOBFile;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.NoneAuthenticationServiceImpl;
import org.apache.derby.security.DatabasePermission;
import org.apache.derby.shared.common.error.SQLWarningFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;

public class EmbedConnection
implements EngineConnection {
    protected static final StandardException exceptionClose = StandardException.closeException();
    public static final SQLException NO_MEM = EmbedConnection.newSQLException("08004", "java.lang.OutOfMemoryError");
    public static final LowMemory memoryState = new LowMemory();
    DatabaseMetaData dbMetadata;
    TransactionResourceImpl tr;
    private HashMap<Integer, Object> lobHashMap = null;
    private int lobHMKey = 0;
    private WeakHashMap<Object, Object> lobReferences = null;
    private HashSet<LOBFile> lobFiles;
    private boolean active;
    private boolean aborting = false;
    boolean autoCommit = true;
    boolean needCommit;
    private boolean usingNoneAuth;
    private int connectionHoldAbility = 1;
    final EmbedConnection rootConnection;
    private SQLWarning topWarning;
    private InternalDriver factory;
    private Connection applicationConnection;
    private int resultSetId;
    private String connString;
    private static final int OP_ENCRYPT = 0;
    private static final int OP_SHUTDOWN = 1;
    private static final int OP_HARD_UPGRADE = 2;
    private static final int OP_REPLICATION = 3;
    private static final int OP_DECRYPT = 4;

    public EmbedConnection(InternalDriver driver, String url, Properties info) throws SQLException {
        this.rootConnection = this;
        this.applicationConnection = this.rootConnection;
        this.factory = driver;
        this.tr = new TransactionResourceImpl(driver, url, info);
        this.active = true;
        this.setupContextStack();
        try {
            String replicationOp;
            boolean createBoot;
            EmbedConnectionContext context = this.pushConnectionContext(this.tr.getContextManager());
            boolean shutdown = EmbedConnection.isTrue(info, "shutdown");
            Database database = (Database)EmbedConnection.findService("org.apache.derby.database.Database", this.tr.getDBName());
            if (database != null && this.isCryptoBoot(info)) {
                this.addWarning(SQLWarningFactory.newSQLWarning("01J17", new Object[0]));
            }
            boolean isTwoPhaseCryptoBoot = !(createBoot = this.createBoot(info)) && this.isCryptoBoot(info);
            boolean isTwoPhaseUpgradeBoot = !createBoot && this.isHardUpgradeBoot(info);
            boolean isStartSlaveBoot = this.isStartReplicationSlaveBoot(info);
            boolean slaveDBAlreadyBooted = false;
            boolean isFailoverMasterBoot = false;
            boolean isFailoverSlaveBoot = false;
            boolean dropDatabase = this.isDropDatabase(info);
            if (shutdown && dropDatabase) {
                throw EmbedConnection.newSQLException("XJ048.C", "shutdown, drop");
            }
            if (isTwoPhaseCryptoBoot) {
                this.checkConflictingCryptoAttributes(info);
            }
            if ((replicationOp = this.getReplicationOperation(info)) != null && (createBoot || shutdown || dropDatabase || isTwoPhaseCryptoBoot || isTwoPhaseUpgradeBoot)) {
                throw StandardException.newException("XRE10", replicationOp);
            }
            if (this.isReplicationFailover(info)) {
                this.checkDatabaseBooted(database, "failover", this.tr.getDBName());
                if (database.isInSlaveMode()) {
                    isFailoverSlaveBoot = true;
                } else {
                    isFailoverMasterBoot = true;
                }
            }
            Properties savedInfo = null;
            if (isStartSlaveBoot) {
                if (database != null) {
                    slaveDBAlreadyBooted = true;
                } else {
                    info.setProperty("replication.slave.mode", "slavepremode");
                }
            }
            if (this.isStopReplicationSlaveBoot(info)) {
                this.handleStopReplicationSlave(database, info);
            } else {
                if (this.isInternalShutdownSlaveDatabase(info)) {
                    this.internalStopReplicationSlave(database, info);
                    return;
                }
                if (isFailoverSlaveBoot) {
                    this.handleFailoverSlave(database);
                }
            }
            if (database != null) {
                this.tr.setDatabase(database);
                isTwoPhaseCryptoBoot = false;
                isTwoPhaseUpgradeBoot = false;
            } else if (!shutdown) {
                if (isTwoPhaseCryptoBoot || isTwoPhaseUpgradeBoot) {
                    savedInfo = info;
                    info = this.removePhaseTwoProps((Properties)info.clone());
                }
                if (!this.bootDatabase(info, isTwoPhaseUpgradeBoot)) {
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
            }
            if (createBoot && !shutdown && !dropDatabase) {
                if (this.tr.getDatabase() != null) {
                    this.addWarning(SQLWarningFactory.newSQLWarning("01J01", this.getDBName()));
                } else {
                    this.checkUserCredentials(true, null, info);
                    database = this.createDatabase(this.tr.getDBName(), info);
                    this.tr.setDatabase(database);
                }
            }
            if (this.tr.getDatabase() == null) {
                this.handleDBNotFound();
            }
            try {
                this.checkUserCredentials(false, this.tr.getDBName(), info);
            }
            catch (SQLException sqle) {
                if (isStartSlaveBoot && !slaveDBAlreadyBooted) {
                    this.tr.startTransaction();
                    this.handleException(this.tr.shutdownDatabaseException());
                }
                throw sqle;
            }
            this.tr.startTransaction();
            if (this.isStartReplicationMasterBoot(info) || this.isStopReplicationMasterBoot(info) || isFailoverMasterBoot) {
                if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
                    this.checkIsDBOwner(3);
                }
                if (this.isStartReplicationMasterBoot(info)) {
                    this.handleStartReplicationMaster(this.tr, info);
                } else if (this.isStopReplicationMasterBoot(info)) {
                    this.handleStopReplicationMaster(this.tr, info);
                } else if (isFailoverMasterBoot) {
                    this.handleFailoverMaster(this.tr);
                }
            }
            if (isTwoPhaseCryptoBoot || isTwoPhaseUpgradeBoot || isStartSlaveBoot) {
                if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
                    int operation = isTwoPhaseCryptoBoot ? (EmbedConnection.isTrue(savedInfo, "decryptDatabase") ? 4 : 0) : (isTwoPhaseUpgradeBoot ? 2 : 3);
                    try {
                        this.checkIsDBOwner(operation);
                    }
                    catch (SQLException sqle) {
                        if (isStartSlaveBoot) {
                            this.handleException(this.tr.shutdownDatabaseException());
                        }
                        throw sqle;
                    }
                }
                if (isStartSlaveBoot) {
                    if (slaveDBAlreadyBooted) {
                        throw StandardException.newException("XRE09.C", this.getTR().getDBName());
                    }
                    info.setProperty("replication.slave.mode", "slavemode");
                    info.setProperty("replication.slave.dbname", this.getTR().getDBName());
                } else {
                    info = savedInfo;
                }
                this.handleException(this.tr.shutdownDatabaseException());
                this.restoreContextStack();
                this.tr = new TransactionResourceImpl(driver, url, info);
                this.active = true;
                this.setupContextStack();
                context = this.pushConnectionContext(this.tr.getContextManager());
                if (!this.bootDatabase(info, false)) {
                    SanityManager.THROWASSERT("bootDatabase failed after initial plain boot for (re)encryption or upgrade");
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
                if (isStartSlaveBoot) {
                    throw StandardException.newException("XRE08", this.getTR().getDBName());
                }
                this.tr.startTransaction();
            }
            if (shutdown) {
                if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
                    this.checkIsDBOwner(1);
                }
                throw this.tr.shutdownDatabaseException();
            }
            if (dropDatabase) {
                if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
                    this.checkIsDBOwner(1);
                }
                String dbName = this.tr.getDBName();
                this.handleException(this.tr.shutdownDatabaseException());
                EmbedConnection.sleep(500L);
                EmbedConnection.removePersistentService(dbName);
                StandardException se = StandardException.newException("08006.D.1", dbName);
                se.setReport(1);
                throw se;
            }
            if (this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
                this.addWarning(SQLWarningFactory.newSQLWarning("01J14", new Object[0]));
            }
            InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
        }
        catch (OutOfMemoryError noMemory) {
            InterruptStatus.restoreIntrFlagIfSeen();
            this.restoreContextStack();
            this.tr.lcc = null;
            this.tr.cm = null;
            memoryState.setLowMemory();
            throw NO_MEM;
        }
        catch (Throwable t) {
            StandardException se;
            InterruptStatus.restoreIntrFlagIfSeen();
            if (t instanceof StandardException && (se = (StandardException)t).getSeverity() < 40000) {
                se.setSeverity(40000);
            }
            this.tr.cleanupOnError(t, false);
            throw this.handleException(t);
        }
        finally {
            this.restoreContextStack();
        }
    }

    private void checkDatabaseBooted(Database database, String operation, String dbname) throws SQLException {
        if (database == null) {
            this.setInactive();
            throw EmbedConnection.newSQLException("XRE11.C", operation, dbname);
        }
    }

    private boolean createBoot(Properties p) throws SQLException {
        int createCount = 0;
        if (EmbedConnection.isTrue(p, "create")) {
            ++createCount;
        }
        int restoreCount = 0;
        if (EmbedConnection.isSet(p, "createFrom")) {
            ++restoreCount;
        }
        if (EmbedConnection.isSet(p, "restoreFrom")) {
            ++restoreCount;
        }
        if (EmbedConnection.isSet(p, "rollForwardRecoveryFrom")) {
            ++restoreCount;
        }
        if (restoreCount > 1) {
            throw EmbedConnection.newSQLException("XJ081.C", new Object[0]);
        }
        if (restoreCount != 0 && this.isCryptoBoot(p)) {
            throw EmbedConnection.newSQLException("XJ081.C", new Object[0]);
        }
        if ((createCount += restoreCount) > 1) {
            throw EmbedConnection.newSQLException("XJ049.C", new Object[0]);
        }
        if (createCount == 1 && this.isDropDatabase(p)) {
            String sqlState = "XJ049.C";
            if (restoreCount > 0) {
                sqlState = "XJ081.C";
            }
            throw EmbedConnection.newSQLException(sqlState, new Object[0]);
        }
        return createCount - restoreCount == 1;
    }

    private void handleDBNotFound() throws SQLException {
        String dbname = this.tr.getDBName();
        this.setInactive();
        throw EmbedConnection.newSQLException("XJ004.C", dbname);
    }

    private boolean isDropDatabase(Properties p) {
        return EmbedConnection.isTrue(p, "drop");
    }

    private boolean isCryptoBoot(Properties p) throws SQLException {
        return EmbedConnection.vetTrue(p, "dataEncryption") || EmbedConnection.vetTrue(p, "decryptDatabase") || EmbedConnection.isSet(p, "newBootPassword") || EmbedConnection.isSet(p, "newEncryptionKey");
    }

    private boolean isHardUpgradeBoot(Properties p) {
        return EmbedConnection.isTrue(p, "upgrade");
    }

    private boolean isStartReplicationSlaveBoot(Properties p) {
        return EmbedConnection.isTrue(p, "startSlave");
    }

    private boolean isStartReplicationMasterBoot(Properties p) {
        return EmbedConnection.isTrue(p, "startMaster");
    }

    private boolean isReplicationFailover(Properties p) {
        return EmbedConnection.isTrue(p, "failover");
    }

    private boolean isStopReplicationMasterBoot(Properties p) {
        return EmbedConnection.isTrue(p, "stopMaster");
    }

    private boolean isStopReplicationSlaveBoot(Properties p) {
        return EmbedConnection.isTrue(p, "stopSlave");
    }

    private boolean isInternalShutdownSlaveDatabase(Properties p) {
        return EmbedConnection.isTrue(p, "internal_stopslave");
    }

    private static boolean isSet(Properties p, String attribute) {
        return p.getProperty(attribute) != null;
    }

    private static boolean isTrue(Properties p, String attribute) {
        return Boolean.valueOf(p.getProperty(attribute));
    }

    private static boolean vetTrue(Properties p, String attribute) throws SQLException {
        String value = p.getProperty(attribute);
        if (value == null) {
            return false;
        }
        if (Boolean.valueOf(value).booleanValue()) {
            return true;
        }
        throw EmbedConnection.newSQLException("XJ05B.C", attribute, value, Boolean.TRUE.toString());
    }

    private String getReplicationOperation(Properties p) throws StandardException {
        String operation = null;
        int opcount = 0;
        if (this.isStartReplicationSlaveBoot(p)) {
            operation = "startSlave";
            ++opcount;
        }
        if (this.isStartReplicationMasterBoot(p)) {
            operation = "startMaster";
            ++opcount;
        }
        if (this.isStopReplicationSlaveBoot(p)) {
            operation = "stopSlave";
            ++opcount;
        }
        if (this.isInternalShutdownSlaveDatabase(p)) {
            operation = "internal_stopslave";
            ++opcount;
        }
        if (this.isStopReplicationMasterBoot(p)) {
            operation = "stopMaster";
            ++opcount;
        }
        if (this.isReplicationFailover(p)) {
            operation = "failover";
            ++opcount;
        }
        if (opcount > 1) {
            throw StandardException.newException("XRE10", operation);
        }
        return operation;
    }

    private void handleStartReplicationMaster(TransactionResourceImpl tr, Properties p) throws SQLException {
        String slavehost;
        if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        if ((slavehost = p.getProperty("slaveHost")) == null) {
            SQLException wrappedExc = EmbedConnection.newSQLException("XCY03.S", "slaveHost");
            throw EmbedConnection.newSQLException("08004", wrappedExc);
        }
        String portString = p.getProperty("slavePort");
        int slaveport = -1;
        if (portString != null) {
            slaveport = Integer.parseInt(portString);
        }
        tr.getDatabase().startReplicationMaster(this.getTR().getDBName(), slavehost, slaveport, "derby.__rt.asynch");
    }

    private void handleStopReplicationMaster(TransactionResourceImpl tr, Properties p) throws SQLException {
        if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        tr.getDatabase().stopReplicationMaster();
    }

    private void handleStopReplicationSlave(Database database, Properties p) throws StandardException, SQLException {
        this.checkDatabaseBooted(database, "stopSlave", this.tr.getDBName());
        database.stopReplicationSlave();
        throw EmbedConnection.newSQLException("XRE42.C", this.getTR().getDBName());
    }

    private void internalStopReplicationSlave(Database database, Properties p) throws StandardException, SQLException {
        this.checkDatabaseBooted(database, "internal_stopslave", this.tr.getDBName());
        if (!(database instanceof SlaveDatabase)) {
            throw EmbedConnection.newSQLException("XRE40", new Object[0]);
        }
        ((SlaveDatabase)database).verifyShutdownSlave();
        this.handleException(this.tr.shutdownDatabaseException());
    }

    private void handleFailoverMaster(TransactionResourceImpl tr) throws SQLException, StandardException {
        if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        tr.getDatabase().failover(tr.getDBName());
    }

    private void handleFailoverSlave(Database database) throws SQLException {
        try {
            database.failover(this.getTR().getDBName());
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private Properties removePhaseTwoProps(Properties p) {
        p.remove("dataEncryption");
        p.remove("decryptDatabase");
        p.remove("newBootPassword");
        p.remove("newEncryptionKey");
        p.remove("upgrade");
        return p;
    }

    public EmbedConnection(EmbedConnection inputConnection) {
        SanityManager.ASSERT(inputConnection.active, "trying to create a proxy for an inactive conneciton");
        this.autoCommit = false;
        this.tr = null;
        this.active = true;
        this.rootConnection = inputConnection.rootConnection;
        this.applicationConnection = this;
        this.factory = inputConnection.factory;
        this.connectionHoldAbility = inputConnection.connectionHoldAbility;
    }

    private void checkUserCredentials(boolean creatingDatabase, String dbname, Properties userInfo) throws SQLException {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        AuthenticationService authenticationService = null;
        try {
            authenticationService = dbname == null ? this.getLocalDriver().getAuthenticationService() : this.getTR().getDatabase().getAuthenticationService();
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        if (authenticationService == null) {
            String failedString = MessageService.getTextMessage(dbname == null ? "A001" : "A002", new Object[0]);
            throw EmbedConnection.newSQLException("08004", failedString);
        }
        if (creatingDatabase && this.compareDatabaseNames(this.getDBName(), authenticationService.getSystemCredentialsDatabaseName())) {
            String user = userInfo.getProperty("user");
            String password = userInfo.getProperty("password");
            if (this.emptyCredential(user) || this.emptyCredential(password)) {
                throw EmbedConnection.newSQLException("08004.C.13", new Object[0]);
            }
            return;
        }
        if (dbname != null) {
            this.checkUserIsNotARole();
        }
        boolean authenticationSucceeded = true;
        try {
            authenticationSucceeded = authenticationService.authenticate(dbname, userInfo);
        }
        catch (SQLWarning warnings) {
            this.addWarning(warnings);
        }
        if (!authenticationSucceeded) {
            throw EmbedConnection.newSQLException("08004.C.1", MessageService.getTextMessage("A020", new Object[0]));
        }
        if (authenticationService instanceof NoneAuthenticationServiceImpl) {
            this.usingNoneAuth = true;
        }
    }

    private boolean emptyCredential(String credential) {
        return credential == null || credential.length() == 0;
    }

    private boolean compareDatabaseNames(String leftDBName, String rightDBName) throws SQLException {
        try {
            String leftCanonical = EmbedConnection.getMonitor().getCanonicalServiceName(leftDBName);
            String rightCanonical = EmbedConnection.getMonitor().getCanonicalServiceName(rightDBName);
            if (leftCanonical == null) {
                return false;
            }
            return leftCanonical.equals(rightCanonical);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private void checkUserIsNotARole() throws SQLException {
        TransactionResourceImpl tr = this.getTR();
        try {
            tr.startTransaction();
            LanguageConnectionContext lcc = tr.getLcc();
            String username = lcc.getSessionUserId();
            DataDictionary dd = lcc.getDataDictionary();
            if (lcc.usesSqlAuthorization() && dd.checkVersion(160, null)) {
                TransactionController tc = lcc.getTransactionExecute();
                String failedString = MessageService.getTextMessage("A020", new Object[0]);
                if (dd.getRoleDefinitionDescriptor(username) != null) {
                    throw EmbedConnection.newSQLException("08004.C.1", failedString);
                }
            }
            tr.rollback();
            InterruptStatus.restoreIntrFlagIfSeen(lcc);
        }
        catch (StandardException e) {
            try {
                tr.rollback();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw this.handleException(e);
        }
    }

    private void checkIsDBOwner(int operation) throws SQLException {
        String dbOwnerId;
        LanguageConnectionContext lcc = this.privilegedGetLCC();
        String actualId = lcc.getSessionUserId();
        if (!actualId.equals(dbOwnerId = lcc.getDataDictionary().getAuthorizationDatabaseOwner())) {
            switch (operation) {
                case 0: {
                    throw EmbedConnection.newSQLException("08004.C.5", actualId, this.tr.getDBName());
                }
                case 4: {
                    throw EmbedConnection.newSQLException("08004.C.14", actualId, this.tr.getDBName());
                }
                case 1: {
                    throw EmbedConnection.newSQLException("08004.C.4", actualId, this.tr.getDBName());
                }
                case 2: {
                    throw EmbedConnection.newSQLException("08004.C.6", actualId, this.tr.getDBName());
                }
                case 3: {
                    throw EmbedConnection.newSQLException("08004.C.8", actualId, this.tr.getDBName());
                }
            }
            SanityManager.THROWASSERT("illegal checkIsDBOwner operation");
            throw EmbedConnection.newSQLException("08004.C.3", new Object[0]);
        }
    }

    public int getEngineType() {
        Database db = this.getDatabase();
        if (null == db) {
            return 0;
        }
        return db.getEngineType();
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.connectionHoldAbility);
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.connectionHoldAbility);
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfClosed();
        return this.factory.newEmbedStatement(this, false, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, 2, null, null);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.connectionHoldAbility, 2, null, null);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, columnIndexes == null || columnIndexes.length == 0 ? 2 : 1, columnIndexes, null);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, columnNames == null || columnNames.length == 0 ? 2 : 1, null, columnNames);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, autoGeneratedKeys, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            PreparedStatement preparedStatement;
            this.setupContextStack();
            try {
                preparedStatement = this.factory.newEmbedPreparedStatement(this, sql, false, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, columnIndexes, columnNames);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return preparedStatement;
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, this.connectionHoldAbility);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.connectionHoldAbility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfClosed();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            CallableStatement callableStatement;
            this.setupContextStack();
            try {
                callableStatement = this.factory.newEmbedCallableStatement(this, sql, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return callableStatement;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkIfClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkIfClosed();
        if (this.rootConnection != this && autoCommit) {
            throw EmbedConnection.newSQLException("XJ030.S", new Object[0]);
        }
        if (this.autoCommit != autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkIfClosed();
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getTR().commit();
                this.clearLOBMapping();
                InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getTR().rollback();
                this.clearLOBMapping();
                InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    @Override
    public void close() throws SQLException {
        this.checkForTransactionInProgress();
        this.close(exceptionClose);
    }

    public void checkForTransactionInProgress() throws SQLException {
        if (!(this.isClosed() || this.rootConnection != this || this.autoCommit || this.transactionIsIdle())) {
            Util.logAndThrowSQLException(EmbedConnection.newSQLException("25001", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(StandardException e) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.rootConnection == this && (this.active || this.isAborting())) {
                if (this.tr.isActive()) {
                    this.setupContextStack();
                    try {
                        this.tr.rollback();
                        InterruptStatus.restoreIntrFlagIfSeen(this.tr.getLcc());
                        this.tr.clearLcc();
                        this.tr.cleanupOnError(e, false);
                    }
                    catch (Throwable t) {
                        throw this.handleException(t);
                    }
                    finally {
                        this.restoreContextStack();
                    }
                } else {
                    InterruptStatus.restoreIntrFlagIfSeen();
                    this.tr.clearLcc();
                    this.tr.cleanupOnError(e, false);
                }
            }
            this.aborting = false;
            if (!this.isClosed()) {
                this.setInactive();
            }
        }
    }

    @Override
    public final boolean isClosed() {
        return !this.active || !this.getTR().isActive();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfClosed();
        if (this.dbMetadata == null) {
            this.dbMetadata = this.factory.newEmbedDatabaseMetaData(this, this.getTR().getUrl());
        }
        return this.dbMetadata;
    }

    @Override
    public final int getHoldability() throws SQLException {
        this.checkIfClosed();
        return this.connectionHoldAbility;
    }

    @Override
    public final void setHoldability(int holdability) throws SQLException {
        this.checkIfClosed();
        this.connectionHoldAbility = holdability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext lcc = this.privilegedGetLCC();
                lcc.setReadOnly(readOnly);
                InterruptStatus.restoreIntrFlagIfSeen(lcc);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        this.checkIfClosed();
        return this.privilegedGetLCC().isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkIfClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkIfClosed();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (level == this.getTransactionIsolation()) {
            return;
        }
        int iLevel = switch (level) {
            case 1 -> 1;
            case 2 -> 2;
            case 4 -> 3;
            case 8 -> 4;
            default -> throw EmbedConnection.newSQLException("XJ045.S", level);
        };
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext lcc = this.privilegedGetLCC();
                lcc.setIsolationLevel(iLevel);
                InterruptStatus.restoreIntrFlagIfSeen(lcc);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        this.checkIfClosed();
        return TransactionControl.jdbcIsolationLevel(this.privilegedGetLCC().getCurrentIsolationLevel());
    }

    @Override
    public final synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed();
        return this.topWarning;
    }

    @Override
    public final synchronized void clearWarnings() throws SQLException {
        this.checkIfClosed();
        this.topWarning = null;
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.checkIfClosed();
        if (map == null) {
            throw EmbedConnection.newSQLException("XJ081.S", map, "map", "java.sql.Connection.setTypeMap");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
    }

    @Override
    public final synchronized void addWarning(SQLWarning newWarning) {
        if (this.topWarning == null) {
            this.topWarning = newWarning;
            return;
        }
        this.topWarning.setNextWarning(newWarning);
    }

    public String getDBName() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getDBName();
    }

    public final LanguageConnectionContext getLanguageConnection() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        SanityManager.ASSERT(!this.isClosed() || this.isAborting(), "connection is closed");
        return this.privilegedGetLCC();
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    SQLException handleException(Throwable thrownException) throws SQLException {
        if (thrownException instanceof StandardException && ((StandardException)thrownException).getSeverity() >= 30000) {
            this.clearLOBMapping();
        }
        return this.getTR().handleException(thrownException, this.autoCommit, true);
    }

    final SQLException handleException(Throwable thrownException, boolean rollbackOnAutoCommit) throws SQLException {
        if (thrownException instanceof StandardException && ((StandardException)thrownException).getSeverity() >= 30000) {
            this.clearLOBMapping();
        }
        return this.getTR().handleException(thrownException, this.autoCommit, rollbackOnAutoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInactive() {
        if (!this.active) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.active = false;
            this.dbMetadata = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.rootConnection == this) {
                this.close(exceptionClose);
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void needCommit() {
        if (!this.needCommit) {
            this.needCommit = true;
        }
    }

    protected void commitIfNeeded() throws SQLException {
        if (this.autoCommit && this.needCommit) {
            try {
                this.getTR().commit();
                this.clearLOBMapping();
                InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            this.needCommit = false;
        }
    }

    protected void commitIfAutoCommit() throws SQLException {
        if (this.autoCommit) {
            try {
                this.getTR().commit();
                this.clearLOBMapping();
                InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            this.needCommit = false;
        }
    }

    protected final Object getConnectionSynchronization() {
        return this.rootConnection;
    }

    protected final void setupContextStack() throws SQLException {
        if (!this.isAborting()) {
            this.checkIfClosed();
        }
        this.getTR().setupContextStack();
    }

    protected final void restoreContextStack() throws SQLException {
        Util.ASSERT(this, this.active || this.getTR().getCsf() != null, "No context service to do restore");
        TransactionResourceImpl tr = this.getTR();
        if (tr.getCsf() != null) {
            ContextManager cm2;
            ContextManager cm1 = tr.getCsf().getCurrentContextManager();
            Util.ASSERT(this, cm1 == (cm2 = tr.getContextManager()) || cm1 == null, "Current Context Manager not the one was expected: " + cm1 + " " + cm2);
        }
        tr.restoreContextStack();
    }

    private Database createDatabase(String dbname, Properties info) throws SQLException {
        info = this.filterProperties(info);
        try {
            if (EmbedConnection.createPersistentService("org.apache.derby.database.Database", dbname, info) == null) {
                this.addWarning(SQLWarningFactory.newSQLWarning("01J01", dbname));
            }
        }
        catch (StandardException mse) {
            throw Util.seeNextException("XJ041.C", this.handleException(mse), mse, dbname);
        }
        info.clear();
        return (Database)EmbedConnection.findService("org.apache.derby.database.Database", dbname);
    }

    private void checkDatabaseCreatePrivileges(String user, String dbname) throws SQLException {
        if (System.getSecurityManager() == null) {
            return;
        }
        if (dbname == null) {
            throw new NullPointerException("dbname can't be null");
        }
        try {
            String url = "directory:" + EmbedConnection.stripSubSubProtocolPrefix(dbname);
            DatabasePermission dp = new DatabasePermission(url, "create");
            this.factory.checkSystemPrivileges(user, dp);
        }
        catch (IOException ioe) {
            throw EmbedConnection.newSQLException("08004.C.10", dbname, ioe);
        }
        catch (Exception e) {
            throw EmbedConnection.newSQLException("08004.C.10", dbname, e);
        }
    }

    private static void sleep(long millis) {
        long startMillis = System.currentTimeMillis();
        long waited = 0L;
        while (waited < millis) {
            try {
                Thread.sleep(millis - waited);
                break;
            }
            catch (InterruptedException ie) {
                InterruptStatus.setInterrupted();
                waited = System.currentTimeMillis() - startMillis;
            }
        }
    }

    public static String stripSubSubProtocolPrefix(String dbname) {
        String prop;
        int i = dbname.indexOf(58);
        if (i > 0 && PropertyUtil.getSystemProperty(prop = "derby.subSubProtocol." + dbname.substring(0, i), null) != null) {
            return dbname.substring(i + 1);
        }
        return dbname;
    }

    private boolean bootDatabase(Properties info, boolean softAuthenticationBoot) throws Throwable {
        String dbname = this.tr.getDBName();
        try {
            info = this.filterProperties(info);
            if (softAuthenticationBoot) {
                info.setProperty("softUpgradeNoFeatureCheck", "true");
            } else {
                info.remove("softUpgradeNoFeatureCheck");
            }
            if (!EmbedConnection.startPersistentService(dbname, info)) {
                return false;
            }
            info.clear();
            Database database = (Database)EmbedConnection.findService("org.apache.derby.database.Database", dbname);
            this.tr.setDatabase(database);
        }
        catch (StandardException mse) {
            Throwable ne = mse.getCause();
            SQLException nse = ne instanceof StandardException ? Util.generateCsSQLException((StandardException)ne) : (ne != null ? Util.javaException(ne) : Util.generateCsSQLException(mse));
            throw Util.seeNextException("XJ040.C", nse, ne == null ? mse : ne, dbname, this.getClass().getClassLoader());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement prepareMetaDataStatement(String sql) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            PreparedStatement s = null;
            try {
                s = this.factory.newEmbedPreparedStatement(this, sql, true, 1003, 1007, this.connectionHoldAbility, 2, null, null);
            }
            finally {
                InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
                this.restoreContextStack();
            }
            return s;
        }
    }

    public final InternalDriver getLocalDriver() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getDriver();
    }

    public final ContextManager getContextManager() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getContextManager();
    }

    private Properties filterProperties(Properties inputSet) {
        Properties limited = new Properties();
        Enumeration<?> e = inputSet.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("derby.")) continue;
            limited.put(key, inputSet.getProperty(key));
        }
        return limited;
    }

    protected Database getDatabase() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getDatabase();
    }

    protected final TransactionResourceImpl getTR() {
        return this.rootConnection.tr;
    }

    private EmbedConnectionContext pushConnectionContext(ContextManager cm) {
        return new EmbedConnectionContext(cm, this);
    }

    public final void setApplicationConnection(Connection applicationConnection) {
        this.applicationConnection = applicationConnection;
    }

    public final Connection getApplicationConnection() {
        return this.applicationConnection;
    }

    @Override
    public void setDrdaID(String drdaID) {
        this.privilegedGetLCC().setDrdaID(drdaID);
    }

    @Override
    public boolean isInGlobalTransaction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetFromPool() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext lcc = this.privilegedGetLCC();
                lcc.resetFromPool();
                InterruptStatus.restoreIntrFlagIfSeen(lcc);
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int xa_prepare() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext lcc = this.privilegedGetLCC();
                XATransactionController tc = (XATransactionController)lcc.getTransactionExecute();
                try {
                    lcc.checkIntegrity();
                }
                catch (StandardException e) {
                    lcc.xaRollback();
                    throw e;
                }
                int ret = tc.xa_prepare();
                if (ret == 1) {
                    lcc.internalCommit(false);
                }
                InterruptStatus.restoreIntrFlagIfSeen(lcc);
                int n = ret;
                return n;
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_commit(boolean onePhase) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext lcc = this.privilegedGetLCC();
                lcc.xaCommit(onePhase);
                InterruptStatus.restoreIntrFlagIfSeen(lcc);
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext lcc = this.privilegedGetLCC();
                lcc.xaRollback();
                InterruptStatus.restoreIntrFlagIfSeen(lcc);
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean transactionIsIdle() {
        return this.getTR().isIdle();
    }

    private int setResultSetType(int resultSetType) {
        if (resultSetType == 1005) {
            this.addWarning(SQLWarningFactory.newSQLWarning("01J02", new Object[0]));
            resultSetType = 1004;
        }
        return resultSetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrepareIsolation(int level) throws SQLException {
        if (level == this.getPrepareIsolation()) {
            return;
        }
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw EmbedConnection.newSQLException("XJ045.S", level);
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.privilegedGetLCC().setPrepareIsolationLevel(level);
        }
    }

    @Override
    public int getPrepareIsolation() {
        return this.privilegedGetLCC().getPrepareIsolationLevel();
    }

    final int getResultSetOrderId() {
        if (this == this.rootConnection) {
            return 0;
        }
        return this.rootConnection.resultSetId++;
    }

    static SQLException newSQLException(String messageId, Object ... args) {
        return Util.generateCsSQLException(messageId, args);
    }

    public String toString() {
        if (this.connString == null) {
            LanguageConnectionContext lcc = this.privilegedGetLCC();
            this.connString = this.getClass().getName() + "@" + this.hashCode() + " " + "(XID = " + lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + Integer.toString(lcc.getInstanceNumber()) + "), " + "(DATABASE = " + lcc.getDbname() + "), " + "(DRDAID = " + lcc.getDrdaID() + ") ";
        }
        return this.connString;
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkIfClosed();
        return new EmbedClob(this);
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkIfClosed();
        return new EmbedBlob(new byte[0], this);
    }

    public int addLOBMapping(Object LOBReference) {
        int loc = this.getIncLOBKey();
        this.getlobHMObj().put(loc, LOBReference);
        return loc;
    }

    public void removeLOBMapping(int key) {
        this.getlobHMObj().remove(key);
    }

    @Override
    public Object getLOBMapping(int key) {
        return this.getlobHMObj().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLOBMapping() throws SQLException {
        WeakHashMap<Object, Object> map = this.rootConnection.lobReferences;
        if (map != null) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                ((EngineLOB)it.next()).free();
            }
            map.clear();
        }
        if (this.rootConnection.lobHashMap != null) {
            this.rootConnection.lobHashMap.clear();
        }
        EmbedConnection embedConnection = this;
        synchronized (embedConnection) {
            if (this.lobFiles != null) {
                SQLException firstException = null;
                Iterator<LOBFile> it = this.lobFiles.iterator();
                while (it.hasNext()) {
                    try {
                        it.next().close();
                    }
                    catch (IOException ioe) {
                        if (firstException != null) continue;
                        firstException = Util.javaException(ioe);
                    }
                }
                this.lobFiles.clear();
                if (firstException != null) {
                    throw firstException;
                }
            }
        }
    }

    private int getIncLOBKey() {
        int newKey;
        if ((newKey = ++this.rootConnection.lobHMKey) == 32768 || newKey == 32770 || newKey == 32772 || newKey == 32774 || newKey == 32776) {
            newKey = ++this.rootConnection.lobHMKey;
        }
        if (newKey == Integer.MIN_VALUE || newKey == 0) {
            this.rootConnection.lobHMKey = 1;
            newKey = 1;
        }
        return newKey;
    }

    void addLOBReference(Object lobReference) {
        if (this.rootConnection.lobReferences == null) {
            this.rootConnection.lobReferences = new WeakHashMap();
        }
        this.rootConnection.lobReferences.put(lobReference, null);
    }

    private HashMap<Integer, Object> getlobHMObj() {
        if (this.rootConnection.lobHashMap == null) {
            this.rootConnection.lobHashMap = new HashMap();
        }
        return this.rootConnection.lobHashMap;
    }

    public void cancelRunningStatement() {
        this.privilegedGetLCC().getStatementContext().cancel();
    }

    @Override
    public String getCurrentSchemaName() {
        return this.privilegedGetLCC().getCurrentSchemaName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLobFile(LOBFile lobFile) {
        EmbedConnection embedConnection = this;
        synchronized (embedConnection) {
            if (this.lobFiles == null) {
                this.lobFiles = new HashSet();
            }
            this.lobFiles.add(lobFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLobFile(LOBFile lobFile) {
        EmbedConnection embedConnection = this;
        synchronized (embedConnection) {
            this.lobFiles.remove(lobFile);
        }
    }

    public boolean isAborting() {
        return this.aborting;
    }

    protected void beginAborting() {
        this.aborting = true;
        this.setInactive();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.commonSetSavepointCode(null, false);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.commonSetSavepointCode(name, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Savepoint commonSetSavepointCode(String name, boolean userSuppliedSavepointName) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                EmbedSavepoint savePt;
                this.verifySavepointCommandIsAllowed();
                if (userSuppliedSavepointName && name == null) {
                    throw EmbedConnection.newSQLException("XJ011.S", new Object[0]);
                }
                if (userSuppliedSavepointName && name.length() > 128) {
                    throw EmbedConnection.newSQLException("42622", name, String.valueOf(128));
                }
                if (userSuppliedSavepointName && name.startsWith("SYS")) {
                    throw EmbedConnection.newSQLException("42939", "SYS");
                }
                EmbedSavepoint embedSavepoint = savePt = new EmbedSavepoint(this, name);
                return embedSavepoint;
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.verifySavepointCommandIsAllowed();
                this.verifySavepointArg(savepoint);
                this.privilegedGetLCC().internalRollbackToSavepoint(((EmbedSavepoint)savepoint).getInternalName(), true, savepoint);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.verifySavepointCommandIsAllowed();
                this.verifySavepointArg(savepoint);
                this.privilegedGetLCC().releaseSavePoint(((EmbedSavepoint)savepoint).getInternalName(), savepoint);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    private void verifySavepointCommandIsAllowed() throws SQLException {
        if (this.autoCommit) {
            throw EmbedConnection.newSQLException("XJ010.S", new Object[0]);
        }
        StatementContext stmtCtxt = this.privilegedGetLCC().getStatementContext();
        if (stmtCtxt != null && stmtCtxt.inTrigger()) {
            throw EmbedConnection.newSQLException("XJ017.S", new Object[0]);
        }
    }

    private void verifySavepointArg(Savepoint savepoint) throws SQLException {
        EmbedSavepoint lsv = (EmbedSavepoint)savepoint;
        if (lsv == null) {
            throw EmbedConnection.newSQLException("3B001.S", "null");
        }
        if (!lsv.sameConnection(this)) {
            throw EmbedConnection.newSQLException("3B502.S", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        this.checkIfClosed();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            String string;
            this.setupContextStack();
            try {
                LanguageConnectionContext lcc = this.privilegedGetLCC();
                string = lcc.getCurrentSchemaName();
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return string;
        }
    }

    @Override
    public void setSchema(String schemaName) throws SQLException {
        this.checkIfClosed();
        try (PreparedStatement ps = null;){
            ps = this.prepareStatement("set schema ?");
            ps.setString(1, schemaName);
            ps.execute();
        }
    }

    private void checkConflictingCryptoAttributes(Properties p) throws SQLException {
        boolean appearsEncrypted;
        boolean bl = appearsEncrypted = EmbedConnection.isSet(p, "encryptionKey") || EmbedConnection.isSet(p, "bootPassword");
        if (appearsEncrypted && EmbedConnection.isTrue(p, "decryptDatabase")) {
            if (EmbedConnection.isSet(p, "newBootPassword")) {
                throw EmbedConnection.newSQLException("XJ048.C", "decryptDatabase, newBootPassword");
            }
            if (EmbedConnection.isSet(p, "newEncryptionKey")) {
                throw EmbedConnection.newSQLException("XJ048.C", "decryptDatabase, newEncryptionKey");
            }
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw EmbedConnection.newSQLException("XJ081.S", timeout, "timeout", "java.sql.Connection.isValid");
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Properties p = FailedProperties40.makeProperties(name, value);
        try {
            this.checkIfClosed();
        }
        catch (SQLException se) {
            FailedProperties40 fp = new FailedProperties40(p);
            throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), fp.getProperties());
        }
        if (name == null && value == null) {
            return;
        }
        this.setClientInfo(p);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        FailedProperties40 fp = new FailedProperties40(properties);
        try {
            this.checkIfClosed();
        }
        catch (SQLException se) {
            throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), fp.getProperties());
        }
        if (properties == null || properties.isEmpty()) {
            return;
        }
        StandardException se = StandardException.newException("XCY02.S", fp.getFirstKey(), fp.getFirstValue());
        throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), fp.getProperties());
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkIfClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkIfClosed();
        return new Properties();
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkIfClosed();
        return Collections.emptyMap();
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        this.checkIfClosed();
        return interfaces.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        this.checkIfClosed();
        try {
            return interfaces.cast(this);
        }
        catch (ClassCastException cce) {
            throw EmbedConnection.newSQLException("XJ128.S", interfaces);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (executor == null) {
            throw EmbedConnection.newSQLException("XCZ02.S", "executor", "null");
        }
        this.beginAborting();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EmbedConnection.this.rollback();
                    EmbedConnection.this.close(exceptionClose);
                }
                catch (SQLException se) {
                    Util.logSQLException(se);
                }
            }
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw Util.notImplemented();
    }

    static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object findService(String factoryInterface, String serviceName) {
        return Monitor.findService(factoryInterface, serviceName);
    }

    private static boolean startPersistentService(String serviceName, Properties properties) throws StandardException {
        return Monitor.startPersistentService(serviceName, properties);
    }

    private static Object createPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        return Monitor.createPersistentService(factoryInterface, serviceName, properties);
    }

    private static void removePersistentService(String name) throws StandardException {
        Monitor.removePersistentService(name);
    }

    private LanguageConnectionContext privilegedGetLCC() {
        return this.getTR().getLcc();
    }
}

